/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.expressionbuilder.ExpressionEntity;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ExpressionParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColBooleanData;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcCallback;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.CalcInterpreterThread;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.python.model.ValuesTableModel;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;

public class ExpressionFunction
extends AbstractFunction {
    private static final String EXPRESSION_KEY = "EXPRESSION_KEY";
    private ExpressionParameter m_expressionParameter = null;

    public ExpressionFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.ExpressionFunction);
    }

    @Override
    public String getName(int index) {
        return "Expression Builder";
    }

    @Override
    public int getNumberOfInParameters() {
        return 1;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 1;
    }

    @Override
    public void process(GraphConnector[] graphObjects, final FunctionGraphNode functionGraphNode, final ProcessCallbackInterface callback) {
        if (this.m_globalTableModelInterface != null) {
            callback.finished(functionGraphNode);
            return;
        }
        this.setInError(false, null);
        this.setCalculating(true);
        try {
            GlobalTableModelInterface srcModel = graphObjects[0].getGlobalTableModelInterface();
            final Table sourceTable = new Table(srcModel);
            ResultVariable tableVar = new ResultVariable((PyObject)sourceTable);
            ResultVariable[] parameters = new ResultVariable[]{tableVar};
            StringBuilder codeSB = new StringBuilder();
            codeSB.append("t=").append(tableVar.getName()).append('\n');
            codeSB.append("calcRes=" + this.m_expressionParameter.getStringValue());
            CalcCallback calcCallback = new CalcCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ArrayList<ResultVariable> variables, CalcError error) {
                    try {
                        if (variables != null) {
                            for (ResultVariable var : variables) {
                                if (var.getName().compareTo("calcRes") != 0) continue;
                                GlobalTableModelInterface model = null;
                                PyObject res = var.getValue();
                                if (res instanceof ColDoubleData) {
                                    col = (ColDoubleData)var.getValue();
                                    col.setColumnName(ExpressionFunction.this.m_expressionParameter.getHumanExpression());
                                    sourceTable.addColumn((Col)col, null, (TableCellRenderer)new DoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4, true, true));
                                    model = sourceTable.getModel();
                                } else if (res instanceof ColBooleanData) {
                                    col = (ColBooleanData)var.getValue();
                                    col.setColumnName(ExpressionFunction.this.m_expressionParameter.getHumanExpression());
                                    sourceTable.addColumn((Col)col, null, null);
                                    model = sourceTable.getModel();
                                } else if (res instanceof Table) {
                                    Table t = (Table)var.getValue();
                                    model = t.getModel();
                                } else if (res instanceof PyFloat || res instanceof PyInteger) {
                                    ArrayList<String> valuesName = new ArrayList<String>(1);
                                    valuesName.add(ExpressionFunction.this.m_expressionParameter.getHumanExpression());
                                    ArrayList<String> values = new ArrayList<String>(1);
                                    values.add(res.toString());
                                    model = new ValuesTableModel(valuesName, values);
                                }
                                ExpressionFunction.this.addModel(model);
                            }
                        } else if (error != null) {
                            ExpressionFunction.this.setInError(error);
                        }
                        ExpressionFunction.this.setCalculating(false);
                    }
                    finally {
                        callback.finished(functionGraphNode);
                    }
                }
            };
            CalcInterpreterTask task = new CalcInterpreterTask(codeSB.toString(), parameters, calcCallback);
            CalcInterpreterThread.getCalcInterpreterThread().addTask(task);
        }
        catch (Exception e) {
            this.setInError(new CalcError((Throwable)e, null, -1));
            this.setCalculating(false);
            callback.finished(functionGraphNode);
        }
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        ParameterList parameterTableList = new ParameterList("Expression Parameters");
        GlobalTableModelInterface model = graphObjects[0].getGlobalTableModelInterface();
        int colCount = model.getColumnCount();
        ArrayList<ExpressionEntity> m_functions = new ArrayList<ExpressionEntity>(20);
        m_functions.add(new ExpressionEntity("abs", "abs(", "Stats.abs("));
        m_functions.add(new ExpressionEntity("mean", "mean(", "Stats.mean("));
        m_functions.add(new ExpressionEntity("log2", "log2(", "Stats.log2("));
        m_functions.add(new ExpressionEntity("log10", "log10(", "Stats.log10("));
        m_functions.add(new ExpressionEntity("std", "std(", "Stats.std("));
        ArrayList<ExpressionEntity> m_variables = new ArrayList<ExpressionEntity>(colCount);
        for (int i = 0; i < colCount; ++i) {
            String columnFullName = model.getColumnName(i);
            String name = columnFullName.replaceAll("<br/>", " ");
            name = this.removeHtmlColor(name);
            int index = i + 1;
            String code = "t[" + index + "]";
            ExpressionEntity var = new ExpressionEntity(name, name, code);
            m_variables.add(var);
        }
        ArrayList<ExpressionEntity> m_calcFunctions = new ArrayList<ExpressionEntity>(20);
        m_calcFunctions.add(new ExpressionEntity("7", "7", "7"));
        m_calcFunctions.add(new ExpressionEntity("8", "8", "8"));
        m_calcFunctions.add(new ExpressionEntity("9", "9", "9"));
        m_calcFunctions.add(new ExpressionEntity("/", "/", "/"));
        m_calcFunctions.add(new ExpressionEntity("4", "4", "4"));
        m_calcFunctions.add(new ExpressionEntity("5", "5", "5"));
        m_calcFunctions.add(new ExpressionEntity("6", "6", "6"));
        m_calcFunctions.add(new ExpressionEntity("*", "*", "*"));
        m_calcFunctions.add(new ExpressionEntity("1", "1", "1"));
        m_calcFunctions.add(new ExpressionEntity("2", "2", "2"));
        m_calcFunctions.add(new ExpressionEntity("3", "3", "3"));
        m_calcFunctions.add(new ExpressionEntity("-", "-", "-"));
        m_calcFunctions.add(new ExpressionEntity("0", "0", "0"));
        m_calcFunctions.add(new ExpressionEntity(".", ".", "."));
        m_calcFunctions.add(new ExpressionEntity("\u00b1", "\u00b1", "\u00b1"));
        m_calcFunctions.add(new ExpressionEntity("+", "+", "+"));
        m_calcFunctions.add(new ExpressionEntity("(", "(", "("));
        m_calcFunctions.add(new ExpressionEntity(")", ")", ")"));
        m_calcFunctions.add(new ExpressionEntity(",", ", ", ","));
        m_calcFunctions.add(new ExpressionEntity("and", " and ", " & "));
        m_calcFunctions.add(new ExpressionEntity("or", " or ", " | "));
        m_calcFunctions.add(new ExpressionEntity("not", " not ", " ~"));
        m_calcFunctions.add(new ExpressionEntity("=", " = ", "=="));
        m_calcFunctions.add(new ExpressionEntity("!=", " != ", "!="));
        m_calcFunctions.add(new ExpressionEntity("<", " < ", "<"));
        m_calcFunctions.add(new ExpressionEntity(">", " > ", ">"));
        m_calcFunctions.add(new ExpressionEntity(">=", " >= ", ">="));
        m_calcFunctions.add(new ExpressionEntity("<=", " <= ", "<="));
        m_calcFunctions.add(new ExpressionEntity("^", "^", " ** "));
        this.m_expressionParameter = new ExpressionParameter(EXPRESSION_KEY, "Expression", m_functions, m_variables, m_calcFunctions, 4);
        this.m_expressionParameter.forceShowLabel(AbstractParameter.LabelVisibility.NO_VISIBLE);
        parameterTableList.add((Object)this.m_expressionParameter);
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = parameterTableList;
        parameterTableList.getPanel();
    }

    private String removeHtmlColor(String value) {
        int colorRemoveStart = value.indexOf("</font>", 0);
        int colorRemoveStop = value.indexOf("</html>", 0);
        if (colorRemoveStart > -1 && colorRemoveStop > colorRemoveStart) {
            value = value.substring(colorRemoveStart + "</font>".length(), colorRemoveStop);
        }
        return value;
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        ExpressionFunction clone = new ExpressionFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null;
    }

    @Override
    public boolean settingsDone() {
        return this.m_expressionParameter != null;
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        ParameterError error = this.m_expressionParameter.checkParameter();
        return error;
    }
}

