/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.extendedtablemodel.MultiJoinDataModel;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class JoinFunction
extends AbstractFunction {
    private static final String JOIN_TABLE1_KEY1 = "JOIN_TABLE1_KEY1";
    private static final String TOLERANCE_KEY1 = "TOLERANCE_KEY1";
    private static final String JOIN_TABLE1_KEY2 = "JOIN_TABLE1_KEY2";
    private static final String TOLERANCE_KEY2 = "TOLERANCE_KEY2";
    private static final String SOURCE_COL = "SOURCE_COL";
    private ParameterList m_parameterList;
    private ArrayList<ObjectParameter> m_paramTableKey1 = null;
    private ArrayList<ObjectParameter> m_paramTableKey2 = null;
    private DoubleParameter m_tolerance1;
    private DoubleParameter m_tolerance2;
    private BooleanParameter m_addSourceCol;

    public JoinFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.JoinFunction);
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_paramTableKey1 = null;
        this.m_paramTableKey2 = null;
        this.m_tolerance1 = null;
        this.m_tolerance2 = null;
        this.m_addSourceCol = null;
    }

    @Override
    public String getName(int index) {
        return "Join";
    }

    @Override
    public int getNumberOfInParameters() {
        return 2;
    }

    @Override
    public int getMaximumNumberOfInParameters() {
        return 16;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 1;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameterList == null) {
            return false;
        }
        return this.m_paramTableKey1 != null && this.m_paramTableKey2 != null;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        JoinFunction clone = new JoinFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(GraphConnector[] graphObjects, FunctionGraphNode functionGraphNode, ProcessCallbackInterface callback) {
        try {
            if (this.m_globalTableModelInterface != null) {
                callback.finished(functionGraphNode);
                return;
            }
            this.setCalculating(true);
            this.setInError(false, null);
            try {
                Table joinedTable;
                int nbTables = graphObjects.length;
                ArrayList<Table> tables = new ArrayList<Table>(nbTables);
                for (int i = 0; i < nbTables; ++i) {
                    Table t = new Table(graphObjects[i].getGlobalTableModelInterface());
                    graphObjects[i].getGlobalTableModelInterface().setName(graphObjects[i].getGraphNode().getDataName());
                    tables.add(t);
                }
                if (this.m_paramTableKey1 != null && this.m_paramTableKey1 != null) {
                    ArrayList<Integer> tableKey1List = new ArrayList<Integer>(nbTables);
                    ArrayList<Integer> tableKey2List = new ArrayList<Integer>(nbTables);
                    for (int i = 0; i < nbTables; ++i) {
                        Integer tableKey1 = (Integer)this.m_paramTableKey1.get(i).getAssociatedObjectValue();
                        tableKey1List.add(tableKey1);
                        Integer tableKey2 = (Integer)this.m_paramTableKey2.get(i).getAssociatedObjectValue();
                        tableKey2List.add(tableKey2);
                    }
                    Double tolerance1 = Double.valueOf(this.m_tolerance1.getStringValue());
                    Double tolerance2 = Double.valueOf(this.m_tolerance2.getStringValue());
                    Boolean showSourceColumn = (Boolean)this.m_addSourceCol.getObjectValue();
                    joinedTable = Table.join(tables, tableKey1List, (Double)tolerance1, tableKey2List, (Double)tolerance2, (Boolean)showSourceColumn);
                } else {
                    joinedTable = Table.join(tables);
                }
                this.addModel(joinedTable.getModel());
            }
            catch (Exception e) {
                this.setInError(new CalcError((Throwable)e, null, -1));
            }
            this.setCalculating(false);
        }
        finally {
            callback.finished(functionGraphNode);
        }
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(final GraphConnector[] graphObjects) {
        int i;
        GlobalTableModelInterface modelForDefaultKey = this.getMainGlobalTableModelInterface(0);
        int nbTables = graphObjects.length;
        int[] keys = null;
        if (modelForDefaultKey == null) {
            ArrayList<GlobalTableModelInterface> data = new ArrayList<GlobalTableModelInterface>(graphObjects.length);
            for (GraphConnector connector : graphObjects) {
                data.add(connector.getGlobalTableModelInterface());
            }
            keys = MultiJoinDataModel.selectKeys(data);
        }
        this.m_paramTableKey1 = new ArrayList();
        this.m_paramTableKey2 = new ArrayList();
        for (int i2 = 0; i2 < nbTables; ++i2) {
            GlobalTableModelInterface model = graphObjects[i2].getGlobalTableModelInterface();
            int keyColumn = 0;
            int nbColumns = model.getColumnCount();
            int nbColumnsKept = 0;
            for (int j = 0; j < nbColumns; ++j) {
                Class c = model.getDataColumnClass(j);
                if (!c.equals(String.class) && !c.equals(Integer.class) && !c.equals(Long.class) && !c.equals(Float.class) && !c.equals(Double.class)) continue;
                ++nbColumnsKept;
            }
            Object[] objectArrayTableKey1 = new Object[nbColumnsKept];
            Object[] associatedObjectArrayTableKey1 = new Object[nbColumnsKept];
            int iKept = 0;
            for (int j = 0; j < nbColumns; ++j) {
                Class c = model.getDataColumnClass(j);
                if (!c.equals(String.class) && !c.equals(Integer.class) && !c.equals(Long.class) && !c.equals(Float.class) && !c.equals(Double.class)) continue;
                objectArrayTableKey1[iKept] = model.getColumnName(j);
                associatedObjectArrayTableKey1[iKept] = j;
                if (j == keys[i2]) {
                    keyColumn = iKept;
                }
                ++iKept;
            }
            int nb = objectArrayTableKey1.length;
            Object[] objectArrayTableKey2 = new Object[nb + 1];
            Object[] associatedObjectArrayTableKey2 = new Object[nb + 1];
            objectArrayTableKey2[0] = "<No Second Key>";
            associatedObjectArrayTableKey2[0] = -1;
            for (int j = 0; j < nb; ++j) {
                objectArrayTableKey2[j + 1] = objectArrayTableKey1[j];
                associatedObjectArrayTableKey2[j + 1] = associatedObjectArrayTableKey1[j];
            }
            ObjectParameter paramTableKey1 = new ObjectParameter(JOIN_TABLE1_KEY1, graphObjects[i2].getFullName() + " Join Column Key 1", new JComboBox<Object>(objectArrayTableKey1), objectArrayTableKey1, associatedObjectArrayTableKey1, keyColumn, null);
            this.m_paramTableKey1.add(paramTableKey1);
            ObjectParameter paramTableKey2 = new ObjectParameter(JOIN_TABLE1_KEY2, graphObjects[i2].getFullName() + " Join Column Key 2", new JComboBox<Object>(objectArrayTableKey2), objectArrayTableKey2, associatedObjectArrayTableKey2, 0, null);
            this.m_paramTableKey2.add(paramTableKey2);
        }
        this.m_tolerance1 = new DoubleParameter(TOLERANCE_KEY1, "Tolerance", JTextField.class, Double.valueOf(0.0), Double.valueOf(0.0), null);
        this.m_tolerance2 = new DoubleParameter(TOLERANCE_KEY2, "Tolerance 2", JTextField.class, Double.valueOf(0.0), Double.valueOf(0.0), null);
        this.m_addSourceCol = new BooleanParameter(SOURCE_COL, "Add Source Info", JCheckBox.class, Boolean.valueOf(true));
        this.m_parameterList = new ParameterList("Join");
        AbstractLinkedParameters linkedParameters1 = new AbstractLinkedParameters(this.m_parameterList){

            public void valueChanged(String value, Object associatedValue) {
                int index = (Integer)associatedValue;
                GlobalTableModelInterface model = graphObjects[0].getGlobalTableModelInterface();
                Class c = model.getDataColumnClass(index);
                this.showParameter((AbstractParameter)JoinFunction.this.m_tolerance1, c.equals(Double.class) || c.equals(Float.class));
                this.updateParameterListPanel();
            }
        };
        AbstractLinkedParameters linkedParameters2 = new AbstractLinkedParameters(this.m_parameterList){

            public void valueChanged(String value, Object associatedValue) {
                int index = (Integer)associatedValue;
                if (index == -1) {
                    this.showParameter((AbstractParameter)JoinFunction.this.m_tolerance2, false);
                } else {
                    GlobalTableModelInterface model = graphObjects[0].getGlobalTableModelInterface();
                    Class c = model.getDataColumnClass(index);
                    this.showParameter((AbstractParameter)JoinFunction.this.m_tolerance2, c.equals(Double.class) || c.equals(Float.class));
                }
                this.updateParameterListPanel();
            }
        };
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = this.m_parameterList;
        for (i = 0; i < nbTables; ++i) {
            this.m_parameterList.add((Object)((AbstractParameter)this.m_paramTableKey1.get(i)));
        }
        this.m_parameterList.add((Object)this.m_tolerance1);
        for (i = 0; i < nbTables; ++i) {
            this.m_parameterList.add((Object)((AbstractParameter)this.m_paramTableKey2.get(i)));
        }
        this.m_parameterList.add((Object)this.m_tolerance2);
        this.m_parameterList.add((Object)this.m_addSourceCol);
        this.m_parameterList.getPanel();
        this.m_paramTableKey1.get(0).addLinkedParameters(linkedParameters1);
        this.m_paramTableKey2.get(0).addLinkedParameters(linkedParameters2);
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        Class cCur;
        Integer keyCur;
        int i;
        Class c;
        Integer key;
        int size;
        int n = size = this.m_paramTableKey1 != null ? this.m_paramTableKey1.size() : 0;
        if (size > 0) {
            key = (Integer)this.m_paramTableKey1.get(0).getAssociatedObjectValue();
            if (key != -1) {
                c = graphObjects[0].getGlobalTableModelInterface().getDataColumnClass(key.intValue());
                for (i = 1; i < size; ++i) {
                    keyCur = (Integer)this.m_paramTableKey1.get(i).getAssociatedObjectValue();
                    if (keyCur == -1) {
                        return new ParameterError("Selected Keys are not compatible", (JComponent)this.m_parameterList.getPanel());
                    }
                    cCur = graphObjects[i].getGlobalTableModelInterface().getDataColumnClass(keyCur.intValue());
                    if (cCur.equals(c)) continue;
                    return new ParameterError("Selected Keys are not compatible", (JComponent)this.m_parameterList.getPanel());
                }
            } else {
                return new ParameterError("First Key is not Selected", (JComponent)this.m_parameterList.getPanel());
            }
        }
        int n2 = size = this.m_paramTableKey2 != null ? this.m_paramTableKey2.size() : 0;
        if (size > 0 && (key = (Integer)this.m_paramTableKey2.get(0).getAssociatedObjectValue()) != -1) {
            c = graphObjects[0].getGlobalTableModelInterface().getDataColumnClass(key.intValue());
            for (i = 1; i < size; ++i) {
                keyCur = (Integer)this.m_paramTableKey2.get(i).getAssociatedObjectValue();
                if (keyCur == -1) {
                    return new ParameterError("Selected Keys are not compatible", (JComponent)this.m_parameterList.getPanel());
                }
                cCur = graphObjects[i].getGlobalTableModelInterface().getDataColumnClass(keyCur.intValue());
                if (cCur.equals(c)) continue;
                return new ParameterError("Selected Keys are not compatible", (JComponent)this.m_parameterList.getPanel());
            }
        }
        return null;
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }
}

