/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graph;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractConnectedGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphLink;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.LinkedList;
import javax.swing.JPopupMenu;

public class GraphConnector
extends AbstractConnectedGraphObject {
    private static final int WIDTH = 10;
    public static final int HEIGHT = 10;
    private static final int LINE_LENGTH = 3;
    private int m_x = 0;
    private int m_y = 0;
    private final boolean m_out;
    private int m_index;
    private final GraphNode m_graphNode;
    private GraphLink m_link = null;
    protected GraphPanel m_graphPanel;
    private final LinkedList<GraphConnector> m_connections = new LinkedList();

    public GraphConnector(GraphNode graphNode, boolean out, int index, GraphPanel panel) {
        super(AbstractGraphObject.TypeGraphObject.CONNECTOR);
        this.m_out = out;
        this.m_graphNode = graphNode;
        this.m_graphPanel = panel;
        this.m_index = index;
    }

    public boolean isOutConnector() {
        return this.m_out;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void getOutLinkedGraphNodes(LinkedList<GraphNode> outLinkedGraphNodes) {
        if (!this.m_out) {
            return;
        }
        for (GraphConnector inConnector : this.m_connections) {
            outLinkedGraphNodes.add(inConnector.getGraphNode());
        }
    }

    @Override
    public String getFullName() {
        return this.m_graphNode.getFullName(this.m_index);
    }

    @Override
    public String getDataName() {
        GraphConnector connector = this.getLinkedSourceGraphConnector();
        if (connector == null) {
            return null;
        }
        GraphNode node = connector.getGraphNode();
        if (node == null) {
            return null;
        }
        return node.getDataName();
    }

    @Override
    public String getTypeName() {
        return null;
    }

    @Override
    public boolean isConnected(boolean recursive) {
        if (this.m_connections.isEmpty()) {
            return false;
        }
        if (!recursive) {
            return true;
        }
        GraphNode node = this.getLinkedSourceGraphConnector().getGraphNode();
        return node.isConnected(recursive);
    }

    @Override
    public boolean canSetSettings() {
        return false;
    }

    @Override
    public boolean settingsDone() {
        return true;
    }

    @Override
    public boolean calculationDone() {
        if (!this.isConnected(true)) {
            return false;
        }
        GraphNode node = this.getLinkedSourceGraphConnector().getGraphNode();
        return node.calculationDone();
    }

    public GraphNode getGraphNode() {
        return this.m_graphNode;
    }

    public GraphConnector getLinkedSourceGraphConnector() {
        if (this.m_out || this.m_connections.isEmpty()) {
            return null;
        }
        return this.m_connections.getFirst();
    }

    public boolean canBeLinked(GraphConnector connector) {
        return this.m_out ^ connector.m_out && this.m_graphNode != connector.m_graphNode;
    }

    public void addConnection(GraphConnector connector) {
        if (!this.m_out && !this.m_connections.isEmpty()) {
            this.deleteInLink();
        }
        this.m_connections.add(connector);
        if (!this.m_out) {
            this.m_graphNode.propagateSourceChanged();
        }
    }

    public void removeConnection(GraphConnector connector) {
        this.m_connections.remove(connector);
        if (this.m_connections.isEmpty()) {
            this.m_link = null;
        }
        if (!this.m_out) {
            this.m_graphNode.updateNumberOfInConnections();
            this.m_graphNode.propagateSourceChanged();
        }
    }

    @Override
    public void delete() {
        GraphConnector[] connectorsArray;
        for (GraphConnector connector : connectorsArray = this.m_connections.toArray(new GraphConnector[this.m_connections.size()])) {
            connector.removeConnection(this);
        }
        this.m_connections.clear();
        this.m_link = null;
    }

    public void deleteInLink() {
        for (GraphConnector connector : this.m_connections) {
            connector.removeConnection(this);
        }
        this.m_connections.clear();
        this.m_link = null;
        if (!this.m_out) {
            this.m_graphNode.updateNumberOfInConnections();
            this.m_graphNode.propagateSourceChanged();
        }
    }

    public void propagateSourceChanged() {
        if (this.m_out) {
            for (GraphConnector connector : this.m_connections) {
                connector.propagateSourceChanged();
            }
        } else {
            this.m_graphNode.propagateSourceChanged();
        }
    }

    public int getXConnection() {
        if (this.m_out) {
            return this.m_x + 10 + 3;
        }
        return this.m_x - 3;
    }

    public int getYConnection() {
        return this.m_y + 5;
    }

    public void setPosition(int xLeft, int yMiddle) {
        this.m_x = xLeft + 3;
        this.m_y = yMiddle - 5;
    }

    public void setRightPosition(int xRight, int yMiddle) {
        this.m_x = xRight - 3 - 10;
        this.m_y = yMiddle - 5;
    }

    @Override
    public void draw(Graphics g) {
        g.setColor(Color.black);
        Graphics2D g2 = (Graphics2D)g;
        Stroke previousStroke = g2.getStroke();
        BasicStroke stroke = this.m_selected ? STROKE_SELECTED : STROKE_NOT_SELECTED;
        g2.setStroke(stroke);
        g2.drawLine(this.m_x, this.m_y, this.m_x + 10, this.m_y + 5);
        g2.drawLine(this.m_x, this.m_y + 10, this.m_x + 10, this.m_y + 5);
        g2.drawLine(this.m_x, this.m_y, this.m_x, this.m_y + 10);
        g2.drawLine(this.m_x - 3, this.m_y + 5, this.m_x, this.m_y + 5);
        g2.drawLine(this.m_x + 10 + 3, this.m_y + 5, this.m_x + 10, this.m_y + 5);
        g2.setStroke(previousStroke);
        if (!this.m_out && !this.m_connections.isEmpty()) {
            GraphConnector connector = this.m_connections.getFirst();
            if (this.m_link == null) {
                this.m_link = new GraphLink(this, this.m_graphPanel);
            }
            this.m_link.setLink(this.getXConnection(), this.getYConnection(), connector.getXConnection(), connector.getYConnection());
            this.m_link.draw(g);
        }
    }

    @Override
    public AbstractGraphObject inside(int x, int y) {
        int DELTA = 3;
        if (x + 3 >= this.m_x && y + 3 >= this.m_y && x - 3 <= this.m_x + 10 && y - 3 <= this.m_y + 10) {
            return this;
        }
        if (this.m_link != null) {
            return this.m_link.inside(x, y);
        }
        return null;
    }

    @Override
    public void move(int dx, int dy) {
        this.m_x += dx;
        this.m_y += dy;
    }

    @Override
    public JPopupMenu createPopup(GraphPanel panel) {
        return null;
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return this.getGlobalTableModelInterface(this.m_index);
    }

    @Override
    public GlobalTableModelInterface getGlobalTableModelInterface(int index) {
        return this.m_graphNode.getGlobalTableModelInterface(index);
    }

    @Override
    public String getPreviousDataName() {
        return null;
    }

    @Override
    public void deleteAction() {
    }

    @Override
    public String getTooltip(int x, int y) {
        if (this.m_graphNode == null) {
            return null;
        }
        if (this.m_out) {
            return this.m_graphNode.getOutTooltip(this.m_index);
        }
        return null;
    }

    public void saveGraph(StringBuilder sb) {
        for (GraphConnector connector : this.m_connections) {
            sb.append("<connector id1=\"");
            sb.append(this.m_graphNode.getId());
            sb.append("\" id2=\"");
            sb.append(connector.m_graphNode.getId());
            sb.append("\" index=\"");
            sb.append(this.m_index);
            sb.append("\"></connector>");
        }
    }
}

