/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graph;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractConnectedGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GraphLink
extends AbstractConnectedGraphObject {
    private GeneralPath m_path = null;
    private GraphConnector m_connector = null;
    private int m_x1;
    private int m_x2;
    private int m_y1;
    private int m_y2;
    protected GraphPanel m_graphPanel = null;
    private static final int DISTMAX_SQUARED = 16;
    private static final Point2D.Double m_p1 = new Point2D.Double();
    private static final Point2D.Double m_p2 = new Point2D.Double();
    private static final Point2D.Double m_p3 = new Point2D.Double();
    private static final Point2D.Double m_p = new Point2D.Double();
    private static final Point2D.Double m_pBezier = new Point2D.Double();

    public GraphLink(GraphConnector connector, GraphPanel panel) {
        super(AbstractGraphObject.TypeGraphObject.LINK);
        this.m_connector = connector;
        this.m_graphPanel = panel;
    }

    @Override
    public boolean isConnected(boolean recursive) {
        if (this.m_connector == null) {
            return false;
        }
        return this.m_connector.isConnected(recursive);
    }

    @Override
    public boolean canSetSettings() {
        return false;
    }

    @Override
    public boolean settingsDone() {
        return true;
    }

    @Override
    public boolean calculationDone() {
        if (this.m_connector == null) {
            return false;
        }
        return this.m_connector.calculationDone();
    }

    @Override
    public String getFullName() {
        return null;
    }

    @Override
    public String getDataName() {
        return null;
    }

    @Override
    public String getTypeName() {
        return null;
    }

    public void setLink(int x1, int y1, int x2, int y2) {
        if (this.m_path != null && x1 == this.m_x1 && x2 == this.m_x2 && y1 == this.m_y1 && y2 == this.m_y2) {
            return;
        }
        if (this.m_path == null) {
            this.m_path = new GeneralPath();
        } else {
            this.m_path.reset();
        }
        this.m_x1 = x1;
        this.m_y1 = y1;
        this.m_x2 = x2;
        this.m_y2 = y2;
        double xdelta = (x2 - x1) / 3;
        double ydelta = (y2 - y1) / 2;
        this.m_path.moveTo(x1, y1);
        this.m_path.lineTo((double)x1 + xdelta, (double)y1);
        this.m_path.quadTo((double)x1 + xdelta * 1.5, (double)y1, (double)x1 + xdelta * 1.5, (double)y1 + ydelta);
        this.m_path.quadTo((double)x1 + xdelta * 1.5, (double)y2, (double)x1 + xdelta * 2.0, (double)y2);
        this.m_path.lineTo(x2, y2);
    }

    private static void getBezierPoint(Point2D.Double p, Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, double t) {
        p.x = p1.getX() * (1.0 - t) * (1.0 - t) + p2.getX() * 2.0 * t * (1.0 - t) + p3.getX() * t * t;
        p.y = p1.getY() * (1.0 - t) * (1.0 - t) + p2.getY() * 2.0 * t * (1.0 - t) + p3.getY() * t * t;
    }

    private static double squaredDistance(Point2D.Double p1, Point2D.Double p2) {
        double d2 = (p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y);
        return d2;
    }

    private static double squaredDistanceToSegment(Point2D.Double ps, Point2D.Double pe, Point2D.Double p) {
        if (ps.x == pe.x && ps.y == pe.y) {
            return GraphLink.squaredDistance(ps, p);
        }
        double sx = pe.x - ps.x;
        double ux = p.x - ps.x;
        double sy = pe.y - ps.y;
        double uy = p.y - ps.y;
        double dp = sx * ux + sy * uy;
        if (dp < 0.0) {
            return GraphLink.squaredDistance(ps, p);
        }
        double sn2 = sx * sx + sy * sy;
        if (dp > sn2) {
            return GraphLink.squaredDistance(pe, p);
        }
        double ah2 = dp * dp / sn2;
        double un2 = ux * ux + uy * uy;
        return un2 - ah2;
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        Stroke previousStroke = g2.getStroke();
        BasicStroke stroke = this.m_selected ? STROKE_SELECTED : STROKE_NOT_SELECTED;
        g2.setStroke(stroke);
        g2.draw(this.m_path);
        g2.setStroke(previousStroke);
    }

    @Override
    public AbstractGraphObject inside(int x, int y) {
        double t;
        m_p.setLocation(x, y);
        double xdelta = (this.m_x2 - this.m_x1) / 3;
        double ydelta = (this.m_y2 - this.m_y1) / 2;
        m_p1.setLocation(this.m_x1, this.m_y1);
        m_p2.setLocation((double)this.m_x1 + xdelta, this.m_y1);
        double distSquared = GraphLink.squaredDistanceToSegment(m_p1, m_p2, m_p);
        if (distSquared < 16.0) {
            return this;
        }
        m_p1.setLocation((double)this.m_x1 + xdelta * 2.0, this.m_y2);
        m_p2.setLocation(this.m_x2, this.m_y2);
        distSquared = GraphLink.squaredDistanceToSegment(m_p1, m_p2, m_p);
        if (distSquared < 16.0) {
            return this;
        }
        m_p1.setLocation((double)this.m_x1 + xdelta, this.m_y1);
        m_p2.setLocation((double)this.m_x1 + xdelta * 1.5, this.m_y1);
        m_p3.setLocation((double)this.m_x1 + xdelta * 1.5, (double)this.m_y1 + ydelta);
        double deltaStep = 100.0;
        deltaStep = Math.max(Math.abs(m_p1.getX() - m_p3.getX()), deltaStep);
        deltaStep = Math.max(Math.abs(m_p1.getY() - m_p3.getY()), deltaStep);
        double deltaT = 1.0 / deltaStep;
        for (t = 0.0; t < 1.0; t += deltaT) {
            GraphLink.getBezierPoint(m_pBezier, m_p1, m_p2, m_p3, t);
            distSquared = GraphLink.squaredDistance(m_p, m_pBezier);
            if (!(distSquared < 16.0)) continue;
            return this;
        }
        m_p1.setLocation((double)this.m_x1 + xdelta * 1.5, (double)this.m_y1 + ydelta);
        m_p2.setLocation((double)this.m_x1 + xdelta * 1.5, this.m_y2);
        m_p3.setLocation((double)this.m_x1 + xdelta * 2.0, this.m_y2);
        deltaStep = 100.0;
        deltaStep = Math.max(Math.abs(m_p1.getX() - m_p3.getX()), deltaStep);
        deltaStep = Math.max(Math.abs(m_p1.getY() - m_p3.getY()), deltaStep);
        deltaT = 1.0 / deltaStep;
        for (t = 0.0; t < 1.0; t += deltaT) {
            GraphLink.getBezierPoint(m_pBezier, m_p1, m_p2, m_p3, t);
            distSquared = GraphLink.squaredDistance(m_p, m_pBezier);
            if (!(distSquared < 16.0)) continue;
            return this;
        }
        return null;
    }

    @Override
    public void move(int dx, int dy) {
    }

    @Override
    public void delete() {
    }

    @Override
    public JPopupMenu createPopup(final GraphPanel panel) {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new DeleteAction());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                GraphLink.this.setSelected(false);
                panel.repaint();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        return popup;
    }

    @Override
    public GlobalTableModelInterface getGlobalTableModelInterface(int index) {
        return null;
    }

    @Override
    public String getPreviousDataName() {
        return null;
    }

    @Override
    public void deleteAction() {
        this.m_connector.deleteInLink();
        this.m_graphPanel.repaint();
    }

    @Override
    public String getTooltip(int x, int y) {
        return null;
    }

    public class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphLink.this.deleteAction();
        }
    }
}

