/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graphics;

import fr.proline.core.orm.uds.BiologicalGroup;
import fr.proline.core.orm.uds.GroupSetup;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.JCheckBoxList;
import fr.proline.studio.gui.JCheckBoxListPanel;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.MultiObjectParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.python.data.ColRef;
import fr.proline.studio.python.data.PythonImage;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcCallback;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.CalcInterpreterThread;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphicGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.types.GroupSelection;
import fr.proline.studio.types.QuantitationType;
import fr.proline.studio.types.XicGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.python.core.PyObject;

public abstract class AbstractMatrixPlotGraphic
extends AbstractGraphic {
    private static final String NBGROUPS_KEY = "NBGROUPS";
    private static final String QUANTITATIONTYPE_KEY = "QUANTITATIONTYPE";
    private static final String SEL_COLS_PREFIX = "SEL_COLS";
    private ObjectParameter m_nbGroupsParameter = null;
    private ObjectParameter m_quantitationTypeParameter = null;
    private MultiObjectParameter[] m_columnsParameterArray = null;
    private final String m_functionName;
    private final String m_pythonCall;
    private final ArrayList<String> m_groupNames = new ArrayList();

    public AbstractMatrixPlotGraphic(GraphPanel panel, String functionName, String pythonCall, AbstractGraphic.GRAPHIC_TYPE graphicType) {
        super(panel, graphicType);
        this.m_functionName = functionName;
        this.m_pythonCall = pythonCall;
    }

    @Override
    public void inLinkDeleted() {
        super.inLinkDeleted();
        this.m_nbGroupsParameter = null;
        this.m_quantitationTypeParameter = null;
        this.m_columnsParameterArray = null;
    }

    public abstract int getMinGroups();

    public abstract int getMaxGroups();

    @Override
    public String getName() {
        return this.m_functionName;
    }

    @Override
    public void process(GraphConnector[] graphObjects, final GraphicGraphNode graphicGraphNode, final ProcessCallbackInterface callback) {
        if (this.m_generatedImage != null) {
            callback.finished(graphicGraphNode);
            return;
        }
        this.setInError(false, null);
        if (this.m_columnsParameterArray == null) {
            callback.finished(graphicGraphNode);
            return;
        }
        int nbColList = (Integer)this.m_nbGroupsParameter.getAssociatedObjectValue();
        int nbCols = 0;
        for (int i = 0; i < nbColList; ++i) {
            List colList = (List)this.m_columnsParameterArray[i].getAssociatedValues(true);
            if (colList == null || colList.isEmpty()) {
                callback.finished(graphicGraphNode);
                return;
            }
            nbCols += colList.size();
        }
        this.setCalculating(true);
        try {
            GlobalTableModelInterface srcModel = graphObjects[0].getGlobalTableModelInterface();
            Table sourceTable = new Table(srcModel);
            ResultVariable[] parameters = new ResultVariable[nbCols];
            int nbSizeDone = 0;
            for (int j = 0; j < nbColList; ++j) {
                List colList = (List)this.m_columnsParameterArray[j].getAssociatedValues(true);
                for (int i = 0; i < colList.size(); ++i) {
                    Integer colIndex = (Integer)colList.get(i);
                    ColRef col = sourceTable.getCol(colIndex.intValue());
                    parameters[i + nbSizeDone] = new ResultVariable((PyObject)col);
                }
                nbSizeDone += colList.size();
            }
            StringBuilder codeSB = new StringBuilder();
            codeSB.append("plot=Stats." + this.m_pythonCall + "((");
            nbSizeDone = 0;
            for (int j = 0; j < nbColList; ++j) {
                codeSB.append('(');
                List colList = (List)this.m_columnsParameterArray[j].getAssociatedValues(true);
                for (int i = 0; i < colList.size(); ++i) {
                    codeSB.append(parameters[i + nbSizeDone].getName());
                    if (i >= colList.size() - 1) continue;
                    codeSB.append(',');
                }
                nbSizeDone += colList.size();
                codeSB.append(')');
                if (j >= nbColList - 1) continue;
                codeSB.append(',');
            }
            codeSB.append("),(");
            boolean first = true;
            for (int j = 0; j < nbColList; ++j) {
                List colList = (List)this.m_columnsParameterArray[j].getAssociatedValues(true);
                for (int i = 0; i < colList.size(); ++i) {
                    if (first) {
                        first = false;
                    } else {
                        codeSB.append(',');
                    }
                    if (this.m_groupNames.size() == nbColList) {
                        codeSB.append("\"" + this.m_groupNames.get(j) + "\"");
                        continue;
                    }
                    codeSB.append("\"group" + j + "\"");
                }
            }
            codeSB.append(")");
            codeSB.append(')');
            CalcCallback calcCallback = new CalcCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ArrayList<ResultVariable> variables, CalcError error) {
                    try {
                        if (variables != null) {
                            for (ResultVariable var : variables) {
                                if (var.getName().compareTo("plot") != 0) continue;
                                PythonImage image = (PythonImage)var.getValue();
                                AbstractMatrixPlotGraphic.this.m_generatedImage = image.getImage();
                            }
                        } else if (error != null) {
                            AbstractMatrixPlotGraphic.this.setInError(error);
                        }
                        AbstractMatrixPlotGraphic.this.setCalculating(false);
                    }
                    finally {
                        callback.finished(graphicGraphNode);
                    }
                }
            };
            CalcInterpreterTask task = new CalcInterpreterTask(codeSB.toString(), parameters, calcCallback);
            CalcInterpreterThread.getCalcInterpreterThread().addTask(task);
        }
        catch (Exception e) {
            this.setInError(new CalcError((Throwable)e, null, -1));
            this.setCalculating(false);
            callback.finished(graphicGraphNode);
        }
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        GlobalTableModelInterface sourceModel = graphObjects[0].getGlobalTableModelInterface();
        boolean hasQuantitationTypeParameter = false;
        int nbGroupsFound = -1;
        int nbGroups = this.getMinGroups();
        GroupSelection groupSelection = (GroupSelection)sourceModel.getSingleValue(GroupSelection.class);
        if (groupSelection != null) {
            nbGroups = nbGroupsFound = groupSelection.getNumberOfGroups();
            Object[] groupArray = new String[]{nbGroupsFound + "group(s)"};
            Object[] groupAssociatedArray = new Object[]{nbGroupsFound};
            this.m_nbGroupsParameter = new ObjectParameter(NBGROUPS_KEY, "Number of Groups", null, groupArray, groupAssociatedArray, nbGroupsFound == 2 ? 0 : 1, null);
            this.m_columnsParameterArray = new MultiObjectParameter[nbGroupsFound];
            for (int i = 0; i < nbGroupsFound; ++i) {
                ArrayList selectedCols = groupSelection.getGroup(i);
                Object[] selectedColsObject = selectedCols.toArray();
                boolean[] selection = new boolean[selectedCols.size()];
                for (int j = 0; j < selection.length; ++j) {
                    selection[j] = true;
                }
                this.m_columnsParameterArray[i] = new MultiObjectParameter(SEL_COLS_PREFIX + i, "group " + i, null, selectedColsObject, selectedColsObject, selection, true);
            }
            this.m_parameters = new ParameterList[0];
        } else {
            int i;
            int i2;
            GroupSetup groupSetup;
            boolean[][] selection;
            int i3;
            final GlobalTableModelInterface model1 = graphObjects[0].getGlobalTableModelInterface();
            int nbColumns = model1.getColumnCount();
            final ArrayList<Integer> columnKept = new ArrayList<Integer>();
            HashSet<QuantitationType> m_quantitationsSet = new HashSet<QuantitationType>();
            for (i3 = 0; i3 < nbColumns; ++i3) {
                QuantitationType quantitationType = (QuantitationType)model1.getColValue(QuantitationType.class, i3);
                if (quantitationType == null) continue;
                columnKept.add(i3);
                m_quantitationsSet.add(quantitationType);
            }
            boolean bl = hasQuantitationTypeParameter = !m_quantitationsSet.isEmpty();
            if (columnKept.isEmpty()) {
                for (i3 = 0; i3 < nbColumns; ++i3) {
                    Class c = model1.getDataColumnClass(i3);
                    if (!c.equals(Float.class) && !c.equals(Double.class) && !c.equals(Integer.class) && !c.equals(Long.class)) continue;
                    columnKept.add(i3);
                }
            }
            final int nbColumnsKept = columnKept.size();
            Object[] objectArray1 = new Object[nbColumnsKept];
            Object[] associatedObjectArray1 = new Object[nbColumnsKept];
            for (int i4 = 0; i4 < nbColumnsKept; ++i4) {
                objectArray1[i4] = model1.getColumnName(((Integer)columnKept.get(i4)).intValue()).replaceAll("<br/>", " ");
                associatedObjectArray1[i4] = (Integer)columnKept.get(i4) + 1;
            }
            nbGroups = this.getMinGroups();
            String[] groupNameList = new String[]{"First Group", "Second Group", "Third Group", "Fourth Group", "Fifth Group", "Sixth Group", "Seventh Group", "Eighth Group"};
            for (boolean[] row : selection = new boolean[this.getMaxGroups()][nbColumnsKept]) {
                Arrays.fill(row, false);
            }
            nbGroupsFound = -1;
            DDataset dataset = (DDataset)model1.getSingleValue(DDataset.class);
            if (dataset != null && (groupSetup = dataset.getGroupSetup()) != null) {
                List listBiologicalGroups = groupSetup.getBiologicalGroups();
                nbGroups = listBiologicalGroups.size();
                if (nbGroups >= this.getMinGroups() && nbGroups <= this.getMaxGroups()) {
                    nbGroupsFound = nbGroups;
                    for (int i5 = 0; i5 < nbGroups; ++i5) {
                        groupNameList[i5] = ((BiologicalGroup)listBiologicalGroups.get(i5)).getName() + " Group";
                    }
                    this.m_groupNames.clear();
                    HashMap<Long, Integer> groupMap = new HashMap<Long, Integer>();
                    for (i2 = 0; i2 < nbColumnsKept; ++i2) {
                        XicGroup group;
                        QuantitationType quantitationType = (QuantitationType)model1.getColValue(QuantitationType.class, ((Integer)columnKept.get(i2)).intValue());
                        if (quantitationType.getType() != 4 && quantitationType.getType() != 0 || groupMap.containsKey((group = (XicGroup)model1.getColValue(XicGroup.class, ((Integer)columnKept.get(i2)).intValue())).getId())) continue;
                        groupMap.put(group.getId(), groupMap.size());
                        String name = group.getName();
                        if (name == null) continue;
                        this.m_groupNames.add(group.getName());
                    }
                    if (groupMap.size() == nbGroups) {
                        for (int j = 0; j < nbGroups; ++j) {
                            for (int i6 = 0; i6 < nbColumnsKept; ++i6) {
                                QuantitationType quantitationType = (QuantitationType)model1.getColValue(QuantitationType.class, ((Integer)columnKept.get(i6)).intValue());
                                XicGroup group = (XicGroup)model1.getColValue(XicGroup.class, ((Integer)columnKept.get(i6)).intValue());
                                if (quantitationType.getType() != 4 && quantitationType.getType() != 0 || (Integer)groupMap.get(group.getId()) != j) continue;
                                selection[j][i6] = true;
                            }
                        }
                    }
                } else {
                    nbGroups = this.getMinGroups();
                }
            }
            int nbGroupChoices = this.getMaxGroups() - this.getMinGroups() + 1;
            Object[] groupArray = new String[nbGroupChoices];
            Object[] groupAssociatedArray = new Object[nbGroupChoices];
            for (i2 = 0; i2 < nbGroupChoices; ++i2) {
                groupArray[i2] = String.valueOf(this.getMinGroups() + i2) + " Groups";
                groupAssociatedArray[i2] = this.getMinGroups() + i2;
            }
            this.m_nbGroupsParameter = new ObjectParameter(NBGROUPS_KEY, "Number of Groups", null, groupArray, groupAssociatedArray, nbGroups == 2 ? 0 : 1, null);
            Object[] quantitationArray = m_quantitationsSet.toArray(new QuantitationType[0]);
            Object[] quantitationTypeArray = new Integer[quantitationArray.length];
            int quantitationSelected = -1;
            for (i = 0; i < quantitationArray.length; ++i) {
                quantitationTypeArray[i] = quantitationArray[i].getType();
                if (quantitationTypeArray[i] != 4 && (Integer)quantitationTypeArray[i] != 0) continue;
                quantitationSelected = i;
            }
            if (hasQuantitationTypeParameter) {
                this.m_quantitationTypeParameter = new ObjectParameter(QUANTITATIONTYPE_KEY, "Quantitation Type", null, quantitationArray, quantitationTypeArray, quantitationSelected, null);
            }
            this.m_columnsParameterArray = new MultiObjectParameter[this.getMaxGroups()];
            for (i = 0; i < this.getMaxGroups(); ++i) {
                this.m_columnsParameterArray[i] = new MultiObjectParameter(SEL_COLS_PREFIX + i, groupNameList[i], null, objectArray1, associatedObjectArray1, selection[i], true);
                this.m_columnsParameterArray[i].setCompulsory(2);
            }
            this.m_parameters = new ParameterList[this.getMaxGroups() + 1];
            this.m_parameters[0] = new ParameterList("group and quantitation");
            this.m_parameters[0].add((Object)this.m_nbGroupsParameter);
            if (hasQuantitationTypeParameter) {
                this.m_parameters[0].add((Object)this.m_quantitationTypeParameter);
            }
            this.m_parameters[0].getPanel();
            for (i = 0; i < this.getMaxGroups(); ++i) {
                this.m_parameters[i + 1] = new ParameterList("bbinomial" + i);
                this.m_parameters[i + 1].add((Object)this.m_columnsParameterArray[i]);
            }
            final int _nbGroupsFound = nbGroupsFound;
            if (this.getMaxGroups() >= 3) {
                for (int i7 = 3; i7 < this.getMaxGroups() + 1; ++i7) {
                    final Integer number = i7;
                    AbstractLinkedParameters nbGroupslinkedParameters = new AbstractLinkedParameters(this.m_parameters[i7]){

                        public void valueChanged(String value, Object associatedValue) {
                            this.enableList((Integer)associatedValue >= number);
                        }
                    };
                    this.m_nbGroupsParameter.addLinkedParameters(nbGroupslinkedParameters);
                }
            }
            AbstractLinkedParameters quantitationVisibilityParameters = new AbstractLinkedParameters(this.m_parameters[0]){

                public void valueChanged(String value, Object associatedValue) {
                    if (AbstractMatrixPlotGraphic.this.m_quantitationTypeParameter != null) {
                        this.showParameter((AbstractParameter)AbstractMatrixPlotGraphic.this.m_quantitationTypeParameter, (Integer)associatedValue == _nbGroupsFound);
                    }
                }
            };
            this.m_nbGroupsParameter.addLinkedParameters(quantitationVisibilityParameters);
            if (hasQuantitationTypeParameter) {
                final int _nbGroups = nbGroups;
                for (int i8 = 0; i8 < this.getMaxGroups(); ++i8) {
                    final int _groudIndex = i8;
                    AbstractLinkedParameters quantitationTypelinkedParameters = new AbstractLinkedParameters(this.m_parameters[i8]){
                        private boolean doingValueChanged;
                        {
                            super(arg0);
                            this.doingValueChanged = false;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void valueChanged(String value, Object associatedValue) {
                            if (this.doingValueChanged) {
                                return;
                            }
                            try {
                                XicGroup group;
                                QuantitationType quantitationType;
                                int i;
                                this.doingValueChanged = true;
                                JCheckBoxList cb = ((JCheckBoxListPanel)AbstractMatrixPlotGraphic.this.m_columnsParameterArray[_groudIndex].getComponent()).getCheckBoxList();
                                cb.reinitSelection();
                                Integer quantitationChoosen = (Integer)associatedValue;
                                HashMap<Long, Integer> groupMap = new HashMap<Long, Integer>();
                                for (i = 0; i < nbColumnsKept; ++i) {
                                    quantitationType = (QuantitationType)model1.getColValue(QuantitationType.class, ((Integer)columnKept.get(i)).intValue());
                                    if (quantitationType.getType() != 4 && quantitationType.getType() != 0 || groupMap.containsKey((group = (XicGroup)model1.getColValue(XicGroup.class, ((Integer)columnKept.get(i)).intValue())).getId())) continue;
                                    groupMap.put(group.getId(), groupMap.size());
                                }
                                if (groupMap.size() == _nbGroups) {
                                    for (i = 0; i < nbColumnsKept; ++i) {
                                        quantitationType = (QuantitationType)model1.getColValue(QuantitationType.class, ((Integer)columnKept.get(i)).intValue());
                                        group = (XicGroup)model1.getColValue(XicGroup.class, ((Integer)columnKept.get(i)).intValue());
                                        if (quantitationType.getType() != quantitationChoosen.intValue() || (Integer)groupMap.get(group.getId()) != _groudIndex) continue;
                                        cb.selectItem(i);
                                    }
                                }
                            }
                            finally {
                                this.doingValueChanged = false;
                            }
                        }
                    };
                    this.m_quantitationTypeParameter.addLinkedParameters(quantitationTypelinkedParameters);
                }
            }
        }
    }

    @Override
    public void userParametersChanged() {
        this.m_generatedImage = null;
    }

    @Override
    public boolean calculationDone() {
        return this.m_generatedImage != null;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameters == null || this.m_columnsParameterArray == null) {
            return false;
        }
        int nbColList = (Integer)this.m_nbGroupsParameter.getAssociatedObjectValue();
        for (int i = 0; i < nbColList; ++i) {
            List colList = (List)this.m_columnsParameterArray[i].getAssociatedValues(true);
            if (colList != null && !colList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }
}

