/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graphics;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.gui.AdvancedSelectionPanel;
import fr.proline.studio.parameter.MultiObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphicGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.LockedDataGraphicsModel;
import java.util.ArrayList;

public class VennDiagramGraphic
extends AbstractGraphic {
    private MultiObjectParameter m_columnsParameter = null;

    public VennDiagramGraphic(GraphPanel panel) {
        super(panel, AbstractGraphic.GRAPHIC_TYPE.VennDiagramGraphic);
    }

    @Override
    public String getName() {
        return "Venn Diagram";
    }

    @Override
    public void inLinkDeleted() {
        super.inLinkDeleted();
        this.m_columnsParameter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(GraphConnector[] graphObjects, GraphicGraphNode graphicGraphNode, ProcessCallbackInterface callback) {
        try {
            if (this.m_graphicsModelInterface != null) {
                return;
            }
            ArrayList selectedColumnsList = (ArrayList)this.m_columnsParameter.getAssociatedValues(true);
            int nbSelected = selectedColumnsList.size();
            int[] cols = new int[nbSelected];
            for (int i = 0; i < nbSelected; ++i) {
                cols[i] = (Integer)selectedColumnsList.get(i);
            }
            this.m_graphicsModelInterface = new LockedDataGraphicsModel((ExtendedTableModelInterface)graphObjects[0].getGlobalTableModelInterface(), PlotType.VENN_DIAGRAM_PLOT, cols);
        }
        finally {
            callback.finished(graphicGraphNode);
        }
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        GlobalTableModelInterface model1 = graphObjects[0].getGlobalTableModelInterface();
        if (this.m_columnsParameter == null) {
            ArrayList<String> columnNamesArrayList = new ArrayList<String>();
            ArrayList<Integer> columnIdsArrayList = new ArrayList<Integer>();
            int nbColumns = model1.getColumnCount();
            for (int i = 0; i < nbColumns; ++i) {
                Class c = model1.getDataColumnClass(i);
                if (!c.equals(Double.class) && !c.equals(Float.class) && !c.equals(Long.class) && !c.equals(Integer.class)) continue;
                columnNamesArrayList.add(model1.getDataColumnIdentifier(i));
                columnIdsArrayList.add(i);
            }
            int nb = columnNamesArrayList.size();
            boolean[] selection = new boolean[nb];
            for (int i = 0; i < nb; ++i) {
                selection[i] = false;
            }
            Object[] columnNamesArray = columnNamesArrayList.toArray(new String[nb]);
            Object[] columnIdsArray = columnIdsArrayList.toArray(new Integer[nb]);
            this.m_columnsParameter = new MultiObjectParameter("MULTI_COLUMNS", "Columns Selection", "Selected Columns", "Unselected Columns", AdvancedSelectionPanel.class, columnNamesArray, columnIdsArray, selection, null);
        }
        ParameterList parameterList1 = new ParameterList("graphic1");
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = parameterList1;
        parameterList1.add((Object)this.m_columnsParameter);
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }

    @Override
    public void userParametersChanged() {
        this.m_graphicsModelInterface = null;
    }

    @Override
    public AbstractGraphic cloneGraphic(GraphPanel p) {
        VennDiagramGraphic clone = new VennDiagramGraphic(p);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public boolean calculationDone() {
        return this.m_graphicsModelInterface != null;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameters == null || this.m_columnsParameter == null) {
            return false;
        }
        ArrayList selectedColumnsList = (ArrayList)this.m_columnsParameter.getAssociatedValues(true);
        return selectedColumnsList != null && selectedColumnsList.size() >= 2;
    }
}

