/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.uds.FragmentationRuleSet;
import fr.proline.core.orm.uds.InstrumentConfiguration;
import fr.proline.core.orm.uds.PeaklistSoftware;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dpm.serverfilesystem.ServerFile;
import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.DefaultStorableDialog;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.parameter.AbstractParameterToString;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.FileParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import fr.proline.studio.rsmexplorer.gui.dialog.FragmentationRuleSetViewer;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.LoggerFactory;

public class ImportIdentificationDialog
extends DefaultStorableDialog {
    private static ImportIdentificationDialog m_singletonDialog = null;
    private static final String OMSSA_PARSER = "Omssa Parser";
    private static final String MASCOT_PARSER = "Mascot";
    private static final String XTANDEM_PARSER = "X!Tandem Parser";
    private static final String MZ_IDENT_PARSER = "MzIdentML";
    private static final String[] PARSER_NAMES = new String[]{"Mascot", "Omssa Parser", "X!Tandem Parser", "MzIdentML"};
    private static final Map<String, Integer> EXTENSION_TO_PARSER = new HashMap<String, Integer>();
    private static final String[] FILE_EXTENSIONS_DESCRIPTION;
    private static final String[] PARSER_IDS;
    private static final String[] DECOY_VALUES;
    private static final String[] DECOY_VALUES_ASSOCIATED_KEYS;
    private static final int CONCATENATED_DECOY_INDEX = 3;
    private static final String SETTINGS_KEY = "ImporteIdentification";
    private JList<File> m_fileList;
    private JButton m_addFileButton;
    private JButton m_removeFileButton;
    private JComboBox m_parserComboBox;
    private int m_previousParserIndex = -1;
    private ParameterList m_sourceParameterList;
    private StringParameter m_decoyRegexParameter;
    private JComboBox m_instrumentsComboBox = null;
    private JComboBox m_fragmentationRuleSetsComboBox = null;
    private JComboBox m_peaklistSoftwaresComboBox = null;
    private JComboBox m_decoyComboBox = null;
    private JLabel m_decoyAccessionRegexLabel = null;
    private JTextField m_decoyRegexTextField = null;
    private JButton m_regexButton;
    private JPanel m_parserParametersPanel = null;
    private boolean m_rootPathError = false;
    private ServerFile m_defaultDirectory = null;

    public static ImportIdentificationDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new ImportIdentificationDialog(parent);
        }
        m_singletonDialog.reinitialize();
        return m_singletonDialog;
    }

    private ImportIdentificationDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Import Search Results");
        this.setDocumentationSuffix("id.147n2zr");
        this.setResizable(true);
        this.setMinimumSize(new Dimension(200, 240));
        this.initInternalPanel();
        this.restoreInitialParameters(NbPreferences.root());
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected void resetParameters() throws Exception {
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        parameterList.initDefaults();
    }

    protected void loadParameters(Preferences filePreferences) throws Exception {
        Preferences preferences = NbPreferences.root();
        String[] keys = filePreferences.keys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String value = filePreferences.get(key, null);
            preferences.put(key, value);
        }
        this.restoreInitialParameters(preferences);
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        parameterList.loadParameters(filePreferences);
        this.m_sourceParameterList.loadParameters(filePreferences);
    }

    protected void saveParameters(Preferences preferences) {
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        String parserSelected = parameterList.toString();
        preferences.put("IdentificationParser", parserSelected);
        if (this.m_defaultDirectory != null) {
            preferences.put("IdentificationFilePath", this.m_defaultDirectory.getAbsolutePath());
        }
        this.m_sourceParameterList.saveParameters(preferences);
        parameterList.saveParameters(preferences);
        if (this.m_decoyRegexTextField.isEnabled()) {
            ArrayList<String> regexArrayList = this.readRegexArray(this.m_decoyRegexTextField.getText());
            this.writeRegexArray(preferences, regexArrayList);
        }
    }

    protected boolean checkParameters() {
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        ParameterError error = this.m_sourceParameterList.checkParameters();
        if (error == null) {
            error = parameterList.checkParameters();
        }
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JPanel fileSelectionPanel = this.createFileSelectionPanel();
        JPanel allParametersPanel = this.createAllParametersPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)fileSelectionPanel, c);
        ++c.gridy;
        c.weighty = 0.0;
        internalPanel.add((Component)allParametersPanel, c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createAllParametersPanel() {
        JPanel allParametersPanel = new JPanel(new GridBagLayout());
        allParametersPanel.setBorder(BorderFactory.createTitledBorder(" Parameters "));
        JPanel parserPanel = this.createParserPanel();
        JPanel decoyPanel = this.createDecoyPanel();
        this.m_parserParametersPanel = this.createParametersPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        allParametersPanel.add((Component)parserPanel, c);
        ++c.gridy;
        allParametersPanel.add((Component)decoyPanel, c);
        ++c.gridy;
        allParametersPanel.add((Component)this.m_parserParametersPanel, c);
        this.m_parserComboBox.setSelectedIndex(0);
        return allParametersPanel;
    }

    private JPanel createFileSelectionPanel() {
        JPanel fileSelectionPanel = new JPanel(new GridBagLayout());
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Files Selection "));
        this.m_fileList = new JList(new DefaultListModel());
        JScrollPane m_fileListScrollPane = new JScrollPane(this.m_fileList){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        this.m_addFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        fileSelectionPanel.add((Component)m_fileListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        fileSelectionPanel.add((Component)this.m_addFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add(Box.createVerticalStrut(30), c);
        this.m_fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = ImportIdentificationDialog.this.m_fileList.getSelectedIndex() != -1;
                ImportIdentificationDialog.this.m_removeFileButton.setEnabled(sometingSelected);
            }
        });
        this.m_addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportIdentificationDialog.this.setStatus(false, String.format("%d file(s)", ImportIdentificationDialog.this.m_fileList.getModel().getSize()));
                if (ImportIdentificationDialog.this.m_rootPathError) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Server has returned no Root Path for Result Files. There is a problem with the server installation, please contact your administrator.");
                    InfoDialog errorDialog = new InfoDialog((Window)((Object)m_singletonDialog), InfoDialog.InfoType.WARNING, "Root Path Error", "Server has returned no Root Path for Result Files.\nThere is a problem with the server installation, please contact your administrator.", true);
                    errorDialog.setButtonVisible(1, false);
                    errorDialog.setLocationRelativeTo((Component)((Object)m_singletonDialog));
                    errorDialog.setVisible(true);
                    return;
                }
                JFileChooser fchooser = ImportIdentificationDialog.this.m_defaultDirectory != null && ImportIdentificationDialog.this.m_defaultDirectory.isDirectory() ? new JFileChooser((File)ImportIdentificationDialog.this.m_defaultDirectory, (FileSystemView)ServerFileSystemView.getServerFileSystemView()) : new JFileChooser((FileSystemView)ServerFileSystemView.getServerFileSystemView());
                fchooser.setMultiSelectionEnabled(true);
                String[] filters = new String[FILE_EXTENSIONS_DESCRIPTION.length];
                for (String key : EXTENSION_TO_PARSER.keySet()) {
                    int i = EXTENSION_TO_PARSER.get(key);
                    if (filters[i] == null) {
                        filters[i] = "";
                    }
                    if (!filters[i].equals("")) {
                        int n = i;
                        filters[n] = filters[n] + ";";
                    }
                    if (key.contains(".")) {
                        int indexOfDot = key.lastIndexOf(46);
                        int n = i;
                        filters[n] = filters[n] + key.substring(indexOfDot + 1);
                        continue;
                    }
                    int n = i;
                    filters[n] = filters[n] + key;
                }
                for (int i = 0; i < filters.length; ++i) {
                    FileNameExtensionFilter filter = new FileNameExtensionFilter(FILE_EXTENSIONS_DESCRIPTION[i], filters[i].split(";"));
                    fchooser.addChoosableFileFilter(filter);
                }
                int result = fchooser.showOpenDialog((Component)((Object)m_singletonDialog));
                if (result == 0) {
                    boolean hasFilesPreviously = ImportIdentificationDialog.this.m_fileList.getModel().getSize() != 0;
                    File[] files = fchooser.getSelectedFiles();
                    int nbFiles = files.length;
                    for (int i = 0; i < nbFiles; ++i) {
                        ((DefaultListModel)ImportIdentificationDialog.this.m_fileList.getModel()).addElement(files[i]);
                    }
                    ImportIdentificationDialog.this.setStatus(false, String.format("%d file(s)", ImportIdentificationDialog.this.m_fileList.getModel().getSize()));
                    if (nbFiles > 0) {
                        File f = files[0];
                        String fileName = f.getName();
                        int parserIndex = -1;
                        for (String key : EXTENSION_TO_PARSER.keySet()) {
                            String extension = "." + key;
                            if (!fileName.endsWith(extension)) continue;
                            parserIndex = EXTENSION_TO_PARSER.get(key);
                            break;
                        }
                        if (parserIndex >= 0) {
                            ImportIdentificationDialog.this.m_parserComboBox.setSelectedIndex(parserIndex);
                        }
                    }
                    if (nbFiles > 0) {
                        File f = files[0];
                        if ((f = f.getParentFile()) != null && f.isDirectory() && f instanceof ServerFile) {
                            ImportIdentificationDialog.this.m_defaultDirectory = (ServerFile)f;
                        }
                    }
                }
            }
        });
        this.m_removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<File> selectedValues = ImportIdentificationDialog.this.m_fileList.getSelectedValuesList();
                Iterator<File> it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)ImportIdentificationDialog.this.m_fileList.getModel()).removeElement(it.next());
                }
                ImportIdentificationDialog.this.setStatus(false, String.format("%d file(s)", ImportIdentificationDialog.this.m_fileList.getModel().getSize()));
                ImportIdentificationDialog.this.m_removeFileButton.setEnabled(false);
            }
        });
        return fileSelectionPanel;
    }

    private JPanel createParserPanel() {
        JPanel parserPanel = new JPanel(new GridBagLayout());
        JLabel parserLabel = new JLabel("Software Engine :");
        parserLabel.setHorizontalAlignment(4);
        this.m_parserComboBox = new JComboBox<ParameterList>(this.createParameters());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        parserPanel.add((Component)parserLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        parserPanel.add((Component)this.m_parserComboBox, c);
        this.m_sourceParameterList = this.createSourceParameters();
        this.m_sourceParameterList.updateValues(NbPreferences.root());
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        JLabel instrumentLabel = new JLabel("Instrument :");
        instrumentLabel.setHorizontalAlignment(4);
        parserPanel.add((Component)instrumentLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        parserPanel.add((Component)this.m_instrumentsComboBox, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        JLabel fragRuleSetLabel = new JLabel("Fragmentation Rule Set :");
        fragRuleSetLabel.setHorizontalAlignment(4);
        parserPanel.add((Component)fragRuleSetLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        parserPanel.add((Component)this.m_fragmentationRuleSetsComboBox, c);
        ++c.gridx;
        c.weightx = 0.0;
        JButton viewFragmentationRuleSet = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DOCUMENT_LIST));
        viewFragmentationRuleSet.setMargin(new Insets(2, 2, 2, 2));
        viewFragmentationRuleSet.setToolTipText("View Fragmentation Rule Sets");
        viewFragmentationRuleSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FragmentationRuleSetViewer viewer = new FragmentationRuleSetViewer((Window)((Object)m_singletonDialog));
                viewer.setVisible(true);
            }
        });
        parserPanel.add((Component)viewFragmentationRuleSet, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        JLabel peaklistSoftwareLabel = new JLabel("Peaklist Software :");
        peaklistSoftwareLabel.setHorizontalAlignment(4);
        parserPanel.add((Component)peaklistSoftwareLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        parserPanel.add((Component)this.m_peaklistSoftwaresComboBox, c);
        this.m_parserComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int parserIndex = ImportIdentificationDialog.this.m_parserComboBox.getSelectedIndex();
                if (parserIndex == ImportIdentificationDialog.this.m_previousParserIndex) {
                    return;
                }
                ImportIdentificationDialog.this.m_previousParserIndex = parserIndex;
                ImportIdentificationDialog.this.initParameters();
                ImportIdentificationDialog.this.repack();
            }
        });
        return parserPanel;
    }

    private JPanel createDecoyPanel() {
        JPanel decoyPanel = new JPanel(new GridBagLayout());
        decoyPanel.setBorder(BorderFactory.createTitledBorder(" Decoy Parameters "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridy = 0;
        JLabel decoyLabel = new JLabel("Decoy :");
        decoyLabel.setHorizontalAlignment(4);
        decoyPanel.add((Component)decoyLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        decoyPanel.add((Component)this.m_decoyComboBox, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        this.m_decoyAccessionRegexLabel = new JLabel("Decoy Accession Regex :");
        this.m_decoyAccessionRegexLabel.setHorizontalAlignment(4);
        decoyPanel.add((Component)this.m_decoyAccessionRegexLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        decoyPanel.add((Component)this.m_decoyRegexTextField, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.m_regexButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DOCUMENT_LIST));
        this.m_regexButton.setMargin(new Insets(2, 2, 2, 2));
        decoyPanel.add((Component)this.m_regexButton, c);
        this.m_decoyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportIdentificationDialog.this.updateDecoyRegexEnabled();
            }
        });
        this.m_regexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> regexArrayList = ImportIdentificationDialog.this.readRegexArray(null);
                SelectRegexDialog regexDialog = SelectRegexDialog.getDialog((JDialog)((Object)m_singletonDialog), regexArrayList);
                regexDialog.setLocationRelativeTo(ImportIdentificationDialog.this.m_regexButton);
                regexDialog.setVisible(true);
                if (regexDialog.getButtonClicked() == 0) {
                    String selectedRegex = regexDialog.getSelectedRegex();
                    if (selectedRegex != null) {
                        ImportIdentificationDialog.this.m_decoyRegexTextField.setText(selectedRegex);
                    }
                    regexArrayList = regexDialog.getRegexArrayList();
                    ImportIdentificationDialog.this.writeRegexArray(NbPreferences.root(), regexArrayList);
                }
            }
        });
        return decoyPanel;
    }

    private ArrayList<String> readRegexArray(String regexToAdd) {
        String regex;
        ArrayList<String> regexArrayList = new ArrayList<String>();
        Preferences preferences = NbPreferences.root();
        int i = 1;
        while ((regex = preferences.get("DecoyRegex_" + i, null)) != null) {
            if (regexToAdd != null && regex.compareTo(regexToAdd) == 0) {
                regexToAdd = null;
                regexArrayList.add(0, regex);
            } else {
                regexArrayList.add(regex);
            }
            ++i;
        }
        if (regexToAdd != null) {
            regexArrayList.add(0, regexToAdd);
        }
        boolean grenobleRegexFound = false;
        boolean strasbourgRegexFound = false;
        for (i = 0; i < regexArrayList.size(); ++i) {
            String regex2 = (String)regexArrayList.get(i);
            if (regex2.compareTo("###REV###\\S+") == 0) {
                grenobleRegexFound = true;
                continue;
            }
            if (regex2.compareTo("sp\\|REV_\\S+") != 0) continue;
            strasbourgRegexFound = true;
        }
        if (!grenobleRegexFound) {
            regexArrayList.add("###REV###\\S+");
        }
        if (!strasbourgRegexFound) {
            regexArrayList.add("sp\\|REV_\\S+");
        }
        return regexArrayList;
    }

    private void writeRegexArray(Preferences preferences, ArrayList<String> regexArrayList) {
        String key;
        String regex;
        int i = 1;
        while ((regex = preferences.get(key = "DecoyRegex_" + i, null)) != null) {
            preferences.remove(key);
            ++i;
        }
        for (i = 0; i < regexArrayList.size(); ++i) {
            key = "DecoyRegex_" + (i + 1);
            preferences.put(key, regexArrayList.get(i));
        }
    }

    private void updateDecoyRegexEnabled() {
        boolean enabled = this.m_decoyComboBox.getSelectedIndex() == 3;
        this.m_decoyRegexParameter.setUsed(enabled);
        this.m_decoyAccessionRegexLabel.setEnabled(enabled);
        this.m_decoyRegexTextField.setEnabled(enabled);
        this.m_regexButton.setEnabled(enabled);
    }

    private JPanel createParametersPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" Parser Parameters "));
        return panel;
    }

    private void initParameters() {
        this.m_parserParametersPanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        this.m_parserParametersPanel.add((Component)parameterList.getPanel(), c);
    }

    private void reinitialize() {
        ((DefaultListModel)this.m_fileList.getModel()).removeAllElements();
        this.setStatus(false, String.format("%d file(s)", this.m_fileList.getModel().getSize()));
        this.m_removeFileButton.setEnabled(false);
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        parameterList.clean();
        Object[] allFRS = DatabaseDataManager.getDatabaseDataManager().getFragmentationRuleSetsWithNullArray();
        String selectedFragmRuleSet = ((ObjectParameter)this.m_sourceParameterList.getParameter("fragmentation_rule_set")).getStringValue();
        this.m_fragmentationRuleSetsComboBox.removeAllItems();
        for (int i = 0; i < allFRS.length; ++i) {
            this.m_fragmentationRuleSetsComboBox.addItem(allFRS[i]);
        }
        ((ObjectParameter)this.m_sourceParameterList.getParameter("fragmentation_rule_set")).updateObjects(allFRS);
        ((ObjectParameter)this.m_sourceParameterList.getParameter("fragmentation_rule_set")).setValue(selectedFragmRuleSet);
        Object[] allPS = DatabaseDataManager.getDatabaseDataManager().getPeaklistSoftwaresWithNullArray();
        String selectedPeaklistSoft = ((ObjectParameter)this.m_sourceParameterList.getParameter("peaklist_software")).getStringValue();
        this.m_peaklistSoftwaresComboBox.removeAllItems();
        for (int i = 0; i < allPS.length; ++i) {
            this.m_peaklistSoftwaresComboBox.addItem(allPS[i]);
        }
        ((ObjectParameter)this.m_sourceParameterList.getParameter("peaklist_software")).updateObjects(allPS);
        ((ObjectParameter)this.m_sourceParameterList.getParameter("peaklist_software")).setValue(selectedPeaklistSoft);
        this.updateDecoyRegexEnabled();
    }

    protected boolean okCalled() {
        if (!this.checkParametersForOK()) {
            return false;
        }
        this.saveParameters(NbPreferences.root());
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }

    private boolean checkParametersForOK() {
        int nbFiles = this.m_fileList.getModel().getSize();
        if (nbFiles == 0) {
            this.setStatus(true, "You must select a file to import.");
            this.highlight(this.m_fileList);
            return false;
        }
        return this.checkParameters();
    }

    private void restoreInitialParameters(Preferences preferences) {
        ServerFile f;
        String parser = preferences.get("IdentificationParser", null);
        int parserIndex = -1;
        if (parser != null) {
            int nbParsers = PARSER_NAMES.length;
            for (int i = 0; i < nbParsers; ++i) {
                String parserCur = PARSER_NAMES[i];
                if (parser.compareToIgnoreCase(parserCur) != 0) continue;
                parserIndex = i;
                break;
            }
        }
        if (parserIndex == -1) {
            parserIndex = 0;
        }
        this.m_parserComboBox.setSelectedIndex(parserIndex);
        ArrayList roots = ServerFileSystemView.getServerFileSystemView().getLabels("result_files");
        if (roots == null || roots.isEmpty()) {
            LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Server has returned no Root Path for Result Files. There is a problem with the server installation, please contact your administrator.");
            this.m_rootPathError = true;
            return;
        }
        this.m_rootPathError = false;
        String filePath = preferences.get("IdentificationFilePath", null);
        if (filePath == null && roots.size() >= 1) {
            filePath = (String)roots.get(0);
        }
        if (filePath != null && (f = new ServerFile(filePath, filePath, true, 0L, 0L)).isDirectory()) {
            this.m_defaultDirectory = f;
        }
    }

    public File[] getFilePaths() {
        DefaultListModel model = (DefaultListModel)this.m_fileList.getModel();
        int nbFiles = model.getSize();
        File[] filePaths = new File[nbFiles];
        for (int i = 0; i < nbFiles; ++i) {
            filePaths[i] = (File)model.getElementAt(i);
        }
        return filePaths;
    }

    public HashMap<String, String> getParserArguments() {
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        return parameterList.getValues();
    }

    public long getInstrumentId() {
        InstrumentConfiguration instrument = (InstrumentConfiguration)this.m_sourceParameterList.getParameter("instrument").getObjectValue();
        return instrument.getId();
    }

    public long getPeaklistSoftwareId() {
        PeaklistSoftware peaklistSoftware = (PeaklistSoftware)this.m_sourceParameterList.getParameter("peaklist_software").getObjectValue();
        return peaklistSoftware.getId();
    }

    public long getFragmentationRuleSetId() {
        FragmentationRuleSet fragmentationRuleSet = (FragmentationRuleSet)this.m_sourceParameterList.getParameter("fragmentation_rule_set").getObjectValue();
        if (fragmentationRuleSet == null) {
            return -1L;
        }
        return fragmentationRuleSet.getId();
    }

    public String getParserId() {
        return PARSER_IDS[this.m_parserComboBox.getSelectedIndex()];
    }

    public String getDecoyRegex() {
        if (this.m_decoyRegexTextField.isEnabled()) {
            return this.m_decoyRegexTextField.getText();
        }
        return null;
    }

    private ParameterList[] createParameters() {
        ParameterList[] plArray = new ParameterList[]{this.createMascotParser(), this.createOmssaParser(), this.createXtandemParser(), this.createMzIdentParser()};
        return plArray;
    }

    private ParameterList createMascotParser() {
        ParameterList parameterList = new ParameterList(MASCOT_PARSER);
        parameterList.add((Object)new DoubleParameter("subset.threshold", "Subset Threshold", JTextField.class, Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(1.0)));
        return parameterList;
    }

    private ParameterList createOmssaParser() {
        ParameterList parameterList = new ParameterList(OMSSA_PARSER);
        Preferences preferences = NbPreferences.root();
        String[] fileFilterNames = new String[]{"Usermods XML File"};
        String[] fileFilterExtensions = new String[]{"xml"};
        parameterList.add((Object)new FileParameter((FileSystemView)ServerFileSystemView.getServerFileSystemView(), "usermod.xml.file", "Usermods file path", JTextField.class, preferences.get("Omssa_Parser.Usermods_file_path", ""), fileFilterNames, fileFilterExtensions));
        String[] fileFilterNames2 = new String[]{"PTM composition File"};
        String[] fileFilterExtensions2 = new String[]{"txt"};
        parameterList.add((Object)new FileParameter((FileSystemView)ServerFileSystemView.getServerFileSystemView(), "ptm.composition.file", "PTM composition file path", JTextField.class, preferences.get("Omssa_Parser.PTM_composition_file_path", ""), fileFilterNames2, fileFilterExtensions2));
        return parameterList;
    }

    private ParameterList createXtandemParser() {
        ParameterList parameterList = new ParameterList(XTANDEM_PARSER);
        Preferences preferences = NbPreferences.root();
        parameterList.add((Object)new StringParameter("protein.parsing.rule", "Protein parsing rule", JTextField.class, preferences.get("XtandemParser.protein_parsing_rule", ""), Integer.valueOf(0), Integer.valueOf(50)));
        return parameterList;
    }

    private ParameterList createMzIdentParser() {
        ParameterList mzIdentParameterList = new ParameterList(MZ_IDENT_PARSER);
        Preferences preferences = NbPreferences.root();
        mzIdentParameterList.add((Object)new StringParameter("Test", "Test", JTextField.class, preferences.get("MzIdentParser.test", ""), Integer.valueOf(0), Integer.valueOf(20)));
        return mzIdentParameterList;
    }

    private ParameterList createSourceParameters() {
        ParameterList parameterList = new ParameterList("Parameter Source");
        AbstractParameterToString<InstrumentConfiguration> instrumentToString = new AbstractParameterToString<InstrumentConfiguration>(){

            public String toString(InstrumentConfiguration o) {
                return o.getName();
            }
        };
        AbstractParameterToString<PeaklistSoftware> softwareToString = new AbstractParameterToString<PeaklistSoftware>(){

            public String toString(PeaklistSoftware o) {
                String version = o.getVersion();
                if (version == null) {
                    return o.getName();
                }
                return o.getName() + " " + version;
            }
        };
        AbstractParameterToString<FragmentationRuleSet> fragmentationRuleSetToString = new AbstractParameterToString<FragmentationRuleSet>(){

            public String toString(FragmentationRuleSet o) {
                return o.getName();
            }
        };
        this.m_instrumentsComboBox = new JComboBox<InstrumentConfiguration>(DatabaseDataManager.getDatabaseDataManager().getInstrumentsWithNullArray());
        final ObjectParameter instrumentParameter = new ObjectParameter("instrument", "Instrument", this.m_instrumentsComboBox, (Object[])DatabaseDataManager.getDatabaseDataManager().getInstrumentsWithNullArray(), null, -1, (AbstractParameterToString)instrumentToString);
        parameterList.add((Object)instrumentParameter);
        this.m_instrumentsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                instrumentParameter.setUsed(true);
            }
        });
        this.m_fragmentationRuleSetsComboBox = new JComboBox<FragmentationRuleSet>(DatabaseDataManager.getDatabaseDataManager().getFragmentationRuleSetsWithNullArray());
        final ObjectParameter fragmentationRuleSetParameter = new ObjectParameter("fragmentation_rule_set", "FragmentationRuleSet", this.m_fragmentationRuleSetsComboBox, (Object[])DatabaseDataManager.getDatabaseDataManager().getFragmentationRuleSetsWithNullArray(), null, -1, (AbstractParameterToString)fragmentationRuleSetToString);
        parameterList.add((Object)fragmentationRuleSetParameter);
        this.m_fragmentationRuleSetsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fragmentationRuleSetParameter.setUsed(true);
            }
        });
        this.m_peaklistSoftwaresComboBox = new JComboBox<PeaklistSoftware>(DatabaseDataManager.getDatabaseDataManager().getPeaklistSoftwaresWithNullArray());
        final ObjectParameter peaklistParameter = new ObjectParameter("peaklist_software", "Peaklist Software", this.m_peaklistSoftwaresComboBox, (Object[])DatabaseDataManager.getDatabaseDataManager().getPeaklistSoftwaresWithNullArray(), null, -1, (AbstractParameterToString)softwareToString);
        parameterList.add((Object)peaklistParameter);
        this.m_peaklistSoftwaresComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                peaklistParameter.setUsed(true);
            }
        });
        this.m_decoyComboBox = new JComboBox<String>(DECOY_VALUES);
        final ObjectParameter decoyParameter = new ObjectParameter("decoy_type", "Decoy", this.m_decoyComboBox, (Object[])DECOY_VALUES, (Object[])DECOY_VALUES_ASSOCIATED_KEYS, 0, null);
        parameterList.add((Object)decoyParameter);
        this.m_decoyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                decoyParameter.setUsed(true);
            }
        });
        this.m_decoyRegexTextField = new JTextField(20);
        this.m_decoyRegexParameter = new StringParameter("decoy_accession", "Decoy Accession", (JComponent)this.m_decoyRegexTextField, "", Integer.valueOf(2), null);
        this.m_decoyRegexParameter.setUsed(false);
        this.m_decoyRegexParameter.setCompulsory(false);
        parameterList.add((Object)this.m_decoyRegexParameter);
        return parameterList;
    }

    static {
        EXTENSION_TO_PARSER.put("dat", 0);
        EXTENSION_TO_PARSER.put("omx", 1);
        EXTENSION_TO_PARSER.put("omx.bz2", 1);
        EXTENSION_TO_PARSER.put("xml", 2);
        EXTENSION_TO_PARSER.put("mzid", 3);
        FILE_EXTENSIONS_DESCRIPTION = new String[]{"Mascot Identification Result", "Omssa Identification Result", "X!Tandem Identification Result", "MZIdentML Identification Result"};
        PARSER_IDS = new String[]{"mascot.dat", "omssa.omx", "xtandem.xml", "mzidentml.mzid"};
        DECOY_VALUES = new String[]{null, "No Decoy", "Software Engine Decoy", "Concatenated Decoy"};
        DECOY_VALUES_ASSOCIATED_KEYS = DECOY_VALUES;
    }

    public static class SelectRegexDialog
    extends DefaultDialog {
        private static SelectRegexDialog m_selectRegexSingletonDialog = null;
        private JList<String> m_regexList;
        private JScrollPane m_regexListScrollPane;
        private JButton m_removeRegexButton;
        private String m_selectedRegex = null;
        private ArrayList<String> m_regexArrayList = null;

        public static SelectRegexDialog getDialog(JDialog parent, ArrayList<String> regexArrayList) {
            if (m_selectRegexSingletonDialog == null) {
                m_selectRegexSingletonDialog = new SelectRegexDialog(parent);
            }
            m_selectRegexSingletonDialog.initData(regexArrayList);
            return m_selectRegexSingletonDialog;
        }

        private SelectRegexDialog(JDialog parent) {
            super((Window)parent, Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle("Select Decoy Accession Regex");
            this.setResizable(false);
            this.setMinimumSize(new Dimension(200, 240));
            this.setButtonVisible(5, false);
            this.initInternalPanel();
        }

        private void initData(ArrayList<String> regexArrayList) {
            this.m_regexArrayList = regexArrayList;
            DefaultListModel model = (DefaultListModel)this.m_regexList.getModel();
            model.clear();
            int nb = regexArrayList.size();
            for (int i = 0; i < nb; ++i) {
                model.addElement(regexArrayList.get(i));
            }
        }

        private void initInternalPanel() {
            JPanel internalPanel = new JPanel();
            internalPanel.setLayout(new GridBagLayout());
            JPanel regexSelectionPanel = this.createRegexSelectionPanel();
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            internalPanel.add((Component)regexSelectionPanel, c);
            this.setInternalComponent(internalPanel);
        }

        private JPanel createRegexSelectionPanel() {
            JPanel regexSelectionPanel = new JPanel(new GridBagLayout());
            regexSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Regex Selection "));
            this.m_regexList = new JList(new DefaultListModel());
            this.m_regexList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        m_selectRegexSingletonDialog.doClick(0);
                    }
                }
            });
            this.m_regexListScrollPane = new JScrollPane(this.m_regexList){
                private Dimension preferredSize;
                {
                    super(arg0);
                    this.preferredSize = new Dimension(280, 140);
                }

                @Override
                public Dimension getPreferredSize() {
                    return this.preferredSize;
                }
            };
            this.m_removeRegexButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
            this.m_removeRegexButton.setMargin(new Insets(2, 2, 2, 2));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 3;
            c.weightx = 1.0;
            c.weighty = 1.0;
            regexSelectionPanel.add((Component)this.m_regexListScrollPane, c);
            ++c.gridx;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            regexSelectionPanel.add((Component)this.m_removeRegexButton, c);
            ++c.gridy;
            regexSelectionPanel.add(Box.createVerticalStrut(30), c);
            this.m_regexList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    boolean sometingSelected = m_regexList.getSelectedIndex() != -1;
                    m_removeRegexButton.setEnabled(sometingSelected);
                }
            });
            this.m_removeRegexButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List<String> selectedValues = m_regexList.getSelectedValuesList();
                    Iterator<String> it = selectedValues.iterator();
                    while (it.hasNext()) {
                        ((DefaultListModel)m_regexList.getModel()).removeElement(it.next());
                    }
                    m_removeRegexButton.setEnabled(false);
                }
            });
            return regexSelectionPanel;
        }

        protected boolean okCalled() {
            this.m_selectedRegex = this.m_regexList.getSelectedValue();
            DefaultListModel model = (DefaultListModel)this.m_regexList.getModel();
            int size = model.getSize();
            if (this.m_regexArrayList == null) {
                this.m_regexArrayList = new ArrayList(size);
            } else {
                this.m_regexArrayList.clear();
            }
            for (int i = 0; i < size; ++i) {
                this.m_regexArrayList.add((String)model.elementAt(i));
            }
            return true;
        }

        protected boolean cancelCalled() {
            this.m_selectedRegex = null;
            return true;
        }

        public String getSelectedRegex() {
            return this.m_selectedRegex;
        }

        public ArrayList<String> getRegexArrayList() {
            return this.m_regexArrayList;
        }
    }
}

