/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.DefaultStorableDialog;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MSDiagDialog
extends DefaultStorableDialog {
    private static MSDiagDialog m_singletonDialog = null;
    private static final String SETTINGS_KEY = "MSDiag";
    private JComboBox m_parserComboBox;
    private ParameterList m_sourceParameterList;
    private JPanel m_parserParametersPanel = null;

    public static MSDiagDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new MSDiagDialog(parent);
        }
        m_singletonDialog.reinitialize();
        return m_singletonDialog;
    }

    private MSDiagDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Define settings for Statistical Reports");
        this.setDocumentationSuffix("id.1qoc8b1");
        this.setResizable(true);
        this.setMinimumSize(new Dimension(200, 240));
        this.initInternalPanel();
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JPanel allParametersPanel = this.createAllParametersPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        ++c.gridy;
        c.weighty = 0.0;
        internalPanel.add((Component)allParametersPanel, c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createAllParametersPanel() {
        JPanel allParametersPanel = new JPanel(new GridBagLayout());
        allParametersPanel.setBorder(BorderFactory.createTitledBorder(" Quality Control Reports Settings "));
        JPanel settingsPanel = this.createSettingsPanel();
        this.m_parserParametersPanel = this.createMSDiagParametersPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        allParametersPanel.add((Component)settingsPanel, c);
        ++c.gridy;
        allParametersPanel.add((Component)this.m_parserParametersPanel, c);
        this.m_parserComboBox.setSelectedIndex(0);
        return allParametersPanel;
    }

    private JPanel createSettingsPanel() {
        JPanel parserPanel = new JPanel(new GridBagLayout());
        this.m_parserComboBox = new JComboBox<ParameterList>(this.createParameters());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        parserPanel.add((Component)this.m_parserComboBox, c);
        this.m_parserComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSDiagDialog.this.m_parserComboBox.getSelectedIndex();
                MSDiagDialog.this.initParameters();
                MSDiagDialog.this.repack();
            }
        });
        return parserPanel;
    }

    private JPanel createMSDiagParametersPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" Statistical Settings... "));
        return panel;
    }

    private void initParameters() {
        this.m_parserParametersPanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        this.m_parserParametersPanel.add((Component)parameterList.getPanel(), c);
    }

    private void reinitialize() {
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        parameterList.clean();
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected boolean checkParameters() {
        return true;
    }

    protected void resetParameters() throws Exception {
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        parameterList.initDefaults();
    }

    protected void loadParameters(Preferences filePreferences) throws Exception {
        Preferences preferences = NbPreferences.root();
        String[] keys = filePreferences.keys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String value = filePreferences.get(key, null);
            preferences.put(key, value);
        }
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        parameterList.loadParameters(filePreferences);
    }

    protected void saveParameters(Preferences preferences) {
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        String parserSelected = parameterList.toString();
        preferences.put("IdentificationParser", parserSelected);
    }

    protected boolean okCalled() {
        if (!this.checkParameters()) {
            return false;
        }
        this.saveParameters(NbPreferences.root());
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }

    public HashMap<String, String> getMSDiagSettings() {
        ParameterList parameterList = (ParameterList)this.m_parserComboBox.getSelectedItem();
        return parameterList.getValues();
    }

    private ParameterList[] createParameters() {
        ParameterList[] plArray = new ParameterList[]{this.createMSDiagSettings()};
        return plArray;
    }

    private ParameterList createMSDiagSettings() {
        ParameterList parameterList = new ParameterList(SETTINGS_KEY);
        parameterList.add((Object)new StringParameter("score.windows", "Score windows (ex: 20-40-60)", JTextField.class, "20-40-60", null, null));
        parameterList.add((Object)new IntegerParameter("max.rank", "Max rank", JTextField.class, Integer.valueOf(1), Integer.valueOf(0), null));
        return parameterList;
    }
}

