/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractParamsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IsobaricMethodParamsPanel
extends AbstractParamsPanel {
    private JTextField m_extractionMoZTolTF;
    private JComboBox<String> m_reporterSourceCbx;
    private JCheckBox m_rescaleAbundancestoMS1CB;
    public static final String ISOBARIC_PARAMS_PREFIX = "IsobaricParameters";
    private final boolean m_readOnly;
    protected static final Double DEFAULT_ISOBARIC_EXTRACTION_MOZTOL_VALUE = 25.0;
    protected static final String DEFAULT_MOZTOL_UNIT = "PPM";

    public IsobaricMethodParamsPanel(QuantitationMethod method) {
        this(method, false);
    }

    public IsobaricMethodParamsPanel(QuantitationMethod method, boolean readOnly) {
        this.m_readOnly = readOnly;
        this.m_parameterList = new ParameterList(ISOBARIC_PARAMS_PREFIX);
        this.createParameters();
        this.setLayout(new BorderLayout());
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
        this.m_parameterList.updateValues(NbPreferences.root());
    }

    private void createParameters() {
        this.m_extractionMoZTolTF = new JTextField();
        DoubleParameter extractionMoZTolParameter = new DoubleParameter("extractionMoZTol", "Extraction moz tolerance", (JComponent)this.m_extractionMoZTolTF, DEFAULT_ISOBARIC_EXTRACTION_MOZTOL_VALUE, Double.valueOf(0.0), null);
        this.m_extractionMoZTolTF.setEnabled(!this.m_readOnly);
        this.m_parameterList.add((Object)extractionMoZTolParameter);
        this.m_rescaleAbundancestoMS1CB = new JCheckBox("Rescale reporter abundances to MS1 signal", false);
        BooleanParameter rescaleAbundanceParameter = new BooleanParameter("RescaleAb2MS1", "Rescale Abundance to MS1", (JComponent)this.m_rescaleAbundancestoMS1CB, Boolean.valueOf(false));
        this.m_rescaleAbundancestoMS1CB.setEnabled(!this.m_readOnly);
        this.m_parameterList.add((Object)rescaleAbundanceParameter);
        Object[] rscValue = new String[ReporterSources.values().length];
        Object[] rscKeys = new String[ReporterSources.values().length];
        int index = 0;
        for (ReporterSources rs : ReporterSources.values()) {
            rscValue[index] = rs.getDisplayValue();
            rscKeys[index++] = rs.name();
        }
        this.m_reporterSourceCbx = new JComboBox<String>(rscValue);
        this.m_reporterSourceCbx.setEnabled(!this.m_readOnly);
        ObjectParameter reporterSourceParameter = new ObjectParameter("reporterSource", "Reporter extract source", this.m_reporterSourceCbx, rscValue, rscKeys, 0, null);
        this.m_parameterList.add((Object)reporterSourceParameter);
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder("Isobaric tagging parameters"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        mainPanel.add((Component)this.createExtractionParamPanel(), c);
        ++c.gridy;
        mainPanel.add((Component)this.createReporterSourcePanel(), c);
        ++c.gridy;
        mainPanel.add(this.createRescalePanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        mainPanel.add(Box.createVerticalGlue(), c);
        return mainPanel;
    }

    private JPanel createReporterSourcePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel extractionMoZTolLabel = new JLabel("Reporter ions will be extracted from:");
        extractionMoZTolLabel.setEnabled(!this.m_readOnly);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.add((Component)extractionMoZTolLabel, c);
        ++c.gridx;
        c.weightx = 0.0;
        panel.add(this.m_reporterSourceCbx, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }

    private JPanel createExtractionParamPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel extractionMoZTolLabel = new JLabel("Reporter ions m/z tolerance (ppm):");
        extractionMoZTolLabel.setEnabled(!this.m_readOnly);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.add((Component)extractionMoZTolLabel, c);
        ++c.gridx;
        c.weightx = 0.0;
        panel.add((Component)this.m_extractionMoZTolTF, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }

    @Override
    public Map<String, Object> getQuantParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> extractionParams = new HashMap<String, String>();
        extractionParams.put("moz_tol", this.m_extractionMoZTolTF.getText());
        extractionParams.put("moz_tol_unit", DEFAULT_MOZTOL_UNIT);
        params.put("extraction_params", extractionParams);
        String sourceValue = (String)this.m_reporterSourceCbx.getSelectedItem();
        ReporterSources rs = ReporterSources.getResourceSourcesForDisplay(sourceValue);
        params.put("reporter_ion_data_source", rs.name());
        params.put("label_free_quant_config", this.m_rescaleAbundancestoMS1CB.isSelected());
        return params;
    }

    @Override
    public void setQuantParams(Map<String, Object> quantParams) {
        if (quantParams == null || quantParams.isEmpty()) {
            this.resetValues();
        } else {
            try {
                String extractParamVal = ((Map)quantParams.get("extraction_params")).getOrDefault("moz_tol", "").toString();
                this.m_extractionMoZTolTF.setText(extractParamVal);
                String reporterDS = (String)quantParams.get("reporter_ion_data_source");
                this.m_reporterSourceCbx.setSelectedItem(ReporterSources.valueOf(reporterDS).getDisplayValue());
                this.m_rescaleAbundancestoMS1CB.setSelected(quantParams.containsKey("label_free_quant_config"));
            }
            catch (ClassCastException | NullPointerException exep) {
                this.resetValues();
            }
        }
    }

    private void resetValues() {
        this.m_extractionMoZTolTF.setText("");
        this.m_reporterSourceCbx.setSelectedIndex(0);
        this.m_rescaleAbundancestoMS1CB.setSelected(false);
    }

    private Component createRescalePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)this.m_rescaleAbundancestoMS1CB, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }

    static enum ReporterSources {
        PROLINE_SPECTRUM("Proline spectrum"),
        MZDB_MS2_SPECTRUM("mzdb MS2 spectrum"),
        MZDB_MS3_SPECTRUM("mzdb MS3 spectrum");

        private String m_displayValue;

        private ReporterSources(String displayValue) {
            this.m_displayValue = displayValue;
        }

        public String getDisplayValue() {
            return this.m_displayValue;
        }

        public static ReporterSources getResourceSourcesForDisplay(String displayValue) {
            for (ReporterSources rs : ReporterSources.values()) {
                if (!rs.getDisplayValue().equals(displayValue)) continue;
                return rs;
            }
            return null;
        }
    }
}

