/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.xic.DatasetReferenceNode;
import fr.proline.studio.rsmexplorer.tree.xic.IdentificationSelectionTree;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExpDesignTreeListener;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICSelectionTransferable;
import fr.proline.studio.rsmexplorer.tree.xic.XICTransferHandler;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.hibernate.Hibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantExperimentalDesignPanel
extends JPanel {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer");
    private AbstractNode m_rootNode;
    private final IdentificationTree m_selectionTree;
    private QuantExperimentalDesignTree m_experimentalDesignTree;
    private final AbstractNode m_initialRootNode;
    private final QuantitationMethod.Type m_quantitationType;
    private final JPanel m_selectionPanel;
    private JComboBox<QuantitationMethod> m_methodsCbx;
    private JCheckBox m_multiBatchCB;
    private boolean m_isMultiQuantPanel;
    private final boolean m_isMultiQuantAllowed;
    private final boolean m_isMultiBatchAllowed;
    private QuantitationMethod m_selectedMethod;
    private XICTransferHandler m_expDesignTransferTreeHandler;
    private List<QuantExpDesignTreeListener> listenerList;

    public QuantExperimentalDesignPanel(AbstractNode rootNode, IdentificationTree selectionTree, QuantitationMethod.Type quantitationType) {
        this.m_initialRootNode = rootNode;
        this.m_isMultiQuantAllowed = quantitationType.equals((Object)QuantitationMethod.Type.ISOBARIC_TAGGING);
        AbstractNode treeRoot = this.m_isMultiQuantAllowed ? new DataSetNode((AbstractData)DataSetData.createTemporaryFolder((String)"All Quantifications")) : rootNode;
        this.m_isMultiQuantPanel = this.m_isMultiQuantAllowed;
        this.m_isMultiBatchAllowed = this.m_isMultiQuantAllowed;
        this.m_rootNode = treeRoot;
        this.m_selectionTree = selectionTree;
        this.m_experimentalDesignTree = this.m_isMultiQuantPanel ? new QuantExperimentalDesignTree(this.m_rootNode, true, false) : new QuantExperimentalDesignTree(this.m_rootNode, true, true);
        this.m_expDesignTransferTreeHandler = (XICTransferHandler)this.m_experimentalDesignTree.getTransferHandler();
        this.m_quantitationType = quantitationType;
        this.m_selectionPanel = this.createSelectionTreePanel();
        this.initializeMethodComponents();
        this.setLayout(new BorderLayout());
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
    }

    private void reinitPanel() {
        AbstractNode treeRoot = this.m_isMultiQuantPanel ? new DataSetNode((AbstractData)DataSetData.createTemporaryFolder((String)"All Quantifications")) : this.m_initialRootNode;
        this.m_rootNode = treeRoot;
        this.m_experimentalDesignTree = this.m_isMultiQuantPanel ? new QuantExperimentalDesignTree(this.m_rootNode, true, false) : new QuantExperimentalDesignTree(this.m_rootNode, true, true);
        this.m_expDesignTransferTreeHandler = (XICTransferHandler)this.m_experimentalDesignTree.getTransferHandler();
        this.fireExpDesignTreeChanges();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
        this.revalidate();
        this.repaint();
    }

    public boolean isMultiQuantPanel() {
        return this.m_isMultiQuantPanel;
    }

    public boolean isMultiBatchSelected() {
        return this.m_multiBatchCB.isSelected();
    }

    protected final JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel designTreePanel = this.createDesignTreePanel();
        JSplitPane sp = new JSplitPane();
        sp.setLeftComponent(designTreePanel);
        sp.setRightComponent(this.m_selectionPanel);
        sp.setResizeWeight(0.5);
        JPanel framePanel = new JPanel(new GridBagLayout());
        framePanel.setBorder(BorderFactory.createTitledBorder(" Experimental Design "));
        GridBagConstraints cFrame = new GridBagConstraints();
        cFrame.insets = new Insets(5, 5, 5, 5);
        cFrame.gridx = 0;
        cFrame.gridy = 0;
        cFrame.weightx = 1.0;
        cFrame.weighty = 1.0;
        cFrame.anchor = 18;
        cFrame.fill = 1;
        cFrame.gridwidth = 1;
        framePanel.add((Component)sp, cFrame);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        switch (this.m_quantitationType) {
            case ISOBARIC_TAGGING: 
            case RESIDUE_LABELING: {
                c.fill = 2;
                c.weighty = 0.0;
                mainPanel.add((Component)this.createMethodPanel(), c);
                c.gridx = 0;
                ++c.gridy;
            }
        }
        c.weighty = 1.0;
        c.fill = 1;
        mainPanel.add((Component)framePanel, c);
        return mainPanel;
    }

    private void initializeMethodComponents() {
        QuantitationMethod[] allMethods;
        QuantitationMethod[] quantMethods = this.retrieveQuantMethods(this.m_quantitationType);
        if (this.m_quantitationType.equals((Object)QuantitationMethod.Type.LABEL_FREE)) {
            allMethods = quantMethods;
        } else {
            allMethods = new QuantitationMethod[quantMethods.length + 1];
            allMethods[0] = null;
            for (int i = 1; i <= quantMethods.length; ++i) {
                allMethods[i] = quantMethods[i - 1];
            }
        }
        this.m_methodsCbx = new JComboBox<QuantitationMethod>(allMethods);
        this.m_selectedMethod = (QuantitationMethod)this.m_methodsCbx.getSelectedItem();
        this.m_methodsCbx.addItemListener(e -> {
            this.m_selectedMethod = (QuantitationMethod)this.m_methodsCbx.getSelectedItem();
        });
        if (this.m_isMultiBatchAllowed) {
            this.m_multiBatchCB = new JCheckBox("Multi Batch Quantitation");
            this.m_multiBatchCB.addActionListener(e -> {
                this.m_isMultiQuantPanel = this.m_isMultiQuantAllowed && !this.m_multiBatchCB.isSelected();
                this.reinitPanel();
            });
        }
    }

    private JPanel createMethodPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" Quantitation Method "));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.anchor = 18;
        c.fill = 0;
        JLabel label = new JLabel("Name:");
        panel.add((Component)label, c);
        ++c.gridx;
        panel.add(this.m_methodsCbx, c);
        if (this.m_isMultiBatchAllowed) {
            ++c.gridx;
            panel.add((Component)this.m_multiBatchCB, c);
        }
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)new JPanel(), c);
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuantitationMethod[] retrieveQuantMethods(QuantitationMethod.Type quantitationType) {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            TypedQuery query = entityManagerUDS.createNamedQuery("findQuantMethodForType", QuantitationMethod.class);
            query.setParameter("searchType", (Object)quantitationType.toString());
            List results = query.getResultList();
            results.forEach(method -> Hibernate.initialize((Object)method.getLabels()));
            QuantitationMethod[] quantitationMethodArray = results.toArray(new QuantitationMethod[0]);
            return quantitationMethodArray;
        }
        return new QuantitationMethod[0];
    }

    private JPanel createDesignTreePanel() {
        JPanel designTreePanel = new JPanel();
        if (!this.m_isMultiQuantPanel) {
            designTreePanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JScrollPane treeScrollPane = new JScrollPane();
            treeScrollPane.setViewportView(this.m_experimentalDesignTree);
            designTreePanel.add((Component)treeScrollPane, c);
        } else {
            JSplitPane sp = new JSplitPane(0);
            sp.setResizeWeight(0.5);
            JPanel dndPanel = new JPanel();
            dndPanel.setLayout(new GridBagLayout());
            GridBagConstraints c2 = new GridBagConstraints();
            c2.anchor = 18;
            c2.fill = 0;
            c2.insets = new Insets(5, 5, 5, 5);
            c2.gridx = 0;
            c2.gridy = 0;
            c2.weightx = 0.0;
            c2.weighty = 0.0;
            JLabel quantTitle = new JLabel("Drag&Drop datasets to quantify here : ");
            dndPanel.add((Component)quantTitle, c2);
            ++c2.gridx;
            c2.anchor = 13;
            JButton clearButton = new JButton();
            clearButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
            clearButton.setToolTipText("Clear All");
            clearButton.addActionListener(e -> {
                this.m_isMultiQuantPanel = this.m_isMultiQuantAllowed;
                this.reinitPanel();
            });
            dndPanel.add((Component)clearButton, c2);
            c2.gridx = 0;
            ++c2.gridy;
            c2.weightx = 1.0;
            c2.weighty = 1.0;
            c2.gridwidth = 2;
            c2.fill = 1;
            JList datasetToQuantList = new JList(new DefaultListModel());
            datasetToQuantList.setTransferHandler(new ListTransferHandler(this.m_experimentalDesignTree, this.m_initialRootNode, this.m_expDesignTransferTreeHandler));
            JScrollPane listPane = new JScrollPane(datasetToQuantList);
            dndPanel.add((Component)listPane, c2);
            JScrollPane treeScrollPane = new JScrollPane();
            treeScrollPane.setViewportView(this.m_experimentalDesignTree);
            sp.setTopComponent(dndPanel);
            sp.setBottomComponent(treeScrollPane);
            designTreePanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            designTreePanel.add((Component)sp, c);
        }
        return designTreePanel;
    }

    private JPanel createSelectionTreePanel() {
        JPanel selectionTreePanel = new JPanel();
        boolean isCorrect = true;
        Enumeration<TreeNode> childEnum = this.m_rootNode.children();
        while (childEnum.hasMoreElements()) {
            AbstractNode childNode = (AbstractNode)childEnum.nextElement();
            if (!(childNode instanceof DatasetReferenceNode)) continue;
            isCorrect = !((DatasetReferenceNode)childNode).isInvalidReference();
        }
        selectionTreePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (isCorrect) {
            AbstractNode rootSelectionNode = this.m_selectionTree == null ? IdentificationTree.getCurrentTree().copyRootNodeForSelection() : this.m_selectionTree.copyRootNodeForSelection();
            IdentificationSelectionTree tree = new IdentificationSelectionTree(rootSelectionNode, true);
            JScrollPane treeScrollPane = new JScrollPane();
            treeScrollPane.setViewportView(tree);
            ++c.gridy;
            selectionTreePanel.add((Component)treeScrollPane, c);
        } else {
            selectionTreePanel = new JPanel(new BorderLayout());
            JLabel errMsgLabel = new JLabel("<html>Invalid Reference Dataset Specified in XIC (may have been revalidated).<br> Same data will be used, no change in experimental design is allowed.</html>", IconManager.getIcon((IconManager.IconType)IconManager.IconType.EXCLAMATION), 0);
            errMsgLabel.setForeground(Color.red);
            selectionTreePanel.add((Component)errMsgLabel, "Center");
        }
        return selectionTreePanel;
    }

    public QuantExperimentalDesignTree getExperimentalDesignTree() {
        return this.m_experimentalDesignTree;
    }

    public List<Long> getQuantifiedRsmIds() {
        ArrayList<Long> rsmids = new ArrayList<Long>();
        if (this.m_isMultiQuantPanel) {
            Enumeration<TreeNode> enumeration = this.m_rootNode.children();
            while (enumeration.hasMoreElements()) {
                rsmids.addAll(this.m_experimentalDesignTree.getQuantifiedRsmIds((AbstractNode)enumeration.nextElement()));
            }
        } else {
            rsmids.addAll(this.m_experimentalDesignTree.getQuantifiedRsmIds(this.m_initialRootNode));
        }
        return rsmids;
    }

    public Component getQuantMethodComponent() {
        return this.m_methodsCbx;
    }

    public QuantitationMethod getQuantitationMethod() {
        return this.m_selectedMethod;
    }

    public void addQuantExpDesignTreeListener(QuantExpDesignTreeListener l) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<QuantExpDesignTreeListener>();
        }
        this.listenerList.add(l);
    }

    public void removeQuantExpDesignTreeListener(QuantExpDesignTreeListener l) {
        this.listenerList.remove(l);
    }

    private void fireExpDesignTreeChanges() {
        for (QuantExpDesignTreeListener l : this.listenerList) {
            l.experiementalTreeChange(this.m_experimentalDesignTree);
        }
    }

    static class ListTransferHandler
    extends TransferHandler {
        private final XICTransferHandler m_xicHandler;
        private final QuantExperimentalDesignTree m_experimentalDesignTrees;
        private final AbstractNode m_templateNode;

        protected ListTransferHandler(QuantExperimentalDesignTree experimentalDesignTrees, AbstractNode template, XICTransferHandler xicHandler) {
            this.m_experimentalDesignTrees = experimentalDesignTrees;
            this.m_templateNode = template;
            this.m_xicHandler = xicHandler;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(XICSelectionTransferable.RSMNodeList_FLAVOR);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            m_logger.info(" Import data to List " + support.toString());
            if (this.canImport(support)) {
                try {
                    XICSelectionTransferable transfer = (XICSelectionTransferable)support.getTransferable().getTransferData(XICSelectionTransferable.RSMNodeList_FLAVOR);
                    XICSelectionTransferable.TransferData data = XICSelectionTransferable.getData(transfer.getTransferKey());
                    JList.DropLocation dropLocation = (JList.DropLocation)support.getDropLocation();
                    DefaultListModel listModel = (DefaultListModel)((JList)support.getComponent()).getModel();
                    AbstractNode root = (AbstractNode)this.m_experimentalDesignTrees.getModel().getRoot();
                    int nbC = root.getChildCount() + 1;
                    XICSelectionTransferable.TransferData singleData = new XICSelectionTransferable.TransferData(data.getSourceId());
                    int index = Math.max(0, dropLocation.getIndex());
                    for (DataSetNode item : data.getDatasetList()) {
                        listModel.add(index++, item.getData().getName());
                        DataSetNode newChild = new DataSetNode((AbstractData)DataSetData.createTemporaryQuantitation((String)("Quant-" + nbC)));
                        this.m_templateNode.copyChildren(newChild);
                        ((DefaultTreeModel)this.m_experimentalDesignTrees.getModel()).insertNodeInto(newChild, root, nbC - 1);
                        ++nbC;
                        ArrayList<DataSetNode> singleDatanode = new ArrayList<DataSetNode>();
                        singleDatanode.add(item);
                        singleData.setDatasetList(singleDatanode);
                        this.m_xicHandler.importDirectNodeToQuant(newChild, singleData);
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }
}

