/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation;

import fr.proline.core.orm.uds.BiologicalGroup;
import fr.proline.core.orm.uds.BiologicalSample;
import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.DQuantitationChannelMapping;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalGroupNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleNode;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class QCMappingTreeTableModel
extends AbstractTreeTableModel {
    List<DDataset> m_datasets;
    Map<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> m_parentQCMappings;

    public QCMappingTreeTableModel(AbstractNode rootNode, List<DDataset> datasets) {
        super((Object)rootNode);
        this.m_datasets = datasets;
        this.m_parentQCMappings = this.inferDefaultMapping(rootNode);
    }

    public int getColumnCount() {
        return this.m_datasets.size() + 1;
    }

    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Sample Analysis";
        }
        DDataset ds = this.m_datasets.get(columnIndex - 1);
        return ds.getName();
    }

    public String getToolTipText(Object o, int column) {
        QuantitationChannel childQc;
        DQuantitationChannelMapping mapping;
        Map<DDataset, QuantitationChannel> quantChannelMap;
        DDataset ds = this.getDatasetAt(column);
        AbstractNode node = (AbstractNode)o;
        if (node != null && node.getType() == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS && (quantChannelMap = (mapping = this.m_parentQCMappings.get(node)).getMappedQuantChannels()) != null && (childQc = quantChannelMap.get(ds)) != null) {
            return childQc.getName() + " (id=" + childQc.getId() + ", number=" + childQc.getNumber() + ")";
        }
        return null;
    }

    private Map<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> inferDefaultMapping(AbstractNode node) {
        HashMap<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> mappings = new HashMap<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping>();
        Stream<TreeNode> groupStream = Collections.list(node.children()).stream().filter(n -> ((AbstractNode)n).getType() == AbstractNode.NodeTypes.BIOLOGICAL_GROUP);
        AtomicInteger index = new AtomicInteger(1);
        List groupNodes = groupStream.map(o -> (XICBiologicalGroupNode)o).collect(Collectors.toList());
        for (XICBiologicalGroupNode groupNode : groupNodes) {
            Stream<TreeNode> sampleStream = Collections.list(groupNode.children()).stream().filter(n -> ((AbstractNode)n).getType() == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE);
            List sampleNodeList = sampleStream.map(s -> (XICBiologicalSampleNode)s).collect(Collectors.toList());
            for (XICBiologicalSampleNode sampleNode : sampleNodeList) {
                Stream<XICBiologicalSampleAnalysisNode> sampleNodeStream = this.parseSample(sampleNode);
                Map<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> qcsNodes = sampleNodeStream.collect(Collectors.toMap(x -> x, x -> new DQuantitationChannelMapping(index.getAndIncrement())));
                List sortedMappings = qcsNodes.values().stream().sorted(Comparator.comparing(DQuantitationChannelMapping::getParentQCNumber)).collect(Collectors.toList());
                for (DDataset ds : this.m_datasets) {
                    BiologicalSample sample;
                    BiologicalGroup group = ds.getGroupSetup().getBiologicalGroups().stream().filter(bg -> bg.getName().equals(((DataSetData)groupNode.getData()).getTemporaryName())).findAny().orElse(null);
                    if (group == null || (sample = (BiologicalSample)group.getBiologicalSamples().stream().filter(bs -> bs.getName().equals(this.getCompletSampleName(group, sampleNode))).findAny().orElse(null)) == null) continue;
                    List groupQcs = sample.getQuantitationChannels();
                    for (int k = 0; k < Math.min(groupQcs.size(), sortedMappings.size()); ++k) {
                        ((DQuantitationChannelMapping)sortedMappings.get(k)).put(ds, (QuantitationChannel)groupQcs.get(k));
                    }
                }
                mappings.putAll(qcsNodes);
            }
        }
        return mappings;
    }

    private String getCompletSampleName(BiologicalGroup group, XICBiologicalSampleNode sampleNode) {
        String groupName = group.getName();
        String sampleName = ((DataSetData)sampleNode.getData()).getTemporaryName();
        Object sampleCompletName = sampleName.startsWith(groupName) ? sampleName : groupName + sampleName;
        return sampleCompletName;
    }

    private Stream<XICBiologicalSampleAnalysisNode> parseGroup(XICBiologicalGroupNode groupNode) {
        Stream<XICBiologicalSampleAnalysisNode> stream = Collections.list(groupNode.children()).stream().flatMap(sampleNode -> Collections.list(((AbstractNode)sampleNode).children()).stream());
        return stream.map(node -> (XICBiologicalSampleAnalysisNode)node);
    }

    private Stream<XICBiologicalSampleAnalysisNode> parseSample(XICBiologicalSampleNode sampleNode) {
        Stream stream = Collections.list(sampleNode.children()).stream();
        return stream.map(node -> (XICBiologicalSampleAnalysisNode)node);
    }

    public boolean isCellEditable(Object o, int column) {
        return false;
    }

    public void setValueAt(Object value, Object node, int column) {
        String text = (String)value;
        DDataset ds = this.m_datasets.get(column - 1);
        DQuantitationChannelMapping mapping = this.m_parentQCMappings.get(node);
        if (text == null || text.trim().isEmpty()) {
            mapping.put(ds, null);
        } else {
            try {
                int number = Integer.parseInt(text);
                mapping.put(ds, number);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object getValueAt(Object o, int columnIndex) {
        AbstractNode node = (AbstractNode)o;
        if (columnIndex == 0) {
            return node.toString();
        }
        if (XICBiologicalSampleAnalysisNode.class.isAssignableFrom(node.getClass())) {
            DDataset ds = this.m_datasets.get(columnIndex - 1);
            DQuantitationChannelMapping mapping = this.m_parentQCMappings.get(node);
            if (mapping == null) {
                return "<nothing>";
            }
            QuantitationChannel childQc = mapping.getMappedQuantChannels().get(ds);
            if (childQc != null) {
                return childQc.getName();
            }
            return "<ignored>";
        }
        return null;
    }

    public Object getChannelAt(Object o, int columnIndex) {
        AbstractNode node = (AbstractNode)o;
        if (columnIndex == 0) {
            return node.toString();
        }
        if (XICBiologicalSampleAnalysisNode.class.isAssignableFrom(node.getClass())) {
            DDataset ds = this.m_datasets.get(columnIndex - 1);
            DQuantitationChannelMapping mapping = this.m_parentQCMappings.get(node);
            if (mapping != null) {
                QuantitationChannel childQc = mapping.getMappedQuantChannels().get(ds);
                return childQc;
            }
        }
        return null;
    }

    public DQuantitationChannelMapping getRowMapping(Object o) {
        if (o instanceof XICBiologicalSampleAnalysisNode) {
            return this.m_parentQCMappings.get(o);
        }
        return null;
    }

    public Object getChild(Object parent, int index) {
        TreeNode node = (TreeNode)parent;
        return node.getChildAt(index);
    }

    public int getChildCount(Object parent) {
        TreeNode node = (TreeNode)parent;
        return node.getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        AbstractNode node = (AbstractNode)parent;
        return node.getIndex((TreeNode)child);
    }

    public Map<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> getMapping() {
        return this.m_parentQCMappings;
    }

    public DDataset getDatasetAt(int column) {
        return this.m_datasets.get(column - 1);
    }

    public boolean isEmptyChannel(Object srcNode, int col) {
        DQuantitationChannelMapping srcMapping;
        QuantitationChannel srcChannel;
        if (col == 0) {
            return true;
        }
        DDataset Quanti = this.getDatasetAt(col);
        return XICBiologicalSampleAnalysisNode.class.isInstance(srcNode) && (srcChannel = (srcMapping = this.m_parentQCMappings.get((XICBiologicalSampleAnalysisNode)srcNode)).getQuantChannel(Quanti)) == null;
    }

    public String verifyRedundantChannel() {
        Object r = "";
        for (DDataset ds : this.m_datasets) {
            String info = this.redundantChannel(ds);
            if (info.isEmpty()) continue;
            r = (String)r + info + "\n";
        }
        return r;
    }

    protected String redundantChannel(DDataset quanti) {
        HashMap<String, ArrayList<XICBiologicalSampleAnalysisNode>> repeatedChannel = new HashMap<String, ArrayList<XICBiologicalSampleAnalysisNode>>();
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        Map<XICBiologicalSampleAnalysisNode, DQuantitationChannelMapping> map = this.getMapping();
        for (XICBiologicalSampleAnalysisNode node : map.keySet()) {
            QuantitationChannel channel = map.get(node).getQuantChannel(quanti);
            if (channel == null) continue;
            ArrayList<XICBiologicalSampleAnalysisNode> nodes = (ArrayList<XICBiologicalSampleAnalysisNode>)repeatedChannel.get(channel.getName());
            if (nodes == null) {
                nodes = new ArrayList<XICBiologicalSampleAnalysisNode>();
            }
            nodes.add(node);
            repeatedChannel.put(channel.getName(), nodes);
        }
        for (String channel : repeatedChannel.keySet()) {
            List nodes = (List)repeatedChannel.get(channel);
            if (nodes.size() <= 1) continue;
            String s = channel + " repeated in ";
            s = s + nodes.stream().map(n -> n.toString()).collect(Collectors.joining(",", "{", "}"));
            result.add((CallSite)((Object)s));
        }
        if (result.isEmpty()) {
            return "";
        }
        return "In Column: " + quanti.getName() + "\n" + result.stream().collect(Collectors.joining("\n"));
    }

    public String toString() {
        return "QCMappingTreeTableModel{m_datasets=" + this.m_datasets + ", m_parentQCMappings=" + this.m_parentQCMappings + "}";
    }
}

