/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.uds.QuantitationLabel;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DefaultColoredCellRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public abstract class AbstractCorrectionMatrixTableModel
extends DecoratedTableModel {
    protected List<String> columnNames;
    List<MassReporter> massReporters;
    protected int valueCoeffColumWidth = 50;
    public static final String TMT_6PLEX_METHOD = "TMT 6plex";
    public static final String TMT_10PLEX_METHOD = "TMT 10plex";
    public static final String TMT_11PLEX_METHOD = "TMT 11plex";
    public static final String TMT_16PLEX_METHOD = "TMT 16plex";
    public static final String TMT_18PLEX_METHOD = "TMT 18plex";
    public static final String TMT_16PLEX_DEUT_METHOD = "TMT 16plex-Deuterated";
    public static final String TMT_35PLEX_METHOD = "TMT 35plex";

    public int getCenterColIndex() {
        return this.columnNames.size() / 2;
    }

    public int getCoeffColumWidth() {
        return this.valueCoeffColumWidth;
    }

    public String getToolTipForHeader(int col) {
        if (col < this.columnNames.size()) {
            return this.columnNames.get(col);
        }
        return "";
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    protected int getCoeffIndex(int colIndex) {
        if (colIndex == 0 || colIndex == this.getCenterColIndex() || colIndex >= this.getColumnCount()) {
            return -1;
        }
        int coefIndex = colIndex < this.getCenterColIndex() ? colIndex - 1 : colIndex - 2;
        return coefIndex;
    }

    public void clearMatrix() {
        for (MassReporter mr : this.massReporters) {
            for (int i = 0; i < mr.correctionCount; ++i) {
                if (mr.coef.get(i).isNaN()) continue;
                mr.coef.set(i, Float.valueOf(0.0f));
            }
        }
    }

    public boolean isCellEditable(int row, int col) {
        MassReporter mr = this.massReporters.get(row);
        int coefIndex = this.getCoeffIndex(col);
        if (coefIndex == -1) {
            return false;
        }
        return mr.isCoeffApplicable(coefIndex);
    }

    public String getColumnName(int column) {
        if (column > this.columnNames.size()) {
            return null;
        }
        return this.columnNames.get(column);
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 || columnIndex == this.getCenterColIndex()) {
            return String.class;
        }
        return Float.class;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        MassReporter mr = this.massReporters.get(rowIndex);
        if (columnIndex == 0 || columnIndex == this.getCenterColIndex()) {
            return;
        }
        try {
            Float newValue = Float.valueOf(aValue.toString());
            int coefIndex = this.getCoeffIndex(columnIndex);
            if (coefIndex == -1) {
                return;
            }
            mr.coef.set(coefIndex, newValue);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
    }

    public TableCellRenderer getRenderer(int row, int col) {
        Object renderer;
        if (col == 0) {
            renderer = new DefaultAlignRenderer((TableCellRenderer)new DefaultColoredCellRenderer(HighlighterFactory.GENERIC_GRAY), 2);
        } else if (col == this.getCenterColIndex()) {
            renderer = new DefaultAlignRenderer((TableCellRenderer)new DefaultColoredCellRenderer(HighlighterFactory.GENERIC_GRAY), 4);
        } else {
            MassReporter mr = this.massReporters.get(row);
            int coefIndex = this.getCoeffIndex(col);
            renderer = coefIndex == -1 ? new DefaultAlignRenderer((TableCellRenderer)new DefaultColoredCellRenderer(HighlighterFactory.GENERIC_GRAY), 2) : (mr.isCoeffApplicable(coefIndex) ? new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4) : new DefaultColoredCellRenderer(new Color(255, 242, 204)));
        }
        return renderer;
    }

    public int getRowCount() {
        return this.massReporters.size();
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        MassReporter mr = this.massReporters.get(rowIndex);
        if (columnIndex == 0) {
            return mr.name;
        }
        if (columnIndex == this.getCenterColIndex()) {
            return "100";
        }
        Float coef = Float.valueOf(0.0f);
        int coefIndex = this.getCoeffIndex(columnIndex);
        if (mr.coef.size() > coefIndex && coefIndex != -1) {
            coef = mr.coef.get(coefIndex);
        }
        return coef;
    }

    public abstract String getPurityMatrixAsString();

    protected String getReporterLabel(QuantitationLabel label) {
        StringBuilder massRepLabel = new StringBuilder(label.getName());
        try {
            Map serProp = label.getSerializedPropertiesAsMap();
            if (serProp != null && !serProp.isEmpty() && serProp.containsKey("reporter_mz")) {
                massRepLabel.append(" (").append(serProp.get("reporter_mz")).append(")");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return massRepLabel.toString();
    }

    static class MassReporter {
        String name;
        int correctionCount;
        List<Float> coef;

        public MassReporter(String name, int correctionCount, int[] indexes) {
            this.name = name;
            this.correctionCount = correctionCount;
            this.coef = new ArrayList<Float>(correctionCount);
            for (int i = 0; i < correctionCount; ++i) {
                int finalI = i;
                if (Arrays.stream(indexes).anyMatch(index -> index == finalI)) {
                    this.coef.add(Float.valueOf(Float.NaN));
                    continue;
                }
                this.coef.add(Float.valueOf(0.0f));
            }
        }

        public String getName() {
            return this.name;
        }

        public List<Float> getCoefWithoutNan() {
            return this.coef.stream().map(value -> Float.valueOf(Float.isNaN(value.floatValue()) ? 0.0f : value.floatValue())).collect(Collectors.toList());
        }

        public boolean isCoeffApplicable(int index) {
            if (index >= this.correctionCount) {
                return false;
            }
            return !this.coef.get(index).isNaN();
        }

        public Float getCoeffSum() {
            return this.coef.stream().filter(value -> !Float.isNaN(value.floatValue())).reduce(Float.valueOf(0.0f), Float::sum);
        }
    }
}

