/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.pattern.MsQueryInfoRset;
import fr.proline.studio.pattern.MsQueryInfoRsm;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class MSQueriesTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_MSQUERY_ID = 0;
    public static final int COLTYPE_MSQUERY_INITIAL_ID = 1;
    public static final int COLTYPE_MSQUERY_CHARGE = 2;
    public static final int COLTYPE_MSQUERY_MOZ = 3;
    public static final int COLTYPE_MSQUERY_NB_PEPTIDE_MATCH = 4;
    public static final int COLTYPE_MSQUERY_FIRST_SCAN = 5;
    public static final int COLTYPE_MSQUERY_LAST_SCAN = 6;
    public static final int COLTYPE_MSQUERY_FIRST_TIME = 7;
    public static final int COLTYPE_MSQUERY_LAST_TIME = 8;
    public static final int COLTYPE_MSQUERY_SPECTRUM_TITLE = 9;
    private static final String[] m_columnNames = new String[]{"Id", "Initial Id", "Charge", "m/z", "#PSMs", "First Scan", "Last Scan", "First Time", "Last Time", "Spectrum Title"};
    private static final String[] m_columnTooltips = new String[]{"MS Query Id", "Initial Id", "Charge", "m/z", "Peptide Matches count", "First Scan", "Last Scan", "First Time", "Last Time", "Spectrum Title"};
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();
    private List<DMsQuery> m_msqueries;
    private Map<Long, Integer> m_nbPeptideMatchesByMsQueryIdMap;
    private String m_modelName;
    private boolean m_rsmSource;

    public MSQueriesTableModel(LazyTable table, boolean rsmSource) {
        super(table);
        this.m_rsmSource = rsmSource;
    }

    public DMsQuery getMsQuery(int row) {
        return this.m_msqueries.get(row);
    }

    @Override
    public int getSubTaskId(int col) {
        return 0;
    }

    public int getRowCount() {
        if (this.m_msqueries == null) {
            return 0;
        }
        return this.m_msqueries.size();
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        DMsQuery msquery = this.m_msqueries.get(rowIndex);
        boolean msQueryCompletelyLoaded = msquery.isSpectrumSet();
        switch (columnIndex) {
            case 0: {
                return msquery.getId();
            }
            case 1: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)Integer.valueOf(msquery.getInitialId()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
            case 2: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)Integer.valueOf(msquery.getCharge()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
            case 3: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)Double.valueOf(msquery.getMoz()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
            case 4: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)this.m_nbPeptideMatchesByMsQueryIdMap.get(msquery.getId()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
            case 5: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)Integer.valueOf(msquery.getDSpectrum().getFirstScan() == null ? 0 : msquery.getDSpectrum().getFirstScan()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
            case 6: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)Integer.valueOf(msquery.getDSpectrum().getLastScan() == null ? 0 : msquery.getDSpectrum().getLastScan()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
            case 7: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)Float.valueOf(msquery.getDSpectrum().getFirstTime() == null ? Float.NaN : msquery.getDSpectrum().getFirstTime().floatValue()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
            case 8: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)Float.valueOf(msquery.getDSpectrum().getLastTime() == null ? Float.NaN : msquery.getDSpectrum().getLastTime().floatValue()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
            case 9: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                if (msQueryCompletelyLoaded) {
                    lazyData.setData((Comparable)((Object)msquery.getDSpectrum().getTitle()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
                }
                return lazyData;
            }
        }
        return null;
    }

    public String getToolTipForHeader(int col) {
        return m_columnTooltips[col];
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        Object renderer = null;
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                break;
            }
            case 3: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 7: 
            case 8: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 9: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
            }
        }
        this.m_rendererMap.put(col, (TableCellRenderer)renderer);
        return renderer;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return m_columnNames[columnIndex];
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return Long.class;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return Integer.class;
            }
            case 3: {
                return Double.class;
            }
            case 7: 
            case 8: {
                return Float.class;
            }
            case 9: {
                return String.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        DMsQuery msq = this.m_msqueries.get(rowIndex);
        if (columnIndex == 0) {
            return msq.getId();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public int getInfoColumn() {
        return 0;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(2, (Filter)new IntegerFilter(this.getColumnName(2), null, 2));
        filtersMap.put(3, (Filter)new DoubleFilter(this.getColumnName(3), null, 3));
        filtersMap.put(4, (Filter)new IntegerFilter(this.getColumnName(4), null, 4));
        filtersMap.put(5, (Filter)new IntegerFilter(this.getColumnName(5), null, 5));
        filtersMap.put(6, (Filter)new IntegerFilter(this.getColumnName(6), null, 6));
        filtersMap.put(7, (Filter)new DoubleFilter(this.getColumnName(7), null, 7));
        filtersMap.put(8, (Filter)new DoubleFilter(this.getColumnName(8), null, 8));
        filtersMap.put(9, (Filter)new StringDiffFilter(this.getColumnName(9), null, 9));
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public void setData(Long taskId, List<DMsQuery> msQueries, Map<Long, Integer> nbPeptideMatchesByMsQueryIdMap) {
        this.m_msqueries = msQueries;
        this.m_nbPeptideMatchesByMsQueryIdMap = nbPeptideMatchesByMsQueryIdMap;
        this.fireTableStructureChanged();
        this.m_taskId = taskId;
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Long.class;
        }
        return LazyData.class;
    }

    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    public DMsQuery getSelectedMsQuery(int row) {
        return this.m_msqueries.get(row);
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DMsQuery.class, true));
        if (this.m_rsmSource) {
            list.add(new ExtraDataType(MsQueryInfoRsm.class, true));
        } else {
            list.add(new ExtraDataType(MsQueryInfoRset.class, true));
        }
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DMsQuery.class)) {
            return this.m_msqueries.get(row);
        }
        if (c.equals(MsQueryInfoRsm.class) && this.m_rsmSource) {
            return new MsQueryInfoRsm(this.m_msqueries.get(row), (ResultSummary)this.getValue(ResultSummary.class));
        }
        if (c.equals(MsQueryInfoRset.class) && !this.m_rsmSource) {
            return new MsQueryInfoRset(this.m_msqueries.get(row), (ResultSet)this.getValue(ResultSet.class));
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

