/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DPtmSiteProperties;
import fr.proline.core.orm.msi.dto.DQuantPeptide;
import fr.proline.studio.dam.data.SelectLevelEnum;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.XicStatusRenderer;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.table.ExportFontModelUtilities;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.table.TableCellRenderer;

public class PTMPeptidesTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEPTIDE_ID = 0;
    public static final int COLTYPE_SELECTION_LEVEL = 1;
    public static final int COLTYPE_PEPTIDE_NAME = 2;
    public static final int COLTYPE_PEPTIDE_SCORE = 3;
    public static final int COLTYPE_PEPTIDE_EXP_MOZ = 4;
    public static final int COLTYPE_PEPTIDE_CHARGE = 5;
    public static final int COLTYPE_PEPTIDE_PTM = 6;
    public static final int COLTYPE_DELTA_MASS_PTM = 7;
    public static final int COLTYPE_PTM_PROBA = 8;
    public static final int COLTYPE_SPECTRUM_TITLE = 9;
    public static final int LAST_STATIC_COLUMN = 9;
    private static final String[] m_columnNames = new String[]{"Id", "Status", "Peptide", "Score", "Exp. MoZ", "Charge", "PTMs", "PTMs D.Mass", "PTMs Confid.(%)", "Spectrum title"};
    private static final String[] m_columnTooltips = new String[]{"Peptide match Id", "Quant. Status", "Peptide Sequence", "Score of the peptide match", "Experimental Mass to Charge Ratio", "Charge", "PTMs associated with this peptide", "PTMs delta mass", "PTMs localisation confidence", "Peptide match query title"};
    private static final String COLTYPE_SITE_PROBA_SUFFIX = "Probability";
    private static final String COLTYPE_SITE_PROBA_TOOLTIP = "Probability of the specific site for this peptide";
    private int m_ptmSiteCount = 0;
    public static final int DYNAMIC_COLTYPE_SELECTION_LEVEL = 0;
    public static final int DYNAMIC_COLTYPE_IDENT_PSM = 1;
    public static final int DYNAMIC_COLTYPE_PSM = 2;
    public static final int DYNAMIC_COLTYPE_RAW_ABUNDANCE = 3;
    public static final int DYNAMIC_COLTYPE_ABUNDANCE = 4;
    public static final int DYNAMIC_COLTYPE_RETENTION_TIME = 5;
    private int m_quantChannelCount = 0;
    private final boolean m_isXicResult;
    private static final String[] m_columnNamesQC = new String[]{"Sel. level", "Ident. Pep. match count", "Pep. match count", "Raw abundance", "Abundance", "Retention time"};
    private static final String[] m_toolTipQC = new String[]{"Selection level", "Identification peptides match count", "Peptides match count", "Raw abundance", "Abundance", "Retention time"};
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();
    private List<Integer> m_columnsIdsToHide = new ArrayList<Integer>();
    private List<PTMPeptideInstance> m_ptmPepInstances = new ArrayList<PTMPeptideInstance>();
    private List<PTMCluster> m_ptmClusters;
    private ArrayList<Row> m_ptmPepInstancesAsRow = new ArrayList();
    private Map<Long, DMasterQuantPeptide> m_quantPeptidesByPepInsId = new HashMap<Long, DMasterQuantPeptide>();
    private Map<String, Map<Long, Float>> m_pepMatchProbaByIdByPTMSite = new HashMap<String, Map<Long, Float>>();
    private TreeMap<Integer, String> m_dynamiqueColumnNamesByProtLoc = new TreeMap();
    private final ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private String m_modelName;
    private boolean m_showPeptideMatches;

    public PTMPeptidesTableModel(LazyTable table, boolean isXicResult, boolean showPepMatches) {
        super(table);
        this.m_isXicResult = isXicResult;
        this.m_showPeptideMatches = showPepMatches;
    }

    public void setData(Long taskId, List<PTMPeptideInstance> ptmPeptides, List<PTMCluster> ptmClusters, Map<Long, DMasterQuantPeptide> quantPeptidesByPepInsId) {
        this.m_taskId = taskId;
        if (this.m_isXicResult && Objects.equals(ptmPeptides, this.m_ptmPepInstances) && Objects.equals(this.m_quantPeptidesByPepInsId, quantPeptidesByPepInsId) || !this.m_isXicResult && Objects.equals(ptmPeptides, this.m_ptmPepInstances)) {
            return;
        }
        this.m_quantPeptidesByPepInsId = quantPeptidesByPepInsId;
        this.m_ptmClusters = ptmClusters;
        if (this.m_isXicResult) {
            QuantChannelInfo qcInfo = (QuantChannelInfo)this.getSingleValue(QuantChannelInfo.class);
            int qcCount = 0;
            if (qcInfo != null) {
                qcCount = qcInfo.getQuantChannels().length;
            }
            this.m_quantChannelCount = qcCount;
        }
        this.m_pepMatchProbaByIdByPTMSite = new HashMap<String, Map<Long, Float>>();
        this.m_dynamiqueColumnNamesByProtLoc = new TreeMap();
        this.m_ptmPepInstances = ptmPeptides != null ? ptmPeptides : new ArrayList();
        this.m_ptmPepInstancesAsRow = new ArrayList();
        this.m_ptmPepInstances.forEach(ptmPI -> {
            DProteinMatch protMatchOfInterest = !ptmPI.getPTMSites().isEmpty() ? ((PTMSite)ptmPI.getPTMSites().get(0)).getProteinMatch() : null;
            ArrayList<DPeptideMatch> pepMatches = new ArrayList<DPeptideMatch>();
            if (this.m_showPeptideMatches) {
                pepMatches.addAll(ptmPI.getPepMatchesOnProteinMatch(protMatchOfInterest));
            } else {
                pepMatches.add(ptmPI.getRepresentativePepMatch(this.m_ptmClusters));
            }
            ptmPI.getPTMSites().forEach(site -> {
                String colName = site.toProteinReadablePtmString();
                Integer protLoc = site.getPositionOnProtein();
                this.m_dynamiqueColumnNamesByProtLoc.put(protLoc, colName);
                HashMap probaByPepMatchd = this.m_pepMatchProbaByIdByPTMSite.get(colName) == null ? new HashMap() : this.m_pepMatchProbaByIdByPTMSite.get(colName);
                pepMatches.forEach(pepMatch -> {
                    if (pepMatch != null) {
                        Float proba = this.getSiteProba((DPeptideMatch)pepMatch, site.toReadablePtmString(Long.valueOf(ptmPI.getPeptideInstance().getPeptideId())));
                        if (proba == null) {
                            proba = this.getSiteProba((DPeptideMatch)pepMatch, site.toOtherReadablePtmString(Long.valueOf(ptmPI.getPeptideInstance().getPeptideId())));
                        }
                        probaByPepMatchd.put(pepMatch.getId(), proba);
                    }
                });
                this.m_pepMatchProbaByIdByPTMSite.put(colName, probaByPepMatchd);
            });
            pepMatches.forEach(pepM -> {
                DMasterQuantPeptide mqPep = this.m_quantPeptidesByPepInsId != null ? this.m_quantPeptidesByPepInsId.get(ptmPI.getPeptideInstance().getId()) : null;
                Long qPepId = mqPep != null ? Long.valueOf(mqPep.getId()) : null;
                Integer generalSelLevel = mqPep != null ? mqPep.getSelectionLevel() : 2;
                this.m_ptmPepInstancesAsRow.add(new Row((PTMPeptideInstance)ptmPI, (DPeptideMatch)pepM, qPepId, generalSelLevel));
            });
        });
        this.m_ptmSiteCount = this.m_pepMatchProbaByIdByPTMSite.size();
        this.setDefaultColumnToHide();
        this.m_rendererMap.clear();
        this.fireTableStructureChanged();
    }

    private void setDefaultColumnToHide() {
        this.m_columnsIdsToHide = new ArrayList<Integer>();
        this.m_columnsIdsToHide.add(0);
        int startQChColIndex = m_columnNames.length + this.m_ptmSiteCount;
        if (this.m_isXicResult) {
            QuantChannelInfo qcInfo = (QuantChannelInfo)this.getSingleValue(QuantChannelInfo.class);
            if (qcInfo != null) {
                for (int i = qcInfo.getQuantChannels().length - 1; i >= 0; --i) {
                    this.m_columnsIdsToHide.add(startQChColIndex + 3 + i * m_columnNamesQC.length);
                    this.m_columnsIdsToHide.add(startQChColIndex + 0 + i * m_columnNamesQC.length);
                }
            }
        } else {
            this.m_columnsIdsToHide.add(1);
        }
    }

    public List<Integer> getDefaultColumnsToHide() {
        return this.m_columnsIdsToHide;
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    private Float getSiteProba(DPeptideMatch pepMatch, String readablePTM) {
        Float proba;
        if (pepMatch == null) {
            return null;
        }
        DPtmSiteProperties properties = pepMatch.getPtmSiteProperties();
        if (properties != null && (proba = (Float)properties.getMascotProbabilityBySite().get(readablePTM)) != null) {
            return Float.valueOf(proba.floatValue() * 100.0f);
        }
        return null;
    }

    private String getPtmSiteProbaColNameAt(int col) {
        if (col >= this.m_dynamiqueColumnNamesByProtLoc.size()) {
            return "";
        }
        Iterator<Integer> keys = this.m_dynamiqueColumnNamesByProtLoc.keySet().iterator();
        for (int i = 0; i < col; ++i) {
            keys.next();
        }
        Integer keyCol = keys.next();
        return this.m_dynamiqueColumnNamesByProtLoc.get(keyCol);
    }

    public DMasterQuantPeptide getMasterQuantPeptideAt(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        return this.m_quantPeptidesByPepInsId.get(this.m_ptmPepInstancesAsRow.get((int)row).ptmPeptideInstance.getPeptideInstance().getId());
    }

    public Row getPTMPeptideInstanceAt(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        return this.m_ptmPepInstancesAsRow.get(row);
    }

    public int getPeptideInstanceIndex(PTMPeptideInstance pep) {
        if (pep == null) {
            return -1;
        }
        for (int row = 0; row < this.m_ptmPepInstancesAsRow.size(); ++row) {
            PTMPeptideInstance comparePep = this.m_ptmPepInstancesAsRow.get((int)row).ptmPeptideInstance;
            if (!pep.equals(comparePep)) continue;
            return row;
        }
        return -1;
    }

    public int getRowCount() {
        return this.m_ptmPepInstancesAsRow.size();
    }

    public int getColumnCount() {
        return m_columnNames.length + this.m_ptmSiteCount + this.m_quantChannelCount * m_columnNamesQC.length;
    }

    public int getPtmSitesColumnCount() {
        return this.m_ptmSiteCount;
    }

    public String getColumnName(int col) {
        if (col <= 9) {
            return m_columnNames[col];
        }
        if (col <= 9 + this.m_ptmSiteCount) {
            if (!this.m_dynamiqueColumnNamesByProtLoc.isEmpty()) {
                return this.getPtmSiteProbaColNameAt(col - m_columnNames.length) + " Probability";
            }
        } else if (this.m_isXicResult) {
            QuantChannelInfo qcinfo = (QuantChannelInfo)this.getSingleValue(QuantChannelInfo.class);
            int dynQchIndex = col - (m_columnNames.length + this.m_ptmSiteCount);
            int nbQc = dynQchIndex / m_columnNamesQC.length;
            int id = dynQchIndex - nbQc * m_columnNamesQC.length;
            StringBuilder sb = new StringBuilder();
            sb.append("<html><font color='").append(qcinfo.getRsmHtmlColor(nbQc)).append("'>&#x25A0;&nbsp;</font>");
            sb.append(m_columnNamesQC[id]);
            sb.append("<br/>");
            sb.append(qcinfo.getQuantChannels()[nbQc].getName());
            sb.append("</html>");
            return sb.toString();
        }
        return "";
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        PTMPeptideInstance ptmPepInstance = this.m_ptmPepInstancesAsRow.get((int)rowIndex).ptmPeptideInstance;
        DPeptideMatch pepMatch = this.m_ptmPepInstancesAsRow.get((int)rowIndex).peptideMatch;
        switch (columnIndex) {
            case 0: {
                if (this.m_showPeptideMatches) {
                    return pepMatch.getId();
                }
                return ptmPepInstance.getPeptideInstance().getId();
            }
            case 2: {
                return pepMatch;
            }
            case 3: {
                return pepMatch == null ? Float.valueOf(0.0f) : pepMatch.getScore();
            }
            case 5: {
                return pepMatch == null ? 0 : pepMatch.getCharge();
            }
            case 4: {
                return pepMatch == null ? Double.NaN : pepMatch.getExperimentalMoz();
            }
            case 6: {
                if (pepMatch == null) {
                    return "UNKNOWN";
                }
                String ptm = "";
                PeptideReadablePtmString ptmString = pepMatch.getPeptide().getTransientData().getPeptideReadablePtmString();
                if (ptmString != null) {
                    ptm = ptmString.getReadablePtmString();
                }
                return ptm;
            }
            case 7: {
                double deltaMass = 0.0;
                if (pepMatch == null) {
                    return deltaMass;
                }
                if (pepMatch.getPeptidePTMArray() == null) {
                    return deltaMass;
                }
                for (DPeptidePTM peptidePTM : pepMatch.getPeptidePTMArray()) {
                    DInfoPTM pepInfoPtm = (DInfoPTM)DInfoPTM.getInfoPTMMap().get(peptidePTM.getIdPtmSpecificity());
                    deltaMass += pepInfoPtm.getMonoMass();
                }
                return deltaMass;
            }
            case 8: {
                if (pepMatch == null) {
                    return Float.valueOf(0.0f);
                }
                DPtmSiteProperties properties = pepMatch.getPtmSiteProperties();
                if (properties != null) {
                    return Float.valueOf(properties.getMascotDeltaScore().floatValue() * 100.0f);
                }
                return Float.valueOf(0.0f);
            }
            case 9: {
                return pepMatch == null ? "UNKNOWN" : pepMatch.getMsQuery().getDSpectrum().getTitle();
            }
            case 1: {
                if (this.m_isXicResult) {
                    DMasterQuantPeptide qPep = this.m_quantPeptidesByPepInsId.get(ptmPepInstance.getPeptideInstance().getId());
                    SelectLevelEnum globalLevel = qPep != null ? SelectLevelEnum.valueOf((int)qPep.getSelectionLevel()) : SelectLevelEnum.UNKNOWN;
                    SelectLevelEnum selLevel = this.m_ptmPepInstancesAsRow.get(rowIndex).getSelectLevelInContext();
                    return new XicStatusRenderer.SelectLevel(selLevel, globalLevel);
                }
                return new XicStatusRenderer.SelectLevel(SelectLevelEnum.SELECTED_AUTO, SelectLevelEnum.SELECTED_AUTO);
            }
        }
        if (columnIndex <= 9 + this.m_ptmSiteCount) {
            String colName = this.getPtmSiteProbaColNameAt(columnIndex - m_columnNames.length);
            Map<Long, Float> probaByPepMatchId = this.m_pepMatchProbaByIdByPTMSite.get(colName);
            if (probaByPepMatchId == null || pepMatch == null) {
                return Float.valueOf(Float.NaN);
            }
            return probaByPepMatchId.getOrDefault(pepMatch.getId(), Float.valueOf(Float.NaN));
        }
        DMasterQuantPeptide qPep = this.m_quantPeptidesByPepInsId.get(ptmPepInstance.getPeptideInstance().getId());
        LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
        if (qPep == null) {
            lazyData.setData(null);
            this.givePriorityTo(this.m_taskId, rowIndex, columnIndex);
        } else {
            int dynQchIndex = columnIndex - (m_columnNames.length + this.m_ptmSiteCount);
            int nbQc = dynQchIndex / m_columnNamesQC.length;
            int id = dynQchIndex - nbQc * m_columnNamesQC.length;
            Map quantPeptideByQchIds = qPep.getQuantPeptideByQchIds();
            if (quantPeptideByQchIds == null) {
                switch (id) {
                    case 0: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 4: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                        break;
                    }
                    case 3: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                        break;
                    }
                    case 2: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 1: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 5: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                    }
                }
            } else {
                QuantChannelInfo qcinfo = (QuantChannelInfo)this.getSingleValue(QuantChannelInfo.class);
                DQuantPeptide quantPeptide = (DQuantPeptide)quantPeptideByQchIds.get(qcinfo.getQuantChannels()[nbQc].getId());
                if (quantPeptide == null) {
                    switch (id) {
                        case 0: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 4: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                            break;
                        }
                        case 3: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                            break;
                        }
                        case 2: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 1: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 5: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                        }
                    }
                } else {
                    switch (id) {
                        case 0: {
                            lazyData.setData((Comparable)quantPeptide.getSelectionLevel());
                            break;
                        }
                        case 4: {
                            lazyData.setData((Comparable)(quantPeptide.getAbundance() == null || quantPeptide.getAbundance().isNaN() ? Float.valueOf(0.0f) : quantPeptide.getAbundance()));
                            break;
                        }
                        case 3: {
                            lazyData.setData((Comparable)(quantPeptide.getRawAbundance() == null || quantPeptide.getRawAbundance().isNaN() ? Float.valueOf(0.0f) : quantPeptide.getRawAbundance()));
                            break;
                        }
                        case 2: {
                            lazyData.setData((Comparable)(quantPeptide.getPeptideMatchesCount() == null ? Integer.valueOf(0) : quantPeptide.getPeptideMatchesCount()));
                            break;
                        }
                        case 1: {
                            lazyData.setData((Comparable)(quantPeptide.getIdentPeptideMatchCount() == null ? Integer.valueOf(0) : quantPeptide.getIdentPeptideMatchCount()));
                            break;
                        }
                        case 5: {
                            lazyData.setData((Comparable)Float.valueOf(quantPeptide.getElutionTime() == null ? Float.valueOf(0.0f).floatValue() : quantPeptide.getElutionTime().floatValue() / 60.0f));
                        }
                    }
                }
            }
        }
        return lazyData;
    }

    public String getToolTipForHeader(int col) {
        if (col == 0 && this.m_showPeptideMatches) {
            return "Peptide Match Id";
        }
        if (col <= 9) {
            return m_columnTooltips[col];
        }
        if (col <= 9 + this.m_ptmSiteCount) {
            return COLTYPE_SITE_PROBA_TOOLTIP;
        }
        QuantChannelInfo qcInfo = (QuantChannelInfo)this.getSingleValue(QuantChannelInfo.class);
        int dynQchIndex = col - (m_columnNames.length + this.m_ptmSiteCount);
        int nbQc = dynQchIndex / m_columnNamesQC.length;
        int id = dynQchIndex - nbQc * m_columnNamesQC.length;
        String rawFilePath = StringUtils.truncate((String)qcInfo.getQuantChannels()[nbQc].getRawFilePath(), (int)50);
        StringBuilder sb = new StringBuilder();
        String rsmHtmlColor = qcInfo.getRsmHtmlColor(nbQc);
        sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        sb.append(m_toolTipQC[id]);
        sb.append("<br/>");
        sb.append(qcInfo.getQuantChannels()[nbQc].getFullName());
        sb.append("<br/>");
        sb.append(rawFilePath);
        sb.append("</html>");
        return sb.toString();
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (col) {
            case 2: {
                renderer = new PeptideRenderer();
                break;
            }
            case 6: 
            case 9: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
                break;
            }
            case 1: {
                renderer = new XicStatusRenderer(null, 1);
                break;
            }
            case 0: 
            case 5: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                break;
            }
            case 8: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 2);
                break;
            }
            case 4: 
            case 7: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 3: {
                renderer = this.m_scoreRenderer;
                break;
            }
            default: {
                if (col <= 9 + this.m_ptmSiteCount) {
                    renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 2);
                    break;
                }
                int dynQchIndex = col - (m_columnNames.length + this.m_ptmSiteCount);
                int nbQc = dynQchIndex / m_columnNamesQC.length;
                int id = dynQchIndex - nbQc * m_columnNamesQC.length;
                switch (id) {
                    case 0: 
                    case 1: 
                    case 2: {
                        renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                        break;
                    }
                    case 3: 
                    case 4: {
                        renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
                        break;
                    }
                    case 5: {
                        renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 2);
                    }
                }
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 1: 
            case 5: {
                return Integer.class;
            }
            case 0: {
                return Long.class;
            }
            case 2: 
            case 6: 
            case 9: {
                return String.class;
            }
            case 4: 
            case 7: {
                return Double.class;
            }
            case 3: 
            case 8: {
                return Float.class;
            }
        }
        if (columnIndex <= 9 + this.m_ptmSiteCount) {
            return Float.class;
        }
        int dynQchIndex = columnIndex - (m_columnNames.length + this.m_ptmSiteCount);
        int nbQc = dynQchIndex / m_columnNamesQC.length;
        int id = dynQchIndex - nbQc * m_columnNamesQC.length;
        switch (id) {
            case 0: 
            case 1: 
            case 2: {
                return Integer.class;
            }
            case 3: 
            case 4: 
            case 5: {
                return Float.class;
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 5: {
                return Integer.class;
            }
            case 0: {
                return Long.class;
            }
            case 2: {
                return DPeptideMatch.class;
            }
            case 6: 
            case 9: {
                return String.class;
            }
            case 4: 
            case 7: {
                return Double.class;
            }
            case 3: 
            case 8: {
                return Float.class;
            }
            case 1: {
                return XicStatusRenderer.SelectLevel.class;
            }
        }
        if (col <= 9 + this.m_ptmSiteCount) {
            return Float.class;
        }
        return LazyData.class;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        if (data instanceof DPeptideMatch) {
            data = ((DPeptideMatch)data).getPeptide().getSequence();
        }
        if (columnIndex == 2) {
            return ((DPeptideMatch)this.getValueAt(rowIndex, columnIndex)).getPeptide().getSequence();
        }
        if (columnIndex == 0) {
            if (this.m_showPeptideMatches) {
                return this.m_ptmPepInstancesAsRow.get((int)rowIndex).peptideMatch.getId();
            }
            return this.m_ptmPepInstancesAsRow.get((int)rowIndex).ptmPeptideInstance.getPeptideInstance().getId();
        }
        if (columnIndex == 1) {
            return ((XicStatusRenderer.SelectLevel)data).getStatus().getIntValue();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{2, 0};
        return keys;
    }

    public int getInfoColumn() {
        return 2;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        return this.getPTMPeptideInstanceAt((int)row).ptmPeptideInstance;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DPeptideMatch)o).getPeptide().getSequence();
            }
        };
        filtersMap.put(2, (Filter)new StringDiffFilter(this.getColumnName(2), peptideConverter, 2));
        filtersMap.put(3, (Filter)new DoubleFilter(this.getColumnName(3), null, 3));
        filtersMap.put(4, (Filter)new DoubleFilter(this.getColumnName(4), null, 4));
        filtersMap.put(5, (Filter)new IntegerFilter(this.getColumnName(5), null, 5));
        filtersMap.put(6, (Filter)new StringDiffFilter(this.getColumnName(6), null, 6));
        filtersMap.put(7, (Filter)new DoubleFilter(this.getColumnName(7), null, 7));
        filtersMap.put(8, (Filter)new DoubleFilter(this.getColumnName(8), null, 8));
        filtersMap.put(9, (Filter)new StringDiffFilter(this.getColumnName(9), null, 9));
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public PlotType getBestPlotType() {
        return PlotType.SCATTER_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        if (col == 2) {
            PTMPeptideInstance peptide = this.m_ptmPepInstancesAsRow.get((int)row).ptmPeptideInstance;
            return ExportFontModelUtilities.getExportFonts(peptide.getPeptideInstance());
        }
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public static class Row {
        public PTMPeptideInstance ptmPeptideInstance;
        public DPeptideMatch peptideMatch;
        private final Long qPepId;
        private final Integer defaultSelLevel;

        public Row(PTMPeptideInstance peptideInstance, DPeptideMatch peptideMatch, Long qPepId, Integer generalSelLevel) {
            this.ptmPeptideInstance = peptideInstance;
            this.peptideMatch = peptideMatch;
            this.qPepId = qPepId;
            this.defaultSelLevel = generalSelLevel;
        }

        public SelectLevelEnum getSelectLevelInContext() {
            Map selLevelByMQPepId;
            DMasterQuantProteinSet proteinSet;
            SelectLevelEnum selLevel = SelectLevelEnum.valueOf((int)this.defaultSelLevel);
            if (this.ptmPeptideInstance.getClusters() != null && !this.ptmPeptideInstance.getClusters().isEmpty() && (proteinSet = ((PTMCluster)this.ptmPeptideInstance.getClusters().get(0)).getMasterQuantProteinSet()) != null && proteinSet.getMasterQuantProtSetProperties() != null && proteinSet.getMasterQuantProtSetProperties().getMqPeptideSelLevelById() != null && (selLevelByMQPepId = proteinSet.getMasterQuantProtSetProperties().getMqPeptideSelLevelById()).containsKey(this.qPepId)) {
                Integer mapSelLevel = (Integer)selLevelByMQPepId.get(this.qPepId);
                selLevel = SelectLevelEnum.valueOf((int)mapSelLevel);
            }
            return selLevel;
        }
    }
}

