/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DPtmSiteProperties;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PercentageRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeptidesPTMSiteTableModel
extends DecoratedTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEPTIDE_ID = 0;
    public static final int COLTYPE_PEPTIDE_NAME = 1;
    public static final int COLTYPE_PEPTIDE_SCORE = 2;
    public static final int COLTYPE_MODIFICATION = 3;
    public static final int COLTYPE_RESIDUE_AA = 4;
    public static final int COLTYPE_MODIFICATION_PROBA = 5;
    public static final int COLTYPE_DELTA_MASS_MODIFICATION = 6;
    public static final int COLTYPE_MODIFICATION_LOC = 7;
    public static final int COLTYPE_PROTEIN_LOC = 8;
    public static final int COLTYPE_PROTEIN_NTERM_CTERM = 9;
    public static final int COLTYPE_PEPTIDE_PTM = 10;
    public static final int COLTYPE_DELTA_MASS_PTM = 11;
    public static final int COLTYPE_PTM_PROBA = 12;
    public static final int COLTYPE_SPECTRUM_TITLE = 13;
    private static final String[] m_columnNames = new String[]{"Id", "Peptide", "Score", "Modification", "Residue", "Site Probability", "Modification D.Mass", "Modification Loc.", "Protein Loc.", "Protein N/C-term", "PTMs", "PTMs D.Mass", "PTMs Probability", "Spectrum title"};
    private static final String[] m_columnTooltips = new String[]{"Peptide Id (Instance Id)", "Peptide", "Score of the peptide match", "Modification", "Modified residue", "Site probability", "Delta mass of the given modification", "Position of the modification on the peptide sequence", "Position of the modification on the protein sequence", "Protein N/C-term", "PTM modifications associated with this peptide", "PTMs delta mass", "PTMs probability", "Peptide match spectrum title"};
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();
    private PTMSite m_currentPtmSite;
    private ArrayList<Row> m_ptmSitePeptides = new ArrayList();
    private ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private String m_modelName;
    private boolean m_showPeptideMatches = false;
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public void setData(PTMSite selectedPTMSite, boolean showPeptideMatches, DPeptideInstance parentPepInstance) {
        this.m_currentPtmSite = selectedPTMSite;
        this.m_showPeptideMatches = showPeptideMatches;
        this.m_ptmSitePeptides = new ArrayList();
        if (this.m_currentPtmSite == null) {
            this.fireTableDataChanged();
            return;
        }
        if (!this.m_currentPtmSite.isLoaded()) {
            m_logger.warn("Peptide Matches not loaded for PTM Site " + this.m_currentPtmSite.toString());
        } else if (!this.m_showPeptideMatches) {
            List dpInstanceList = this.m_currentPtmSite.getParentPeptideInstances();
            for (DPeptideInstance parentPeptideInstance : dpInstanceList) {
                if (this.m_currentPtmSite.getPTMSitePeptideInstance(Long.valueOf(parentPeptideInstance.getPeptideId())) == null) continue;
                DPeptideMatch bestPM = this.m_currentPtmSite.getPTMSitePeptideInstance(Long.valueOf(parentPeptideInstance.getPeptideId())).getRepresentativePepMatch();
                this.m_ptmSitePeptides.add(new Row(parentPeptideInstance, bestPM));
            }
        } else if (parentPepInstance == null) {
            m_logger.warn("Must shown all peptide matches but no peptide instance specified for PTM Site " + this.m_currentPtmSite.toString());
        } else if (this.m_currentPtmSite.getPTMSitePeptideInstance(Long.valueOf(parentPepInstance.getPeptideId())) != null) {
            List peptideInstancesForPeptide = this.m_currentPtmSite.getPTMSitePeptideInstance(Long.valueOf(parentPepInstance.getPeptideId())).getLeafPepInstances();
            if (peptideInstancesForPeptide == null) {
                this.m_currentPtmSite = null;
                this.fireTableDataChanged();
                return;
            }
            for (DPeptideInstance pi : peptideInstancesForPeptide) {
                for (DPeptideMatch pepMatch : pi.getPeptideMatches()) {
                    this.m_ptmSitePeptides.add(new Row(pi, pepMatch));
                }
            }
        }
        this.fireTableDataChanged();
    }

    public PTMSite getCurrentPTMSite() {
        return this.m_currentPtmSite;
    }

    public DPeptideMatch getSelectedPeptideMatchSite(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        return this.m_ptmSitePeptides.get((int)row).peptideMatch;
    }

    public DPeptideInstance getSelectedPeptideInstance(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        return this.m_ptmSitePeptides.get((int)row).peptideInstance;
    }

    public int getSelectedIndex(DPeptideInstance pep) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            DPeptideInstance comparePep = this.m_ptmSitePeptides.get((int)row).peptideInstance;
            if (!pep.equals(comparePep)) continue;
            return row;
        }
        return -1;
    }

    public int getRowCount() {
        return this.m_ptmSitePeptides.size();
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        DPeptideMatch pepMatch = this.m_ptmSitePeptides.get((int)rowIndex).peptideMatch;
        switch (columnIndex) {
            case 0: {
                if (this.m_showPeptideMatches) {
                    return pepMatch.getId();
                }
                return this.m_ptmSitePeptides.get((int)rowIndex).peptideInstance.getId();
            }
            case 1: {
                return pepMatch;
            }
            case 2: {
                return pepMatch.getScore();
            }
            case 10: {
                String ptm = "";
                PeptideReadablePtmString ptmString = pepMatch.getPeptide().getTransientData().getPeptideReadablePtmString();
                if (ptmString != null) {
                    ptm = ptmString.getReadablePtmString();
                }
                return ptm;
            }
            case 3: {
                return this.m_currentPtmSite.getPTMSpecificity().getPtmShortName();
            }
            case 7: {
                String locationSpecitifcity = this.m_currentPtmSite.getPTMSpecificity().getLocationSpecificity();
                if (locationSpecitifcity.contains("N-term")) {
                    return "N-term";
                }
                if (locationSpecitifcity.contains("C-term")) {
                    return "C-term";
                }
                return String.valueOf(this.m_currentPtmSite.getPositionOnPeptide(Long.valueOf(pepMatch.getPeptide().getId())));
            }
            case 8: {
                return this.m_currentPtmSite.getPositionOnProtein();
            }
            case 9: {
                String locationSpecitifcity = this.m_currentPtmSite.getPTMSpecificity().getLocationSpecificity();
                if (locationSpecitifcity.contains("-term")) {
                    return locationSpecitifcity;
                }
                return "";
            }
            case 12: {
                DPtmSiteProperties properties = pepMatch.getPtmSiteProperties();
                if (properties != null) {
                    return Float.valueOf(properties.getMascotDeltaScore().floatValue() * 100.0f);
                }
                return null;
            }
            case 5: {
                DPtmSiteProperties properties = pepMatch.getPtmSiteProperties();
                if (properties != null) {
                    Map test = properties.getMascotProbabilityBySite();
                    Float proba = (Float)properties.getMascotProbabilityBySite().get(this.m_currentPtmSite.toReadablePtmString(Long.valueOf(pepMatch.getPeptide().getId())));
                    if (proba == null) {
                        proba = (Float)properties.getMascotProbabilityBySite().get(this.m_currentPtmSite.toOtherReadablePtmString(Long.valueOf(pepMatch.getPeptide().getId())));
                    }
                    return Float.valueOf(proba.floatValue() * 100.0f);
                }
                return null;
            }
            case 11: {
                double deltaMass = 0.0;
                for (DPeptidePTM peptidePTM : pepMatch.getPeptidePTMArray()) {
                    DInfoPTM pepInfoPtm = (DInfoPTM)DInfoPTM.getInfoPTMMap().get(peptidePTM.getIdPtmSpecificity());
                    deltaMass += pepInfoPtm.getMonoMass();
                }
                return deltaMass;
            }
            case 6: {
                return this.m_currentPtmSite.getPTMSpecificity().getMonoMass();
            }
            case 4: {
                return this.m_currentPtmSite.getPTMSpecificity().getResidueAASpecificity();
            }
            case 13: {
                return pepMatch.getMsQuery().getDSpectrum().getTitle();
            }
        }
        return null;
    }

    public String getToolTipForHeader(int col) {
        if (col == 0 && this.m_showPeptideMatches) {
            return "Peptide Match Id";
        }
        return m_columnTooltips[col];
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (col) {
            case 1: {
                renderer = new PeptideRenderer();
                break;
            }
            case 3: 
            case 10: 
            case 13: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
                break;
            }
            case 7: 
            case 9: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4);
                break;
            }
            case 8: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                break;
            }
            case 5: 
            case 12: {
                renderer = new PercentageRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4));
                break;
            }
            case 6: 
            case 11: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 2: {
                renderer = this.m_scoreRenderer;
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return -1;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return String.class;
        }
        return this.getColumnClass(columnIndex);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return DPeptideMatch.class;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                return String.class;
            }
            case 8: {
                return Integer.class;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                return Double.class;
            }
            case 2: {
                return Float.class;
            }
            case 4: {
                return Character.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return ((DPeptideMatch)this.getValueAt(rowIndex, columnIndex)).getPeptide().getSequence();
        }
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{1, 0};
        return keys;
    }

    public int getInfoColumn() {
        return 1;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(PTMSite.class)) {
            return this.m_currentPtmSite;
        }
        if (c.equals(DProteinMatch.class)) {
            return this.m_currentPtmSite.getProteinMatch();
        }
        if (c.equals(DPeptideMatch.class)) {
            return this.m_ptmSitePeptides.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DPeptideMatch)o).getPeptide().getSequence();
            }
        };
        filtersMap.put(1, (Filter)new StringDiffFilter(this.getColumnName(1), peptideConverter, 1));
        filtersMap.put(2, (Filter)new DoubleFilter(this.getColumnName(2), null, 2));
        filtersMap.put(3, (Filter)new StringDiffFilter(this.getColumnName(3), null, 3));
        ConvertValueInterface aAConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((Character)o).toString();
            }
        };
        filtersMap.put(4, (Filter)new StringDiffFilter(this.getColumnName(4), aAConverter, 4));
        filtersMap.put(5, (Filter)new DoubleFilter(this.getColumnName(5), null, 5));
        filtersMap.put(6, (Filter)new DoubleFilter(this.getColumnName(6), null, 6));
        filtersMap.put(7, (Filter)new StringDiffFilter(this.getColumnName(7), null, 7));
        filtersMap.put(8, (Filter)new IntegerFilter(this.getColumnName(8), null, 8));
        filtersMap.put(9, (Filter)new StringDiffFilter(this.getColumnName(9), null, 9));
        filtersMap.put(10, (Filter)new StringDiffFilter(this.getColumnName(10), null, 10));
        filtersMap.put(11, (Filter)new DoubleFilter(this.getColumnName(11), null, 11));
        filtersMap.put(12, (Filter)new DoubleFilter(this.getColumnName(12), null, 12));
        filtersMap.put(13, (Filter)new StringDiffFilter(this.getColumnName(13), null, 13));
    }

    public boolean isLoaded() {
        return true;
    }

    public int getLoadingPercentage() {
        return 100;
    }

    public PlotType getBestPlotType() {
        return PlotType.SCATTER_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    static class Row {
        DPeptideInstance peptideInstance;
        DPeptideMatch peptideMatch;

        public Row(DPeptideInstance peptideInstance, DPeptideMatch peptideMatch) {
            this.peptideInstance = peptideInstance;
            this.peptideMatch = peptideMatch;
        }
    }
}

