/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.uds.QuantitationLabel;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.studio.rsmexplorer.gui.model.AbstractCorrectionMatrixTableModel;
import fr.proline.studio.table.renderer.DefaultColoredCellRenderer;
import fr.proline.studio.utils.StringUtils;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;

public class PurityCorrectionMatrixTableModel
extends AbstractCorrectionMatrixTableModel {
    final QuantitationMethod m_quantMethod;
    int m_nbrReporters;
    boolean m_readOnly;

    public PurityCorrectionMatrixTableModel(QuantitationMethod quantMethod, boolean readOnly) {
        this.m_quantMethod = quantMethod;
        this.m_nbrReporters = this.m_quantMethod.getLabels().size();
        this.m_readOnly = readOnly;
        this.initData();
    }

    public PurityCorrectionMatrixTableModel(QuantitationMethod quantMethod) {
        this(quantMethod, false);
    }

    private void initData() {
        this.massReporters = new ArrayList();
        this.columnNames = new ArrayList();
        this.columnNames.add("Mass Reporter");
        for (QuantitationLabel l : this.m_quantMethod.getLabels()) {
            AbstractCorrectionMatrixTableModel.MassReporter nextMR = new AbstractCorrectionMatrixTableModel.MassReporter(this.getReporterLabel(l), this.m_nbrReporters, new int[0]);
            this.massReporters.add(nextMR);
            this.columnNames.add(nextMR.getName());
        }
        this.valueCoeffColumWidth = 100;
    }

    public void setData(Double[][] allReporterCoeff) {
        if (allReporterCoeff == null) {
            JOptionPane.showMessageDialog(null, "Unable to set matrix data, no data specified !", "Matrix Error", 0);
            return;
        }
        if (allReporterCoeff.length != this.massReporters.size()) {
            JOptionPane.showMessageDialog(null, "Unable to set matrix data, not the same number of reporters !", "Matrix Error", 0);
        }
        for (int i = 0; i < allReporterCoeff.length; ++i) {
            AbstractCorrectionMatrixTableModel.MassReporter mr = (AbstractCorrectionMatrixTableModel.MassReporter)this.massReporters.get(i);
            Double[] coeff = allReporterCoeff[i];
            for (int j = 0; j < coeff.length; ++j) {
                mr.coef.set(j, Float.valueOf(coeff[j].floatValue()));
            }
        }
    }

    @Override
    public int getCenterColIndex() {
        return this.getColumnCount() + 1;
    }

    @Override
    public String getPurityMatrixAsString() {
        StringBuilder sb = new StringBuilder("[");
        for (AbstractCorrectionMatrixTableModel.MassReporter mr : this.massReporters) {
            sb.append(StringUtils.formatFloatList(mr.getCoefWithoutNan(), (int)4)).append(",");
        }
        sb.deleteCharAt(sb.length() - 1).append("]");
        return sb.toString();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_readOnly) {
            return false;
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_readOnly) {
            return DefaultColoredCellRenderer.disabledCellRendered;
        }
        return super.getRenderer(row, col);
    }
}

