/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.studio.rsmexplorer.gui.model.AbstractCorrectionMatrixTableModel;
import fr.proline.studio.utils.StringUtils;
import java.util.ArrayList;

public class ThermoCorrectionMatrixTableModel
extends AbstractCorrectionMatrixTableModel {
    final String m_quantMethod;
    private final String[] MASS_REPORTER_NAME = new String[]{"126", "127N", "127C", "128N", "128C", "129N", "129C", "130N", "130C", "131N", "131C", "132N", "132C", "133N", "133C", "134N", "134C", "135N"};
    private final String[] MASS_DEUTERATED_REPORTER_NAME = new String[]{"127D", "128ND", "128CD", "129ND", "129CD", "130ND", "130CD", "131ND", "131CD", "132ND", "132CD", "133ND", "133CD", "134ND", "134CD", "135ND"};
    private final String[] MASS_MIXED_REPORTER_NAME = new String[]{"126", "127N", "127C", "127D", "128N", "128ND", "128C", "128CD", "129N", "129ND", "129C", "129CD", "130N", "130ND", "130C", "130CD", "131N", "131ND", "131C", "131CD", "132N", "132ND", "132C", "132CD", "133N", "133ND", "133C", "133CD", "134N", "134ND", "134C", "134CD", "135N", "135ND", "135CD"};

    public ThermoCorrectionMatrixTableModel(String quantMethod) {
        this.m_quantMethod = quantMethod;
        this.initData();
    }

    private void initColName(int nbrCol) {
        switch (nbrCol) {
            case 6: {
                this.columnNames.add("Mass Reporter");
                this.columnNames.add("-2");
                this.columnNames.add("-1");
                this.columnNames.add("M+");
                this.columnNames.add("+1");
                this.columnNames.add("+2");
                break;
            }
            case 10: {
                this.columnNames.add("Mass Reporter");
                this.columnNames.add("-2 (-2x13C)");
                this.columnNames.add("-2 (-13C -15N)");
                this.columnNames.add("-1 (-13C)");
                this.columnNames.add("-1 (-15N)");
                this.columnNames.add("M+");
                this.columnNames.add("+1 (+15N)");
                this.columnNames.add("+1 (+13C)");
                this.columnNames.add("+2 (+15N +13C)");
                this.columnNames.add("+2 (+2x13C)");
                this.valueCoeffColumWidth = 90;
                break;
            }
            case 16: {
                this.columnNames.add("Mass Reporter");
                this.columnNames.add("-2 (-13C -2H)");
                this.columnNames.add("-2 (-2x13C)");
                this.columnNames.add("-2 (-15N -2H)");
                this.columnNames.add("-2 (-13C -15N)");
                this.columnNames.add("-1 (-2H)");
                this.columnNames.add("-1 (-13C)");
                this.columnNames.add("-1 (-15N)");
                this.columnNames.add("M+");
                this.columnNames.add("+1 (+15N)");
                this.columnNames.add("+1 (+13C)");
                this.columnNames.add("+1 (+2H)");
                this.columnNames.add("+2 (+15N +13C)");
                this.columnNames.add("+2 (+15N +2H)");
                this.columnNames.add("+2 (+2x13C)");
                this.columnNames.add("+2 (+13C +2H)");
                this.valueCoeffColumWidth = 90;
            }
        }
    }

    private void initData() {
        this.massReporters = new ArrayList();
        this.columnNames = new ArrayList();
        switch (this.m_quantMethod) {
            case "TMT 6plex": {
                this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter("126", 4, this.getNoneApplicableCoef("TMT 6plex", 0)));
                this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter("127", 4, this.getNoneApplicableCoef("TMT 6plex", 1)));
                this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter("128", 4, this.getNoneApplicableCoef("TMT 6plex", 2)));
                this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter("129", 4, this.getNoneApplicableCoef("TMT 6plex", 3)));
                this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter("130", 4, this.getNoneApplicableCoef("TMT 6plex", 4)));
                this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter("131", 4, this.getNoneApplicableCoef("TMT 6plex", 5)));
                this.initColName(6);
                break;
            }
            case "TMT 10plex": {
                for (int i = 0; i < 10; ++i) {
                    this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter(this.MASS_REPORTER_NAME[i], 4, this.getNoneApplicableCoef("TMT 10plex", i)));
                }
                this.initColName(6);
                break;
            }
            case "TMT 11plex": {
                for (int i = 0; i < 11; ++i) {
                    this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter(this.MASS_REPORTER_NAME[i], 4, this.getNoneApplicableCoef("TMT 11plex", i)));
                }
                this.initColName(6);
                break;
            }
            case "TMT 16plex": {
                for (int i = 0; i < 16; ++i) {
                    this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter(this.MASS_REPORTER_NAME[i], 8, this.getNoneApplicableCoef("TMT 16plex", i)));
                }
                this.initColName(10);
                break;
            }
            case "TMT 18plex": {
                for (int i = 0; i < 18; ++i) {
                    this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter(this.MASS_REPORTER_NAME[i], 8, this.getNoneApplicableCoef("TMT 18plex", i)));
                }
                this.initColName(10);
                break;
            }
            case "TMT 16plex-Deuterated": {
                for (int i = 0; i < 16; ++i) {
                    this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter(this.MASS_DEUTERATED_REPORTER_NAME[i], 14, this.getNoneApplicableCoef("TMT 16plex-Deuterated", i)));
                }
                this.initColName(16);
                break;
            }
            case "TMT 35plex": {
                for (int i = 0; i < 35; ++i) {
                    this.massReporters.add(new AbstractCorrectionMatrixTableModel.MassReporter(this.MASS_MIXED_REPORTER_NAME[i], 14, this.getNoneApplicableCoef("TMT 35plex", i)));
                }
                this.initColName(16);
                break;
            }
            default: {
                this.columnNames.add("Mass Reporter");
            }
        }
    }

    private int[] getNoneApplicableCoef(String tmtMethod, int coeffIndex) {
        int[] naIndexes = new int[]{};
        block0 : switch (coeffIndex) {
            case 0: {
                switch (tmtMethod) {
                    case "TMT 6plex": 
                    case "TMT 10plex": 
                    case "TMT 11plex": {
                        naIndexes = new int[]{0, 1};
                        break;
                    }
                    case "TMT 16plex": 
                    case "TMT 18plex": {
                        naIndexes = new int[]{0, 1, 2, 3};
                        break;
                    }
                    case "TMT 16plex-Deuterated": {
                        naIndexes = new int[]{0, 1, 2, 3, 5, 6};
                        break;
                    }
                    case "TMT 35plex": {
                        naIndexes = new int[]{0, 1, 2, 3, 4, 5, 6, 9, 11, 13};
                    }
                }
                break;
            }
            case 1: {
                switch (tmtMethod) {
                    case "TMT 6plex": 
                    case "TMT 10plex": 
                    case "TMT 11plex": {
                        naIndexes = new int[]{0};
                        break;
                    }
                    case "TMT 16plex": 
                    case "TMT 18plex": {
                        naIndexes = new int[]{0, 1, 2, 4, 6};
                        break;
                    }
                    case "TMT 16plex-Deuterated": {
                        naIndexes = new int[]{0, 1, 3, 5, 7, 10, 11};
                        break;
                    }
                    case "TMT 35plex": {
                        naIndexes = new int[]{0, 1, 2, 3, 4, 5, 7, 9, 10, 11, 13};
                    }
                }
                break;
            }
            case 2: {
                switch (tmtMethod) {
                    case "TMT 10plex": 
                    case "TMT 11plex": {
                        naIndexes = new int[]{0};
                        break;
                    }
                    case "TMT 16plex": 
                    case "TMT 18plex": {
                        naIndexes = new int[]{0, 1, 3};
                        break;
                    }
                    case "TMT 16plex-Deuterated": {
                        naIndexes = new int[]{1, 2, 3, 6};
                        break;
                    }
                    case "TMT 35plex": {
                        naIndexes = new int[]{0, 1, 2, 3, 4, 6, 9, 11, 13};
                    }
                }
                break;
            }
            case 3: {
                switch (tmtMethod) {
                    case "TMT 16plex": 
                    case "TMT 18plex": {
                        naIndexes = new int[]{0, 4, 6};
                        break;
                    }
                    case "TMT 16plex-Deuterated": {
                        naIndexes = new int[]{1, 7, 10, 11};
                        break;
                    }
                    case "TMT 35plex": {
                        naIndexes = new int[]{0, 1, 2, 3, 5, 6};
                    }
                }
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                switch (tmtMethod) {
                    case "TMT 16plex": 
                    case "TMT 18plex": {
                        naIndexes = new int[]{1, 3};
                        break;
                    }
                    case "TMT 16plex-Deuterated": {
                        if (coeffIndex == 14) {
                            naIndexes = new int[]{2, 3, 6, 12};
                            break;
                        }
                        naIndexes = new int[]{2, 3, 6};
                        break;
                    }
                    case "TMT 35plex": {
                        naIndexes = coeffIndex == 4 ? new int[]{0, 1, 2, 4, 7, 9, 10, 11, 13} : (coeffIndex == 6 || coeffIndex == 10 || coeffIndex == 14 || coeffIndex == 18 || coeffIndex == 22 ? new int[]{0, 2, 3, 4, 6, 9, 11, 13} : (coeffIndex == 8 || coeffIndex == 12 || coeffIndex == 16 || coeffIndex == 20 || coeffIndex == 24 ? new int[]{0, 2, 4, 7, 9, 10, 11, 13} : (coeffIndex == 26 ? new int[]{0, 2, 3, 4, 6, 9, 11, 12, 13} : (coeffIndex == 28 ? new int[]{0, 2, 4, 7, 9, 10, 11, 12, 13} : (coeffIndex == 30 ? new int[]{0, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13} : (coeffIndex == 32 ? new int[]{0, 2, 4, 7, 8, 9, 10, 11, 12, 13} : new int[]{2, 3, 6, 8, 10, 12, 13}))))));
                    }
                }
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                switch (tmtMethod) {
                    case "TMT 16plex": 
                    case "TMT 18plex": {
                        naIndexes = new int[]{4, 6};
                        break block0;
                    }
                    case "TMT 16plex-Deuterated": {
                        if (coeffIndex == 15) {
                            naIndexes = new int[]{7, 10, 11, 12};
                            break block0;
                        }
                        naIndexes = new int[]{7, 10, 11};
                        break block0;
                    }
                    case "TMT 35plex": {
                        naIndexes = coeffIndex == 5 ? new int[]{0, 1, 3, 5, 7, 10, 11} : (coeffIndex == 7 ? new int[]{1, 2, 3, 6} : (coeffIndex == 9 ? new int[]{1, 7, 10, 11} : (coeffIndex == 11 || coeffIndex == 15 || coeffIndex == 19 || coeffIndex == 23 || coeffIndex == 27 ? new int[]{2, 3, 6} : (coeffIndex == 13 || coeffIndex == 17 || coeffIndex == 21 || coeffIndex == 25 || coeffIndex == 29 ? new int[]{7, 10, 11} : (coeffIndex == 31 ? new int[]{2, 3, 6, 12} : new int[]{7, 10, 11, 12})))));
                    }
                }
            }
        }
        return naIndexes;
    }

    @Override
    public String getPurityMatrixAsString() {
        int mReporterCount = this.massReporters.size();
        StringBuilder sb = new StringBuilder();
        Float[] row = new Float[mReporterCount];
        sb.append("[");
        for (int massRepIndex = 0; massRepIndex < mReporterCount; ++massRepIndex) {
            AbstractCorrectionMatrixTableModel.MassReporter mr = (AbstractCorrectionMatrixTableModel.MassReporter)this.massReporters.get(massRepIndex);
            Float coefSum = mr.getCoeffSum();
            if (massRepIndex != 0) {
                sb.append(",");
            }
            for (int colIndex = 0; colIndex < mReporterCount; ++colIndex) {
                boolean isCreporter;
                row[colIndex] = Float.valueOf(0.0f);
                if (colIndex == massRepIndex) {
                    row[colIndex] = Float.valueOf((100.0f - coefSum.floatValue()) / 100.0f);
                    continue;
                }
                if (this.m_quantMethod.equals("TMT 6plex")) {
                    if (colIndex == massRepIndex - 2) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(0).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex - 1) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(1).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex + 1) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(2).floatValue() / 100.0f);
                    }
                    if (colIndex != massRepIndex + 2) continue;
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(3).floatValue() / 100.0f);
                    continue;
                }
                if (this.m_quantMethod.equals("TMT 10plex") || this.m_quantMethod.equals("TMT 11plex")) {
                    if (colIndex == massRepIndex - 4) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(0).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex - 2) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(1).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex + 2) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(2).floatValue() / 100.0f);
                    }
                    if (colIndex != massRepIndex + 4) continue;
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(3).floatValue() / 100.0f);
                    continue;
                }
                if (this.m_quantMethod.equals("TMT 16plex") || this.m_quantMethod.equals("TMT 18plex")) {
                    boolean bl = isCreporter = massRepIndex % 2 == 0;
                    if (colIndex == massRepIndex - 1 && !isCreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(3).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex - 2) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(2).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex - 3 && !isCreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(1).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex - 4) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(0).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex + 1 && isCreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(4).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex + 2) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(5).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex + 3 && isCreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(6).floatValue() / 100.0f);
                    }
                    if (colIndex != massRepIndex + 4) continue;
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(7).floatValue() / 100.0f);
                    continue;
                }
                if (this.m_quantMethod.equals("TMT 16plex-Deuterated")) {
                    boolean bl = isCreporter = massRepIndex % 2 == 0;
                    if (colIndex == massRepIndex - 1 && !isCreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(6).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex - 2) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(5).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex - 3 && !isCreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(3).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex - 4) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(1).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex + 1 && isCreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(7).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex + 2) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(8).floatValue() / 100.0f);
                    }
                    if (colIndex == massRepIndex + 3 && isCreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(10).floatValue() / 100.0f);
                    }
                    if (colIndex != massRepIndex + 4) continue;
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(12).floatValue() / 100.0f);
                    continue;
                }
                if (!this.m_quantMethod.equals("TMT 35plex")) continue;
                boolean isDreporter = massRepIndex > 2 && massRepIndex % 2 == 1 || massRepIndex == 34;
                boolean isNreporter = mr.name.contains("N");
                if (colIndex == massRepIndex - 1 && massRepIndex == 1) {
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(6).floatValue() / 100.0f);
                }
                if (colIndex == massRepIndex - 2) {
                    if (massRepIndex == 2) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(5).floatValue() / 100.0f);
                    } else if (massRepIndex > 2 && isNreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(6).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex - 3) {
                    if (massRepIndex == 3) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(4).floatValue() / 100.0f);
                    }
                    if (massRepIndex == 4 || massRepIndex == 34) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(5).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex - 4) {
                    if (massRepIndex == 4) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(3).floatValue() / 100.0f);
                    }
                    if (massRepIndex == 5 || massRepIndex == 34) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(4).floatValue() / 100.0f);
                    }
                    if (massRepIndex > 5 && massRepIndex < 34) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(5).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex - 5) {
                    if (massRepIndex == 5) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(2).floatValue() / 100.0f);
                    }
                    if (massRepIndex > 5 && massRepIndex < 34 && isDreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(4).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex - 6) {
                    if (massRepIndex == 6) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(1).floatValue() / 100.0f);
                    }
                    if (massRepIndex > 6 && isNreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(3).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex - 7) {
                    if (massRepIndex == 7) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(0).floatValue() / 100.0f);
                    }
                    if (massRepIndex == 8 || massRepIndex == 34) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(1).floatValue() / 100.0f);
                    }
                    if (massRepIndex > 8 && isDreporter && isNreporter) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(2).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex - 8) {
                    if (massRepIndex == 9 || massRepIndex == 34) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(0).floatValue() / 100.0f);
                    }
                    if (massRepIndex > 9 && massRepIndex < 34) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(1).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex - 9 && massRepIndex > 10 && isDreporter && massRepIndex < 34) {
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(0).floatValue() / 100.0f);
                }
                if (colIndex == massRepIndex + 1 && massRepIndex == 0) {
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(7).floatValue() / 100.0f);
                }
                if (colIndex == massRepIndex + 2) {
                    if (massRepIndex == 0) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(8).floatValue() / 100.0f);
                    }
                    if (massRepIndex > 1 && !isNreporter && massRepIndex < 32) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(7).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex + 3 && (massRepIndex == 1 || massRepIndex == 31)) {
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(8).floatValue() / 100.0f);
                }
                if (colIndex == massRepIndex + 4) {
                    if (massRepIndex == 0) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(10).floatValue() / 100.0f);
                    }
                    if (massRepIndex > 1 && massRepIndex < 30) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(8).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex + 6) {
                    if (massRepIndex == 0) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(12).floatValue() / 100.0f);
                    }
                    if (massRepIndex > 1 && !isNreporter && massRepIndex < 29) {
                        row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(10).floatValue() / 100.0f);
                    }
                }
                if (colIndex == massRepIndex + 7 && (massRepIndex == 1 || massRepIndex == 27)) {
                    row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(12).floatValue() / 100.0f);
                }
                if (colIndex != massRepIndex + 8 || massRepIndex <= 1 || massRepIndex >= 26) continue;
                row[colIndex] = Float.valueOf(mr.getCoefWithoutNan().get(12).floatValue() / 100.0f);
            }
            sb.append(StringUtils.formatFloatArray((Float[])row, (int)4));
        }
        sb.append("]");
        return sb.toString();
    }
}

