/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model.properties;

import fr.proline.core.orm.msi.Enzyme;
import fr.proline.core.orm.msi.InstrumentConfig;
import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.MsmsSearch;
import fr.proline.core.orm.msi.Peaklist;
import fr.proline.core.orm.msi.PeaklistSoftware;
import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.SearchSetting;
import fr.proline.core.orm.msi.SearchSettingsSeqDatabaseMap;
import fr.proline.core.orm.msi.SeqDatabase;
import fr.proline.core.orm.msi.UsedPtm;
import fr.proline.core.orm.uds.FragmentationRuleSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.rsmexplorer.gui.model.properties.AbstractPropertiesTableModel;
import fr.proline.studio.table.DataGroup;
import fr.proline.studio.utils.SerializedPropertiesUtil;
import java.awt.Color;
import java.io.File;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IdentificationPropertiesTableModel
extends AbstractPropertiesTableModel {
    private ArrayList<ResultSet> m_rsetArray = null;
    private ArrayList<ResultSummary> m_rsmArray = null;
    private final StringBuilder m_sb = new StringBuilder();

    @Override
    public void setData(ArrayList<DDataset> datasetArrayList) {
        int nbDataset = datasetArrayList.size();
        this.initArrays(nbDataset);
        boolean hasRsm = false;
        for (int i = 0; i < nbDataset; ++i) {
            DDataset dataset = datasetArrayList.get(i);
            this.m_datasetNameArray.add(dataset.getName());
            this.m_projectIdArray.add(dataset.getProject().getId());
            this.m_datasetIdArray.add(dataset.getId());
            this.m_rsetArray.add(dataset.getResultSet());
            ResultSummary rsm = dataset.getResultSummary();
            this.m_rsmArray.add(rsm);
            if (rsm == null) continue;
            hasRsm = true;
        }
        this.initGroups(hasRsm, datasetArrayList);
    }

    public void setData(long projectId, ArrayList<ResultSet> rsetArray) {
        int nb = rsetArray.size();
        this.initArrays(nb);
        this.m_rsetArray = rsetArray;
        for (int i = 0; i < nb; ++i) {
            ResultSet rset = rsetArray.get(i);
            this.m_datasetNameArray.add(rset.getName());
            this.m_projectIdArray.add(projectId);
            this.m_datasetIdArray.add(-1L);
            this.m_rsmArray.add(null);
        }
        this.initGroups(false, null);
    }

    private void initArrays(int nb) {
        this.m_datasetNameArray = new ArrayList(nb);
        this.m_rsetArray = new ArrayList(nb);
        this.m_rsmArray = new ArrayList(nb);
        this.m_projectIdArray = new ArrayList(nb);
        this.m_datasetIdArray = new ArrayList(nb);
    }

    private void initGroups(boolean hasRsm, ArrayList<DDataset> datasetArrayList) {
        this.m_rowCount = -1;
        if (this.m_dataGroupList == null) {
            this.m_dataGroupList = new ArrayList();
            int startRow = 0;
            DataGroup group = new GeneralInformationGroup(startRow);
            this.m_dataGroupList.add(group);
            startRow += group.getRowCount();
            group = new SearchPropertiesGroup(startRow);
            this.m_dataGroupList.add(group);
            startRow += group.getRowCount();
            group = new SearchResultInformationGroup(startRow);
            this.m_dataGroupList.add(group);
            startRow += group.getRowCount();
            if (hasRsm) {
                group = new IdentificationSummaryInformationGroup(startRow, datasetArrayList);
                this.m_dataGroupList.add(group);
                startRow += group.getRowCount();
                group = new ValidationParametersGroup(startRow, datasetArrayList);
                this.m_dataGroupList.add(group);
                startRow += group.getRowCount();
                group = new ValidationResultsGroup(startRow, datasetArrayList);
                this.m_dataGroupList.add(group);
                startRow += group.getRowCount();
            }
            group = new SqlIdGroup(startRow);
            this.m_dataGroupList.add(group);
            int n = startRow + group.getRowCount();
        }
        this.m_loaded = true;
        this.fireTableStructureChanged();
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }

    public class GeneralInformationGroup
    extends DataGroup {
        private static final int ROWTYPE_RAW_FILE_NAME = 0;
        private static final int FASTA_FILE_NAME = 1;
        private static final int ROWTYPE_SEARCH_RESULT_NAME = 2;
        private static final int ROWTYPE_INSTRUMENT_NAME = 3;
        private static final int ROWTYPE_FRAGMENTATION_RULESET_NAME = 4;
        private static final int ROWTYPE_TARGET_DECOY_MODE = 5;
        private static final int ROWTYPE_PEAKLIST_SOFTWARE_NAME = 6;
        private static final int ROW_COUNT = 7;
        private final Color GROUP_COLOR_BACKGROUND;
        private StringBuilder m_sb;

        public GeneralInformationGroup(int rowStart) {
            super("General Information", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(0, 0, 0);
            this.m_sb = new StringBuilder();
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Raw File Name", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Fasta Files", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Search Result Name", (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, "Instrument Name", (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, "Fragmentation Rule Set", (DataGroup)this);
                }
                case 5: {
                    return new DataGroup.GroupObject((DataGroup)this, "Target Decoy Mode", (DataGroup)this);
                }
                case 6: {
                    return new DataGroup.GroupObject((DataGroup)this, "Peaklist Software", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            ResultSet rset = IdentificationPropertiesTableModel.this.m_rsetArray.get(columnIndex);
            ResultSet rsetDecoy = rset == null ? null : rset.getDecoyResultSet();
            MsiSearch msiSearch = rset == null ? null : rset.getMsiSearch();
            SearchSetting searchSetting = msiSearch == null ? null : msiSearch.getSearchSetting();
            InstrumentConfig instrumentConfig = searchSetting == null ? null : searchSetting.getInstrumentConfig();
            FragmentationRuleSet frs = searchSetting == null ? null : DatabaseDataManager.getDatabaseDataManager().getFragmentationRuleSet(searchSetting.getFragmentationRuleSetId());
            Peaklist peaklist = msiSearch == null ? null : msiSearch.getPeaklist();
            PeaklistSoftware peaklistSoftware = peaklist == null ? null : peaklist.getPeaklistSoftware();
            switch (rowIndex) {
                case 0: {
                    if (peaklist == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    String path = peaklist.getPath();
                    File f = new File(path);
                    return new DataGroup.GroupObject((DataGroup)this, f.getName(), (DataGroup)this);
                }
                case 1: {
                    boolean first = true;
                    if (searchSetting == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "[unknown]", (DataGroup)this);
                    }
                    Set searchSettingsSeqDatabaseMapSet = searchSetting.getSearchSettingsSeqDatabaseMaps();
                    for (SearchSettingsSeqDatabaseMap seqDbMap : searchSettingsSeqDatabaseMapSet) {
                        SeqDatabase seqDatabase = seqDbMap.getSeqDatabase();
                        if (!first) {
                            this.m_sb.append(" ; ");
                        }
                        this.m_sb.append(seqDatabase.getFastaFilePath());
                        first = false;
                    }
                    String paths = this.m_sb.toString();
                    this.m_sb.setLength(0);
                    return new DataGroup.GroupObject((DataGroup)this, paths, (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, rset == null ? "" : rset.getName(), (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, instrumentConfig == null ? "" : instrumentConfig.getName(), (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, frs == null ? "" : frs.getName(), (DataGroup)this);
                }
                case 5: {
                    if (rsetDecoy == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    try {
                        Map map = rsetDecoy.getSerializedPropertiesAsMap();
                        Object o = map.get("target_decoy_mode");
                        if (o == null) {
                            map = rset.getSerializedPropertiesAsMap();
                            o = map.get("target_decoy_mode");
                        }
                        if (o == null) {
                            return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                        }
                        return new DataGroup.GroupObject((DataGroup)this, o.toString(), (DataGroup)this);
                    }
                    catch (Exception e) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                }
                case 6: {
                    if (peaklistSoftware == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    Object name = peaklistSoftware.getName();
                    String version = peaklistSoftware.getVersion();
                    if (version != null && !version.isEmpty()) {
                        name = (String)name + " " + version;
                    }
                    return new DataGroup.GroupObject((DataGroup)this, (String)name, (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 7;
        }
    }

    public class SearchPropertiesGroup
    extends DataGroup {
        private static final int ROWTYPE_RESULT_FILE_NAME = 0;
        private static final int ROWTYPE_SEARCH_DATE = 1;
        private static final int ROWTYPE_SOFTWARE_NAME = 2;
        private static final int ROWTYPE_SOFTWARE_VERSION = 3;
        private static final int ROWTYPE_TAXONOMY = 4;
        private static final int ROWTYPE_ENZYME = 5;
        private static final int ROWTYPE_MAX_MISSED_CLIVAGE = 6;
        private static final int ROWTYPE_FIXED_MODIFICATIONS = 7;
        private static final int ROWTYPE_VARIABLE_MODIFICATIONS = 8;
        private static final int ROWTYPE_FRAGMENT_MASS_TOLERANCE = 9;
        private static final int ROWTYPE_PEPTIDE_CHARGE_STATES = 10;
        private static final int ROWTYPE_PEPTIDE_MASS_ERROR_TOLERANCE = 11;
        private static final int ROWTYPE_FRAGMENT_CHARGE_STATES = 12;
        private static final int ROWTYPE_FRAGMENT_MASS_ERROR_TOLERANCE = 13;
        private static final int ROW_COUNT = 14;
        private final Color GROUP_COLOR_BACKGROUND;

        public SearchPropertiesGroup(int rowStart) {
            super("Search Properties", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(254, 163, 71);
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Result File Name", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Search Date", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Software Name", (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, "Software Version", (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, "Taxonomy", (DataGroup)this);
                }
                case 5: {
                    return new DataGroup.GroupObject((DataGroup)this, "Enzyme", (DataGroup)this);
                }
                case 6: {
                    return new DataGroup.GroupObject((DataGroup)this, "Max Missed Clivage", (DataGroup)this);
                }
                case 7: {
                    return new DataGroup.GroupObject((DataGroup)this, "Fixed Modifications", (DataGroup)this);
                }
                case 8: {
                    return new DataGroup.GroupObject((DataGroup)this, "Variable Modifications", (DataGroup)this);
                }
                case 9: {
                    return new DataGroup.GroupObject((DataGroup)this, "Fragment Mass Tolerance", (DataGroup)this);
                }
                case 10: {
                    return new DataGroup.GroupObject((DataGroup)this, "Peptide Charge States", (DataGroup)this);
                }
                case 11: {
                    return new DataGroup.GroupObject((DataGroup)this, "Peptide Mass Error Tolerance", (DataGroup)this);
                }
                case 12: {
                    return new DataGroup.GroupObject((DataGroup)this, "Fragment Charge States", (DataGroup)this);
                }
                case 13: {
                    return new DataGroup.GroupObject((DataGroup)this, "Fragment Mass Error Tolerance", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            ResultSet rset = IdentificationPropertiesTableModel.this.m_rsetArray.get(columnIndex);
            MsiSearch msiSearch = rset == null ? null : rset.getMsiSearch();
            SearchSetting searchSetting = msiSearch == null ? null : msiSearch.getSearchSetting();
            MsmsSearch msmsSearch = null;
            if (searchSetting instanceof MsmsSearch) {
                msmsSearch = (MsmsSearch)searchSetting;
            }
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, msiSearch == null ? "" : msiSearch.getResultFileName(), (DataGroup)this);
                }
                case 1: {
                    if (msiSearch == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    Timestamp timeStamp = msiSearch.getDate();
                    DateFormat df = DateFormat.getDateInstance(1, Locale.getDefault());
                    String dateFormatted = df.format(timeStamp);
                    return new DataGroup.GroupObject((DataGroup)this, dateFormatted, (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, searchSetting == null ? "" : searchSetting.getSoftwareName(), (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, searchSetting == null ? "" : searchSetting.getSoftwareVersion(), (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, searchSetting == null ? "" : searchSetting.getTaxonomy(), (DataGroup)this);
                }
                case 5: {
                    Object enzyme = "";
                    if (searchSetting != null) {
                        Set enzymeSet = searchSetting.getEnzymes();
                        Iterator it = enzymeSet.iterator();
                        while (it.hasNext()) {
                            if (!((String)enzyme).isEmpty()) {
                                enzyme = (String)enzyme;
                            }
                            enzyme = (String)enzyme + ((Enzyme)it.next()).getName();
                        }
                    }
                    return new DataGroup.GroupObject((DataGroup)this, (String)enzyme, (DataGroup)this);
                }
                case 6: {
                    return new DataGroup.GroupObject((DataGroup)this, searchSetting == null ? "" : searchSetting.getMaxMissedCleavages().toString(), (DataGroup)this);
                }
                case 7: {
                    if (searchSetting == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    Set usedPtmSet = searchSetting.getUsedPtms();
                    HashSet<String> stringPtmSet = new HashSet<String>();
                    for (UsedPtm usedPtm : usedPtmSet) {
                        if (!usedPtm.getIsFixed()) continue;
                        StringBuilder shortNamebuilder = new StringBuilder(usedPtm.getShortName());
                        PtmSpecificity ptmSpecificity = usedPtm.getPtmSpecificity();
                        if (ptmSpecificity != null) {
                            Character c = ptmSpecificity.getResidue();
                            if (c != null) {
                                shortNamebuilder.append("(").append(c.toString()).append(")");
                            } else if (ptmSpecificity.getLocation() != null) {
                                PtmSpecificity.PtmLocation loc = PtmSpecificity.PtmLocation.withName((String)ptmSpecificity.getLocation());
                                switch (loc) {
                                    case ANY_C_TERM: 
                                    case ANY_N_TERM: 
                                    case PROT_C_TERM: 
                                    case PROT_N_TERM: {
                                        shortNamebuilder.append("(").append(loc.toString()).append(")");
                                    }
                                }
                            }
                        }
                        stringPtmSet.add(shortNamebuilder.toString());
                    }
                    Object[] array = stringPtmSet.toArray(new String[stringPtmSet.size()]);
                    Arrays.sort(array);
                    for (Object array1 : array) {
                        if (IdentificationPropertiesTableModel.this.m_sb.length() > 0) {
                            IdentificationPropertiesTableModel.this.m_sb.append(", ");
                        }
                        IdentificationPropertiesTableModel.this.m_sb.append((String)array1);
                    }
                    String modifications = IdentificationPropertiesTableModel.this.m_sb.toString();
                    IdentificationPropertiesTableModel.this.m_sb.setLength(0);
                    return new DataGroup.GroupObject((DataGroup)this, modifications, (DataGroup)this);
                }
                case 8: {
                    if (searchSetting == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    Set usedPtmSet = searchSetting.getUsedPtms();
                    HashSet<String> stringPtmSet = new HashSet<String>();
                    for (UsedPtm usedPtm : usedPtmSet) {
                        if (usedPtm.getIsFixed()) continue;
                        StringBuilder shortNameB = new StringBuilder(usedPtm.getShortName());
                        PtmSpecificity ptmSpecificity = usedPtm.getPtmSpecificity();
                        if (ptmSpecificity != null) {
                            Character c = ptmSpecificity.getResidue();
                            if (c != null) {
                                shortNameB.append("(").append(c.toString()).append(")");
                            } else if (ptmSpecificity.getLocation() != null) {
                                PtmSpecificity.PtmLocation loc = PtmSpecificity.PtmLocation.withName((String)ptmSpecificity.getLocation());
                                switch (loc) {
                                    case ANY_C_TERM: 
                                    case ANY_N_TERM: 
                                    case PROT_C_TERM: 
                                    case PROT_N_TERM: {
                                        shortNameB.append("(").append(loc.toString()).append(")");
                                    }
                                }
                            }
                        }
                        stringPtmSet.add(shortNameB.toString());
                    }
                    Object[] array = stringPtmSet.toArray(new String[stringPtmSet.size()]);
                    Arrays.sort(array);
                    for (Object array1 : array) {
                        if (IdentificationPropertiesTableModel.this.m_sb.length() > 0) {
                            IdentificationPropertiesTableModel.this.m_sb.append(", ");
                        }
                        IdentificationPropertiesTableModel.this.m_sb.append((String)array1);
                    }
                    String modifications = IdentificationPropertiesTableModel.this.m_sb.toString();
                    IdentificationPropertiesTableModel.this.m_sb.setLength(0);
                    return new DataGroup.GroupObject((DataGroup)this, modifications, (DataGroup)this);
                }
                case 9: {
                    if (msmsSearch == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, msmsSearch.getFragmentMassErrorTolerance() + " " + msmsSearch.getFragmentMassErrorToleranceUnit(), (DataGroup)this);
                }
                case 10: {
                    return new DataGroup.GroupObject((DataGroup)this, searchSetting == null ? "" : searchSetting.getPeptideChargeStates(), (DataGroup)this);
                }
                case 11: {
                    return new DataGroup.GroupObject((DataGroup)this, (String)(searchSetting == null ? "" : searchSetting.getPeptideMassErrorTolerance().toString() + " " + searchSetting.getPeptideMassErrorToleranceUnit()), (DataGroup)this);
                }
                case 12: {
                    return new DataGroup.GroupObject((DataGroup)this, msmsSearch == null ? "" : msmsSearch.getFragmentChargeStates(), (DataGroup)this);
                }
                case 13: {
                    return new DataGroup.GroupObject((DataGroup)this, (String)(msmsSearch == null ? "" : String.valueOf(msmsSearch.getFragmentMassErrorTolerance()) + " " + msmsSearch.getFragmentMassErrorToleranceUnit()), (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 14;
        }
    }

    public class SearchResultInformationGroup
    extends DataGroup {
        private static final int ROWTYPE_QUERIES_NUMBER = 0;
        private static final int ROWTYPE_PSM_NUMBER = 1;
        private static final int ROWTYPE_PROTEIN_NUMBER = 2;
        private static final int ROWTYPE_DECOY_PSM_NUMBER = 3;
        private static final int ROWTYPE_DECOY_PROTEIN_NUMBER = 4;
        private static final int ROW_COUNT = 5;
        private final Color GROUP_COLOR_BACKGROUND;

        public SearchResultInformationGroup(int rowStart) {
            super("Search Result Information", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(76, 166, 107);
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Queries Number", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "PSM Number", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Protein Number", (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, "PSM Decoy Number", (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, "Protein Decoy Number", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            MsiSearch msiSearch;
            ResultSet rset = IdentificationPropertiesTableModel.this.m_rsetArray.get(columnIndex);
            ResultSet rsetDecoy = rset == null ? null : rset.getDecoyResultSet();
            MsiSearch msiSearch2 = msiSearch = rset == null ? null : rset.getMsiSearch();
            if (rset == null) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            switch (rowIndex) {
                case 0: {
                    if (msiSearch == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(msiSearch.getQueriesCount()), (DataGroup)this);
                }
                case 1: {
                    Integer data = rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getPeptideMatchesCount();
                    if (data == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, ((Object)data).toString(), (DataGroup)this);
                }
                case 2: {
                    Integer data = rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinMatchesCount();
                    if (data == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, ((Object)data).toString(), (DataGroup)this);
                }
                case 3: {
                    if (rsetDecoy == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    Integer data = rsetDecoy.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getPeptideMatchesCount();
                    if (data == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, ((Object)data).toString(), (DataGroup)this);
                }
                case 4: {
                    if (rsetDecoy == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    Integer data = rsetDecoy.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinMatchesCount();
                    if (data == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, ((Object)data).toString(), (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 5;
        }
    }

    public class IdentificationSummaryInformationGroup
    extends DataGroup {
        private static final int ROWTYPE_PROTEINSET_NUMBER = 0;
        private static final int ROWTYPE_PSM_NUMBER = 1;
        private static final int ROWTYPE_PEPTIDE_NUMBER = 2;
        private static final int ROWTYPE_PROTEINSET_DECOY_NUMBER = 3;
        private static final int ROWTYPE_PSM_DECOY_NUMBER = 4;
        private static final int ROWTYPE_PEPTIDE_DECOY_NUMBER = 5;
        private static final int ROW_COUNT = 6;
        private final Color GROUP_COLOR_BACKGROUND;
        private ArrayList<String> m_valuesName;
        private HashMap<Integer, HashMap<String, String>> m_valuesMap;

        public IdentificationSummaryInformationGroup(int rowStart, ArrayList<DDataset> datasetArrayList) {
            super("Identification Summary Information", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(71, 163, 254);
            this.m_valuesName = new ArrayList();
            this.m_valuesMap = new HashMap();
            TreeSet<String> keysSet = new TreeSet<String>();
            int nbDataset = datasetArrayList.size();
            try {
                for (int i = 0; i < nbDataset; ++i) {
                    DDataset dataset = datasetArrayList.get(i);
                    ResultSummary rsm = dataset.getResultSummary();
                    if (rsm == null) continue;
                    Map map = dataset.getResultSummary().getSerializedPropertiesAsMap();
                    HashMap<String, String> propertiesList = new HashMap<String, String>();
                    SerializedPropertiesUtil.getProperties(propertiesList, (String)"Identification Summary Information", (Map)map);
                    this.m_valuesMap.put(i, propertiesList);
                    for (String key : propertiesList.keySet()) {
                        if (key.contains("validation_properties / results /") || key.contains("validation_properties / params /")) continue;
                        keysSet.add(key);
                    }
                    Map schemaNames = rsm.getObjectTreeIdByName();
                    if (schemaNames == null || schemaNames.isEmpty()) continue;
                    for (String nextSchName : schemaNames.keySet()) {
                        propertiesList.put(nextSchName, "defined");
                        keysSet.add(nextSchName);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String key : keysSet) {
                this.m_valuesName.add(key);
            }
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Protein Sets Number", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "PSM Number", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Peptide Number", (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, "Protein Sets Decoy Number", (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, "PSM Decoy Number", (DataGroup)this);
                }
                case 5: {
                    return new DataGroup.GroupObject((DataGroup)this, "Peptide Decoy Number", (DataGroup)this);
                }
            }
            return new DataGroup.GroupObject((DataGroup)this, this.m_valuesName.get(rowIndex - 6), (DataGroup)this);
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            ResultSummary rsm = IdentificationPropertiesTableModel.this.m_rsmArray.get(columnIndex);
            if (rsm == null) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            ResultSummary rsmDecoy = rsm.getDecoyResultSummary();
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getNumberOfProteinSet()), (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getNumberOfPeptideMatches()), (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getNumberOfPeptides()), (DataGroup)this);
                }
                case 3: {
                    if (rsmDecoy == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    Integer number = rsmDecoy.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getNumberOfProteinSet();
                    if (number == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(number), (DataGroup)this);
                }
                case 4: {
                    if (rsmDecoy == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    Integer psmDecoyNumber = rsmDecoy.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getNumberOfPeptideMatches();
                    if (psmDecoyNumber == null) {
                        psmDecoyNumber = 0;
                    }
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(psmDecoyNumber), (DataGroup)this);
                }
                case 5: {
                    if (rsmDecoy == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(rsmDecoy.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getNumberOfPeptides()), (DataGroup)this);
                }
            }
            String key = this.m_valuesName.get(rowIndex - 6);
            String value = this.m_valuesMap.get(columnIndex).get(key);
            if (value == null) {
                value = "";
            }
            return new DataGroup.GroupObject((DataGroup)this, value, (DataGroup)this);
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 6 + this.m_valuesName.size();
        }
    }

    public class ValidationParametersGroup
    extends DataGroup {
        private final Color GROUP_COLOR_BACKGROUND;
        private ArrayList<String> m_valuesName;
        private HashMap<Integer, HashMap<String, String>> m_valuesMap;
        private final String REQUIRED_PREFIX = "validation_properties / params /";

        public ValidationParametersGroup(int rowStart, ArrayList<DDataset> datasetArrayList) {
            super("Validation Parameters", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(250, 128, 114);
            this.m_valuesName = new ArrayList();
            this.m_valuesMap = new HashMap();
            this.REQUIRED_PREFIX = "validation_properties / params /";
            TreeSet<String> keysSet = new TreeSet<String>();
            int nbDataset = datasetArrayList.size();
            try {
                for (int i = 0; i < nbDataset; ++i) {
                    DDataset dataset = datasetArrayList.get(i);
                    ResultSummary rsm = dataset.getResultSummary();
                    if (rsm == null) continue;
                    Map map = dataset.getResultSummary().getSerializedPropertiesAsMap();
                    HashMap propertiesList = new HashMap();
                    SerializedPropertiesUtil.getProperties(propertiesList, (String)"Identification Summary Information", (Map)map);
                    this.m_valuesMap.put(i, propertiesList);
                    for (String key : propertiesList.keySet()) {
                        if (!key.contains("validation_properties / params /")) continue;
                        keysSet.add(key);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String key : keysSet) {
                this.m_valuesName.add(key);
            }
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            String key = this.m_valuesName.get(rowIndex);
            String value = this.m_valuesMap.get(columnIndex).get(key);
            if (value == null) {
                value = "";
            }
            return new DataGroup.GroupObject((DataGroup)this, value, (DataGroup)this);
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            return new DataGroup.GroupObject((DataGroup)this, this.m_valuesName.get(rowIndex).substring(this.m_valuesName.get(rowIndex).indexOf("validation_properties / params /") + "validation_properties / params /".length() + 1), (DataGroup)this);
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return this.m_valuesName.size();
        }
    }

    public class ValidationResultsGroup
    extends DataGroup {
        private final Color GROUP_COLOR_BACKGROUND;
        private ArrayList<String> m_valuesName;
        private HashMap<Integer, HashMap<String, String>> m_valuesMap;
        private final String REQUIRED_PREFIX = "validation_properties / results /";

        public ValidationResultsGroup(int rowStart, ArrayList<DDataset> datasetArrayList) {
            super("Validation Results", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(205, 133, 63);
            this.m_valuesName = new ArrayList();
            this.m_valuesMap = new HashMap();
            this.REQUIRED_PREFIX = "validation_properties / results /";
            TreeSet<String> keysSet = new TreeSet<String>();
            int nbDataset = datasetArrayList.size();
            try {
                for (int i = 0; i < nbDataset; ++i) {
                    DDataset dataset = datasetArrayList.get(i);
                    ResultSummary rsm = dataset.getResultSummary();
                    if (rsm == null) continue;
                    Map map = dataset.getResultSummary().getSerializedPropertiesAsMap();
                    HashMap propertiesList = new HashMap();
                    SerializedPropertiesUtil.getProperties(propertiesList, (String)"Identification Summary Information", (Map)map);
                    this.m_valuesMap.put(i, propertiesList);
                    for (String key : propertiesList.keySet()) {
                        if (!key.contains("validation_properties / results /")) continue;
                        keysSet.add(key);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String key : keysSet) {
                this.m_valuesName.add(key);
            }
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            String key = this.m_valuesName.get(rowIndex);
            String value = this.m_valuesMap.get(columnIndex).get(key);
            if (value == null) {
                value = "";
            }
            return new DataGroup.GroupObject((DataGroup)this, value, (DataGroup)this);
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            return new DataGroup.GroupObject((DataGroup)this, this.m_valuesName.get(rowIndex).substring(this.m_valuesName.get(rowIndex).indexOf("validation_properties / results /") + "validation_properties / results /".length() + 1), (DataGroup)this);
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return this.m_valuesName.size();
        }
    }

    public class SqlIdGroup
    extends DataGroup {
        private static final int ROWTYPE_PROJECT_ID = 0;
        private static final int ROWTYPE_DATASET_ID = 1;
        private static final int ROWTYPE_RSET_ID = 2;
        private static final int ROWTYPE_RSM_ID = 3;
        private static final int ROWTYPE_MSI_SEARCH_ID = 4;
        private static final int ROWTYPE_PEAKLIST_SEARCH_ID = 5;
        private static final int ROWTYPE_PEAKLIST_SOFTWARE_ID = 6;
        private static final int ROWTYPE_SEARCH_SETTINGS_ID = 7;
        private static final int ROWTYPE_INSTRUMENT_CONFIGURATION_ID = 8;
        private static final int ROW_COUNT = 9;
        private final Color GROUP_COLOR_BACKGROUND;

        public SqlIdGroup(int rowStart) {
            super("Sql Ids", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(153, 122, 141);
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Project id", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Dataset id", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "ResultSet id", (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, "ResultSummary id", (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, "Msi Search id", (DataGroup)this);
                }
                case 5: {
                    return new DataGroup.GroupObject((DataGroup)this, "Peaklist Search id", (DataGroup)this);
                }
                case 6: {
                    return new DataGroup.GroupObject((DataGroup)this, "Peaklist Software id", (DataGroup)this);
                }
                case 7: {
                    return new DataGroup.GroupObject((DataGroup)this, "Search Settings id", (DataGroup)this);
                }
                case 8: {
                    return new DataGroup.GroupObject((DataGroup)this, "Instrument Configuration id", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            ResultSet rset = IdentificationPropertiesTableModel.this.m_rsetArray.get(columnIndex);
            ResultSummary rsm = IdentificationPropertiesTableModel.this.m_rsmArray.get(columnIndex);
            MsiSearch msiSearch = rset == null ? null : rset.getMsiSearch();
            SearchSetting searchSetting = msiSearch == null ? null : msiSearch.getSearchSetting();
            InstrumentConfig instrumentConfig = searchSetting == null ? null : searchSetting.getInstrumentConfig();
            Peaklist peaklist = msiSearch == null ? null : msiSearch.getPeaklist();
            PeaklistSoftware peaklistSoftware = peaklist == null ? null : peaklist.getPeaklistSoftware();
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(IdentificationPropertiesTableModel.this.m_projectIdArray.get(columnIndex)), (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(IdentificationPropertiesTableModel.this.m_datasetIdArray.get(columnIndex)), (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, rset == null ? "" : String.valueOf(rset.getId()), (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, rsm == null ? "" : String.valueOf(rsm.getId()), (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, msiSearch == null ? "" : String.valueOf(msiSearch.getId()), (DataGroup)this);
                }
                case 5: {
                    return new DataGroup.GroupObject((DataGroup)this, peaklist == null ? "" : String.valueOf(peaklist.getId()), (DataGroup)this);
                }
                case 6: {
                    return new DataGroup.GroupObject((DataGroup)this, peaklistSoftware == null ? "" : String.valueOf(peaklistSoftware.getId()), (DataGroup)this);
                }
                case 7: {
                    return new DataGroup.GroupObject((DataGroup)this, searchSetting == null ? "" : String.valueOf(searchSetting.getId()), (DataGroup)this);
                }
                case 8: {
                    return new DataGroup.GroupObject((DataGroup)this, instrumentConfig == null ? "" : String.valueOf(instrumentConfig.getId()), (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 9;
        }
    }
}

