/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model.properties;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.BiologicalSample;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.rsmexplorer.gui.model.properties.AbstractPropertiesTableModel;
import fr.proline.studio.table.DataGroup;
import fr.proline.studio.utils.SerializedPropertiesUtil;
import java.awt.Color;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class XICPropertiesTableModel
extends AbstractPropertiesTableModel {
    private ArrayList<DDataset> m_datasetArrayList = null;

    @Override
    public void setData(ArrayList<DDataset> datasetArrayList) {
        this.m_datasetArrayList = datasetArrayList;
        int nbDataset = datasetArrayList.size();
        this.m_datasetNameArray = new ArrayList(nbDataset);
        this.m_projectIdArray = new ArrayList(nbDataset);
        this.m_datasetIdArray = new ArrayList(nbDataset);
        int maxMasterQuantitationChannels = 0;
        for (int i = 0; i < nbDataset; ++i) {
            int nbMasterQuantitationChannels;
            DDataset dataset = datasetArrayList.get(i);
            this.m_datasetNameArray.add(dataset.getName());
            this.m_projectIdArray.add(dataset.getProject().getId());
            this.m_datasetIdArray.add(dataset.getId());
            List quantitationChannels = dataset.getMasterQuantitationChannels();
            int n = nbMasterQuantitationChannels = quantitationChannels == null ? 0 : quantitationChannels.size();
            if (nbMasterQuantitationChannels <= maxMasterQuantitationChannels) continue;
            maxMasterQuantitationChannels = nbMasterQuantitationChannels;
        }
        int[] maxQuantitationChannels = new int[maxMasterQuantitationChannels];
        for (int i = 0; i < nbDataset; ++i) {
            DDataset dataset = datasetArrayList.get(i);
            List masterQuantitationChannels = dataset.getMasterQuantitationChannels();
            int idMasterQuantitationChannel = 0;
            for (DMasterQuantitationChannel masterQuantitationChannel : masterQuantitationChannels) {
                List quantitationChannels = masterQuantitationChannel.getQuantitationChannels();
                if (quantitationChannels.size() > maxQuantitationChannels[idMasterQuantitationChannel]) {
                    maxQuantitationChannels[idMasterQuantitationChannel] = quantitationChannels.size();
                }
                ++idMasterQuantitationChannel;
            }
        }
        this.m_rowCount = -1;
        if (this.m_dataGroupList == null) {
            int i;
            this.m_dataGroupList = new ArrayList();
            int startRow = 0;
            DataGroup group = new GeneralInformationGroup(startRow);
            this.m_dataGroupList.add(group);
            startRow += group.getRowCount();
            group = new IdentificationSummaryGroup(startRow, datasetArrayList);
            this.m_dataGroupList.add(group);
            startRow += group.getRowCount();
            group = new QuantProcessingConfigGroup(startRow, datasetArrayList, false);
            this.m_dataGroupList.add(group);
            startRow += group.getRowCount();
            boolean postQuantProcessingConfig = false;
            for (i = 0; i < nbDataset; ++i) {
                DDataset dataset = datasetArrayList.get(i);
                try {
                    Map objectTreeAsMap = dataset.getPostQuantProcessingConfigAsMap();
                    if (objectTreeAsMap == null || objectTreeAsMap.isEmpty()) continue;
                    postQuantProcessingConfig = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (postQuantProcessingConfig) {
                group = new QuantProcessingConfigGroup(startRow, datasetArrayList, true);
                this.m_dataGroupList.add(group);
                startRow += group.getRowCount();
            }
            group = new QuantitationMethodGroup(startRow);
            this.m_dataGroupList.add(group);
            startRow += group.getRowCount();
            for (i = 0; i < maxMasterQuantitationChannels; ++i) {
                group = new MasterQuantitationChannelGroup(startRow, i);
                this.m_dataGroupList.add(group);
                startRow += group.getRowCount();
                for (int j = 0; j < maxQuantitationChannels[i]; ++j) {
                    group = new QuantitationChannelGroup(startRow, i, j);
                    this.m_dataGroupList.add(group);
                    startRow += group.getRowCount();
                    group = new BiologicalSampleGroup(startRow, i, j);
                    this.m_dataGroupList.add(group);
                    startRow += group.getRowCount();
                }
            }
        }
        this.m_loaded = true;
        this.fireTableStructureChanged();
    }

    public class GeneralInformationGroup
    extends DataGroup {
        private static final int ROWTYPE_XIC_ID = 0;
        private static final int ROWTYPE_XIC_DESCRIPTION = 1;
        private static final int ROW_COUNT = 1;
        private final Color GROUP_COLOR_BACKGROUND;

        public GeneralInformationGroup(int rowStart) {
            super("General Information", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(0, 0, 0);
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "XIC id", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "XIC Description", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            DDataset dataset = XICPropertiesTableModel.this.m_datasetArrayList.get(columnIndex);
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(dataset.getId()), (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, dataset.getDescription(), (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 1;
        }
    }

    public class IdentificationSummaryGroup
    extends DataGroup {
        private static final int ROWTYPE_IDENTIFICATION_SUMMARY_ID = 0;
        private static final int ROWTYPE_DESCRIPTION = 1;
        private static final int ROWTYPE_DATE = 2;
        private static final int ROW_COUNT = 3;
        private final Color GROUP_COLOR_BACKGROUND;
        private ArrayList<String> m_valuesName;
        private HashMap<Integer, HashMap<String, String>> m_valuesMap;

        public IdentificationSummaryGroup(int rowStart, ArrayList<DDataset> datasetArrayList) {
            super("Identification Summary", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(254, 163, 71);
            this.m_valuesName = new ArrayList();
            this.m_valuesMap = new HashMap();
            TreeSet<String> keysSet = new TreeSet<String>();
            int nbDataset = datasetArrayList.size();
            try {
                for (int i = 0; i < nbDataset; ++i) {
                    DDataset dataset = datasetArrayList.get(i);
                    ResultSummary rsm = dataset.getResultSummary();
                    if (rsm == null) continue;
                    HashMap<String, String> propertiesList = new HashMap<String, String>();
                    this.m_valuesMap.put(i, propertiesList);
                    Map schemaNames = rsm.getObjectTreeIdByName();
                    if (schemaNames == null || schemaNames.isEmpty()) continue;
                    for (String nextSchName : schemaNames.keySet()) {
                        propertiesList.put(nextSchName, "defined");
                        keysSet.add(nextSchName);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String key : keysSet) {
                this.m_valuesName.add(key);
            }
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Identification Summary id", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Description", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Date", (DataGroup)this);
                }
            }
            return new DataGroup.GroupObject((DataGroup)this, this.m_valuesName.get(rowIndex - 3), (DataGroup)this);
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            DDataset dataset = XICPropertiesTableModel.this.m_datasetArrayList.get(columnIndex);
            ResultSummary rsm = dataset.getResultSummary();
            if (rsm == null) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(rsm.getId()), (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, rsm.getDescription(), (DataGroup)this);
                }
                case 2: {
                    Timestamp timeStamp = rsm.getModificationTimestamp();
                    DateFormat df = DateFormat.getDateInstance(1, Locale.getDefault());
                    return new DataGroup.GroupObject((DataGroup)this, df.format(timeStamp), (DataGroup)this);
                }
            }
            String key = this.m_valuesName.get(rowIndex - 3);
            String value = this.m_valuesMap.get(columnIndex).get(key);
            if (value == null) {
                value = "";
            }
            return new DataGroup.GroupObject((DataGroup)this, value, (DataGroup)this);
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 3 + this.m_valuesName.size();
        }
    }

    public class QuantProcessingConfigGroup
    extends DataGroup {
        private Color m_groupColorBackground;
        private ArrayList<String> m_valuesName;
        private HashMap<Integer, HashMap<String, String>> m_valuesMap;

        public QuantProcessingConfigGroup(int rowStart, ArrayList<DDataset> datasetArrayList, boolean post) {
            super(post ? "Post Quantitation Processing Config" : "Quantitation Processing Config", rowStart);
            this.m_valuesName = new ArrayList();
            this.m_valuesMap = new HashMap();
            this.m_groupColorBackground = post ? new Color(76, 120, 107) : new Color(76, 166, 107);
            TreeSet<String> keysSet = new TreeSet<String>();
            int nbDataset = datasetArrayList.size();
            try {
                for (int i = 0; i < nbDataset; ++i) {
                    DDataset dataset = datasetArrayList.get(i);
                    Map objectTreeAsMap = post ? dataset.getPostQuantProcessingConfigAsMap() : dataset.getQuantProcessingConfigAsMap();
                    HashMap propertiesList = new HashMap();
                    SerializedPropertiesUtil.getProperties(propertiesList, (String)(post ? "Post Quantitation Processing Config" : "Quantitation Processing Config"), (Map)objectTreeAsMap);
                    this.m_valuesMap.put(i, propertiesList);
                    for (String key : propertiesList.keySet()) {
                        keysSet.add(key);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String key : keysSet) {
                this.m_valuesName.add(key);
            }
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            return new DataGroup.GroupObject((DataGroup)this, this.m_valuesName.get(rowIndex), (DataGroup)this);
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            String key = this.m_valuesName.get(rowIndex);
            String value = this.m_valuesMap.get(columnIndex).get(key);
            if (value == null) {
                value = "";
            }
            return new DataGroup.GroupObject((DataGroup)this, value, (DataGroup)this);
        }

        public Color getGroupColor(int row) {
            return this.m_groupColorBackground;
        }

        public int getRowCountImpl() {
            return this.m_valuesName.size();
        }
    }

    public class QuantitationMethodGroup
    extends DataGroup {
        private static final int ROWTYPE_QUANTI_METHOD_NAME = 0;
        private static final int ROWTYPE_QUANTI_METHOD_TYPE = 1;
        private static final int ROWTYPE_QUANTI_METHOD_ABUNDANCE_UNIT = 2;
        private static final int ROW_COUNT = 3;
        private final Color GROUP_COLOR_BACKGROUND;

        public QuantitationMethodGroup(int rowStart) {
            super("Quantitation Method", rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(71, 163, 254);
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Name", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Type", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Abundance Unit", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            DDataset dataset = XICPropertiesTableModel.this.m_datasetArrayList.get(columnIndex);
            QuantitationMethod quantMethod = dataset.getQuantitationMethod();
            switch (rowIndex) {
                case 0: {
                    if (quantMethod == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, quantMethod.getName(), (DataGroup)this);
                }
                case 1: {
                    if (quantMethod == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, quantMethod.getType(), (DataGroup)this);
                }
                case 2: {
                    if (quantMethod == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, quantMethod.getAbundanceUnit(), (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 3;
        }
    }

    public class MasterQuantitationChannelGroup
    extends DataGroup {
        private static final int ROWTYPE_MASTER_QUANTICHANNEL_ID = 0;
        private static final int ROWTYPE_MASTER_QUANTICHANNEL_NAME = 1;
        private static final int ROWTYPE_MASTER_QUANTICHANNEL_IDENT_DATASET_NAME = 2;
        private static final int ROWTYPE_MASTER_QUANTICHANNEL_NAME_SERIALIZEDPROPERTIES = 3;
        private static final int ROW_COUNT = 3;
        private final Color GROUP_COLOR_BACKGROUND;
        private int m_number;

        public MasterQuantitationChannelGroup(int rowStart, int number) {
            super("Master Quantitation Channel " + (number + 1), rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(254, 71, 163);
            this.m_number = number;
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Master Quantitation id", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Name", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Identification Dataset Name", (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, "Serialized Properties", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            DDataset dataset = XICPropertiesTableModel.this.m_datasetArrayList.get(columnIndex);
            List quantitationChannels = dataset.getMasterQuantitationChannels();
            if (quantitationChannels == null || quantitationChannels.size() <= this.m_number) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            DMasterQuantitationChannel masterQuantitationChannel = (DMasterQuantitationChannel)quantitationChannels.get(this.m_number);
            switch (rowIndex) {
                case 0: {
                    if (masterQuantitationChannel == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(masterQuantitationChannel.getId()), (DataGroup)this);
                }
                case 1: {
                    if (masterQuantitationChannel == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, masterQuantitationChannel.getName(), (DataGroup)this);
                }
                case 2: {
                    if (masterQuantitationChannel == null || masterQuantitationChannel.getIdentDataset() == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, masterQuantitationChannel.getIdentDataset().getName(), (DataGroup)this);
                }
                case 3: {
                    if (masterQuantitationChannel == null) {
                        return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
                    }
                    return new DataGroup.GroupObject((DataGroup)this, masterQuantitationChannel.getSerializedProperties(), (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 3;
        }
    }

    public class QuantitationChannelGroup
    extends DataGroup {
        private static final int ROWTYPE_QUANTICHANNEL_ID = 0;
        private static final int ROWTYPE_RESULT_FILE_NAME = 1;
        private static final int ROWTYPE_RAW_FILE_PATH = 2;
        private static final int ROWTYPE_MZDB_RAW_FILE_NAME = 3;
        private static final int ROWTYPE_IDENTIFICATION_RSM_ID = 4;
        private static final int ROWTYPE_QUANTI_LABEL_NAME_ID = 5;
        private static final int ROW_COUNT = 6;
        private final Color GROUP_COLOR_BACKGROUND;
        private final int m_numberMaster;
        private final int m_numberChannel;

        public QuantitationChannelGroup(int rowStart, int numberMaster, int numberChannel) {
            super("Quantitation Channel " + (numberChannel + 1), rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(153, 122, 141);
            this.m_numberMaster = numberMaster;
            this.m_numberChannel = numberChannel;
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Quantitation Channel id", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Result File Name", (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, "Raw File Path", (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, "Mzdb Raw File Name", (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, "Identification Summary Id", (DataGroup)this);
                }
                case 5: {
                    return new DataGroup.GroupObject((DataGroup)this, "Quantitation Label (id)", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            DDataset dataset = XICPropertiesTableModel.this.m_datasetArrayList.get(columnIndex);
            List masterQuantitationChannels = dataset.getMasterQuantitationChannels();
            if (masterQuantitationChannels == null || masterQuantitationChannels.size() <= this.m_numberMaster) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            DMasterQuantitationChannel masterQuantitationChannel = (DMasterQuantitationChannel)masterQuantitationChannels.get(this.m_numberMaster);
            List quantitationChannels = masterQuantitationChannel.getQuantitationChannels();
            if (quantitationChannels.size() <= this.m_numberChannel) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            DQuantitationChannel quantitationChannel = (DQuantitationChannel)quantitationChannels.get(this.m_numberChannel);
            if (quantitationChannel == null) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(quantitationChannel.getId()), (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, quantitationChannel.getResultFileName(), (DataGroup)this);
                }
                case 2: {
                    return new DataGroup.GroupObject((DataGroup)this, quantitationChannel.getRawFilePath(), (DataGroup)this);
                }
                case 3: {
                    return new DataGroup.GroupObject((DataGroup)this, quantitationChannel.getMzdbFileName(), (DataGroup)this);
                }
                case 4: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(quantitationChannel.getIdentResultSummaryId()), (DataGroup)this);
                }
                case 5: {
                    String value = quantitationChannel.getQuantitationLabel() == null ? "" : quantitationChannel.getQuantitationLabel().getName() + " (" + quantitationChannel.getQuantitationLabel().getId() + ") ";
                    return new DataGroup.GroupObject((DataGroup)this, value, (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 6;
        }
    }

    public class BiologicalSampleGroup
    extends DataGroup {
        private static final int ROWTYPE_BIOLOGICAL_SAMPLE_ID = 0;
        private static final int ROWTYPE_BIOLOGICAL_SAMPLE_NAME = 1;
        private static final int ROW_COUNT = 2;
        private final Color GROUP_COLOR_BACKGROUND;
        private final int m_numberMaster;
        private final int m_numberChannel;

        public BiologicalSampleGroup(int rowStart, int numberMaster, int numberChannel) {
            super("Biological Sample " + (numberChannel + 1), rowStart);
            this.GROUP_COLOR_BACKGROUND = new Color(122, 141, 153);
            this.m_numberMaster = numberMaster;
            this.m_numberChannel = numberChannel;
        }

        public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, "Biological Sample id", (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, "Biological Sample Name", (DataGroup)this);
                }
            }
            return null;
        }

        public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
            DDataset dataset = XICPropertiesTableModel.this.m_datasetArrayList.get(columnIndex);
            List masterQuantitationChannels = dataset.getMasterQuantitationChannels();
            if (masterQuantitationChannels == null || masterQuantitationChannels.size() <= this.m_numberMaster) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            DMasterQuantitationChannel masterQuantitationChannel = (DMasterQuantitationChannel)masterQuantitationChannels.get(this.m_numberMaster);
            List quantitationChannels = masterQuantitationChannel.getQuantitationChannels();
            if (quantitationChannels.size() <= this.m_numberChannel) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            DQuantitationChannel quantitationChannel = (DQuantitationChannel)quantitationChannels.get(this.m_numberChannel);
            BiologicalSample biologicalSample = quantitationChannel.getBiologicalSample();
            if (biologicalSample == null) {
                return new DataGroup.GroupObject((DataGroup)this, "", (DataGroup)this);
            }
            switch (rowIndex) {
                case 0: {
                    return new DataGroup.GroupObject((DataGroup)this, String.valueOf(biologicalSample.getId()), (DataGroup)this);
                }
                case 1: {
                    return new DataGroup.GroupObject((DataGroup)this, biologicalSample.getName(), (DataGroup)this);
                }
            }
            return null;
        }

        public Color getGroupColor(int row) {
            return this.GROUP_COLOR_BACKGROUND;
        }

        public int getRowCountImpl() {
            return 2;
        }
    }
}

