/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMPeptidesGraphicView;
import fr.proline.studio.rsmexplorer.gui.ptm.PeptideOnProteinOverviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMGraphicCtrlPanel
extends JPanel
implements DataBoxPanelInterface,
SplittedPanelContainer.UserActions {
    DProteinMatch m_selectedProteinMatch;
    List<PTMPeptideInstance> m_ptmPeptideInstances;
    private static final Logger m_logger = LoggerFactory.getLogger(PTMGraphicCtrlPanel.class);
    private final PTMPeptidesGraphicView m_ptmPeptideAreaCtrl = new PTMPeptidesGraphicView();
    private final PeptideOnProteinOverviewPanel m_proteinOverviewCtrl;
    protected AbstractDataBox m_dataBox;

    public PTMGraphicCtrlPanel() {
        this.m_ptmPeptideAreaCtrl.setSuperCtrl(this);
        this.m_proteinOverviewCtrl = new PeptideOnProteinOverviewPanel(this);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JToolBar toolbar = this.initToolbar();
        this.m_ptmPeptideAreaCtrl.setSize(-29, -48);
        this.m_proteinOverviewCtrl.setPreferredSize(new Dimension(-29, 50));
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.m_ptmPeptideAreaCtrl, "Center");
        centerPanel.add((Component)this.m_proteinOverviewCtrl, "South");
        this.add((Component)toolbar, "West");
        this.add((Component)centerPanel, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)this);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setSelectedProtein(DProteinMatch proteinMatch) {
        this.m_selectedProteinMatch = proteinMatch;
    }

    public void setData(List<PTMPeptideInstance> ptmPepInstances) {
        if (ptmPepInstances == null || ptmPepInstances.isEmpty()) {
            return;
        }
        this.m_ptmPeptideAreaCtrl.setData(ptmPepInstances);
        this.m_ptmPeptideInstances = ptmPepInstances;
        if (this.m_selectedProteinMatch == null) {
            return;
        }
        DPeptideInstance[] peptideInstances = this.m_selectedProteinMatch.getPeptideSet(this.m_dataBox.getRsmId()).getPeptideInstances();
        if (this.m_selectedProteinMatch.getDBioSequence() != null) {
            this.m_proteinOverviewCtrl.setData(this.m_selectedProteinMatch.getAccession(), this.m_selectedProteinMatch.getDBioSequence().getSequence(), ptmPepInstances.get(0), ptmPepInstances, peptideInstances);
        } else {
            this.m_proteinOverviewCtrl.setData(this.m_selectedProteinMatch.getAccession(), "0" + this.m_ptmPeptideAreaCtrl.getSequence().length(), ptmPepInstances.get(0), ptmPepInstances, peptideInstances);
        }
        this.repaint();
    }

    protected void valueChanged() {
        this.m_dataBox.addDataChanged(PTMPeptideInstance.class, null);
        this.m_dataBox.propagateDataChanged();
        this.repaint();
    }

    public void setSelectedPTMPeptide(PTMPeptideInstance pepInstance) {
        this.m_ptmPeptideAreaCtrl.setSelectedPTMPeptide(pepInstance);
        this.m_proteinOverviewCtrl.setSelectedPeptide(pepInstance);
    }

    public PTMPeptideInstance getSelectedPTMPeptideInstance() {
        return this.m_ptmPeptideAreaCtrl.getSelectedPTMPeptideInstance();
    }

    public int getSelectedIndex() {
        return this.m_ptmPeptideAreaCtrl.getSelectedIndex();
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
        this.m_ptmPeptideAreaCtrl.setDataBox(dataBox);
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void setLoading(int id) {
    }

    @Override
    public void setLoading(int id, boolean calculating) {
    }

    @Override
    public void setLoaded(int id) {
    }

    void onMessage(Source source, Message message) {
        if (source.equals((Object)Source.PEPTIDE_AREA)) {
            if (message.equals((Object)Message.SELECTED)) {
                this.m_proteinOverviewCtrl.setSelectedPeptide(this.m_ptmPeptideAreaCtrl.getSelectedPTMPeptideInstance());
            }
        } else if (source.equals((Object)Source.SEQUENCE)) {
            if (message.equals((Object)Message.SELECTED)) {
                int selectedOnProtein = this.m_proteinOverviewCtrl.getSelectedProteinPosition();
                this.m_ptmPeptideAreaCtrl.setViewPosition(selectedOnProtein);
            } else if (message.equals((Object)Message.SEQUENCE)) {
                String sequence = this.m_proteinOverviewCtrl.getProteinSequence();
                this.m_ptmPeptideAreaCtrl.setProteinSequence(sequence);
            }
        }
        this.repaint();
    }

    public static enum Source {
        PEPTIDE_AREA,
        SEQUENCE;

    }

    public static enum Message {
        SELECTED,
        SEQUENCE;

    }
}

