/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DPeptidePTM;

public class PTMMark {
    private DPeptidePTM m_peptidePtm;
    private int m_proteinLocation;
    private int m_proteinDisplayLocation;
    private boolean m_ptmIsNorCTerm;
    private boolean m_addPtmNCTerm;

    public PTMMark(DPeptidePTM peptidePtm, int proteinLocation) {
        this(peptidePtm, proteinLocation, proteinLocation, false);
    }

    public PTMMark(DPeptidePTM peptidePtm, int proteinLocation, int proteinDisplayLocation, boolean isNCTermPTM) {
        this.m_peptidePtm = peptidePtm;
        this.m_proteinLocation = proteinLocation;
        this.m_proteinDisplayLocation = proteinDisplayLocation;
        this.m_ptmIsNorCTerm = isNCTermPTM;
    }

    public boolean equals(PTMMark compare) {
        return compare.getProteinLocation() == this.m_proteinLocation && this.m_peptidePtm.getIdPeptide() == compare.getPeptidePtm().getIdPeptide() && this.m_peptidePtm.getIdPtmSpecificity() == compare.getPeptidePtm().getIdPtmSpecificity();
    }

    public void setAddPtmNCTerm(boolean addCNTermMark) {
        this.m_addPtmNCTerm = addCNTermMark;
    }

    public boolean showNorCtermMark() {
        return this.m_addPtmNCTerm;
    }

    public DPeptidePTM getPeptidePtm() {
        return this.m_peptidePtm;
    }

    public int getProteinLocation() {
        return this.m_proteinLocation;
    }

    public int getProteinLocationToDisplay() {
        return this.m_proteinDisplayLocation;
    }

    public boolean isPTMNorCterm() {
        return this.m_ptmIsNorCTerm;
    }

    public String getPtmShortName() {
        DInfoPTM ptm = (DInfoPTM)DInfoPTM.getInfoPTMMap().get(this.m_peptidePtm.getIdPtmSpecificity());
        return ptm.getPtmShortName();
    }

    public char getPtmSymbol() {
        DInfoPTM ptm = (DInfoPTM)DInfoPTM.getInfoPTMMap().get(this.m_peptidePtm.getIdPtmSpecificity());
        return ptm.getPtmShortName().toUpperCase().charAt(0);
    }

    public Long getPtmSpecificityId() {
        return this.m_peptidePtm.getIdPtmSpecificity();
    }

    public String toString() {
        return "PTMMark{m_peptidePtm=" + this.getPtmShortName() + " id=" + this.m_peptidePtm.getIdPtmSpecificity() + ", m_proteinLocation=" + this.m_proteinLocation + ", m_ptmIsNorCTerm=" + this.m_ptmIsNorCTerm + "}";
    }
}

