/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.rsmexplorer.gui.RsmProteinAndPeptideOverviewPlotPanel;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMGraphicCtrlPanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeptideOnProteinOverviewPanel
extends RsmProteinAndPeptideOverviewPlotPanel {
    private static final Logger m_logger = LoggerFactory.getLogger(PeptideOnProteinOverviewPanel.class);
    HashMap<Integer, ArrayList<PTMPeptideInstance>> m_postionPTMPeptideMap;
    private List<PTMPeptideInstance> m_PTMPeptideInstances;
    private PTMPeptideInstance m_selectedPTMPeptideInstance;
    private int m_selectedPosition;
    private final Color PTM_PEPTIDE_COLOR = Color.red;

    public PeptideOnProteinOverviewPanel(PTMGraphicCtrlPanel superCtrl) {
        super(superCtrl);
    }

    public void setSelectedPeptide(PTMPeptideInstance selectedPTMPeptideInstance) {
        this.m_selectedPTMPeptideInstance = selectedPTMPeptideInstance;
    }

    public int getSelectedProteinPosition() {
        return this.m_selectedPosition;
    }

    private void setSelectedOnProtein(int position) {
        this.m_selectedPosition = position;
    }

    public void setData(String proteinName, String sequence, PTMPeptideInstance selectedPeptide, List<PTMPeptideInstance> ptmPeptideInstances, DPeptideInstance[] peptideInstances) {
        this.m_PTMPeptideInstances = ptmPeptideInstances;
        this.m_peptideInstances = peptideInstances;
        this.m_proteinLength = sequence.length();
        this.m_proteinSequence = sequence;
        String titleComment = "";
        if (sequence.startsWith("0")) {
            this.m_proteinLength = Integer.valueOf(sequence.substring(1));
            this.m_proteinSequence = "";
            titleComment = " (calculated <= protein length)";
            this.m_needCreateSequence = true;
        }
        this.m_selectedPTMPeptideInstance = selectedPeptide;
        this.m_startPositionProtein = 0;
        this.m_peptidePTMMap = new HashMap();
        this.createPTMPeptideMap(ptmPeptideInstances);
        this.createAADataMap(peptideInstances);
        if (this.m_needCreateSequence) {
            ((PTMGraphicCtrlPanel)this.m_superCtrl).onMessage(PTMGraphicCtrlPanel.Source.SEQUENCE, PTMGraphicCtrlPanel.Message.SEQUENCE);
        }
        this.m_aaWidth = this.m_aaWidthOriginal = (double)(this.getWidth() - 20) / (double)this.m_proteinLength;
        String title = proteinName + " Protein Sequence Coverage " + this.m_proteinLength + " amino acid" + titleComment;
        ((TitledBorder)this.getBorder()).setTitle(title);
        this.removeAll();
        this.repaint();
    }

    @Override
    protected void paintSelectedPeptide(Graphics2D g) {
        g.setColor(this.PTM_PEPTIDE_COLOR);
        for (PTMPeptideInstance pep : this.m_PTMPeptideInstances) {
            int start = pep.getStartPosition() + 1;
            int stop = pep.getStopPosition();
            int length = stop - start + 1;
            this.drawPeptide(g, start, length);
        }
        g.setColor(this.SELECTED_COLOR);
        if (this.m_selectedPTMPeptideInstance != null) {
            int start = this.m_selectedPTMPeptideInstance.getStartPosition() + 1;
            int length = this.m_selectedPTMPeptideInstance.getStopPosition() - start + 1;
            this.drawPeptide(g, start, length);
        }
    }

    private void createPTMPeptideMap(List<PTMPeptideInstance> peptideInstances) {
        this.m_postionPTMPeptideMap = new HashMap();
        int start = 0;
        int stop = 0;
        for (PTMPeptideInstance pep : peptideInstances) {
            start = pep.getStartPosition();
            stop = pep.getStopPosition();
            if (stop > this.m_proteinLength) {
                this.m_proteinLength = stop;
            }
            for (int i = start; i <= stop; ++i) {
                ArrayList<PTMPeptideInstance> pepList = this.m_postionPTMPeptideMap.get(i);
                pepList = pepList == null ? new ArrayList<PTMPeptideInstance>() : pepList;
                pepList.add(pep);
                this.m_postionPTMPeptideMap.put(i, pepList);
            }
        }
    }

    @Override
    protected void actionMouseClicked(MouseEvent e) {
        this.requestFocusInWindow();
        if (SwingUtilities.isLeftMouseButton(e)) {
            int x = e.getX();
            int y = e.getY();
            if (y > 20 && y < 45) {
                int positionOnProtein = this.getPosOnProtein(x);
                this.setSelectedOnProtein(positionOnProtein);
                ((PTMGraphicCtrlPanel)this.m_superCtrl).onMessage(PTMGraphicCtrlPanel.Source.SEQUENCE, PTMGraphicCtrlPanel.Message.SELECTED);
            }
        }
    }
}

