/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm.mark;

import fr.proline.studio.rsmexplorer.gui.ptm.PTMMark;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewContext;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewPtmAbstract;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMMarkView
extends ViewPtmAbstract {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    private PTMMark m_mark;
    private final List<PTMMark> m_aaLocMarks;
    private final List<PTMMark> m_cOrNtermMarks;
    private boolean hasMultipleAAPTMSpecif;
    private boolean hasMultipleCorNPTMSpecif;
    private final String m_symbol;
    private final Color m_color;

    public PTMMarkView(List<PTMMark> marks) {
        if (marks == null || marks.isEmpty()) {
            throw new RuntimeException("Empty PTMMark list !!");
        }
        this.m_cOrNtermMarks = new ArrayList<PTMMark>();
        this.m_aaLocMarks = new ArrayList<PTMMark>();
        this.m_mark = null;
        boolean samePtmSpecifId = true;
        boolean sameCorNTermPtmSpecifId = true;
        Long prevAAPtmSpecifId = null;
        Long prevCorNtermSpecifId = null;
        for (PTMMark pm : marks) {
            if (pm.isPTMNorCterm()) {
                this.m_cOrNtermMarks.add(pm);
                if (prevCorNtermSpecifId == null) {
                    prevCorNtermSpecifId = pm.getPtmSpecificityId();
                    continue;
                }
                sameCorNTermPtmSpecifId = prevCorNtermSpecifId.equals(pm.getPtmSpecificityId());
                continue;
            }
            this.m_aaLocMarks.add(pm);
            if (prevAAPtmSpecifId == null) {
                prevAAPtmSpecifId = pm.getPtmSpecificityId();
            } else {
                samePtmSpecifId = prevAAPtmSpecifId.equals(pm.getPtmSpecificityId());
            }
            if (this.m_mark != null) continue;
            this.m_mark = pm;
        }
        if (this.m_mark == null) {
            this.m_mark = marks.get(0);
        }
        this.hasMultipleAAPTMSpecif = !samePtmSpecifId;
        boolean bl = this.hasMultipleCorNPTMSpecif = !sameCorNTermPtmSpecifId;
        if (!this.m_aaLocMarks.isEmpty() && this.hasMultipleAAPTMSpecif) {
            this.m_color = ViewSetting.getMultiPTMColor();
            this.m_symbol = "*";
        } else if (!this.m_aaLocMarks.isEmpty() && !this.hasMultipleAAPTMSpecif) {
            this.m_color = ViewSetting.getColor(this.m_mark);
            this.m_symbol = Character.toString(this.m_mark.getPtmSymbol());
        } else if (!this.m_cOrNtermMarks.isEmpty() && this.hasMultipleCorNPTMSpecif) {
            this.m_color = ViewSetting.getMultiPTMColor();
            this.m_symbol = "*";
        } else {
            this.m_color = ViewSetting.getColor(this.m_mark);
            this.m_symbol = Character.toString(this.m_mark.getPtmSymbol());
        }
    }

    @Override
    public void setBeginPoint(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    public boolean isNCTerm() {
        return !this.m_cOrNtermMarks.isEmpty();
    }

    public int getLocationProtein() {
        return this.m_mark.getProteinLocation();
    }

    public int getDisplayedLocationProtein() {
        return this.m_mark.getProteinLocationToDisplay();
    }

    public String getPTMShortName() {
        if (this.hasMultipleAAPTMSpecif) {
            return "Multiple PTMs";
        }
        return this.m_mark.getPtmShortName();
    }

    @Override
    public void paint(Graphics2D g, ViewContext viewContext) {
        FontMetrics fm = g.getFontMetrics(ViewSetting.FONT_PTM);
        Color oldColor = g.getColor();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.x0 = this.m_x + this.getLocationProtein() * ViewSetting.WIDTH_AA;
        this.y0 = this.m_y + ViewSetting.HEIGHT_AA;
        int xWidthAA = this.x0 + ViewSetting.WIDTH_AA;
        int yHeightAA = this.y0 + ViewSetting.HEIGHT_AA;
        int yBottom = (int)((double)this.y0 + (double)ViewSetting.HEIGHT_AA * 1.5);
        int xCenter = this.x0 + ViewSetting.WIDTH_AA / 2;
        g.setColor(this.m_color);
        if (this.m_aaLocMarks.isEmpty()) {
            int[] xPtm = new int[]{this.x0, xWidthAA, xCenter};
            int[] yPtm = new int[]{yHeightAA, yHeightAA, yBottom};
            g.fillPolygon(xPtm, yPtm, yPtm.length);
        } else {
            g.setStroke(ViewSetting.STROKE);
            g.drawLine(this.x0, this.y0, xWidthAA, this.y0);
            g.drawLine(xWidthAA, this.y0, xWidthAA, yHeightAA);
            g.drawLine(xWidthAA, yHeightAA, this.x0, yHeightAA);
            g.drawLine(this.x0, yHeightAA, this.x0, this.y0);
            if (this.isNCTerm()) {
                Color aaColor = g.getColor();
                Color cnTermColor = ViewSetting.getMultiPTMColor();
                if (!this.hasMultipleCorNPTMSpecif) {
                    cnTermColor = ViewSetting.getColor(this.m_cOrNtermMarks.get(0));
                }
                g.setColor(cnTermColor);
                int[] xPtm = new int[]{this.x0, xWidthAA, xCenter};
                int[] yPtm = new int[]{yHeightAA, yHeightAA, yBottom};
                g.fillPolygon(xPtm, yPtm, yPtm.length);
                g.setColor(aaColor);
            } else {
                g.drawLine(xCenter, yHeightAA, xCenter, yBottom);
                g.drawLine(this.x0, yBottom, xWidthAA, yBottom);
            }
            g.setFont(ViewSetting.FONT_PTM);
            int stringWidth = fm.stringWidth(this.m_symbol);
            g.drawString(this.m_symbol, xCenter - stringWidth / 2, yHeightAA - (ViewSetting.HEIGHT_AA - stringWidth) / 2);
        }
        if (!this.m_aaLocMarks.isEmpty() || this.m_aaLocMarks.isEmpty() && viewContext.isNCtermIndexShown()) {
            g.setColor(Color.BLACK);
            g.setFont(ViewSetting.FONT_NUMBER);
            fm = g.getFontMetrics(ViewSetting.FONT_NUMBER);
            int descent = fm.getDescent();
            int stringWidth = fm.stringWidth(String.valueOf(this.getLocationProtein()));
            if (stringWidth > ViewSetting.WIDTH_AA - ViewSetting.BORDER_GAP + 3) {
                Font smallerFont = ViewSetting.FONT_NUMBER_DIAGONAL;
                g.setFont(smallerFont);
                fm = g.getFontMetrics(smallerFont);
                stringWidth = fm.stringWidth(String.valueOf(this.getLocationProtein()));
            }
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawString(String.valueOf(this.getDisplayedLocationProtein()), xCenter - stringWidth / 2, this.y0 - descent / 2);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        g.setColor(oldColor);
    }

    public String toString() {
        return "ViewPtmMark{m_type=" + this.m_symbol + ", _locationProtein=" + this.getLocationProtein() + ", m_displayedLocationProtein=" + this.getDisplayedLocationProtein() + "}";
    }
}

