/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm.pep;

import fr.proline.studio.rsmexplorer.gui.ptm.ViewContext;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewPtmAbstract;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import fr.proline.studio.rsmexplorer.gui.ptm.pep.PeptideView;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Objects;

public class PeptideSetView
extends ViewPtmAbstract {
    ArrayList<PeptideView> m_peptideList = new ArrayList();

    @Override
    public void paint(Graphics2D g, ViewContext viewContext) {
        this.x0 = this.m_x;
        this.y0 = this.m_y;
        for (PeptideView vp : this.m_peptideList) {
            this.paintGrillX(g, viewContext.getAreaWidth(), this.x0, this.y0);
            this.paintGrillX(g, viewContext.getAreaWidth(), this.x0, this.y0 + ViewSetting.HEIGHT_AA);
            vp.setBeginPoint(this.x0, this.y0);
            g.setColor(ViewSetting.PEPTIDE_COLOR);
            vp.paint(g, viewContext);
            this.y0 = (int)((double)this.y0 + (double)ViewSetting.HEIGHT_AA * 1.5);
        }
    }

    private void paintGrillX(Graphics2D g, int areaWidth, int x, int y) {
        Stroke s = g.getStroke();
        g.setColor(CyclicColorPalette.GRAY_GRID);
        g.setStroke(ViewSetting.DASHED);
        g.drawLine(x, y, areaWidth, y);
        g.setStroke(s);
    }

    @Override
    public void setBeginPoint(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    protected void setPeptideViewList(ArrayList<PeptideView> peptideList) {
        this.m_peptideList = Objects.requireNonNullElseGet(peptideList, ArrayList::new);
    }

    protected int getSelectedItemIndex(int x, int y) {
        this.y0 = this.m_y;
        for (int i = 0; i < this.m_peptideList.size(); ++i) {
            int yRangA = this.y0;
            int yRangZ = yRangA + ViewSetting.HEIGHT_AA;
            if (y > yRangA && y < yRangZ) {
                return i;
            }
            this.y0 = (int)((double)this.y0 + (double)ViewSetting.HEIGHT_AA * 1.5);
        }
        return -1;
    }

    protected String getToolTipText(int x, int y) {
        int index = this.getSelectedItemIndex(x, y);
        if (index != -1) {
            return this.m_peptideList.get(index).getToolTipText(x);
        }
        return null;
    }
}

