/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.spectrum;

import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.GenerateSpectrumMatchTask;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrum;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.GenerateSpectrumMatchesDialog;
import fr.proline.studio.rsmexplorer.gui.spectrum.AbstractPeptideSpectrumPanel;
import fr.proline.studio.rsmexplorer.gui.spectrum.PeptideFragmentationData;
import fr.proline.studio.utils.IconManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JButton;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsetPeptideSpectrumPanel
extends AbstractPeptideSpectrumPanel {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final String SPECTRUM_GENERATION_RUNNING = "Generate Spectrum Match in progress...";
    private JButton m_generateMatchButton;
    private boolean _isSpectrumMatchGenerationAsked = false;

    public RsetPeptideSpectrumPanel() {
        super("intensity");
        this.customizeToolbar();
    }

    private void customizeToolbar() {
        this.m_generateMatchButton = new JButton();
        this.m_generateMatchButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.FRAGMENTATION));
        this.m_generateMatchButton.setToolTipText("Generate & Store Spectrum Match");
        this.m_generateMatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateSpectrumMatchesDialog dialog;
                DDataset dataset = (DDataset)RsetPeptideSpectrumPanel.this.getDataBox().getData(DDataset.class);
                if (dataset == null) {
                    MsiSearch msiSearch = RsetPeptideSpectrumPanel.this.getPeptideMatchMsiSearch();
                    dialog = new GenerateSpectrumMatchesDialog((Window)WindowManager.getDefault().getMainWindow(), msiSearch);
                } else {
                    dialog = new GenerateSpectrumMatchesDialog((Window)WindowManager.getDefault().getMainWindow(), Collections.singletonList(dataset));
                }
                Point location = RsetPeptideSpectrumPanel.this.m_generateMatchButton.getLocationOnScreen();
                dialog.setLocation(location.x + 30, location.y - dialog.getHeight() - 60);
                dialog.setVisible(true);
                if (dialog.getButtonClicked() == 0) {
                    Long frsId = dialog.getFragmentationRuleSetId();
                    Boolean forceGenerate = dialog.getDoForceGenerate();
                    RsetPeptideSpectrumPanel.this._isSpectrumMatchGenerationAsked = true;
                    RsetPeptideSpectrumPanel.this.m_generateMatchButton.setIcon(IconManager.getIconWithHourGlass((IconManager.IconType)IconManager.IconType.LOAD_ALIGNMENT_CLOUD));
                    RsetPeptideSpectrumPanel.this.m_generateMatchButton.setToolTipText(RsetPeptideSpectrumPanel.SPECTRUM_GENERATION_RUNNING);
                    RsetPeptideSpectrumPanel.this.generateSpectrumMatch(frsId, forceGenerate);
                }
            }
        });
        this.m_toolbar.add(this.m_generateMatchButton);
    }

    private MsiSearch getPeptideMatchMsiSearch() {
        ResultSet rs = (ResultSet)this.getDataBox().getData(ResultSet.class);
        if (rs != null) {
            return rs.getMsiSearch();
        }
        ResultSummary rsm = (ResultSummary)this.getDataBox().getData(ResultSummary.class);
        if (rsm != null && rsm.getResultSet() != null) {
            return rsm.getResultSet().getMsiSearch();
        }
        return null;
    }

    private void generateSpectrumMatch(Long frsId, Boolean forceGenerateSM) {
        AbstractJMSCallback spectrumMatchCallback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                if (success) {
                    RsetPeptideSpectrumPanel.this._isSpectrumMatchGenerationAsked = false;
                    ((DataBoxRsetPeptideSpectrum)RsetPeptideSpectrumPanel.this.m_dataBox).loadAnnotations(RsetPeptideSpectrumPanel.this.m_peptideMatch);
                } else {
                    m_logger.error("Fail to generate spectrum matches for peptide_match.id=" + RsetPeptideSpectrumPanel.this.m_peptideMatch.getId());
                }
                RsetPeptideSpectrumPanel.this.m_generateMatchButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.FRAGMENTATION));
                RsetPeptideSpectrumPanel.this.m_generateMatchButton.setToolTipText("Generate & Store Spectrum Match");
                RsetPeptideSpectrumPanel.this.setCursor(new Cursor(0));
            }
        };
        this.setCursor(new Cursor(3));
        GenerateSpectrumMatchTask task = new GenerateSpectrumMatchTask(spectrumMatchCallback, null, Long.valueOf(this.m_dataBox.getProjectId()), Long.valueOf(this.m_peptideMatch.getResultSetId()), null, Long.valueOf(this.m_peptideMatch.getId()), frsId.longValue(), forceGenerateSM);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    @Override
    public void updateFragmentationPlot(DPeptideMatch peptideMatch, PeptideFragmentationData peptideFragmentationData) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.m_generateMatchButton.setEnabled(true);
        }
        this.m_chart.getPlot().removeChangeListener((PlotChangeListener)this);
        this.constructSpectrumChart(peptideMatch);
        this.m_chart.getXYPlot().getRangeAxis().setDefaultAutoRange(new Range(this.m_chart.getXYPlot().getRangeAxis().getLowerBound(), this.m_chart.getXYPlot().getRangeAxis().getUpperBound()));
        this.m_chart.getXYPlot().getDomainAxis().setDefaultAutoRange(new Range(this.m_chart.getXYPlot().getDomainAxis().getLowerBound(), this.m_chart.getXYPlot().getDomainAxis().getUpperBound()));
        this.annotateSpectrum();
        this.m_chart.getPlot().addChangeListener((PlotChangeListener)this);
    }

    @Override
    public void addCustomAnnotations() {
        PeptideFragmentationData.FragmentMatch[] fragmentationMatches = this.m_peptideFragmentationData.getFragmentMatches();
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        double abcReferenceYPosition = this.getReferenceABCSeriesRange();
        double xyzReferenceYPosition = this.getReferenceXYZSeriesRange();
        double spacerValue = this.pixelToValueRange(3.0);
        double pointerSizeValue = this.pixelToValueRange(20.0);
        for (PeptideFragmentationData.FragmentMatch match : fragmentationMatches) {
            String referenceSeries;
            String label = match.neutral_loss_mass != null && match.neutral_loss_mass.floatValue() > 0.0f ? match.label + "-" + Math.round(match.neutral_loss_mass.floatValue()) : match.label;
            XYPointerAnnotation pointer = new XYPointerAnnotation(label, match.moz.doubleValue(), (double)match.intensity.floatValue() + spacerValue, 4.71238898038469);
            pointer.setBaseRadius(5.0);
            pointer.setTipRadius(0.0);
            pointer.setArrowWidth(2.0);
            pointer.setFont(new Font("SansSerif", 0, 9));
            Color color = match.isABCSerie() ? AbstractPeptideSpectrumPanel.ABC_SERIE_COLOR : AbstractPeptideSpectrumPanel.XYZ_SERIE_COLOR;
            double referenceYPosition = match.isABCSerie() ? abcReferenceYPosition : xyzReferenceYPosition;
            pointer.setArrowPaint((Paint)color);
            pointer.setPaint((Paint)color);
            pointer.setTextAnchor(TextAnchor.BOTTOM_CENTER);
            StringBuilder builder = new StringBuilder("<html>");
            builder.append("m/z: ").append(match.moz).append("<br>");
            builder.append("intensity: ").append(match.intensity);
            if (match.neutral_loss_mass != null && match.neutral_loss_mass.floatValue() > 0.0f) {
                builder.append("<br>").append("Neutral loss: ").append(match.neutral_loss_mass).append("<br>");
            }
            builder.append("</html>");
            pointer.setToolTipText(builder.toString());
            plot.addAnnotation((XYAnnotation)pointer);
            float[] dash = new float[]{3.0f};
            String string = referenceSeries = match.isABCSerie() ? this.m_peptideFragmentationData.getABCReferenceSeriesName() : this.m_peptideFragmentationData.getXYZReferenceSeriesName();
            if (!this.m_peptideFragmentationData.getTheoreticalFragmentSeries(referenceSeries).isMatching(match) || !((double)match.intensity.floatValue() + spacerValue + pointerSizeValue < referenceYPosition)) continue;
            BasicStroke stk = new BasicStroke(0.5f, 0, 0, 5.0f, dash, 0.5f);
            XYLineAnnotation line = new XYLineAnnotation(match.calculated_moz.doubleValue(), referenceYPosition, match.calculated_moz.doubleValue(), (double)match.intensity.floatValue() + spacerValue + pointerSizeValue, (Stroke)stk, (Paint)color);
            plot.addAnnotation((XYAnnotation)line);
        }
    }

    @Override
    public double[][] getMassIntensityValues(DSpectrum spectrum) {
        return spectrum.getMassIntensityValues();
    }

    public void setShowed(boolean showed) {
    }

    public boolean isShowed() {
        return true;
    }
}

