/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.IsobaricMethodParamsPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.LabelFreeMSParamsCompletePanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.QuantSimplifiedPostProcessingPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentalDesignPanel
extends HourglassPanel
implements DataBoxPanelInterface {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private AbstractDataBox m_dataBox;
    private JPanel m_expDesignPanel;
    private QuantExperimentalDesignTree m_expDesignTree;
    private JTabbedPane m_tabbedPane;
    private JPanel m_confPanel;
    private JPanel m_lowlevelConfPanel;
    private JPanel m_refinedPanel;
    private DDataset m_dataset;
    private boolean m_displayPostProcessing = false;
    private boolean m_displayLowLevel = false;
    private boolean m_displayQuantParam = true;
    private final DDatasetType.QuantitationMethodInfo m_quantMethodInfo;
    private static String TAB_POST_PROCESSING_TITLE = "Compute Post Processing";
    private static String TAB_LOW_LEVEL_TITLE = "Low Level";

    public ExperimentalDesignPanel(DDatasetType.QuantitationMethodInfo quantMethodInfo) {
        this.m_quantMethodInfo = quantMethodInfo;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel expDesignPanel = this.createExperimentalDesignPanel();
        this.add(expDesignPanel, "Center");
    }

    private JPanel createExperimentalDesignPanel() {
        JPanel expDesignPanel = new JPanel();
        expDesignPanel.setBounds(0, 0, 500, 400);
        expDesignPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        expDesignPanel.add((Component)toolbar, "West");
        expDesignPanel.add((Component)internalPanel, "Center");
        return expDesignPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportButton = new ExportButton("Exp. Design", this.m_expDesignPanel);
        toolbar.add((Component)exportButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_tabbedPane = new JTabbedPane();
        JScrollPane scrollPaneExpDesign = new JScrollPane();
        this.m_expDesignPanel = new JPanel();
        this.m_expDesignPanel.setLayout(new BorderLayout());
        this.m_expDesignTree = new QuantExperimentalDesignTree(QuantitationTree.getCurrentTree().copyCurrentNodeForSelection(), false, false);
        this.m_expDesignPanel.add((Component)this.m_expDesignTree, "Center");
        scrollPaneExpDesign.setViewportView(this.m_expDesignPanel);
        this.m_confPanel = new JPanel();
        this.m_confPanel.setLayout(new BorderLayout());
        this.m_refinedPanel = new JPanel();
        this.m_refinedPanel.setLayout(new BorderLayout());
        this.m_lowlevelConfPanel = new JPanel();
        this.m_lowlevelConfPanel.setLayout(new BorderLayout());
        this.m_tabbedPane.add("Exp.Design", scrollPaneExpDesign);
        this.m_tabbedPane.add("Exp. Parameters", this.m_confPanel);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_tabbedPane, c);
        return internalPanel;
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public void setData(Long taskId, DDataset dataset, boolean finished) {
        this.m_dataset = dataset;
        this.updateData();
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.updateData();
    }

    private void updateData() {
        QuantExperimentalDesignTree.displayExperimentalDesign(this.m_dataset, (AbstractNode)this.m_expDesignTree.getModel().getRoot(), this.m_expDesignTree, true, true);
        try {
            if (this.m_dataset.isQuantitation() && this.m_dataset.isAggregation()) {
                this.m_confPanel.setVisible(false);
                this.m_displayQuantParam = false;
                this.m_tabbedPane.remove(this.m_confPanel);
            } else {
                if (this.m_dataset.getQuantProcessingConfig() != null) {
                    switch (this.m_quantMethodInfo) {
                        case FEATURES_EXTRACTION: {
                            Map quantCfg = this.m_dataset.getQuantProcessingConfigAsMap();
                            String cfgVersion = quantCfg.containsKey("config_version") ? quantCfg.get("config_version").toString() : "1.0";
                            LabelFreeMSParamsCompletePanel xicParamPanel = new LabelFreeMSParamsCompletePanel(true, false, cfgVersion);
                            this.m_confPanel.removeAll();
                            xicParamPanel.resetScrollbar();
                            this.m_confPanel.add((Component)xicParamPanel, "Center");
                            xicParamPanel.setQuantParams(quantCfg);
                            break;
                        }
                        case ISOBARIC_TAGGING: {
                            IsobaricMethodParamsPanel tmtParamPanel;
                            Map tmtParams = this.m_dataset.getQuantProcessingConfigAsMap();
                            if (tmtParams.containsKey("label_free_quant_config")) {
                                tmtParamPanel = new IsobaricMethodParamsPanel(this.m_dataset.getQuantitationMethod(), true);
                                this.m_confPanel.removeAll();
                                this.m_confPanel.add((Component)tmtParamPanel, "North");
                                tmtParamPanel.setQuantParams(tmtParams);
                                Map quantCfg = (Map)tmtParams.get("label_free_quant_config");
                                String cfgVersion = quantCfg.containsKey("config_version") ? quantCfg.get("config_version").toString() : "1.0";
                                LabelFreeMSParamsCompletePanel xicParamPanel = new LabelFreeMSParamsCompletePanel(true, false, cfgVersion);
                                xicParamPanel.resetScrollbar();
                                this.m_confPanel.add((Component)xicParamPanel, "Center");
                                xicParamPanel.setQuantParams(quantCfg);
                                break;
                            }
                            tmtParamPanel = new IsobaricMethodParamsPanel(this.m_dataset.getQuantitationMethod(), true);
                            this.m_confPanel.removeAll();
                            this.m_confPanel.add((Component)tmtParamPanel, "Center");
                            tmtParamPanel.setQuantParams(tmtParams);
                            break;
                        }
                        default: {
                            this.m_confPanel.removeAll();
                            this.m_confPanel.add((Component)new JLabel("no configuration available"), "Center");
                            break;
                        }
                    }
                } else {
                    this.m_confPanel.removeAll();
                    this.m_confPanel.add((Component)new JLabel("no configuration available"), "Center");
                }
                if (!this.m_displayQuantParam) {
                    this.m_displayQuantParam = true;
                    this.m_tabbedPane.add(this.m_confPanel);
                }
            }
            if (this.m_dataset.getPostQuantProcessingConfig() != null) {
                this.m_refinedPanel.removeAll();
                if (!this.m_displayPostProcessing) {
                    this.m_tabbedPane.add(TAB_POST_PROCESSING_TITLE, this.m_refinedPanel);
                    this.m_displayPostProcessing = true;
                }
                Map<Long, String> ptmName = this.getPtmSpecificityNameById();
                QuantSimplifiedPostProcessingPanel postProcessingParamPanel = new QuantSimplifiedPostProcessingPanel(true, this.m_dataset.getQuantitationMethod(), this.m_quantMethodInfo, ptmName, true);
                this.m_refinedPanel.add((Component)postProcessingParamPanel, "Center");
                postProcessingParamPanel.setRefinedParams(this.m_dataset.getPostQuantProcessingConfigAsMap());
            } else {
                if (this.m_displayPostProcessing) {
                    this.m_tabbedPane.remove(this.m_refinedPanel);
                    this.m_displayPostProcessing = false;
                }
                this.m_refinedPanel.removeAll();
            }
            if (this.m_dataset.getQuantLowLevelConfig() != null) {
                this.m_lowlevelConfPanel.removeAll();
                if (!this.m_displayLowLevel) {
                    this.m_tabbedPane.add(TAB_LOW_LEVEL_TITLE, this.m_lowlevelConfPanel);
                    this.m_displayLowLevel = true;
                }
                JScrollPane sPane = new JScrollPane();
                sPane.setHorizontalScrollBarPolicy(31);
                JTextArea area = new JTextArea(100, 20);
                Map llMap = this.m_dataset.getQuantLowLevelConfigAsMap();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String formattedString = gson.toJson((Object)llMap);
                area.setText(formattedString);
                area.setLineWrap(true);
                sPane.setViewportView(area);
                this.m_lowlevelConfPanel.add((Component)sPane, "Center");
            } else {
                if (this.m_displayLowLevel) {
                    this.m_tabbedPane.remove(this.m_lowlevelConfPanel);
                    this.m_displayLowLevel = false;
                }
                this.m_lowlevelConfPanel.removeAll();
            }
        }
        catch (Exception ex) {
            m_logger.error("error while settings quanti params " + ex);
        }
        this.m_tabbedPane.revalidate();
    }

    private Map<Long, String> getPtmSpecificityNameById() {
        ArrayList ptms = new ArrayList();
        DatabasePTMsTask task = new DatabasePTMsTask(null);
        task.initLoadUsedPTMs(Long.valueOf(this.m_dataset.getProject().getId()), this.m_dataset.getResultSummaryId(), ptms);
        task.fetchData();
        return ptms.stream().collect(Collectors.toMap(PtmSpecificity::getId, PtmSpecificity::toString));
    }
}

