/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.MapTime;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.studio.Exceptions;
import fr.proline.studio.dam.tasks.xic.MapAlignmentConverter;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.pattern.xic.DataboxMapAlignment;
import fr.proline.studio.rsmexplorer.gui.xic.AbstractMapAlignmentPanel;
import fr.proline.studio.rsmexplorer.gui.xic.LoessParametersDialog;
import fr.proline.studio.rsmexplorer.gui.xic.MapTimeTableModel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTScatterPlot;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTTableModel;
import fr.proline.studio.table.BeanTableModel;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.util.FastMath;

public class MapAlignmentPanel
extends AbstractMapAlignmentPanel {
    private List<MapAlignment> m_allMapAlignments;
    private long m_referenceMapId = 0L;
    private JComboBox m_destMapsCB;
    private JButton m_addLoessCurveBtn;
    private JButton m_removeLoessCurveBtn;

    public MapAlignmentPanel(DataboxMapAlignment dataBox) {
        super(dataBox, "time");
    }

    @Override
    protected String getTitleLabel() {
        return "<html>Reference Map: <font color='RED'>&#x25A0;&nbsp;</font>   map   &nbsp;, Alignment Mode : I/H) </html>";
    }

    @Override
    protected List<JButton> getMoreCloudButtons() {
        ArrayList<JButton> bts = new ArrayList<JButton>();
        this.m_addLoessCurveBtn = new JButton();
        this.m_addLoessCurveBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ADD_LOESS_CURVE));
        this.m_addLoessCurveBtn.setMargin(new Insets(2, 2, 2, 2));
        this.m_addLoessCurveBtn.setToolTipText("Fit a Loess smooth curve to ions scatter plot");
        this.m_addLoessCurveBtn.addActionListener(e -> this.computeLoess());
        bts.add(this.m_addLoessCurveBtn);
        this.m_removeLoessCurveBtn = new JButton();
        this.m_removeLoessCurveBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REMOVE_LOESS_CURVE));
        this.m_removeLoessCurveBtn.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeLoessCurveBtn.setToolTipText("Clear Loess fit curve ");
        this.m_removeLoessCurveBtn.addActionListener(e -> {
            ((DataboxMapAlignment)this.m_dataBox).loadCloud();
            this.m_removeLoessCurveBtn.setEnabled(false);
        });
        bts.add(this.m_removeLoessCurveBtn);
        return bts;
    }

    @Override
    protected JPanel createConvertPanel() {
        this.m_destMapsCB = new JComboBox();
        this.m_destMapsCB.addActionListener(e -> {
            this.convertTime();
            this.setDataGraphic();
        });
        this.m_destMapsCB.setName("cbDestMaps");
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new FlowLayout(0));
        timePanel.add(this.m_srcTimeValueTF);
        JLabel label0 = new JLabel("(min) in ");
        timePanel.add(label0);
        this.m_sourceMapsCB.setName("cbSourceMaps");
        timePanel.add(this.m_sourceMapsCB);
        JLabel label = new JLabel("predicted to");
        timePanel.add(label);
        this.m_destValueTF = new JTextField(10);
        this.m_destValueTF.setName("tfDestTime");
        this.m_destValueTF.setEditable(false);
        timePanel.add(this.m_destValueTF);
        JLabel label2 = new JLabel("(min) in");
        timePanel.add(label2);
        timePanel.add(this.m_destMapsCB);
        return timePanel;
    }

    @Override
    protected void setEnabledCloudButtons(boolean enable) {
        super.setEnabledCloudButtons(enable);
        this.m_addLoessCurveBtn.setEnabled(enable);
        this.m_removeLoessCurveBtn.setEnabled(false);
    }

    private void computeLoess() {
        if (this.m_isIonsCloudLoaded) {
            IonsRTTableModel cloudData2;
            long mapIdSrc = this.getSelectedMapId(this.m_sourceMapsCB);
            long mapIdDst = this.getSelectedMapId(this.m_destMapsCB);
            MapAlignment map = MapAlignmentConverter.getMapAlgn((Long)mapIdSrc, (Long)mapIdDst, this.m_allMapAlignments);
            IonsRTTableModel cloudData = this.getCloudData(mapIdSrc);
            if (cloudData == null) {
                logger.warn(" compute Loess, no Cloud data for source Map, id " + mapIdSrc);
                return;
            }
            IonsRTTableModel ionsRTTableModel = cloudData2 = map == null ? this.getCloudData(this.m_referenceMapId) : null;
            if (map == null && cloudData2 == null) {
                logger.warn(" compute Loess, Not direct MAP, but no Cloud data for reference Map, id " + this.m_referenceMapId);
                return;
            }
            double bandwidth = 0.1;
            LoessParametersDialog dialog = new LoessParametersDialog();
            dialog.getValueTF().setText(Double.toString(bandwidth));
            Point panelLocation = this.getLocationOnScreen();
            dialog.setLocation(panelLocation.x + this.getWidth() / 2, panelLocation.y + this.getHeight() / 2);
            dialog.setVisible(true);
            if (dialog.getButtonClicked() == 0) {
                bandwidth = Double.parseDouble(dialog.getValueTF().getText());
                if (map != null) {
                    this.computeAndDisplayLoessForMaps(this.getRTLandmarks(cloudData, mapIdSrc, mapIdDst), bandwidth, this.m_alignmentGraphicPanel);
                } else {
                    this.computeAndDisplayLoessForMaps(this.getRTLandmarks(cloudData, mapIdSrc, this.m_referenceMapId), bandwidth, this.m_alignmentGraphicPanel);
                    this.computeAndDisplayLoessForMaps(this.getRTLandmarks(cloudData2, this.m_referenceMapId, mapIdDst), bandwidth, this.m_alignmentGraphicPanel_2);
                }
                this.m_removeLoessCurveBtn.setEnabled(true);
            }
        }
    }

    private void computeAndDisplayLoessForMaps(List<Pair<Double, Double>> landmarks, double bandwidth, BasePlotPanel graphicalPanel) {
        if (bandwidth <= 0.0) {
            this._altComputeAndDisplayLoessForMaps(landmarks, graphicalPanel);
        } else {
            double[] x = new double[landmarks.size()];
            double[] y = new double[landmarks.size()];
            for (int i = 0; i < landmarks.size(); ++i) {
                x[i] = (Double)landmarks.get(i).getKey();
                y[i] = (Double)landmarks.get(i).getValue();
            }
            try {
                int robustness = 2;
                double accuracy = 1.0E-12;
                LoessInterpolator interpolator = new LoessInterpolator(bandwidth, robustness, accuracy);
                double[] yfit = interpolator.smooth(x, y);
                this.createRegressionPlot(this.toFilteredList(x, yfit), graphicalPanel, Color.DARK_GRAY);
                double[] residuals = new double[yfit.length];
                for (int k = 0; k < yfit.length; ++k) {
                    residuals[k] = (y[k] - yfit[k]) * (y[k] - yfit[k]);
                }
                bandwidth = Math.max(0.3, bandwidth);
                interpolator = new LoessInterpolator(bandwidth, robustness, accuracy);
                double[] sd = interpolator.smooth(x, residuals);
                double[] upper = new double[yfit.length];
                double[] lower = new double[yfit.length];
                double nsigma = 3.89;
                for (int k = 0; k < yfit.length; ++k) {
                    double s = Math.sqrt(Math.max(0.0, sd[k]));
                    upper[k] = yfit[k] + nsigma * s;
                    lower[k] = yfit[k] - nsigma * s;
                }
                this.createRegressionPlot(x, upper, graphicalPanel);
                this.createRegressionPlot(x, lower, graphicalPanel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<Pair<Double, Double>> getRTLandmarks(IonsRTTableModel cloudData, Long mapIdSrc, Long mapIdDst) {
        int sourceMapRTColumn = cloudData.getColumnIndex(mapIdSrc);
        int destMapDeltaRTColumn = cloudData.getColumnIndex(mapIdDst);
        int size = cloudData.getRowCount();
        ArrayList<Pair<Double, Double>> data = new ArrayList(size);
        double ftAlignmentTimeTolerance = ((DataboxMapAlignment)this.m_dataBox).getFeatureAlignmentTimeTolerance();
        for (int i = 0; i < size; ++i) {
            if (cloudData.isCrossAssigned(i, destMapDeltaRTColumn)) continue;
            Object value = cloudData.getDataValueAt(i, sourceMapRTColumn);
            Double rt = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
            value = cloudData.getDataValueAt(i, destMapDeltaRTColumn);
            Double deltaRT = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
            if (!(Math.abs(deltaRT) <= ftAlignmentTimeTolerance)) continue;
            data.add((Pair<Double, Double>)Pair.of((Object)rt, (Object)deltaRT));
        }
        Map<Double, Double> landmarks = data.stream().distinct().collect(Collectors.groupingBy(p -> (Double)p.getKey(), Collectors.averagingDouble(p -> (Double)p.getValue())));
        data = landmarks.entrySet().stream().map(e -> Pair.of((Object)((Double)e.getKey()), (Object)((Double)e.getValue()))).sorted().collect(Collectors.toList());
        return data;
    }

    private void _altComputeAndDisplayLoessForMaps(List<Pair<Double, Double>> landmarks, BasePlotPanel graphicalPanel) {
        double[] x = new double[landmarks.size()];
        double[] y = new double[landmarks.size()];
        for (int i = 0; i < landmarks.size(); ++i) {
            x[i] = (Double)landmarks.get(i).getKey();
            y[i] = (Double)landmarks.get(i).getValue();
        }
        double timeInterval = 300.0;
        double windowOverlap = 0.05;
        double stepSize = timeInterval * (1.0 - windowOverlap);
        int nbIter = (int)Math.ceil((x[x.length - 1] - x[0]) * 60.0 / stepSize);
        logger.info("Step size {}s, nbIter:  {}", (Object)stepSize, (Object)nbIter);
        DescriptiveStatistics stats = new DescriptiveStatistics();
        DescriptiveStatistics densityStats = new DescriptiveStatistics();
        for (int step = 0; step <= nbIter; ++step) {
            double min = (double)step * stepSize + x[0] * 60.0;
            double max = min + timeInterval;
            landmarks.stream().filter(p -> (Double)p.getKey() * 60.0 >= min && (Double)p.getKey() * 60.0 <= max).forEach(p -> stats.addValue(((Double)p.getValue()).doubleValue()));
            densityStats.addValue((double)stats.getN());
            stats.clear();
        }
        double meanSize = densityStats.getMean();
        logger.info("mean density {} from N {} values: ", (Object)meanSize, (Object)densityStats.getN());
        double bandwidth = Math.max(0.01, 40.0 / (double)x.length);
        logger.info("calculated bandwidth : " + bandwidth);
        try {
            int robustness = 2;
            double accuracy = 1.0E-12;
            LoessInterpolator interpolator = new LoessInterpolator(bandwidth, robustness, accuracy);
            double[] yfit = interpolator.smooth(x, y);
            this.createRegressionPlot(this.toFilteredList(x, yfit), graphicalPanel, Color.DARK_GRAY);
            double[] squaredResiduals = new double[yfit.length];
            double[] absResiduals = new double[yfit.length];
            double[] residuals = new double[yfit.length];
            int upperCount = 0;
            int lowerCount = 0;
            for (int k = 0; k < yfit.length; ++k) {
                squaredResiduals[k] = (y[k] - yfit[k]) * (y[k] - yfit[k]);
                absResiduals[k] = FastMath.abs((double)(y[k] - yfit[k]));
                residuals[k] = y[k] - yfit[k];
                if (residuals[k] >= 0.0) {
                    ++upperCount;
                }
                if (!(residuals[k] <= 0.0)) continue;
                ++lowerCount;
            }
            logger.info("Upper count = {}", (Object)upperCount);
            logger.info("Lower count = {}", (Object)lowerCount);
            bandwidth = Math.max(0.3, bandwidth);
            logger.info("calculated squaredResiduals bandwidth : " + bandwidth);
            interpolator = new LoessInterpolator(bandwidth, robustness, accuracy);
            double[] smoothedSquaredResiduals = interpolator.smooth(x, squaredResiduals);
            double[] smoothedAbsResiduals = interpolator.smooth(x, absResiduals);
            double[] weights = new double[squaredResiduals.length];
            for (int k = 0; k < x.length; ++k) {
                double d = weights[k] = absResiduals[k] > 5.767314 * smoothedAbsResiduals[k] ? 0.0 : 1.0;
                if (!(absResiduals[k] > 5.767314 * smoothedAbsResiduals[k])) continue;
            }
            double sum = Arrays.stream(weights).sum();
            logger.info("weights = {} / {}", (Object)sum, (Object)weights.length);
            logger.info("calculated weighted squaredResiduals bandwidth : " + bandwidth);
            interpolator = new LoessInterpolator(bandwidth, robustness, accuracy);
            double[] asd2 = interpolator.smooth(x, absResiduals, weights);
            double[] upperX = new double[upperCount];
            double[] lowerX = new double[lowerCount];
            double[] upperResiduals = new double[upperCount];
            double[] lowerResiduals = new double[lowerCount];
            double[] upperWeights = new double[upperCount];
            double[] lowerWeights = new double[lowerCount];
            upperCount = 0;
            lowerCount = 0;
            for (int k = 0; k < x.length; ++k) {
                if (residuals[k] >= 0.0) {
                    upperX[upperCount] = x[k];
                    upperWeights[upperCount] = weights[k];
                    upperResiduals[upperCount++] = residuals[k];
                }
                if (!(residuals[k] <= 0.0)) continue;
                lowerX[lowerCount] = x[k];
                lowerWeights[lowerCount] = weights[k];
                lowerResiduals[lowerCount++] = residuals[k];
            }
            bandwidth = Math.max(0.01, 40.0 / (double)x.length);
            bandwidth = Math.max(0.1, bandwidth);
            logger.info("calculated weighted squaredResiduals bandwidth : " + bandwidth);
            interpolator = new LoessInterpolator(bandwidth, robustness, accuracy);
            double[] smoothedUpperResiduals = interpolator.smooth(upperX, upperResiduals, upperWeights);
            double[] smoothedLowerResiduals = interpolator.smooth(lowerX, lowerResiduals, lowerWeights);
            PolynomialSplineFunction upperLinearFct = new LinearInterpolator().interpolate(upperX, smoothedUpperResiduals);
            PolynomialSplineFunction lowerLinearFct = new LinearInterpolator().interpolate(lowerX, smoothedLowerResiduals);
            double[] upper = new double[yfit.length];
            double[] lower = new double[yfit.length];
            double[] aUpper = new double[yfit.length];
            double[] aLower = new double[yfit.length];
            double[] a2Upper = new double[yfit.length];
            double[] a2Lower = new double[yfit.length];
            double[] a3Upper = new double[yfit.length];
            double[] a3Lower = new double[yfit.length];
            double nsigma = 3.89;
            for (int k = 0; k < yfit.length; ++k) {
                double s = Math.sqrt(Math.max(0.0, smoothedSquaredResiduals[k]));
                double as = 1.4826 * smoothedAbsResiduals[k];
                double as2 = 1.4826 * asd2[k];
                upper[k] = yfit[k] + nsigma * s;
                lower[k] = yfit[k] - nsigma * s;
                aUpper[k] = yfit[k] + nsigma * as;
                aLower[k] = yfit[k] - nsigma * as;
                a2Upper[k] = yfit[k] + nsigma * as2;
                a2Lower[k] = yfit[k] - nsigma * as2;
                if (upperLinearFct.isValidPoint(x[k])) {
                    a3Upper[k] = yfit[k] + 4.581233999999999 * upperLinearFct.value(x[k]);
                }
                if (!lowerLinearFct.isValidPoint(x[k])) continue;
                a3Lower[k] = yfit[k] + 4.581233999999999 * lowerLinearFct.value(x[k]);
            }
            this.createRegressionPlot(this.toList(x, upper), graphicalPanel, Color.DARK_GRAY);
            this.createRegressionPlot(this.toList(x, lower), graphicalPanel, Color.DARK_GRAY);
            this.createRegressionPlot(this.toList(x, aUpper), graphicalPanel, Color.ORANGE);
            this.createRegressionPlot(this.toList(x, aLower), graphicalPanel, Color.ORANGE);
            this.createRegressionPlot(this.toList(x, a2Upper), graphicalPanel, Color.MAGENTA);
            this.createRegressionPlot(this.toList(x, a2Lower), graphicalPanel, Color.MAGENTA);
            this.createRegressionPlot(this.toList(x, a3Upper), graphicalPanel, Color.BLUE);
            this.createRegressionPlot(this.toList(x, a3Lower), graphicalPanel, Color.BLUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createRegressionPlot(double[] x, double[] newDeltas, BasePlotPanel graphicPanel) {
        this.createRegressionPlot(this.toList(x, newDeltas), graphicPanel, CyclicColorPalette.GRAY_DARK);
    }

    private List<Pair<Double, Double>> toFilteredList(double[] x, double[] newDeltas) {
        ArrayList<Pair<Double, Double>> data = new ArrayList<Pair<Double, Double>>(x.length);
        data.add(Pair.of((Object)x[0], (Object)newDeltas[0]));
        double prevTime = x[0];
        double prevTimePlusDelta = x[0] + newDeltas[0] / 60.0;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > prevTime) || !(x[i] + newDeltas[i] / 60.0 > prevTimePlusDelta)) continue;
            data.add((Pair<Double, Double>)Pair.of((Object)x[i], (Object)newDeltas[i]));
            prevTime = x[i];
            prevTimePlusDelta = x[i] + newDeltas[i] / 60.0;
        }
        logger.info("Filtering effect : {} pts to {} ", (Object)x.length, (Object)data.size());
        return data;
    }

    private List<Pair<Double, Double>> toList(double[] x, double[] newDeltas) {
        ArrayList<Pair<Double, Double>> data = new ArrayList<Pair<Double, Double>>(x.length);
        for (int i = 0; i < x.length; ++i) {
            data.add((Pair<Double, Double>)Pair.of((Object)x[i], (Object)newDeltas[i]));
        }
        return data;
    }

    private void createRegressionPlot(List<Pair<Double, Double>> data, BasePlotPanel graphicPanel, Color color) {
        BeanTableModel model = new BeanTableModel(Pair.class);
        model.setData(data);
        String xAxisTitle = graphicPanel.getXAxis().getTitle();
        String yAxisTitle = graphicPanel.getYAxis().getTitle();
        PlotLinear regressionCurve = new PlotLinear(graphicPanel, (ExtendedTableModelInterface)model, null, 0, 3);
        PlotInformation plotInfo = new PlotInformation();
        plotInfo.setPlotColor(color);
        regressionCurve.setPlotInformation(plotInfo);
        regressionCurve.setStroke(1.0f);
        graphicPanel.addPlot((PlotXYAbstract)regressionCurve, true);
        graphicPanel.getXAxis().setTitle(xAxisTitle);
        graphicPanel.getYAxis().setTitle(yAxisTitle);
        graphicPanel.repaint();
    }

    @Override
    public void setData(QuantChannelInfo quantChannelInfo, List<ExtendedTableModelInterface> compareDataInterfaceList) {
        if (!this.m_isInitialized) {
            this.m_quantChannelInfo = quantChannelInfo;
            this.m_allMapAlignments = new ArrayList<MapAlignment>();
            this.m_allMapAlignments.addAll(this.m_quantChannelInfo.getDataset().getMapAlignments());
            this.m_allMapAlignments.addAll(this.m_quantChannelInfo.getDataset().getMapReversedAlignments());
            this.m_referenceMapId = this.m_quantChannelInfo.getDataset().getAlnReferenceMapId();
            String referenceMapTitle = this.m_quantChannelInfo.getMapTitle(this.m_referenceMapId);
            String referenceMapColor = this.m_quantChannelInfo.getMapHtmlColor(this.m_quantChannelInfo.getDataset().getAlnReferenceMapId());
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("Reference Map: ");
            sb.append("<font color='").append(referenceMapColor).append("'>&#x25A0;&nbsp;</font>");
            sb.append(referenceMapTitle);
            sb.append(", Alignment Mode : ");
            sb.append(this.getAlignmentMethod());
            sb.append("</html>");
            this.m_labelTitle.setText(sb.toString());
            this.m_pMapByIndex = new HashMap();
            String[] mapItems = new String[this.m_quantChannelInfo.getDataset().getMaps().size()];
            int i = 0;
            for (ProcessedMap map : this.m_quantChannelInfo.getDataset().getMaps()) {
                String mapTitle = this.m_quantChannelInfo.getMapTitle(map.getId());
                sb = new StringBuilder();
                String mapColor = this.m_quantChannelInfo.getMapHtmlColor(map.getId());
                sb.append("<html><font color='").append(mapColor).append("'>&#x25A0;&nbsp;</font>");
                sb.append(mapTitle);
                sb.append("</html>");
                mapItems[i] = sb.toString();
                this.m_pMapByIndex.put(i, map);
                ++i;
            }
            DefaultComboBoxModel<String> sourceMapsModel = new DefaultComboBoxModel<String>(mapItems);
            DefaultComboBoxModel<String> destMapsModel = new DefaultComboBoxModel<String>(mapItems);
            this.m_sourceMapsCB.setModel(sourceMapsModel);
            this.m_destMapsCB.setModel(destMapsModel);
            if (mapItems.length > 0) {
                sourceMapsModel.setSelectedItem(mapItems[0]);
            }
            if (mapItems.length > 1) {
                destMapsModel.setSelectedItem(mapItems[1]);
            }
            this.setDataGraphic();
            this.m_isInitialized = true;
            this.repaint();
        }
    }

    private String getAlignmentMethod() {
        String method = "unknown";
        try {
            Map quantParams = this.m_quantChannelInfo.getDataset().getQuantProcessingConfigAsMap();
            if (quantParams.containsKey("alignment_config")) {
                Map alignmentConfig = (Map)quantParams.get("alignment_config");
                method = alignmentConfig.getOrDefault("method_name", "unknown");
            }
            return method;
        }
        catch (Exception e) {
            return "unknown alignment method exception ";
        }
    }

    @Override
    protected Double getCorrespondingData(Double time, Long mapId) {
        Long targetMapId = this.getSelectedMapId(this.m_destMapsCB);
        logger.debug("calculate time for " + time + " from source mapId=" + mapId + " to target MapId=" + targetMapId);
        Double calcTime = Double.NaN;
        try {
            calcTime = MapAlignmentConverter.convertElutionTime((Double)(time * 60.0), (Long)mapId, (Long)targetMapId, this.m_allMapAlignments, (Long)this.m_quantChannelInfo.getDataset().getAlnReferenceMapId());
            logger.debug("...result= " + calcTime);
        }
        catch (Exception e) {
            logger.error("Error while retrieving time in map alignment: " + e);
        }
        return calcTime / 60.0;
    }

    @Override
    protected void setDataGraphic() {
        long mapIdDst;
        long mapIdSrc = this.getSelectedMapId(this.m_sourceMapsCB);
        if (mapIdSrc == (mapIdDst = this.getSelectedMapId(this.m_destMapsCB).longValue())) {
            this.m_alignmentGraphicPanel.clearPlotsWithRepaint();
            if (this.m_plotPanel2.isVisible()) {
                this.m_plotPanel2.setVisible(false);
                this.m_alignmentGraphicPanel_2.clearPlotsWithRepaint();
            }
            this.repaint();
        } else {
            MapAlignment map = MapAlignmentConverter.getMapAlgn((Long)mapIdSrc, (Long)mapIdDst, this.m_allMapAlignments);
            if (map != null) {
                this.m_plotPanel2.setVisible(false);
                this.setDataGraphicTableModel(map, true);
            } else {
                map = MapAlignmentConverter.getMapAlgn((Long)mapIdSrc, (Long)this.m_referenceMapId, this.m_allMapAlignments);
                if (map != null) {
                    this.setDataGraphicTableModel(map, true);
                    map = MapAlignmentConverter.getMapAlgn((Long)this.m_referenceMapId, (Long)mapIdDst, this.m_allMapAlignments);
                    this.setDataGraphicTableModel(map, false);
                    this.m_plotPanel2.setVisible(true);
                    this.m_splitPane.resetToPreferredSizes();
                }
            }
        }
    }

    private void setDataGraphicTableModel(MapAlignment mapAlignment, boolean toFirstPanel) {
        Long mapIdSrc = mapAlignment.getSourceMap().getId();
        Long mapIdDst = mapAlignment.getDestinationMap().getId();
        String mapTitleFrom = this.m_quantChannelInfo.getMapTitle(mapIdSrc);
        String mapTitleTo = this.m_quantChannelInfo.getMapTitle(mapIdDst);
        String title = "Map Alignment from " + mapTitleFrom + " (to. " + mapTitleTo + ")";
        Color color = this.m_quantChannelInfo.getMapColor(mapIdDst);
        double crossAssignmentTimeTolerance = ((DataboxMapAlignment)this.m_dataBox).getCrossAssignmentTimeTolerance();
        double featureAlignmentTimeTolerance = ((DataboxMapAlignment)this.m_dataBox).getFeatureAlignmentTimeTolerance();
        MapTimeTableModel extendedTableModel = new MapTimeTableModel(mapAlignment.getMapTimeList(), color, title, mapTitleFrom, mapTitleTo);
        BasePlotPanel graphicPanel = toFirstPanel ? this.m_alignmentGraphicPanel : this.m_alignmentGraphicPanel_2;
        PlotLinear alignmentCurve = new PlotLinear(graphicPanel, (ExtendedTableModelInterface)extendedTableModel, null, 0, 1);
        alignmentCurve.setPlotInformation(extendedTableModel.getPlotInformation());
        alignmentCurve.setStroke(3.0f);
        graphicPanel.setPlot((PlotBaseAbstract)alignmentCurve);
        if (this.m_isIonsCloudLoaded) {
            IonsRTTableModel cloudData;
            if (crossAssignmentTimeTolerance > 0.0) {
                List timeList = mapAlignment.getMapTimeList();
                PlotInformation plotInformation = extendedTableModel.getPlotInformation();
                plotInformation.setDashed(true);
                Map serializedPropsAsMap = null;
                try {
                    serializedPropsAsMap = mapAlignment.getSerializedPropertiesAsMap();
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                List toleranceMapTime = serializedPropsAsMap == null ? null : (List)serializedPropsAsMap.get("tolerance_time_list");
                ArrayList newToleranceMapTime = new ArrayList(timeList.size());
                ArrayList<Object> maxToleranceTimeList = new ArrayList<MapTime>(timeList.size());
                ArrayList<Object> minToleranceTimeList = new ArrayList<MapTime>(timeList.size());
                for (int i = 0; i < timeList.size(); ++i) {
                    MapTime mt = (MapTime)timeList.get(i);
                    double delta = toleranceMapTime != null ? (Double)toleranceMapTime.get(i) : crossAssignmentTimeTolerance;
                    maxToleranceTimeList.add(new MapTime(mt.getTime(), Double.valueOf(mt.getDeltaValue() + delta)));
                    minToleranceTimeList.add(new MapTime(mt.getTime(), Double.valueOf(mt.getDeltaValue() - delta)));
                }
                PlotLinear maxDeltaRtCurve = this.getPlotLinear(graphicPanel, mapTitleFrom, mapTitleTo, title, color, plotInformation, maxToleranceTimeList);
                graphicPanel.addPlot((PlotXYAbstract)maxDeltaRtCurve);
                PlotLinear minDeltaRtCurve = this.getPlotLinear(graphicPanel, mapTitleFrom, mapTitleTo, title, color, plotInformation, minToleranceTimeList);
                graphicPanel.addPlot((PlotXYAbstract)minDeltaRtCurve);
                plotInformation = extendedTableModel.getPlotInformation();
                plotInformation.setDashed(false);
                maxToleranceTimeList = new ArrayList(timeList.size());
                minToleranceTimeList = new ArrayList(timeList.size());
                for (int i = 0; i < timeList.size(); ++i) {
                    MapTime mt = (MapTime)timeList.get(i);
                    maxToleranceTimeList.add(new MapTime(mt.getTime(), Double.valueOf(mt.getDeltaValue() + crossAssignmentTimeTolerance)));
                    minToleranceTimeList.add(new MapTime(mt.getTime(), Double.valueOf(mt.getDeltaValue() - crossAssignmentTimeTolerance)));
                }
                maxDeltaRtCurve = this.getPlotLinear(graphicPanel, mapTitleFrom, mapTitleTo, title, color, plotInformation, maxToleranceTimeList);
                graphicPanel.addPlot((PlotXYAbstract)maxDeltaRtCurve);
                minDeltaRtCurve = this.getPlotLinear(graphicPanel, mapTitleFrom, mapTitleTo, title, color, plotInformation, minToleranceTimeList);
                graphicPanel.addPlot((PlotXYAbstract)minDeltaRtCurve);
            }
            if ((cloudData = this.getCloudData(mapIdSrc)) != null) {
                int axisX = cloudData.getColumnIndex(mapIdSrc);
                int axisY = cloudData.getColumnIndex(mapIdDst);
                this.m_removeLoessCurveBtn.setEnabled(false);
                IonsRTScatterPlot ionsScatterPlot = new IonsRTScatterPlot(graphicPanel, cloudData, null, axisX, axisY);
                ionsScatterPlot.showCrossAssignedIons(this.m_showHideCrossAssigned.getActionCommand().equals("HIDE"));
                ionsScatterPlot.setColor(color);
                ionsScatterPlot.setFeatureAlignmentTimeTolerance(featureAlignmentTimeTolerance);
                if (this.m_zoomMode == 0) {
                    double yMax = alignmentCurve.getYMax();
                    double yMin = alignmentCurve.getYMin();
                    ionsScatterPlot.setYMax(yMax + 2.0 * crossAssignmentTimeTolerance);
                    ionsScatterPlot.setYMin(yMin - 2.0 * crossAssignmentTimeTolerance);
                }
                if (toFirstPanel) {
                    this.m_ionsScatterPlot = ionsScatterPlot;
                } else {
                    this.m_ionsScatterPlot2 = ionsScatterPlot;
                }
                graphicPanel.addPlot((PlotXYAbstract)ionsScatterPlot);
            }
        }
        graphicPanel.repaint();
    }

    private PlotLinear getPlotLinear(BasePlotPanel graphicPanel, String mapTitleFrom, String mapTitleTo, String title, Color color, PlotInformation plotInformation, List<MapTime> minDeltaRt) {
        MapTimeTableModel minExtendedTableModel = new MapTimeTableModel(minDeltaRt, color, title, mapTitleFrom, mapTitleTo);
        PlotLinear minDeltaRtCurve = new PlotLinear(graphicPanel, (ExtendedTableModelInterface)minExtendedTableModel, null, 0, 1);
        minDeltaRtCurve.setPlotInformation(plotInformation);
        return minDeltaRtCurve;
    }
}

