/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QuantChannelInfo {
    private DQuantitationChannel[] m_quantChannels = null;
    private DDataset m_dataset = null;
    private Map<Long, DQuantitationChannel> m_quantChannelsById;

    public QuantChannelInfo(DDataset dataset) {
        this.m_dataset = dataset;
        List listQuantChannel = new ArrayList();
        if (this.m_dataset.getMasterQuantitationChannels() != null && !this.m_dataset.getMasterQuantitationChannels().isEmpty()) {
            DMasterQuantitationChannel masterChannel = (DMasterQuantitationChannel)this.m_dataset.getMasterQuantitationChannels().get(0);
            listQuantChannel = masterChannel.getQuantitationChannels();
        }
        this.m_quantChannels = new DQuantitationChannel[listQuantChannel.size()];
        listQuantChannel.toArray(this.m_quantChannels);
        this.m_quantChannelsById = listQuantChannel.stream().collect(Collectors.toMap(qc -> qc.getId(), qc -> qc));
    }

    public QuantChannelInfo(List<DQuantitationChannel> listQuantChannel) {
        this.m_quantChannels = new DQuantitationChannel[listQuantChannel.size()];
        listQuantChannel.toArray(this.m_quantChannels);
        this.m_quantChannelsById = listQuantChannel.stream().collect(Collectors.toMap(qc -> qc.getId(), qc -> qc));
    }

    public DQuantitationChannel getQuantChannels(Long id) {
        return this.m_quantChannelsById.get(id);
    }

    public DQuantitationChannel[] getQuantChannels() {
        return this.m_quantChannels;
    }

    public Color getQuantChannelColor(Long id) {
        return CyclicColorPalette.getColor((int)(this.getQuantChannels(id).getNumber() - 1));
    }

    public void setQuantChannels(DQuantitationChannel[] quantChannels) {
        this.m_quantChannels = quantChannels;
    }

    public String getRsmHtmlColor(int quantChIndex) {
        return CyclicColorPalette.getHTMLColor((int)quantChIndex);
    }

    private int getMapPaletteIndex(Long mapId) {
        for (int i = 0; i < this.m_quantChannels.length; ++i) {
            if (!this.compareMap(this.m_quantChannels[i], mapId)) continue;
            return i;
        }
        return this.m_quantChannels.length;
    }

    public Color getMapColor(Long mapId) {
        return CyclicColorPalette.getColor((int)this.getMapPaletteIndex(mapId));
    }

    public String getMapHtmlColor(Long mapId) {
        for (int i = 0; i < this.m_quantChannels.length; ++i) {
            if (!this.compareMap(this.m_quantChannels[i], mapId)) continue;
            return CyclicColorPalette.getHTMLColor((int)i);
        }
        return CyclicColorPalette.getHTMLColor((int)this.m_quantChannels.length);
    }

    public String getMapTitle(Long mapId) {
        for (DQuantitationChannel m_quantChannel : this.m_quantChannels) {
            if (!this.compareMap(m_quantChannel, mapId)) continue;
            return m_quantChannel.getName();
        }
        return null;
    }

    public DQuantitationChannel getQuantChannelForMap(long mapId) {
        for (DQuantitationChannel quantChannel : this.m_quantChannels) {
            if (!this.compareMap(quantChannel, mapId)) continue;
            return quantChannel;
        }
        return null;
    }

    public DDataset getDataset() {
        return this.m_dataset;
    }

    private boolean compareMap(DQuantitationChannel m_quantChannel, Long mapId) {
        Long lcmsRawMapId = m_quantChannel.getLcmsRawMapId();
        Long lcmsMapId = m_quantChannel.getLcmsMapId();
        if (lcmsRawMapId != null && lcmsRawMapId.equals(mapId)) {
            return true;
        }
        return lcmsMapId != null && lcmsMapId.equals(mapId);
    }
}

