/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.corewrapper.util.PeptideClassesUtils;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.MsQueryRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class QuantChannelPeptideMatchTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEPTIDE_ID = 0;
    public static final int COLTYPE_PEPTIDE_QC_NAME = 1;
    public static final int COLTYPE_PEPTIDE_NAME = 2;
    public static final int COLTYPE_PEPTIDE_SCORE = 3;
    public static final int COLTYPE_PEPTIDE_MSQUERY = 4;
    public static final int COLTYPE_PEPTIDE_RANK = 5;
    public static final int COLTYPE_PEPTIDE_CALCULATED_MASS = 6;
    public static final int COLTYPE_PEPTIDE_EXPERIMENTAL_MOZ = 7;
    public static final int COLTYPE_PEPTIDE_PPM = 8;
    public static final int COLTYPE_PEPTIDE_CHARGE = 9;
    public static final int COLTYPE_PEPTIDE_MISSED_CLIVAGE = 10;
    public static final int COLTYPE_PEPTIDE_RETENTION_TIME = 11;
    public static final int COLTYPE_PEPTIDE_ION_PARENT_INTENSITY = 12;
    public static final int COLTYPE_PEPTIDE_PTM = 13;
    private static final String[] m_columnNames = new String[]{"Id", "Quant. channel", "Peptide", "Score", "MsQuery", "Rank", "Calc. Mass", "Exp. m/z", "Ppm", "Charge", "Missed Cl.", "RT", "Ion Parent Int.", "PTMs"};
    private static final String[] m_toolTipColumns = new String[]{"PSM Id", "Quantitation channel", "Peptide", "Score", "MsQuery", "Rank", "Calculated Mass", "Experimental Mass to Charge Ratio", "parts-per-million", "Charge", "Missed Clivage", "Retention Time (min)", "Ion Parent Intensity", "Post Translational Modifications"};
    private DQuantitationChannel[] m_quantitationChannelArray = null;
    private Map<Long, List<Long>> m_peptideMatchListPerQC;
    private List<DPeptideMatch> m_peptideMatchList;
    private QuantChannelInfo m_quantChannelInfo;
    private ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private String m_modelName;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public QuantChannelPeptideMatchTableModel(LazyTable table) {
        super(table);
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    public String getExportColumnName(int col) {
        return m_columnNames[col];
    }

    public String getToolTipForHeader(int col) {
        return m_toolTipColumns[col];
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Long.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    public int getRowCount() {
        if (this.m_peptideMatchList == null) {
            return 0;
        }
        return this.m_peptideMatchList.size();
    }

    public Object getValueAt(int row, int col) {
        LazyData lazyData = this.getLazyData(row, col);
        DPeptideMatch peptideMatch = this.m_peptideMatchList.get(row);
        if (peptideMatch == null) {
            this.givePriorityTo(this.m_taskId, row, 10);
            lazyData.setData(null);
            return lazyData;
        }
        switch (col) {
            case 0: {
                return peptideMatch.getId();
            }
            case 1: {
                int idQc = this.getPeptideMatchQuantChannel(peptideMatch.getId());
                if (idQc != -1) {
                    StringBuilder sb = new StringBuilder();
                    String rsmHtmlColor = this.m_quantChannelInfo.getRsmHtmlColor(idQc);
                    sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
                    sb.append(this.m_quantitationChannelArray[idQc].getName());
                    sb.append("</html>");
                    lazyData.setData((Comparable)((Object)sb.toString()));
                    return lazyData;
                }
                lazyData.setData((Comparable)((Object)""));
                return lazyData;
            }
            case 2: {
                lazyData.setData((Comparable)peptideMatch);
                return lazyData;
            }
            case 3: {
                Float score = peptideMatch.getScore();
                lazyData.setData((Comparable)score);
                return lazyData;
            }
            case 4: {
                if (!peptideMatch.isMsQuerySet()) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    DMsQuery msQuery = peptideMatch.getMsQuery();
                    lazyData.setData((Comparable)msQuery);
                }
                return lazyData;
            }
            case 5: {
                lazyData.setData((Comparable)peptideMatch.getCDPrettyRank());
                return lazyData;
            }
            case 9: {
                lazyData.setData((Comparable)Integer.valueOf(peptideMatch.getCharge()));
                return lazyData;
            }
            case 7: {
                BigDecimal bd = new BigDecimal(peptideMatch.getExperimentalMoz());
                Float expMoz = Float.valueOf(bd.setScale(4, RoundingMode.HALF_UP).floatValue());
                lazyData.setData((Comparable)expMoz);
                return lazyData;
            }
            case 8: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                    return lazyData;
                }
                float ppm = PeptideClassesUtils.getPPMFor((DPeptideMatch)peptideMatch, (Peptide)peptide).floatValue();
                lazyData.setData((Comparable)Float.valueOf(ppm));
                return lazyData;
            }
            case 6: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                } else {
                    BigDecimal bd = new BigDecimal(peptide.getCalculatedMass());
                    Float calculatedMass = Float.valueOf(bd.setScale(4, RoundingMode.HALF_UP).floatValue());
                    lazyData.setData((Comparable)calculatedMass);
                }
                return lazyData;
            }
            case 10: {
                lazyData.setData((Comparable)Integer.valueOf(peptideMatch.getMissedCleavage()));
                return lazyData;
            }
            case 11: {
                lazyData.setData((Comparable)peptideMatch.getRetentionTime());
                return lazyData;
            }
            case 12: {
                if (!peptideMatch.isMsQuerySet()) {
                    this.givePriorityTo(this.m_taskId, row, 4);
                    lazyData.setData(null);
                } else {
                    DMsQuery msQuery = peptideMatch.getMsQuery();
                    Float precursorIntenstity = msQuery.getPrecursorIntensity();
                    if (precursorIntenstity == null) {
                        lazyData.setData((Comparable)Float.valueOf(Float.NaN));
                    } else {
                        lazyData.setData((Comparable)precursorIntenstity);
                    }
                }
                return lazyData;
            }
            case 13: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                    return lazyData;
                }
                boolean ptmStringLoadeed = peptide.getTransientData().isPeptideReadablePtmStringLoaded();
                if (!ptmStringLoadeed) {
                    this.givePriorityTo(this.m_taskId, row, col);
                    lazyData.setData(null);
                    return lazyData;
                }
                String ptm = "";
                PeptideReadablePtmString ptmString = peptide.getTransientData().getPeptideReadablePtmString();
                if (ptmString != null) {
                    ptm = ptmString.getReadablePtmString();
                }
                lazyData.setData((Comparable)((Object)ptm));
                return lazyData;
            }
        }
        return null;
    }

    public void setData(Long taskId, DQuantitationChannel[] quantChannelArray, QuantChannelInfo quantChannelInfo, List<DPeptideMatch> peptideMatchList, Map<Long, List<Long>> peptideMatchIdListPerQC) {
        this.m_quantChannelInfo = quantChannelInfo;
        this.m_quantitationChannelArray = quantChannelArray;
        this.m_peptideMatchListPerQC = peptideMatchIdListPerQC;
        this.m_peptideMatchList = peptideMatchList;
        this.m_taskId = taskId;
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public DPeptideMatch getPSM(int i) {
        return this.m_peptideMatchList.get(i);
    }

    public int findRow(long psmId) {
        int nb = this.m_peptideMatchList.size();
        for (int i = 0; i < nb; ++i) {
            if (psmId != this.m_peptideMatchList.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> psmIds, CompoundTableModel compoundTableModel) {
        if (this.m_peptideMatchListPerQC == null) {
            return;
        }
        HashSet<Long> psmIdMap = new HashSet<Long>(psmIds.size());
        psmIdMap.addAll(psmIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            DPeptideMatch f;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!psmIdMap.contains((f = this.getPSM(iModel)).getId())) continue;
            psmIds.set(iCur++, f.getId());
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        int colIdx = 0;
        filtersMap.put(++colIdx, (Filter)new StringDiffFilter(this.getColumnName(colIdx), null, colIdx));
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DPeptideMatch)o).getPeptide().getSequence();
            }
        };
        filtersMap.put(++colIdx, (Filter)new StringDiffFilter(this.getColumnName(colIdx), peptideConverter, colIdx));
        filtersMap.put(++colIdx, (Filter)new DoubleFilter(this.getColumnName(colIdx), null, colIdx));
        ConvertValueInterface msQueryConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DMsQuery)o).getInitialId();
            }
        };
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), msQueryConverter, colIdx));
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new DoubleFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new DoubleFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new DoubleFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new IntegerFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new DoubleFilter(this.getColumnName(colIdx), null, colIdx));
        filtersMap.put(++colIdx, (Filter)new StringDiffFilter(this.getColumnName(colIdx), null, colIdx));
        ++colIdx;
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: 
            case 2: 
            case 13: {
                return String.class;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                return Float.class;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                return Integer.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        if (data instanceof DPeptideMatch) {
            data = ((DPeptideMatch)data).getPeptide().getSequence();
        } else if (data instanceof DMsQuery) {
            data = ((DMsQuery)data).getInitialId();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{2, 0};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public PlotType getBestPlotType() {
        return PlotType.HISTOGRAM_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case HISTOGRAM_PLOT: {
                int[] cols = new int[]{8, -1};
                return cols;
            }
            case SCATTER_PLOT: {
                int[] cols = new int[]{6, 3};
                return cols;
            }
        }
        return null;
    }

    public int getInfoColumn() {
        return 2;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public String getTootlTipValue(int row, int col) {
        return "";
    }

    private int getPeptideMatchQuantChannel(Long peptideMatchId) {
        int nbQC = this.m_quantitationChannelArray.length;
        for (Map.Entry<Long, List<Long>> entrySet : this.m_peptideMatchListPerQC.entrySet()) {
            long qcId = entrySet.getKey();
            List<Long> psmIds = entrySet.getValue();
            int id = psmIds.indexOf(peptideMatchId);
            if (id <= -1) continue;
            for (int q = 0; q < nbQC; ++q) {
                if (this.m_quantitationChannelArray[q].getId() != qcId) continue;
                return q;
            }
            return -1;
        }
        return -1;
    }

    public String getExportRowCell(int row, int col) {
        int rowFiltered = row;
        DPeptideMatch peptideMatch = this.m_peptideMatchList.get(rowFiltered);
        switch (col) {
            case 0: {
                return Long.toString(peptideMatch.getId());
            }
            case 1: {
                int idQc = this.getPeptideMatchQuantChannel(peptideMatch.getId());
                if (idQc != -1) {
                    return this.m_quantitationChannelArray[idQc].getName();
                }
                return "";
            }
            case 2: {
                return peptideMatch.getPeptide().getSequence();
            }
            case 3: {
                return Float.toString(peptideMatch.getScore().floatValue());
            }
            case 4: {
                if (!peptideMatch.isMsQuerySet()) {
                    return "";
                }
                DMsQuery msQuery = peptideMatch.getMsQuery();
                return Integer.toString(msQuery.getInitialId());
            }
            case 5: {
                return Integer.toString(peptideMatch.getCDPrettyRank());
            }
            case 9: {
                return Integer.toString(peptideMatch.getCharge());
            }
            case 7: {
                return Double.toString(peptideMatch.getExperimentalMoz());
            }
            case 8: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    return "";
                }
                float ppm = PeptideClassesUtils.getPPMFor((DPeptideMatch)peptideMatch, (Peptide)peptide).floatValue();
                return Float.toString(ppm);
            }
            case 6: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    return "";
                }
                return Double.toString(peptide.getCalculatedMass());
            }
            case 10: {
                return Integer.toString(peptideMatch.getMissedCleavage());
            }
            case 11: {
                return Float.toString(peptideMatch.getRetentionTime().floatValue());
            }
            case 12: {
                if (!peptideMatch.isMsQuerySet()) {
                    return "";
                }
                DMsQuery msQuery = peptideMatch.getMsQuery();
                Float precursorIntenstity = msQuery.getPrecursorIntensity();
                if (precursorIntenstity == null) {
                    return "";
                }
                return Float.toString(precursorIntenstity.floatValue());
            }
            case 13: {
                Peptide peptide = peptideMatch.getPeptide();
                if (peptide == null) {
                    return "";
                }
                boolean ptmStringLoadeed = peptide.getTransientData().isPeptideReadablePtmStringLoaded();
                if (!ptmStringLoadeed) {
                    return "";
                }
                String ptm = "";
                PeptideReadablePtmString ptmString = peptide.getTransientData().getPeptideReadablePtmString();
                if (ptmString != null) {
                    ptm = ptmString.getReadablePtmString();
                }
                return ptm;
            }
        }
        return "";
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (col) {
            case 2: {
                renderer = new PeptideRenderer();
                break;
            }
            case 1: 
            case 13: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
                break;
            }
            case 3: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 8: 
            case 12: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4));
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 4: {
                renderer = new MsQueryRenderer();
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DPeptideMatch.class, true));
        list.add(new ExtraDataType(QuantChannelInfo.class, false));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        if (c.equals(QuantChannelInfo.class)) {
            return this.m_quantChannelInfo;
        }
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DPeptideMatch.class)) {
            return this.m_peptideMatchList.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

