/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.MasterQuantComponent;
import fr.proline.core.orm.msi.MasterQuantReporterIon;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DQuantReporterIon;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.dam.data.SelectLevelEnum;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.XicStatusRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.types.QuantitationType;
import fr.proline.studio.types.XicGroup;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantPepMatchReporterIonTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    private static final Logger m_logger = LoggerFactory.getLogger(QuantPepMatchReporterIonTableModel.class);
    public static final int COLTYPE_PEPTIDE_MATCH_ID = 0;
    public static final int COLTYPE_PEPTIDE_MATCH_REP_ION_ID = 1;
    public static final int COLTYPE_PEPTIDE_SEQUENCE = 2;
    public static final int COLTYPE_PEPTIDE_MATCH_REP_ION_STATUS = 3;
    public static final int COLTYPE_PEPTIDE_PTM = 4;
    public static final int COLTYPE_PEPTIDE_SCORE = 5;
    public static final int COLTYPE_PEPTIDE_MATCH_CHARGE = 6;
    public static final int COLTYPE_PEPTIDE_MATCH_MOZ = 7;
    public static final int COLTYPE_PEPTIDE_MATCH_RETENTION_TIME = 8;
    public static final int COLTYPE_PEPTIDE_MATCH_PIF = 9;
    public static final int LAST_STATIC_COLUMN = 9;
    private static final String[] m_columnNames = new String[]{"Pep. Match Id", "PSM Rep. Ion Id", "Peptide Sequence", "Status", "PTMs", "Score", "Charge", "m/z", "RT", "PIF"};
    private static final String[] m_columnNamesForFilter = new String[]{"Peptide Match Id", "Pep. Match Reporter Ion id", "Peptide Sequence", "Pep. Match status", "PTMs", "Score", "Charge", "m/z", "RT", "PIF"};
    private static final String[] m_toolTipColumns = new String[]{"Peptide Match Id", "Master Quant Reporter Ion Id", "Identified Peptide Sequence", "Pep. Match status: invalid, valid", "Post Translational Modifications", "Score", "Charge", "Mass to Charge Ratio", "Retention time (min)", "Precursor Ion Fraction "};
    public static final int COLTYPE_RAW_ABUNDANCE = 0;
    public static final int COLTYPE_ABUNDANCE = 1;
    private static final String[] m_columnNamesQC = new String[]{"Raw abundance", "Abundance"};
    private static final String[] m_toolTipQC = new String[]{"Raw abundance", "Abundance"};
    private List<MasterQuantReporterIon> m_quantPSMReporterIons = null;
    private DQuantitationChannel[] m_quantChannels = null;
    private int m_quantChannelNumber;
    private final ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private String m_modelName;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public QuantPepMatchReporterIonTableModel(LazyTable table) {
        super(table);
    }

    public int getColumnCount() {
        if (this.m_quantChannels == null) {
            return m_columnNames.length;
        }
        return m_columnNames.length + this.m_quantChannelNumber * m_columnNamesQC.length;
    }

    public String getColumnName(int col) {
        if (col <= 9) {
            return m_columnNames[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            StringBuilder sb = new StringBuilder();
            String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
            sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
            sb.append(m_columnNamesQC[id]);
            sb.append("<br/>");
            sb.append(this.m_quantChannels[nbQc].getName());
            sb.append("</html>");
            return sb.toString();
        }
        return "";
    }

    public String getExportColumnName(int col) {
        if (col <= 9) {
            return m_columnNamesForFilter[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            return m_columnNamesQC[id] + " " + this.m_quantChannels[nbQc].getName();
        }
        return "";
    }

    public String getColumnNameForFilter(int col) {
        if (col <= 9) {
            return m_columnNamesForFilter[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            return m_columnNamesQC[id];
        }
        return "";
    }

    public String getToolTipForHeader(int col) {
        if (col <= 9) {
            return m_toolTipColumns[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            String rawFilePath = StringUtils.truncate((String)this.m_quantChannels[nbQc].getRawFilePath(), (int)50);
            StringBuilder sb = new StringBuilder();
            String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
            sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
            sb.append(m_toolTipQC[id]);
            sb.append("<br/>");
            sb.append(this.m_quantChannels[nbQc].getFullName());
            sb.append("<br/>");
            sb.append(rawFilePath);
            sb.append("</html>");
            return sb.toString();
        }
        return "";
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        if (col == 1) {
            return Long.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return 0;
    }

    public int getRowCount() {
        if (this.m_quantPSMReporterIons == null) {
            return 0;
        }
        return this.m_quantPSMReporterIons.size();
    }

    public Object getValueAt(int row, int col) {
        MasterQuantReporterIon psmReporterIon = this.m_quantPSMReporterIons.get(row);
        DMasterQuantPeptideIon peptideIon = psmReporterIon.getTransientData().getDMasterQuantPeptideIon();
        switch (col) {
            case 1: {
                return psmReporterIon.getId();
            }
            case 9: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideMatch peptideMatch = psmReporterIon.getTransientData().getPeptideMatch();
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    Map vals = peptideMatch.getPropertiesAsMap();
                    if (vals != null && !vals.isEmpty() && vals.containsKey("precursor_intensity_fraction")) {
                        String pifStringVal = vals.get("precursor_intensity_fraction").toString();
                        try {
                            Float pifVal = Float.valueOf(pifStringVal);
                            lazyData.setData((Comparable)pifVal);
                        }
                        catch (NumberFormatException nfe) {
                            m_logger.error("Unable to get Float value for PIF " + pifStringVal + " set to NaN");
                            lazyData.setData((Comparable)Float.valueOf(Float.NaN));
                        }
                    } else {
                        lazyData.setData((Comparable)Float.valueOf(Float.NaN));
                    }
                }
                return lazyData;
            }
            case 0: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideMatch peptideMatch = psmReporterIon.getTransientData().getPeptideMatch();
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Long.valueOf(peptideMatch.getId()));
                }
                return lazyData;
            }
            case 2: {
                LazyData lazyData = this.getLazyData(row, col);
                if (psmReporterIon.getResultSummary() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (peptideIon == null || peptideIon.getPeptideInstance() == null) {
                    lazyData.setData(null);
                } else {
                    lazyData.setData((Comparable)peptideIon.getPeptideInstance().getPeptide());
                }
                return lazyData;
            }
            case 4: {
                LazyData lazyData = this.getLazyData(row, col);
                if (psmReporterIon.getResultSummary() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (peptideIon == null || peptideIon.getPeptideInstance() == null) {
                    lazyData.setData((Comparable)((Object)""));
                } else if (peptideIon.getPeptideInstance().getPeptide() != null) {
                    if (!peptideIon.getPeptideInstance().getPeptide().getTransientData().isPeptideReadablePtmStringLoaded()) {
                        lazyData.setData(null);
                    } else {
                        String ptm = "";
                        PeptideReadablePtmString ptmString = peptideIon.getPeptideInstance().getPeptide().getTransientData().getPeptideReadablePtmString();
                        if (ptmString != null) {
                            ptm = ptmString.getReadablePtmString();
                        }
                        lazyData.setData((Comparable)((Object)ptm));
                    }
                } else {
                    lazyData.setData((Comparable)((Object)""));
                }
                return lazyData;
            }
            case 5: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideMatch peptideMatch = psmReporterIon.getTransientData().getPeptideMatch();
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)peptideMatch.getScore());
                }
                return lazyData;
            }
            case 6: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideMatch peptideMatch = psmReporterIon.getTransientData().getPeptideMatch();
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Integer.valueOf(peptideMatch.getCharge()));
                }
                return lazyData;
            }
            case 7: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideMatch peptideMatch = psmReporterIon.getTransientData().getPeptideMatch();
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Double.valueOf(peptideMatch.getExperimentalMoz()));
                }
                return lazyData;
            }
            case 8: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideMatch peptideMatch = psmReporterIon.getTransientData().getPeptideMatch();
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)psmReporterIon.getTransientData().getPeptideMatch().getRetentionTime());
                }
                return lazyData;
            }
            case 3: {
                LazyData lazyData = this.getLazyData(row, col);
                MasterQuantComponent mqc = psmReporterIon.getMasterQuantComponent();
                if (mqc == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    SelectLevelEnum selectionLevel = SelectLevelEnum.valueOf((int)psmReporterIon.getMasterQuantComponent().getSelectionLevel());
                    lazyData.setData((Comparable)new XicStatusRenderer.SelectLevel(selectionLevel, selectionLevel));
                }
                return lazyData;
            }
        }
        LazyData lazyData = this.getLazyData(row, col);
        if (psmReporterIon.getResultSummary() == null) {
            lazyData.setData(null);
            this.givePriorityTo(this.m_taskId, row, col);
        } else {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            Map quantReporterIonByQchIds = psmReporterIon.getTransientData().getQuantReporterIonByQchIds();
            if (quantReporterIonByQchIds == null) {
                switch (id) {
                    case 0: 
                    case 1: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                    }
                }
            } else {
                DQuantReporterIon quantRepIon = (DQuantReporterIon)quantReporterIonByQchIds.get(this.m_quantChannels[nbQc].getId());
                if (quantRepIon == null) {
                    switch (id) {
                        case 0: 
                        case 1: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                        }
                    }
                } else {
                    switch (id) {
                        case 1: {
                            lazyData.setData((Comparable)(quantRepIon.getAbundance().isNaN() ? Float.valueOf(0.0f) : quantRepIon.getAbundance()));
                            break;
                        }
                        case 0: {
                            lazyData.setData((Comparable)(quantRepIon.getRawAbundance().isNaN() ? Float.valueOf(0.0f) : quantRepIon.getRawAbundance()));
                        }
                    }
                }
            }
        }
        return lazyData;
    }

    public void setData(Long taskId, DQuantitationChannel[] quantChannels, List<MasterQuantReporterIon> peptideReporterIons) {
        boolean structureChanged = true;
        if (this.m_quantChannels != null && this.m_quantChannels.length == quantChannels.length) {
            for (int i = 0; i < this.m_quantChannels.length; ++i) {
                structureChanged = !this.m_quantChannels[i].equals((Object)quantChannels[i]);
            }
        }
        this.m_quantPSMReporterIons = peptideReporterIons;
        this.m_quantChannels = quantChannels;
        this.m_quantChannelNumber = quantChannels.length;
        if (structureChanged) {
            this.fireTableStructureChanged();
        }
        this.m_taskId = taskId;
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public MasterQuantReporterIon getPeptideMatchRepIon(int i) {
        return this.m_quantPSMReporterIons.get(i);
    }

    public int findRow(long peptideRepIonId) {
        int nb = this.m_quantPSMReporterIons.size();
        for (int i = 0; i < nb; ++i) {
            if (peptideRepIonId != this.m_quantPSMReporterIons.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        ConvertValueInterface peptideConverter = o -> {
            if (o == null) {
                return null;
            }
            return ((Peptide)o).getSequence();
        };
        filtersMap.put(9, (Filter)new DoubleFilter(this.getColumnNameForFilter(9), null, 9));
        filtersMap.put(2, (Filter)new StringDiffFilter(this.getColumnNameForFilter(2), peptideConverter, 2));
        filtersMap.put(4, (Filter)new StringDiffFilter(this.getColumnName(4), null, 4));
        filtersMap.put(5, (Filter)new DoubleFilter(this.getColumnName(5), null, 5));
        filtersMap.put(6, (Filter)new IntegerFilter(this.getColumnNameForFilter(6), null, 6));
        filtersMap.put(7, (Filter)new DoubleFilter(this.getColumnNameForFilter(7), null, 7));
        ConvertValueInterface minuteConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return (double)((Float)o).floatValue() / 60.0;
            }
        };
        filtersMap.put(8, (Filter)new DoubleFilter(this.getColumnNameForFilter(8), minuteConverter, 8));
        int nbCol = this.getColumnCount();
        for (int i = 10; i < nbCol; ++i) {
            int nbQc = (i - m_columnNames.length) / m_columnNamesQC.length;
            int id = i - m_columnNames.length - nbQc * m_columnNamesQC.length;
            switch (id) {
                case 0: 
                case 1: {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                }
            }
        }
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public Long getResultSummaryId() {
        if (this.m_quantPSMReporterIons == null || this.m_quantPSMReporterIons.size() == 0) {
            return null;
        }
        return this.m_quantPSMReporterIons.get(0).getResultSummary().getId();
    }

    public List<Integer> getDefaultColumnsToHide() {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        listIds.add(0);
        listIds.add(1);
        listIds.add(9);
        if (this.m_quantChannels != null) {
            for (int i = this.m_quantChannels.length - 1; i >= 0; --i) {
                listIds.add(m_columnNames.length + 0 + i * m_columnNamesQC.length);
            }
        }
        return listIds;
    }

    public String getExportRowCell(int row, int col) {
        MasterQuantReporterIon peptideMatchReportertIon = this.m_quantPSMReporterIons.get(row);
        DMasterQuantPeptideIon peptideIon = peptideMatchReportertIon.getTransientData().getDMasterQuantPeptideIon();
        switch (col) {
            case 1: {
                return String.valueOf(peptideMatchReportertIon.getId());
            }
            case 0: {
                if (peptideIon == null) {
                    return "";
                }
                if (peptideIon.getPeptideInstance() == null) {
                    return "";
                }
                return String.valueOf(peptideIon.getPeptideInstance().getPeptideId());
            }
            case 2: {
                if (peptideIon == null) {
                    return "";
                }
                if (peptideIon.getPeptideInstance() == null) {
                    return "";
                }
                return peptideIon.getPeptideInstance().getPeptide().getSequence();
            }
            case 4: {
                DPeptideInstance peptideInstance = peptideIon.getPeptideInstance();
                if (peptideInstance == null) {
                    return "";
                }
                if (peptideInstance.getPeptide() != null) {
                    boolean ptmStringLoadeed = peptideInstance.getPeptide().getTransientData().isPeptideReadablePtmStringLoaded();
                    if (!ptmStringLoadeed) {
                        return null;
                    }
                    String ptm = "";
                    PeptideReadablePtmString ptmString = peptideInstance.getPeptide().getTransientData().getPeptideReadablePtmString();
                    if (ptmString != null) {
                        ptm = ptmString.getReadablePtmString();
                    }
                    return ptm;
                }
                return "";
            }
            case 5: {
                DPeptideMatch peptideMatch = peptideMatchReportertIon.getTransientData().getPeptideMatch();
                if (peptideMatch == null) {
                    return "";
                }
                float score = peptideMatch.getScore().floatValue();
                return String.valueOf(score);
            }
            case 6: {
                if (peptideIon == null) {
                    return "";
                }
                return String.valueOf(peptideIon.getCharge());
            }
            case 7: {
                if (peptideMatchReportertIon.getTransientData().getPeptideMatch() == null) {
                    return "";
                }
                return String.valueOf(peptideMatchReportertIon.getTransientData().getPeptideMatch().getExperimentalMoz());
            }
            case 8: {
                if (peptideMatchReportertIon.getTransientData().getPeptideMatch() == null) {
                    return "";
                }
                return StringUtils.getTimeInMinutes((float)peptideMatchReportertIon.getTransientData().getPeptideMatch().getRetentionTime().floatValue(), (int)2);
            }
            case 3: {
                MasterQuantComponent mqc = peptideMatchReportertIon.getMasterQuantComponent();
                if (mqc == null) {
                    return SelectLevelEnum.UNKNOWN.getDescription();
                }
                SelectLevelEnum selectionLevel = SelectLevelEnum.valueOf((int)mqc.getSelectionLevel());
                return selectionLevel.getDescription();
            }
            case 9: {
                DPeptideMatch peptideMatch = peptideMatchReportertIon.getTransientData().getPeptideMatch();
                if (peptideMatch == null) {
                    return "";
                }
                Map vals = peptideMatch.getPropertiesAsMap();
                if (vals != null && !vals.isEmpty() && vals.containsKey("precursor_intensity_fraction")) {
                    return vals.get("precursor_intensity_fraction").toString();
                }
                return "";
            }
        }
        int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
        int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
        if (peptideMatchReportertIon.getResultSummary() == null) {
            switch (id) {
                case 0: 
                case 1: {
                    return "0";
                }
            }
        } else {
            Map quantPepMatchReporterIonByQchIds = peptideMatchReportertIon.getTransientData().getQuantReporterIonByQchIds();
            if (quantPepMatchReporterIonByQchIds == null) {
                switch (id) {
                    case 0: 
                    case 1: {
                        return "0";
                    }
                }
            } else {
                DQuantReporterIon quantPepMatchRepIon = (DQuantReporterIon)quantPepMatchReporterIonByQchIds.get(this.m_quantChannels[nbQc].getId());
                if (quantPepMatchRepIon == null) {
                    switch (id) {
                        case 0: 
                        case 1: {
                            return "0";
                        }
                    }
                } else {
                    switch (id) {
                        case 1: {
                            return quantPepMatchRepIon.getAbundance() == null || quantPepMatchRepIon.getAbundance().isNaN() ? "0" : Float.toString(quantPepMatchRepIon.getAbundance().floatValue());
                        }
                        case 0: {
                            return quantPepMatchRepIon.getRawAbundance() == null || quantPepMatchRepIon.getRawAbundance().isNaN() ? "0" : Float.toString(quantPepMatchRepIon.getRawAbundance().floatValue());
                        }
                    }
                }
            }
        }
        return "";
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getDataColumnIdentifier(int col) {
        if (col <= 9) {
            return m_columnNamesForFilter[col];
        }
        int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
        int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
        return m_columnNamesQC[id] + " " + this.m_quantChannels[nbQc].getName();
    }

    public Class getDataColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return Long.class;
            }
            case 2: {
                return String.class;
            }
            case 5: 
            case 8: 
            case 9: {
                return Float.class;
            }
            case 4: {
                return String.class;
            }
            case 3: 
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Double.class;
            }
        }
        int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
        int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
        switch (id) {
            case 0: 
            case 1: {
                return Float.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        if (columnIndex == 3) {
            return ((XicStatusRenderer.SelectLevel)data).getStatus().getIntValue();
        }
        return data;
    }

    public int[] getKeysColumn() {
        return new int[]{0, 1};
    }

    public int getInfoColumn() {
        return 2;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        block0 : switch (col) {
            case 0: 
            case 1: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Long.class), 4);
                break;
            }
            case 2: {
                renderer = new PeptideRenderer();
                break;
            }
            case 3: {
                return new XicStatusRenderer(null, 3);
            }
            case 4: 
            case 9: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
                break;
            }
            case 6: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                break;
            }
            case 7: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 8: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 5: {
                renderer = this.m_scoreRenderer;
                break;
            }
            default: {
                int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
                switch (id) {
                    case 1: {
                        renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
                        break block0;
                    }
                    case 0: {
                        renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
                    }
                }
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DMasterQuantPeptideIon.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DMasterQuantPeptideIon.class)) {
            return this.m_quantPSMReporterIons.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        if (c.equals(XicGroup.class)) {
            if (col <= 9) {
                return null;
            }
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            return new XicGroup(this.m_quantChannels[nbQc].getBiologicalGroupId(), null);
        }
        if (c.equals(QuantitationType.class)) {
            if (col <= 9) {
                return null;
            }
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            switch (id) {
                case 1: {
                    return QuantitationType.getQuantitationType((int)0);
                }
                case 0: {
                    return QuantitationType.getQuantitationType((int)1);
                }
            }
            return null;
        }
        return null;
    }
}

