/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DQuantPeptide;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.BestGraphicsInterface;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.table.LazyData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class XICComparePeptideTableModel
implements ExtendedTableModelInterface,
TableModel,
BestGraphicsInterface {
    public static final int COLTYPE_QC_ID = 0;
    public static final int COLTYPE_QC_NAME = 1;
    public static final int COLTYPE_ABUNDANCE = 2;
    public static final int COLTYPE_RAW_ABUNDANCE = 3;
    public static final int COLTYPE_PSM = 4;
    protected static final String[] m_columnNames = new String[]{"Id", "Quant. Channel", "Abundance", "Raw Abundance", "Pep. match count"};
    protected static final String[] m_columnNames_SC = new String[]{"Id", "Quant. Channel", "[W. SC]", "Specific SC", "Basic SC"};
    protected final ArrayList<Integer> m_colUsed = new ArrayList();
    private DMasterQuantPeptide m_quantPeptide = null;
    protected DQuantitationChannel[] m_quantChannels = null;
    protected String m_modelName;
    protected DDatasetType.QuantitationMethodInfo m_quantMethodInfo;
    protected HashMap<Class, Object> m_extraValues = null;
    private boolean m_isSelected;
    protected EventListenerList listenerList = new EventListenerList();

    public XICComparePeptideTableModel() {
        this.m_quantMethodInfo = DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION;
        this.setColUsed();
    }

    protected boolean isSpectralCountQuant() {
        return this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING);
    }

    protected void setColUsed() {
        this.m_colUsed.clear();
        if (this.isSpectralCountQuant()) {
            this.m_colUsed.add(0);
            this.m_colUsed.add(1);
            this.m_colUsed.add(3);
            this.m_colUsed.add(4);
        } else {
            this.m_colUsed.add(0);
            this.m_colUsed.add(1);
            this.m_colUsed.add(2);
            this.m_colUsed.add(3);
            this.m_colUsed.add(4);
        }
    }

    public void setSelected(boolean isSelected) {
        this.m_isSelected = isSelected;
    }

    public void setData(DQuantitationChannel[] quantChannels, DMasterQuantPeptide peptide, DDatasetType.QuantitationMethodInfo quantitationMethodInfo) {
        this.m_quantChannels = quantChannels;
        this.m_quantPeptide = peptide;
        this.m_quantMethodInfo = quantitationMethodInfo;
        this.setColUsed();
        this.fireTableDataChanged();
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    @Override
    public int getRowCount() {
        if (this.m_quantChannels == null) {
            return 0;
        }
        return this.m_quantChannels.length;
    }

    @Override
    public int getColumnCount() {
        return this.m_colUsed.size();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public int getInfoColumn() {
        return 1;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        plotInformation.setSelected(this.m_isSelected);
        if (this.m_quantPeptide.getPeptideInstance() != null && this.m_quantPeptide.getPeptideInstance().getPeptide() != null) {
            Peptide peptide = this.m_quantPeptide.getPeptideInstance().getPeptide();
            String sequence = PeptideRenderer.constructPeptideDisplay(peptide).replaceAll("<html>", "").replaceAll("</html>", "");
            StringBuilder sb = new StringBuilder(sequence);
            if (peptide.getTransientData().isPeptideReadablePtmStringLoaded() && peptide.getTransientData().getPeptideReadablePtmString() != null) {
                sb.append(" - ").append(peptide.getTransientData().getPeptideReadablePtmString().getReadablePtmString());
            }
            plotInformation.setPlotTitle(sb.toString());
        }
        if (this.m_quantPeptide.getSelectionLevel() < 2) {
            plotInformation.setPlotColor(Color.LIGHT_GRAY);
        }
        plotInformation.setDrawPoints(true);
        plotInformation.setDrawGap(true);
        return plotInformation;
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public PlotDataSpec getDataSpecAt(int row) {
        int matcheCount;
        PlotDataSpec result = new PlotDataSpec();
        DQuantitationChannel qc = this.m_quantChannels[row];
        Map quantPeptideByQchIds = this.m_quantPeptide.getQuantPeptideByQchIds();
        DQuantPeptide quantPeptide = (DQuantPeptide)quantPeptideByQchIds.get(qc.getId());
        if (quantPeptide != null && quantPeptide.getRawAbundance() != null && quantPeptide.getPeptideMatchesCount() != null && (matcheCount = quantPeptide.getPeptideMatchesCount().intValue()) == 0) {
            result.setFill(PlotDataSpec.FILL.EMPTY);
        }
        return result;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DQuantitationChannel.class, true));
        list.add(new ExtraDataType(DMasterQuantPeptide.class, false));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    private void registerSingleValuesAsExtraTypes(ArrayList<ExtraDataType> extraDataTypeList) {
        if (this.m_extraValues == null) {
            return;
        }
        for (Class c : this.m_extraValues.keySet()) {
            extraDataTypeList.add(new ExtraDataType(c, false));
        }
    }

    public Object getValue(Class c) {
        if (c.equals(DMasterQuantPeptide.class)) {
            return this.m_quantPeptide;
        }
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DQuantitationChannel.class)) {
            return this.m_quantChannels[row];
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addSingleValue(Object v) {
        if (this.m_extraValues == null) {
            this.m_extraValues = new HashMap();
        }
        this.m_extraValues.put(v.getClass(), v);
    }

    public Object getSingleValue(Class c) {
        if (this.m_extraValues == null) {
            return null;
        }
        return this.m_extraValues.get(c);
    }

    @Override
    public Object getValueAt(int row, int col) {
        int realCol = this.m_colUsed.get(col);
        DQuantitationChannel qc = this.m_quantChannels[row];
        Map quantPeptideByQchIds = this.m_quantPeptide.getQuantPeptideByQchIds();
        DQuantPeptide quantPeptide = (DQuantPeptide)quantPeptideByQchIds.get(qc.getId());
        switch (realCol) {
            case 0: {
                return qc.getId();
            }
            case 1: {
                return qc.getName();
            }
            case 2: {
                if (quantPeptide == null || quantPeptide.getAbundance() == null) {
                    return null;
                }
                if (this.isSpectralCountQuant()) {
                    return quantPeptide.getRawAbundance().isNaN() ? null : quantPeptide.getRawAbundance();
                }
                return quantPeptide.getAbundance().isNaN() ? null : quantPeptide.getAbundance();
            }
            case 3: {
                if (quantPeptide == null || quantPeptide.getRawAbundance() == null) {
                    return null;
                }
                return quantPeptide.getRawAbundance().isNaN() ? null : quantPeptide.getRawAbundance();
            }
            case 4: {
                if (quantPeptide == null || quantPeptide.getPeptideMatchesCount() == null) {
                    return null;
                }
                return quantPeptide.getPeptideMatchesCount();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.isSpectralCountQuant() ? m_columnNames_SC[this.m_colUsed.get(columnIndex)] : m_columnNames[this.m_colUsed.get(columnIndex)];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        int realColumnIndex = this.m_colUsed.get(columnIndex);
        switch (realColumnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Float.class;
            }
            case 3: {
                if (this.isSpectralCountQuant()) {
                    return Integer.class;
                }
                return Float.class;
            }
            case 4: {
                return Integer.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public PlotType getBestPlotType() {
        return PlotType.LINEAR_PLOT;
    }

    protected int convertColToColUsed(int col) {
        for (int i = 0; i < this.m_colUsed.size(); ++i) {
            if (col != this.m_colUsed.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case LINEAR_PLOT: {
                int[] cols = new int[]{this.convertColToColUsed(1), this.isSpectralCountQuant() ? this.convertColToColUsed(3) : this.convertColToColUsed(2)};
                return cols;
            }
        }
        return null;
    }
}

