/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.data.SelectLevelEnum;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.SelectLevelRadioButtonGroup;
import fr.proline.studio.rsmexplorer.gui.renderer.RendererMouseCallback;
import fr.proline.studio.rsmexplorer.gui.renderer.XicStatusRenderer;
import fr.proline.studio.rsmexplorer.gui.xic.QuantPeptideTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.CustomColumnControlButton;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XicPeptidePanel
extends HourglassPanel
implements RendererMouseCallback,
DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private AbstractDataBox m_dataBox;
    private JScrollPane m_peptideScrollPane;
    private QuantPeptideTable m_quantPeptideTable;
    private QuantPeptideTableModel m_quantPeptideTableModel;
    private MarkerContainerPanel m_markerContainerPanel;
    private ModifyStatusDialog m_modifyStatusDialog;
    private DMasterQuantProteinSet m_proteinSetToDisplayFor;
    private DQuantitationChannel[] m_quantChannels;
    private DDatasetType.QuantitationMethodInfo m_quantMethodInfo;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private JButton m_graphicsButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private SearchToggleButton m_searchToggleButton;
    private JButton m_modifyStatusButton;
    private InfoToggleButton m_infoToggleButton;
    private final boolean m_canGraph;
    private static final String OVERVIEW_KEY = "OVERVIEW_KEY";

    public XicPeptidePanel(boolean canGraph, DDatasetType.QuantitationMethodInfo quantMethodInfo) {
        this.m_canGraph = canGraph;
        this.m_quantMethodInfo = quantMethodInfo;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(5000);
        final JPanel peptidePanel = this.createPeptidePanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                peptidePanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)peptidePanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 1));
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 2));
    }

    private JPanel createPeptidePanel() {
        JPanel peptidePanel = new JPanel();
        peptidePanel.setBounds(0, 0, 500, 400);
        peptidePanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        peptidePanel.add((Component)toolbar, "West");
        peptidePanel.add((Component)internalPanel, "Center");
        return peptidePanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_quantPeptideTable, (JXTable)this.m_quantPeptideTable, (FilterTableModelInterface)((CompoundTableModel)this.m_quantPeptideTable.getModel()));
        toolbar.add((Component)this.m_searchToggleButton);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_quantPeptideTable.getModel(), (SettingsInterface)this.m_quantPeptideTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_quantPeptideTable.getModel())){

            protected void filteringDone() {
                XicPeptidePanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                XicPeptidePanel.this.m_dataBox.propagateDataChanged();
                XicPeptidePanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_quantPeptideTable.getModel()), "Peptides", (JXTable)this.m_quantPeptideTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        if (this.m_canGraph) {
            this.m_graphicsButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CHART));
            this.m_graphicsButton.setToolTipText("Graphics : Linear Plot");
            this.m_graphicsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!((CompoundTableModel)XicPeptidePanel.this.m_quantPeptideTable.getModel()).isLoaded()) {
                        ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)((CompoundTableModel)XicPeptidePanel.this.m_quantPeptideTable.getModel()), (String)"Data loading", (String)"Histogram functionnality is not available while data is loading. Please Wait.");
                        dialog.setLocation(XicPeptidePanel.this.getLocationOnScreen().x + XicPeptidePanel.this.m_graphicsButton.getWidth() + 5, XicPeptidePanel.this.m_graphicsButton.getLocationOnScreen().y + XicPeptidePanel.this.getHeight() + 5);
                        dialog.setVisible(true);
                        if (!dialog.isWaitingFinished()) {
                            return;
                        }
                    }
                    WindowBox wbox = WindowBoxFactory.getMultiGraphicsWindowBox("Peptide Graphic", XicPeptidePanel.this.m_dataBox, false);
                    wbox.setEntryData(XicPeptidePanel.this.m_dataBox.getProjectId(), null);
                    DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
                    WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
                }
            });
            toolbar.add(this.m_graphicsButton);
        }
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_quantPeptideTable.getModel())){

            public void actionPerformed() {
                JXTable table = XicPeptidePanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(XicPeptidePanel.this.m_dataBox.getId(), XicPeptidePanel.this.m_dataBox.getUserName(), XicPeptidePanel.this.m_dataBox.getDataName(), XicPeptidePanel.this.m_dataBox.getTypeName(), table);
                Image i = XicPeptidePanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_addCompareDataButton);
        this.m_modifyStatusButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REFINE));
        this.m_modifyStatusButton.setToolTipText("Modify Peptide Status...");
        ActionListener modifyStatusButtonAction = this.createModifyStatusButtonAction();
        this.m_modifyStatusButton.addActionListener(modifyStatusButtonAction);
        toolbar.add(this.m_modifyStatusButton);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_quantPeptideTable, (InfoInterface)this.m_quantPeptideTable);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private ActionListener createModifyStatusButtonAction() {
        ActionListener modifyStatusButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = XicPeptidePanel.this.m_quantPeptideTable.getSelectedRows();
                if (selectedRows.length > 0) {
                    if (XicPeptidePanel.this.m_modifyStatusDialog == null) {
                        XicPeptidePanel.this.m_modifyStatusDialog = new ModifyStatusDialog();
                    }
                    XicPeptidePanel.this.m_modifyStatusDialog.setSelectedRows(selectedRows);
                    XicPeptidePanel.this.m_modifyStatusDialog.setLocationRelativeTo(XicPeptidePanel.this.m_modifyStatusButton);
                    XicPeptidePanel.this.m_modifyStatusDialog.setVisible(true);
                }
            }
        };
        return modifyStatusButtonAction;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_peptideScrollPane = new JScrollPane();
        this.m_quantPeptideTable = new QuantPeptideTable();
        this.m_quantPeptideTableModel = new QuantPeptideTableModel(this.m_quantPeptideTable, this, this.m_quantMethodInfo);
        this.m_quantPeptideTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)this.m_quantPeptideTableModel, true));
        XicStatusRenderer renderer = (XicStatusRenderer)this.m_quantPeptideTableModel.getRenderer(0, 1);
        this.m_quantPeptideTable.addMouseListener(renderer);
        this.m_quantPeptideTable.addMouseMotionListener(renderer);
        CustomColumnControlButton customColumnControl = new CustomColumnControlButton((JXTable)this.m_quantPeptideTable);
        this.m_quantPeptideTable.setColumnControl((JComponent)customColumnControl);
        this.m_quantPeptideTable.getColumnExt(this.m_quantPeptideTable.convertColumnIndexToView(0)).setVisible(false);
        if (this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING)) {
            this.m_quantPeptideTable.getColumnExt(this.m_quantPeptideTable.convertColumnIndexToView(1)).setVisible(false);
        }
        this.m_quantPeptideTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_peptideScrollPane, (MarkerComponentInterface)this.m_quantPeptideTable);
        this.m_peptideScrollPane.setViewportView((Component)((Object)this.m_quantPeptideTable));
        this.m_quantPeptideTable.setFillsViewportHeight(true);
        this.m_quantPeptideTable.setViewport(this.m_peptideScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void setData(Long taskId, DMasterQuantProteinSet proteinSetToDisplayFor, DQuantitationChannel[] quantChannels, List<DMasterQuantPeptide> peptides, DDatasetType.QuantitationMethodInfo quantitationMethodInfo, boolean finished) {
        boolean qcChanged = true;
        if (this.m_quantChannels != null && this.m_quantChannels.length == quantChannels.length) {
            for (int q = 0; q < this.m_quantChannels.length; ++q) {
                qcChanged = !this.m_quantChannels[q].equals((Object)quantChannels[q]);
            }
        }
        this.m_quantChannels = quantChannels;
        this.m_quantMethodInfo = quantitationMethodInfo;
        this.m_proteinSetToDisplayFor = proteinSetToDisplayFor;
        this.m_quantPeptideTableModel.setData(taskId, this.m_dataBox.getProjectId(), quantChannels, peptides, this.m_proteinSetToDisplayFor, this.m_quantMethodInfo);
        if (this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING)) {
            this.m_quantPeptideTableModel.setOverviewType(3);
        }
        if (peptides != null && peptides.size() > 0) {
            this.m_quantPeptideTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(peptides.size());
            this.m_markerContainerPanel.removeAllMarkers();
        }
        this.m_infoToggleButton.updateInfo();
        if (finished) {
            this.m_quantPeptideTable.setSortable(true);
        }
        if (qcChanged) {
            this.setColumnsVisibility();
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_quantPeptideTable.dataUpdated(subTask, finished);
        if (finished) {
            this.m_quantPeptideTable.setSortable(true);
        }
    }

    private void setColumnsVisibility() {
        boolean columnVisible;
        boolean columnVisible2;
        List<Integer> listIdsToHide = this.m_quantPeptideTableModel.getDefaultColumnsToHide();
        List columns = this.m_quantPeptideTable.getColumns(true);
        for (Integer id : listIdsToHide) {
            boolean columnVisible3 = ((TableColumnExt)columns.get(id)).isVisible();
            if (!columnVisible3) continue;
            this.m_quantPeptideTable.getColumnExt(this.m_quantPeptideTable.convertColumnIndexToView(id)).setVisible(false);
        }
        if (this.m_proteinSetToDisplayFor == null && (columnVisible2 = ((TableColumnExt)columns.get(11)).isVisible())) {
            this.m_quantPeptideTable.getColumnExt(this.m_quantPeptideTable.convertColumnIndexToView(11)).setVisible(false);
        }
        if (columnVisible = ((TableColumnExt)columns.get(0)).isVisible()) {
            this.m_quantPeptideTable.getColumnExt(this.m_quantPeptideTable.convertColumnIndexToView(0)).setVisible(false);
        }
        if (this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING) && (columnVisible = ((TableColumnExt)columns.get(1)).isVisible())) {
            this.m_quantPeptideTable.getColumnExt(this.m_quantPeptideTable.convertColumnIndexToView(1)).setVisible(false);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_quantPeptideTableModel.setDatabox(dataBox);
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_quantPeptideTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_quantPeptideTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public DMasterQuantPeptide getSelectedMasterQuantPeptide() {
        return this.m_quantPeptideTable.getSelectedMasterQuantPeptide();
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_quantPeptideTable;
    }

    @Override
    public void mouseAction(MouseEvent e) {
        int col = this.m_quantPeptideTable.columnAtPoint(e.getPoint());
        int row = this.m_quantPeptideTable.rowAtPoint(e.getPoint());
        if (row != -1) {
            int rowModelIndex = this.m_quantPeptideTable.convertRowIndexToModel(row);
            if (this.m_quantPeptideTable.convertColumnIndexToModel(col) == 1) {
                this.m_quantPeptideTable.getSelectionModel().setSelectionInterval(row, row);
                if (this.m_quantPeptideTableModel.isRowEditable(rowModelIndex)) {
                    if (this.m_modifyStatusDialog == null) {
                        this.m_modifyStatusDialog = new ModifyStatusDialog();
                    }
                    int[] selectedViewRows = new int[]{row};
                    this.m_modifyStatusDialog.setSelectedRows(selectedViewRows);
                    this.m_modifyStatusDialog.setLocation(e.getLocationOnScreen().x, e.getLocationOnScreen().y);
                    this.m_modifyStatusDialog.setVisible(true);
                }
            }
        }
    }

    public void modifyStatusActionFinished(boolean success, String errorMessage) {
        this.m_modifyStatusDialog.actionFinished(success, errorMessage);
    }

    private class QuantPeptideTable
    extends LazyTable
    implements ExportModelInterface,
    InfoInterface {
        private ObjectParameter m_overviewParameter;
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public QuantPeptideTable() {
            super(XicPeptidePanel.this.m_peptideScrollPane.getVerticalScrollBar());
            this.m_overviewParameter = null;
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        public ArrayList<ParameterList> getParameters() {
            ArrayList parameterListArray = super.getParameters();
            ParameterList overviewParameterList = new ParameterList("Overview Parameters");
            boolean isSC = XicPeptidePanel.this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING);
            Object[] overviewDisplay = new String[]{!isSC ? "Overview on Pep. Match Count" : "Overview on Basic SC", "Overview on Abundance", !isSC ? "Overview on Raw Abundance" : "Overview on Specific SC"};
            Object[] overviewValues = new Integer[]{0, 1, 2};
            List columns = this.getColumns(true);
            int overviewType = XicPeptidePanel.this.m_quantPeptideTableModel.getOverviewType();
            boolean overviewColumnVisible = ((TableColumnExt)columns.get(10)).isVisible();
            int defaultIndex = 0;
            if (!overviewColumnVisible) {
                defaultIndex = 0;
            } else {
                switch (overviewType) {
                    case 4: {
                        defaultIndex = 1;
                        break;
                    }
                    case 3: {
                        defaultIndex = 2;
                        break;
                    }
                    case 2: {
                        defaultIndex = 0;
                    }
                }
            }
            this.m_overviewParameter = new ObjectParameter(XicPeptidePanel.OVERVIEW_KEY, "Overview", null, overviewDisplay, overviewValues, defaultIndex, null);
            overviewParameterList.add((Object)this.m_overviewParameter);
            parameterListArray.add(overviewParameterList);
            return parameterListArray;
        }

        public void parametersChanged() {
            super.parametersChanged();
            if (this.m_overviewParameter == null) {
                return;
            }
            Integer index = (Integer)this.m_overviewParameter.getAssociatedObjectValue();
            if (index == 1) {
                XicPeptidePanel.this.m_quantPeptideTableModel.setOverviewType(4);
            } else if (index == 2) {
                XicPeptidePanel.this.m_quantPeptideTableModel.setOverviewType(3);
            } else if (index == 0) {
                XicPeptidePanel.this.m_quantPeptideTableModel.setOverviewType(2);
            }
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            if (rowIndex < 0) {
                return null;
            }
            int colIndex = this.columnAtPoint(p);
            if (colIndex < 0) {
                return null;
            }
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            int realRowIndex = this.convertRowIndexToModel(rowIndex);
            if (realColumnIndex == 1) {
                return super.getToolTipText(e);
            }
            CompoundTableModel tableModel = (CompoundTableModel)this.getModel();
            return tableModel.getTootlTipValue(realRowIndex, realColumnIndex);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            XicPeptidePanel.this.m_dataBox.addDataChanged(DMasterQuantPeptide.class);
            XicPeptidePanel.this.m_dataBox.propagateDataChanged();
        }

        public boolean selectPeptide(Long peptideId, String searchText) {
            QuantPeptideTableModel tableModel = (QuantPeptideTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(peptideId);
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((QuantPeptideTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return XicPeptidePanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return XicPeptidePanel.this.m_dataBox.isLoaded();
        }

        public DMasterQuantPeptide getSelectedMasterQuantPeptide() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            try {
                selectedRow = this.convertRowIndexToModel(selectedRow);
            }
            catch (Exception e) {
                m_loggerProline.debug("Exception catched as a wart : " + e.getMessage());
                return null;
            }
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            QuantPeptideTableModel tableModel = (QuantPeptideTableModel)compoundTableModel.getBaseModel();
            return tableModel.getPeptide(selectedRow);
        }

        public String getExportColumnName(int col) {
            return ((CompoundTableModel)XicPeptidePanel.this.m_quantPeptideTable.getModel()).getExportColumnName(this.convertColumnIndexToModel(col));
        }

        public String getExportRowCell(int row, int col) {
            return ((CompoundTableModel)XicPeptidePanel.this.m_quantPeptideTable.getModel()).getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ((CompoundTableModel)XicPeptidePanel.this.m_quantPeptideTable.getModel()).getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(XicPeptidePanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count;
            return count + ((count = this.getModel().getRowCount()) > 1 ? " Peptides" : " Peptide");
        }
    }

    class ModifyStatusDialog
    extends DefaultDialog {
        private final ModifyStatusPanel m_internalPanel;
        private static final String CMD_VALIDATED = "Validated";
        private static final String CMD_INVALIDATED = "Invalidated";
        private static final String CMD_RESET = "Reset Status to Automatic";
        private LocalStatusPanel m_localStatusPanel;
        private SelectLevelRadioButtonGroup m_globalValidButtonPane;
        private SelectLevelRadioButtonGroup m_globalInvalidButtonPane;
        private ButtonGroup m_globalButtonGroup;
        private JButton m_resetButton;
        private DMasterQuantPeptide m_selectedPeptide;
        private ArrayList<Integer> m_selectedRows;

        public ModifyStatusDialog() {
            super((Window)WindowManager.getDefault().getMainWindow(), Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle("Modify Peptide Status");
            this.m_internalPanel = new ModifyStatusPanel();
            String help_text = "Peptide status is the combination between the global status (defined for the whole dataset) and the local status (defined for a Protein Set using razor peptides selection for example).<br> Only the global status can be changed, this will impact the local status and Post-Processing service SHOULD be run again.";
            this.setHelpHeader(help_text, 370, 100);
            this.setInternalComponent((Component)((Object)this.m_internalPanel));
            this.setResizable(true);
            this.setButtonVisible(5, false);
        }

        protected boolean okCalled() {
            this.actionStarted();
            String command = this.m_globalButtonGroup.getSelection().getActionCommand();
            if (command.equals(CMD_VALIDATED)) {
                ArrayList<DMasterQuantPeptide> listToModify = XicPeptidePanel.this.m_quantPeptideTableModel.listToModifyForValidateModifications(this.m_selectedRows, SelectLevelEnum.SELECTED_MANUAL);
                XicPeptidePanel.this.m_quantPeptideTableModel.validateModifications(XicPeptidePanel.this, listToModify);
            } else if (command.equals(CMD_INVALIDATED)) {
                ArrayList<DMasterQuantPeptide> listToModify = XicPeptidePanel.this.m_quantPeptideTableModel.listToModifyForValidateModifications(this.m_selectedRows, SelectLevelEnum.DESELECTED_MANUAL);
                XicPeptidePanel.this.m_quantPeptideTableModel.validateModifications(XicPeptidePanel.this, listToModify);
            }
            this.m_buttonClicked = 0;
            return false;
        }

        private ActionListener createResetAction() {
            ActionListener resetAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList<DMasterQuantPeptide> listToModify = XicPeptidePanel.this.m_quantPeptideTableModel.listToModifyForValidateModifications(ModifyStatusDialog.this.m_selectedRows, SelectLevelEnum.RESET_AUTO);
                    XicPeptidePanel.this.m_quantPeptideTableModel.validateModifications(XicPeptidePanel.this, listToModify);
                }
            };
            return resetAction;
        }

        protected boolean cancelCalled() {
            return true;
        }

        public void actionFinished(boolean success, String errorMessage) {
            this.m_selectedPeptide = null;
            this.m_selectedRows.clear();
            this.m_internalPanel.setLoaded(1);
            this.setVisible(false);
            if (!success) {
                this.setStatus(success, errorMessage);
            }
        }

        public void actionStarted() {
            this.m_internalPanel.setLoading(1, true);
        }

        private void updateRadioButton(ButtonGroup buttonGroup, boolean selectLevelHomogenous, SelectLevelEnum selectLevel, SelectLevelRadioButtonGroup validPane, SelectLevelRadioButtonGroup invalidPane) {
            if (selectLevelHomogenous) {
                switch (selectLevel) {
                    case DESELECTED_MANUAL: 
                    case DESELECTED_AUTO: {
                        validPane.removeOptionIcon();
                        invalidPane.getRadioButton().setSelected(true);
                        invalidPane.addIcon(selectLevel.getIntValue());
                        break;
                    }
                    case SELECTED_AUTO: 
                    case SELECTED_MANUAL: {
                        validPane.getRadioButton().setSelected(true);
                        validPane.addIcon(selectLevel.getIntValue());
                        invalidPane.removeOptionIcon();
                        break;
                    }
                    default: {
                        validPane.getRadioButton().setSelected(false);
                        invalidPane.getRadioButton().setSelected(false);
                        validPane.removeOptionIcon();
                        invalidPane.removeOptionIcon();
                        break;
                    }
                }
            } else {
                validPane.removeOptionIcon();
                invalidPane.removeOptionIcon();
                buttonGroup.clearSelection();
            }
        }

        private void updateLocal(boolean localSelectLevelHomogenous, SelectLevelEnum selectLevel, LocalStatusPanel statusPanel) {
            boolean automatic = selectLevel == SelectLevelEnum.DESELECTED_AUTO || selectLevel == SelectLevelEnum.SELECTED_AUTO;
            boolean validated = selectLevel == SelectLevelEnum.SELECTED_AUTO || selectLevel == SelectLevelEnum.SELECTED_MANUAL;
            statusPanel.setValues(localSelectLevelHomogenous, validated, automatic);
        }

        private void setSelectedRows(int[] selectedViewRows) {
            Object selectedPeptide;
            this.m_selectedRows.clear();
            for (int row : selectedViewRows) {
                int modelIndex = XicPeptidePanel.this.m_quantPeptideTable.convertRowIndexToModel(row);
                this.m_selectedRows.add(modelIndex);
            }
            DMasterQuantPeptide firstSelectedPeptide = (DMasterQuantPeptide)XicPeptidePanel.this.m_quantPeptideTableModel.getRowValue(DMasterQuantPeptide.class, this.m_selectedRows.get(0));
            if (this.m_selectedRows.size() == 1) {
                this.m_selectedPeptide = firstSelectedPeptide;
            }
            boolean globalSelectLevelHomogenous = true;
            int globalSelectLevelRef = firstSelectedPeptide.getSelectionLevel();
            for (int modelIndex : this.m_selectedRows) {
                selectedPeptide = (DMasterQuantPeptide)XicPeptidePanel.this.m_quantPeptideTableModel.getRowValue(DMasterQuantPeptide.class, modelIndex);
                int globalSelectLevelCur = selectedPeptide.getSelectionLevel();
                if (globalSelectLevelRef == globalSelectLevelCur) continue;
                globalSelectLevelHomogenous = false;
                break;
            }
            this.updateRadioButton(this.m_globalButtonGroup, globalSelectLevelHomogenous, SelectLevelEnum.valueOf((int)globalSelectLevelRef), this.m_globalValidButtonPane, this.m_globalInvalidButtonPane);
            boolean localSelectLevelHomogenous = true;
            int localSelectLevelRef = XicPeptidePanel.this.m_quantPeptideTableModel.getSelectionLevelFor((DMasterQuantPeptide)firstSelectedPeptide).m_status.getIntValue();
            selectedPeptide = this.m_selectedRows.iterator();
            while (selectedPeptide.hasNext()) {
                int modelIndex = (Integer)selectedPeptide.next();
                DMasterQuantPeptide selectedPeptide2 = (DMasterQuantPeptide)XicPeptidePanel.this.m_quantPeptideTableModel.getRowValue(DMasterQuantPeptide.class, modelIndex);
                int localSelectLevelCur = XicPeptidePanel.this.m_quantPeptideTableModel.getSelectionLevelFor((DMasterQuantPeptide)selectedPeptide2).m_status.getIntValue();
                if (localSelectLevelRef == localSelectLevelCur) continue;
                localSelectLevelHomogenous = false;
                break;
            }
            this.updateLocal(localSelectLevelHomogenous, XicPeptidePanel.this.m_quantPeptideTableModel.getSelectionLevelFor((DMasterQuantPeptide)firstSelectedPeptide).m_status, this.m_localStatusPanel);
            ArrayList<DMasterQuantPeptide> listToModify = XicPeptidePanel.this.m_quantPeptideTableModel.listToModifyForValidateModifications(this.m_selectedRows, SelectLevelEnum.RESET_AUTO);
            this.m_resetButton.setEnabled(listToModify != null);
        }

        private JPanel createLocalStatusPanel() {
            JLabel localText = new JLabel("Status for Selected Protein Set :");
            this.m_localStatusPanel = new LocalStatusPanel();
            JPanel localPane = new JPanel(new GridBagLayout());
            localPane.setBorder(BorderFactory.createTitledBorder(" Peptide Local Status"));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 1;
            localPane.add(Box.createHorizontalStrut(20), c);
            ++c.gridx;
            localPane.add((Component)localText, c);
            ++c.gridx;
            localPane.add(Box.createHorizontalStrut(10), c);
            ++c.gridx;
            localPane.add((Component)this.m_localStatusPanel, c);
            ++c.gridx;
            c.weightx = 1.0;
            localPane.add(Box.createGlue(), c);
            c.weightx = 0.0;
            return localPane;
        }

        private JPanel createGlobalStatusPanel() {
            int anchor;
            JPanel globalPane = new JPanel(new GridBagLayout());
            globalPane.setBorder(BorderFactory.createTitledBorder(" Peptide Global Status"));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            JLabel globalTextLabel = new JLabel("Status for Whole Dataset :");
            globalPane.add(Box.createHorizontalStrut(20), c);
            ++c.gridx;
            globalPane.add((Component)globalTextLabel, c);
            ++c.gridx;
            globalPane.add(Box.createHorizontalStrut(10), c);
            c.gridx = anchor = c.gridx + 1;
            this.m_globalValidButtonPane = new SelectLevelRadioButtonGroup(globalPane, c, CMD_VALIDATED, IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED));
            ++c.gridy;
            c.gridx = anchor;
            this.m_globalInvalidButtonPane = new SelectLevelRadioButtonGroup(globalPane, c, CMD_INVALIDATED, IconManager.getIcon((IconManager.IconType)IconManager.IconType.INVALIDATED));
            this.m_globalValidButtonPane.getRadioButton().setActionCommand(CMD_VALIDATED);
            this.m_globalInvalidButtonPane.getRadioButton().setActionCommand(CMD_INVALIDATED);
            this.m_globalButtonGroup = new ButtonGroup();
            this.m_globalButtonGroup.add(this.m_globalValidButtonPane.getRadioButton());
            this.m_globalButtonGroup.add(this.m_globalInvalidButtonPane.getRadioButton());
            this.m_resetButton = new JButton(CMD_RESET, IconManager.getIcon((IconManager.IconType)IconManager.IconType.DEFAULT));
            this.m_resetButton.addActionListener(this.createResetAction());
            JPanel resetButtonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c2 = new GridBagConstraints();
            c2.anchor = 18;
            c2.insets = new Insets(2, 2, 2, 2);
            c2.gridx = 0;
            c2.gridy = 0;
            c2.fill = 1;
            c2.weightx = 1.0;
            resetButtonPanel.add(Box.createHorizontalGlue(), c2);
            c2.weightx = 0.0;
            ++c2.gridx;
            resetButtonPanel.add(this.m_resetButton);
            c.gridx = 1;
            c.gridwidth = 6;
            c.weightx = 1.0;
            ++c.gridy;
            globalPane.add((Component)resetButtonPanel, c);
            return globalPane;
        }

        class ModifyStatusPanel
        extends HourglassPanel {
            ModifyStatusPanel() {
                ModifyStatusDialog.this.m_selectedRows = new ArrayList();
                JPanel localPane = ModifyStatusDialog.this.createLocalStatusPanel();
                JPanel globalPane = ModifyStatusDialog.this.createGlobalStatusPanel();
                this.setLayout(new BoxLayout((Container)((Object)this), 3));
                this.setBorder(new EmptyBorder(10, 10, 10, 10));
                this.add(localPane);
                this.add(Box.createRigidArea(new Dimension(0, 10)));
                this.add(globalPane);
                Dimension d = this.getPreferredSize();
                this.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
            }
        }
    }

    private class LocalStatusPanel
    extends JPanel {
        private final JLabel m_textLabel;
        private final JLabel m_validatedlabel;
        private final JLabel m_automaticLabel;

        public LocalStatusPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(1, 1, 1, 1);
            this.m_textLabel = new JLabel();
            this.m_validatedlabel = new JLabel(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(16, 16);
                }
            };
            this.m_automaticLabel = new JLabel(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(16, 16);
                }
            };
            c.gridx = 0;
            this.add((Component)this.m_textLabel, c);
            ++c.gridx;
            this.add(Box.createHorizontalStrut(10), c);
            ++c.gridx;
            this.add((Component)this.m_validatedlabel, c);
            ++c.gridx;
            this.add((Component)this.m_automaticLabel, c);
        }

        public void setValues(boolean localSelectLevelHomogenous, boolean validated, boolean automatic) {
            if (!localSelectLevelHomogenous) {
                this.resetValues();
                return;
            }
            if (validated) {
                this.m_textLabel.setText("Validated");
                this.m_validatedlabel.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED));
                this.m_validatedlabel.setToolTipText("Validated");
            } else {
                this.m_textLabel.setText("Invalidated");
                this.m_validatedlabel.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INVALIDATED));
                this.m_validatedlabel.setToolTipText("Invalidated");
            }
            if (automatic) {
                this.m_automaticLabel.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.GEAR));
                this.m_automaticLabel.setToolTipText("Automatic");
            } else {
                this.m_automaticLabel.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HAND_OPEN));
                this.m_automaticLabel.setToolTipText("Manual");
            }
        }

        public void resetValues() {
            this.m_textLabel.setText("Heterogeneous Values");
            this.m_validatedlabel.setIcon(null);
            this.m_automaticLabel.setToolTipText(null);
            this.m_automaticLabel.setIcon(null);
            this.m_automaticLabel.setToolTipText(null);
        }
    }
}

