/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.SetRsetNameAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.ChildFactory;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTree
extends JTree
implements MouseListener {
    private static int ID_INC = 0;
    private int m_id = ID_INC++;
    private SetRsetNameAction m_subscribedRenamer;
    private int m_expected = -1;
    protected RSMTreeModel m_model;
    protected RSMTreeSelectionModel m_selectionModel;
    protected HashMap<AbstractData, AbstractNode> m_loadingMap = new HashMap();
    private HashSet<AbstractNode> m_loadingStartedMap = new HashSet();
    private ArrayList<ResultSummary> selectionFromrsmArray = null;

    public int getId() {
        return this.m_id;
    }

    public void subscribeRenamer(SetRsetNameAction subscribedRenamer) {
        this.m_subscribedRenamer = subscribedRenamer;
    }

    public SetRsetNameAction getSubscribedRenamer() {
        return this.m_subscribedRenamer;
    }

    public void setExpected(int expected) {
        this.m_expected = expected;
    }

    protected void initTree(AbstractNode top) {
        this.m_model = new RSMTreeModel(this, top);
        this.setModel(this.m_model);
        this.m_selectionModel = new RSMTreeSelectionModel();
        this.setSelectionModel(this.m_selectionModel);
        this.putClientProperty("JTree.lineStyle", "Horizontal");
        this.setRowHeight(18);
        IdentificationTree.RSMTreeRenderer renderer = new IdentificationTree.RSMTreeRenderer();
        this.setCellRenderer(renderer);
        if (this.isEditable()) {
            this.setCellEditor(new RSMTreeCellEditor(this, renderer));
        }
        this.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    protected void startLoading(final AbstractNode nodeToLoad, final boolean identificationDataset) {
        if (nodeToLoad.getChildCount() == 0) {
            return;
        }
        AbstractNode childNode = (AbstractNode)nodeToLoad.getChildAt(0);
        if (childNode.getType() != AbstractNode.NodeTypes.HOUR_GLASS) {
            return;
        }
        if (this.m_loadingStartedMap.contains(nodeToLoad)) {
            return;
        }
        this.m_loadingStartedMap.add(nodeToLoad);
        this.m_loadingMap.put(nodeToLoad.getData(), nodeToLoad);
        final ArrayList childrenList = new ArrayList();
        final AbstractData parentData = nodeToLoad.getData();
        if (nodeToLoad.getType() == AbstractNode.NodeTypes.TREE_PARENT) {
            nodeToLoad.setIsChanging(true);
            this.m_model.nodeChanged(nodeToLoad);
        }
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return false;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (nodeToLoad.getType() == AbstractNode.NodeTypes.TREE_PARENT) {
                            nodeToLoad.setIsChanging(false);
                            AbstractTree.this.m_model.nodeChanged(nodeToLoad);
                        }
                        AbstractTree.this.dataLoaded(parentData, childrenList);
                        if (AbstractTree.this.m_loadingMap.isEmpty() && AbstractTree.this.selectionFromrsmArray != null) {
                            AbstractTree.this.setSelection(AbstractTree.this.selectionFromrsmArray);
                            AbstractTree.this.selectionFromrsmArray = null;
                        }
                        if (identificationDataset) {
                            IdentificationTree.getCurrentTree().loadTrash();
                        } else {
                            QuantitationTree.getCurrentTree().loadTrash();
                        }
                    }
                });
            }
        };
        parentData.load(callback, childrenList, identificationDataset);
    }

    protected void dataLoaded(AbstractData data, List<AbstractData> list) {
        AbstractNode parentNode = this.m_loadingMap.remove(data);
        parentNode.remove(0);
        int indexToInsert = 0;
        for (AbstractData dataCur : list) {
            parentNode.insert(ChildFactory.createNode(dataCur), indexToInsert);
            ++indexToInsert;
        }
        this.m_model.nodeStructureChanged(parentNode);
    }

    public void loadNodes(HashSet<AbstractNode> nodes, Runnable callback, boolean identificationDataset) {
        if (nodes.isEmpty() && callback != null) {
            callback.run();
            return;
        }
        AbstractNode node = nodes.iterator().next();
        this.loadNodes(nodes, node, callback, identificationDataset);
    }

    public void loadNode(AbstractNode node, Runnable callback, boolean identificationDataset) {
        HashSet<AbstractNode> nodes = new HashSet<AbstractNode>(1);
        nodes.add(node);
        this.loadNodes(nodes, node, callback, identificationDataset);
    }

    private void loadNodes(final HashSet<AbstractNode> nodes, final AbstractNode node, final Runnable callback, final boolean identificationDataset) {
        if (node.getChildCount() == 0) {
            nodes.remove(node);
            this.loadNodes(nodes, callback, identificationDataset);
            return;
        }
        AbstractNode childNode = (AbstractNode)node.getChildAt(0);
        if (childNode.getType() != AbstractNode.NodeTypes.HOUR_GLASS) {
            int nbChildren = node.getChildCount();
            for (int i = 0; i < nbChildren; ++i) {
                nodes.add((AbstractNode)node.getChildAt(i));
            }
            nodes.remove(node);
            this.loadNodes(nodes, callback, identificationDataset);
        } else {
            this.m_loadingMap.put(node.getData(), node);
            final ArrayList childrenList = new ArrayList();
            final AbstractData parentData = node.getData();
            if (node.getType() == AbstractNode.NodeTypes.TREE_PARENT) {
                node.setIsChanging(true);
                this.m_model.nodeChanged(node);
            }
            AbstractDatabaseCallback databaseCallback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (node.getType() == AbstractNode.NodeTypes.TREE_PARENT) {
                        node.setIsChanging(false);
                        AbstractTree.this.m_model.nodeChanged(node);
                    }
                    AbstractTree.this.dataLoadingDone(nodes, node, callback, parentData, childrenList, identificationDataset);
                }
            };
            parentData.load(databaseCallback, childrenList, AbstractDatabaseTask.Priority.TOP, identificationDataset);
        }
    }

    private void dataLoadingDone(HashSet<AbstractNode> nodes, AbstractNode node, Runnable callback, AbstractData data, List<AbstractData> list, boolean identificationDataset) {
        AbstractNode parentNode = this.m_loadingMap.remove(data);
        nodes.remove(node);
        parentNode.remove(0);
        int indexToInsert = 0;
        for (AbstractData dataCur : list) {
            parentNode.insert(ChildFactory.createNode(dataCur), indexToInsert);
            ++indexToInsert;
        }
        this.m_model.nodeStructureChanged(parentNode);
        int nbChildren = parentNode.getChildCount();
        for (int i = 0; i < nbChildren; ++i) {
            AbstractNode childNode = (AbstractNode)parentNode.getChildAt(i);
            if (childNode.getChildCount() == 0) continue;
            nodes.add(childNode);
        }
        this.loadNodes(nodes, callback, identificationDataset);
    }

    public void loadAllAtOnce(final AbstractNode nodeToLoad, final boolean identificationDataset) {
        if (nodeToLoad.getChildCount() == 0) {
            --this.m_expected;
            if (identificationDataset && this.m_subscribedRenamer != null && this.m_expected == 0) {
                this.m_subscribedRenamer.proceedWithRenaming();
            }
            return;
        }
        AbstractNode childNode = (AbstractNode)nodeToLoad.getChildAt(0);
        if (childNode.getType() != AbstractNode.NodeTypes.HOUR_GLASS) {
            int nbChildren = nodeToLoad.getChildCount();
            this.m_expected += nbChildren;
            for (int i = 0; i < nbChildren; ++i) {
                this.loadAllAtOnce((AbstractNode)nodeToLoad.getChildAt(i), identificationDataset);
            }
            --this.m_expected;
            if (identificationDataset && this.m_subscribedRenamer != null && this.m_expected == 0) {
                this.m_subscribedRenamer.proceedWithRenaming();
            }
            return;
        }
        this.m_loadingMap.put(nodeToLoad.getData(), nodeToLoad);
        final ArrayList childrenList = new ArrayList();
        final AbstractData parentData = nodeToLoad.getData();
        if (nodeToLoad.getType() == AbstractNode.NodeTypes.TREE_PARENT) {
            nodeToLoad.setIsChanging(true);
            this.m_model.nodeChanged(nodeToLoad);
        }
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (nodeToLoad.getType() == AbstractNode.NodeTypes.TREE_PARENT) {
                    nodeToLoad.setIsChanging(false);
                    AbstractTree.this.m_model.nodeChanged(nodeToLoad);
                }
                AbstractTree.this.dataLoadedAtOnce(parentData, childrenList, identificationDataset);
            }
        };
        parentData.load(callback, childrenList, AbstractDatabaseTask.Priority.TOP, identificationDataset);
    }

    private void dataLoadedAtOnce(AbstractData data, List<AbstractData> list, boolean identificationDataset) {
        AbstractNode parentNode = this.m_loadingMap.remove(data);
        parentNode.remove(0);
        int indexToInsert = 0;
        for (AbstractData dataCur : list) {
            parentNode.insert(ChildFactory.createNode(dataCur), indexToInsert);
            ++indexToInsert;
        }
        this.m_model.nodeStructureChanged(parentNode);
        int nbChildren = parentNode.getChildCount();
        this.m_expected = this.m_expected + nbChildren - 1;
        for (int i = 0; i < nbChildren; ++i) {
            this.loadAllAtOnce((AbstractNode)parentNode.getChildAt(i), identificationDataset);
        }
        if (identificationDataset && this.m_subscribedRenamer != null && this.m_expected == 0) {
            this.m_subscribedRenamer.proceedWithRenaming();
        }
    }

    public void revertSelectionSetDisabled(boolean disabled) {
        AbstractNode rootNode;
        TreePath[] selectedPaths = this.getSelectionPaths();
        ArrayList<AbstractNode> availableNodes = new ArrayList<AbstractNode>();
        if (selectedPaths != null) {
            for (TreePath selectedPath : selectedPaths) {
                Object[] pathElements;
                for (Object nextElem : pathElements = selectedPath.getPath()) {
                    AbstractNode nextNode = (AbstractNode)nextElem;
                    if (availableNodes.contains(nextNode)) continue;
                    availableNodes.add(nextNode);
                }
            }
        }
        if (!availableNodes.contains(rootNode = (AbstractNode)this.m_model.getRoot())) {
            rootNode.setIsDisabled(disabled);
            this.m_model.nodeChanged(rootNode);
        }
        this.childRevertSelectionSetDisabled(rootNode, availableNodes, disabled);
    }

    private void childRevertSelectionSetDisabled(AbstractNode parent, List<AbstractNode> enabledNodes, boolean disabled) {
        int nbrChild = this.m_model.getChildCount(parent);
        for (int i = 0; i < nbrChild; ++i) {
            AbstractNode childNode = (AbstractNode)this.m_model.getChild(parent, i);
            if (!enabledNodes.contains(childNode)) {
                childNode.setIsDisabled(disabled);
                this.m_model.nodeChanged(childNode);
            }
            this.childRevertSelectionSetDisabled(childNode, enabledNodes, disabled);
        }
    }

    public void setSelection(ArrayList<ResultSummary> rsmArray) {
        if (!this.m_loadingMap.isEmpty()) {
            this.selectionFromrsmArray = rsmArray;
            return;
        }
        AbstractNode rootNode = (AbstractNode)this.m_model.getRoot();
        ArrayList<TreePath> selectedPathArray = new ArrayList<TreePath>(rsmArray.size());
        ArrayList<AbstractNode> nodePath = new ArrayList<AbstractNode>();
        nodePath.add(rootNode);
        this.setSelectionImpl(rootNode, nodePath, rsmArray, selectedPathArray);
        TreePath[] selectedPaths = selectedPathArray.toArray(new TreePath[selectedPathArray.size()]);
        this.setSelectionPaths(selectedPaths);
    }

    private void setSelectionImpl(AbstractNode parentNode, ArrayList<AbstractNode> nodePath, ArrayList<ResultSummary> rsmArray, ArrayList<TreePath> selectedPathArray) {
        Enumeration<TreeNode> en = parentNode.children();
        while (en.hasMoreElements()) {
            DataSetNode dataSetNode;
            Long rsmId;
            AbstractNode node = (AbstractNode)en.nextElement();
            if (node.getType() == AbstractNode.NodeTypes.DATA_SET && !node.isDisabled() && (rsmId = (dataSetNode = (DataSetNode)node).getResultSummaryId()) != null) {
                int size = rsmArray.size();
                for (int i = 0; i < size; ++i) {
                    ResultSummary rsmItem = rsmArray.get(i);
                    if (rsmItem.getId() != rsmId.longValue()) continue;
                    nodePath.add(node);
                    TreePath path = new TreePath(nodePath.toArray());
                    selectedPathArray.add(path);
                    nodePath.remove(nodePath.size() - 1);
                    break;
                }
            }
            if (node.isLeaf() || node.isDisabled()) continue;
            nodePath.add(node);
            this.setSelectionImpl(node, nodePath, rsmArray, selectedPathArray);
        }
        nodePath.remove(nodePath.size() - 1);
    }

    public AbstractNode[] getSelectedNodes() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        int nbPath = paths.length;
        AbstractNode[] nodes = new AbstractNode[nbPath];
        for (int i = 0; i < nbPath; ++i) {
            nodes[i] = (AbstractNode)paths[i].getLastPathComponent();
        }
        return nodes;
    }

    public boolean isSelected(int row) {
        if (row == -1) {
            return false;
        }
        return this.getSelectionModel().isRowSelected(row);
    }

    protected void manageSelectionOnRightClick(MouseEvent e) {
        int[] selectedRows = this.getSelectionRows();
        int nbSelectedRows = selectedRows.length;
        if (nbSelectedRows == 0) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            if (row != -1) {
                this.setSelectionRow(row);
            }
        } else if (nbSelectedRows == 1) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            if (row != -1 && (e.isShiftDown() || e.isControlDown())) {
                this.addSelectionRow(row);
            } else if (row != -1 && row != selectedRows[0]) {
                this.setSelectionRow(row);
            }
        } else if (e.isShiftDown() || e.isControlDown()) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            if (row != -1) {
                this.addSelectionRow(row);
            }
        } else {
            int row = this.getRowForLocation(e.getX(), e.getY());
            if (row != -1 && !this.isSelected(row)) {
                this.setSelectionRow(row);
            }
        }
    }

    public void expandNodeIfNeeded(AbstractNode n) {
        final TreePath pathToExpand = new TreePath(n.getPath());
        if (!this.isExpanded(pathToExpand)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractTree.this.expandPath(pathToExpand);
                }
            });
        }
    }

    public abstract void rename(AbstractNode var1, String var2);

    @Override
    public String getToolTipText(MouseEvent evt) {
        int row = this.getRowForLocation(evt.getX(), evt.getY());
        if (row == -1) {
            return null;
        }
        TreePath curPath = this.getPathForRow(row);
        AbstractNode node = (AbstractNode)curPath.getLastPathComponent();
        return node.getToolTipText();
    }

    public class RSMTreeModel
    extends DefaultTreeModel {
        private AbstractTree m_parentTree;

        public RSMTreeModel(AbstractTree parentTree, TreeNode root) {
            super(root, false);
            this.m_parentTree = null;
            this.m_parentTree = parentTree;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            AbstractNode rsmNode = (AbstractNode)path.getLastPathComponent();
            this.m_parentTree.rename(rsmNode, newValue.toString());
        }
    }

    public static class RSMTreeSelectionModel
    extends DefaultTreeSelectionModel {
        @Override
        public void setSelectionPaths(TreePath[] pPaths) {
            ArrayList<TreePath> newSelectionList = new ArrayList<TreePath>();
            for (TreePath path : pPaths) {
                AbstractNode node = (AbstractNode)path.getLastPathComponent();
                if (node.isDisabled()) continue;
                newSelectionList.add(path);
            }
            super.setSelectionPaths(newSelectionList.toArray(new TreePath[newSelectionList.size()]));
        }
    }

    public static class RSMTreeCellEditor
    extends DefaultTreeCellEditor {
        public RSMTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        @Override
        protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            this.editingIcon = this.renderer.getIcon();
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        }
    }
}

