/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.quantitation;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.HourGlassNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantiTransferable;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationProjectNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantiTransferHandler
extends TransferHandler {
    private Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof QuantitationTree) {
            QuantitationTree tree = (QuantitationTree)c;
            long commonProjectId = -1L;
            AbstractNode[] selectedNodes = tree.getSelectedNodes();
            int nbSelectedNode = selectedNodes.length;
            for (int i = 0; i < nbSelectedNode; ++i) {
                AbstractNode node = selectedNodes[i];
                if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                    return null;
                }
                if (node.isChanging()) {
                    return null;
                }
                DataSetNode datasetNode = (DataSetNode)node;
                if (datasetNode.isTrash()) {
                    return null;
                }
                long projectId = datasetNode.getDataset().getProject().getId();
                if (commonProjectId == -1L) {
                    commonProjectId = projectId;
                    continue;
                }
                if (commonProjectId == projectId) continue;
                return null;
            }
            ArrayList<AbstractNode> keptNodes = new ArrayList<AbstractNode>(nbSelectedNode);
            keptNodes.add(selectedNodes[0]);
            block1: for (int i = 1; i < nbSelectedNode; ++i) {
                AbstractNode curKeptNode;
                int j;
                AbstractNode curNode = selectedNodes[i];
                int nbKeptNodes = keptNodes.size();
                for (j = 0; j < nbKeptNodes; ++j) {
                    curKeptNode = keptNodes.get(j);
                    if (curNode.isNodeAncestor(curKeptNode)) continue block1;
                }
                for (j = nbKeptNodes - 1; j >= 0; --j) {
                    curKeptNode = keptNodes.get(j);
                    if (!curKeptNode.isNodeAncestor(curNode)) continue;
                    keptNodes.remove(j);
                }
                keptNodes.add(curNode);
            }
            QuantiTransferable.TransferData data = new QuantiTransferable.TransferData();
            data.setNodeList(keptNodes);
            Integer transferKey = QuantiTransferable.register(data);
            return new QuantiTransferable(transferKey, commonProjectId);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        QuantiTransferable.clearRegisteredData();
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        support.setShowDropLocation(true);
        if (support.isDataFlavorSupported(QuantiTransferable.QuantiNodeList_FLAVOR)) {
            long dropProjectId;
            TreePath dropTreePath = ((JTree.DropLocation)support.getDropLocation()).getPath();
            if (dropTreePath == null) {
                return false;
            }
            Object dropComponent = dropTreePath.getLastPathComponent();
            if (!(dropComponent instanceof AbstractNode)) {
                return false;
            }
            AbstractNode dropRSMNode = (AbstractNode)dropComponent;
            if (dropRSMNode.isChanging()) {
                return false;
            }
            AbstractNode.NodeTypes nodeType = dropRSMNode.getType();
            if (nodeType == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode dropDatasetNode = (DataSetNode)dropRSMNode;
                if (dropDatasetNode.isQuantitation() && !dropDatasetNode.isFolder()) {
                    return false;
                }
                dropProjectId = dropDatasetNode.getDataset().getProject().getId();
            } else if (nodeType == AbstractNode.NodeTypes.PROJECT_QUANTITATION) {
                QuantitationProjectNode dropProjectNode = (QuantitationProjectNode)dropRSMNode;
                dropProjectId = dropProjectNode.getProject().getId();
            } else {
                return false;
            }
            try {
                QuantiTransferable nodeListTransferable = (QuantiTransferable)support.getTransferable().getTransferData(QuantiTransferable.QuantiNodeList_FLAVOR);
                if (nodeListTransferable.getProjectId() != dropProjectId) {
                    return false;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                this.m_logger.error(this.getClass().getSimpleName() + " DnD error ", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (this.canImport(support)) {
            try {
                QuantiTransferable transfer = (QuantiTransferable)support.getTransferable().getTransferData(QuantiTransferable.QuantiNodeList_FLAVOR);
                QuantiTransferable.TransferData data = QuantiTransferable.getData(transfer.getTransferKey());
                if (data.isNodeList()) {
                    return this.importNodes(support, data);
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                this.m_logger.error(this.getClass().getSimpleName() + " DnD error ", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean importNodes(TransferHandler.TransferSupport support, QuantiTransferable.TransferData data) {
        AbstractNode lastChild;
        JTree.DropLocation location = (JTree.DropLocation)support.getDropLocation();
        TreePath dropTreePath = location.getPath();
        int childIndex = location.getChildIndex();
        AbstractNode dropRSMNode = (AbstractNode)dropTreePath.getLastPathComponent();
        QuantitationTree tree = QuantitationTree.getCurrentTree();
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        if (childIndex == -1 && (childIndex = dropRSMNode.getChildCount()) > 0 && (lastChild = (AbstractNode)dropRSMNode.getChildAt(childIndex - 1)) instanceof DataSetNode && ((DataSetNode)lastChild).isTrash()) {
            --childIndex;
        }
        LinkedHashSet<AbstractNode> allParentNodeModified = new LinkedHashSet<AbstractNode>();
        ArrayList nodeList = data.getDataList();
        int nbNodes = nodeList.size();
        for (int i = 0; i < nbNodes; ++i) {
            AbstractNode node = (AbstractNode)nodeList.get(i);
            if (dropRSMNode.isNodeChild(node)) {
                int indexChild = dropRSMNode.getIndex(node);
                if (indexChild < childIndex) {
                    --childIndex;
                }
            } else {
                allParentNodeModified.add((AbstractNode)node.getParent());
            }
            treeModel.removeNodeFromParent(node);
            treeModel.insertNodeInto(node, dropRSMNode, childIndex);
            ++childIndex;
        }
        allParentNodeModified.add(dropRSMNode);
        LinkedHashMap databaseObjectsToModify = new LinkedHashMap();
        for (AbstractNode parentNode : allParentNodeModified) {
            DDataset databaseParentObject = null;
            AbstractNode.NodeTypes type = parentNode.getType();
            if (type == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode datasetNode = (DataSetNode)parentNode;
                databaseParentObject = datasetNode.getDataset();
            } else if (type == AbstractNode.NodeTypes.PROJECT_QUANTITATION) {
                QuantitationProjectNode projectNode = (QuantitationProjectNode)parentNode;
                databaseParentObject = projectNode.getProject();
            }
            int nbChildren = parentNode.getChildCount();
            ArrayList<DDataset> datasetList = new ArrayList<DDataset>(nbChildren);
            for (int i = 0; i < nbChildren; ++i) {
                AbstractNode childNode = (AbstractNode)parentNode.getChildAt(i);
                if (!(childNode instanceof DataSetNode)) {
                    if (!(childNode instanceof HourGlassNode)) continue;
                    datasetList.add(null);
                    continue;
                }
                DataSetNode childDatasetNode = (DataSetNode)childNode;
                DDataset dataset = childDatasetNode.getDataset();
                datasetList.add(dataset);
            }
            databaseObjectsToModify.put(databaseParentObject, datasetList);
        }
        DatabaseDataSetTask.updateDatasetAndProjectsTree(databaseObjectsToModify, (boolean)false);
        return true;
    }
}

