/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.quantitation;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class QuantiTransferable
implements Transferable,
Serializable {
    public static final DataFlavor QuantiNodeList_FLAVOR = new DataFlavor(QuantitationTree.class, "Drag and drop Quantitation TreePath list");
    private Integer m_transferKey = null;
    private long m_projectId = -1L;
    private static HashMap<Integer, TransferData> transferMap = new HashMap();
    private static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{QuantiNodeList_FLAVOR};
    private static final long serialVersionUID = 1L;
    private static int m_transferIndex = 0;

    public QuantiTransferable(Integer transferKey, long projectId) {
        this.m_transferKey = transferKey;
        this.m_projectId = projectId;
    }

    public static Integer register(TransferData data) {
        Integer transferKey = m_transferIndex;
        ++m_transferIndex;
        transferMap.put(transferKey, data);
        return transferKey;
    }

    public static TransferData getData(Integer transferKey) {
        return transferMap.get(transferKey);
    }

    public static void clearRegisteredData() {
        transferMap.clear();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DATA_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DATA_FLAVORS[0].equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this;
        }
        return null;
    }

    public Integer getTransferKey() {
        return this.m_transferKey;
    }

    public long getProjectId() {
        return this.m_projectId;
    }

    public static class TransferData {
        private boolean m_isNodeList;
        private ArrayList m_dataList = null;

        public void setResultSetList(ArrayList<ResultSet> list) {
            this.m_isNodeList = false;
            this.m_dataList = list;
        }

        public void setNodeList(ArrayList<AbstractNode> list) {
            this.m_isNodeList = true;
            this.m_dataList = list;
        }

        public boolean isNodeList() {
            return this.m_isNodeList;
        }

        public ArrayList getDataList() {
            return this.m_dataList;
        }
    }
}

