/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.xic;

import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.xic.IdentificationSelectionTree;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICSelectionTransferable;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTreeTransferHandler
extends TransferHandler {
    private Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    protected boolean m_isIdentificationSelectionTree;
    private int m_treeId;

    protected AbstractTreeTransferHandler(boolean isSelectionTree, int treeId) {
        this.m_isIdentificationSelectionTree = isSelectionTree;
        this.m_treeId = treeId;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (this.m_isIdentificationSelectionTree) {
            IdentificationSelectionTree tree = (IdentificationSelectionTree)c;
            AbstractNode[] selectedNodes = tree.getSelectedNodes();
            ArrayList<DataSetNode> keptNodes = new ArrayList<DataSetNode>();
            this.retrieveLeaves(keptNodes, selectedNodes);
            if (keptNodes.isEmpty()) {
                return null;
            }
            XICSelectionTransferable.TransferData data = new XICSelectionTransferable.TransferData(this.m_treeId);
            data.setDatasetList(keptNodes);
            Integer transferKey = XICSelectionTransferable.register(data);
            return new XICSelectionTransferable(transferKey);
        }
        QuantExperimentalDesignTree tree = (QuantExperimentalDesignTree)c;
        AbstractNode[] selectedNodes = tree.getSelectedNodes();
        ArrayList<AbstractNode> keptNodes = new ArrayList<AbstractNode>();
        AbstractNode.NodeTypes commonType = null;
        for (AbstractNode node : selectedNodes) {
            AbstractNode.NodeTypes type = node.getType();
            if (type != AbstractNode.NodeTypes.BIOLOGICAL_GROUP && type != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS && type != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE) {
                return null;
            }
            if (commonType != null) {
                if (commonType != type) {
                    return null;
                }
            } else {
                commonType = type;
            }
            keptNodes.add(node);
        }
        String keptNodesAsString = keptNodes.stream().map(i -> i.toString()).collect(Collectors.joining(",", "[", "]"));
        XICSelectionTransferable.TransferData data = new XICSelectionTransferable.TransferData(this.m_treeId);
        data.setDesignList(keptNodes);
        Integer transferKey = XICSelectionTransferable.register(data);
        return new XICSelectionTransferable(transferKey);
    }

    protected void retrieveLeaves(ArrayList<DataSetNode> keptNodes, AbstractNode[] selectedNodes) {
        for (AbstractNode node : selectedNodes) {
            this.retrieveLeaves(keptNodes, node);
        }
    }

    protected void retrieveLeaves(ArrayList<DataSetNode> keptNodes, AbstractNode node) {
        if (node.isChanging()) {
            return;
        }
        AbstractNode.NodeTypes type = node.getType();
        if (type != AbstractNode.NodeTypes.DATA_SET) {
            return;
        }
        DataSetNode datasetNode = (DataSetNode)node;
        if (node.isLeaf()) {
            if (!datasetNode.hasResultSummary()) {
                return;
            }
            keptNodes.add(datasetNode);
        } else {
            int nbChildren = node.getChildCount();
            for (int i = 0; i < nbChildren; ++i) {
                this.retrieveLeaves(keptNodes, (AbstractNode)node.getChildAt(i));
            }
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.m_isIdentificationSelectionTree) {
            XICSelectionTransferable.clearRegisteredData();
        }
    }
}

