/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.xic;

import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.xic.IdentificationSelectionTree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class XICSelectionTransferable
implements Transferable,
Serializable {
    public static final DataFlavor RSMNodeList_FLAVOR = new DataFlavor(IdentificationSelectionTree.class, "Drag and drop Identification Summary");
    private Integer m_transferKey = null;
    private static HashMap<Integer, TransferData> transferMap = new HashMap();
    private static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{RSMNodeList_FLAVOR};
    private static final long serialVersionUID = 1L;
    private static int m_transferIndex = 0;

    public XICSelectionTransferable(Integer transferKey) {
        this.m_transferKey = transferKey;
    }

    public static Integer register(TransferData data) {
        Integer transferKey = m_transferIndex;
        ++m_transferIndex;
        transferMap.put(transferKey, data);
        return transferKey;
    }

    public static TransferData getData(Integer transferKey) {
        return transferMap.get(transferKey);
    }

    public static void clearRegisteredData() {
        transferMap.clear();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DATA_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DATA_FLAVORS[0].equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this;
        }
        return null;
    }

    public Integer getTransferKey() {
        return this.m_transferKey;
    }

    public static class TransferData {
        private ArrayList<DataSetNode> m_datasetList = null;
        private ArrayList<AbstractNode> m_designList = null;
        private int m_sourceId;

        public TransferData(int sourceId) {
            this.m_sourceId = sourceId;
        }

        public int getSourceId() {
            return this.m_sourceId;
        }

        public boolean isDesignData() {
            return this.m_designList != null;
        }

        public AbstractNode.NodeTypes getDesignNodeType() {
            if (this.m_designList == null || this.m_designList.isEmpty()) {
                return null;
            }
            return this.m_designList.get(0).getType();
        }

        public void setDatasetList(ArrayList<DataSetNode> list) {
            this.m_datasetList = list;
        }

        public ArrayList<DataSetNode> getDatasetList() {
            return this.m_datasetList;
        }

        public void setDesignList(ArrayList<AbstractNode> list) {
            this.m_designList = list;
        }

        public ArrayList<AbstractNode> getDesignList() {
            return this.m_designList;
        }
    }
}

