/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class LazyTableCellRenderer
extends DefaultTableCellRenderer {
    private TableCellRenderer m_childRenderer = null;

    public LazyTableCellRenderer() {
        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HOUR_GLASS));
    }

    public LazyTableCellRenderer(TableCellRenderer childRenderer) {
        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HOUR_GLASS));
        this.m_childRenderer = childRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return TableDefaultRendererManager.getDefaultRenderer(String.class).getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }
        Object data = ((LazyData)value).getData();
        if (this.m_childRenderer != null && data != null) {
            return this.m_childRenderer.getTableCellRendererComponent(table, data, isSelected, hasFocus, row, column);
        }
        if (data == null) {
            super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            return this;
        }
        return table.getDefaultRenderer(data.getClass()).getTableCellRendererComponent(table, data, isSelected, hasFocus, row, column);
    }
}

