/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.data;

import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.util.Conversion;
import java.util.ArrayList;

public class ColDoubleData
extends Col {
    private final ArrayList<Double> m_data;

    public ColDoubleData(Table table, ArrayList<Double> data, String name) {
        super(table);
        this.m_data = data;
        this.m_columnName = name;
    }

    public ColDoubleData(Table table, double[] data, String name) {
        super(table);
        this.m_data = new ArrayList(data.length);
        for (double d : data) {
            this.m_data.add(d);
        }
        this.m_columnName = name;
    }

    private ColDoubleData() {
        super(null);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getValueAt(int row) {
        return this.m_data.get(row);
    }

    @Override
    public void setValuetAt(int row, Object o) {
        Number n = Conversion.convertToJavaNumber(o);
        if (n == null) {
            this.m_data.set(row, null);
        } else {
            this.m_data.set(row, n.doubleValue());
        }
    }

    @Override
    public Col mutable() {
        return this;
    }

    @Override
    public int getRowCount() {
        return this.m_data.size();
    }

    @Override
    public Class getColumnClass() {
        return Double.class;
    }
}

