/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.interpreter;

import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColBooleanData;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.PythonImage;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.ResultVariable;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;
import org.slf4j.LoggerFactory;

public class CalcInterpreterThread
extends Thread {
    private static CalcInterpreterThread m_instance;
    private final LinkedList<CalcInterpreterTask> m_actions = new LinkedList();

    private CalcInterpreterThread() {
        super("CalcInterpreterThread");
    }

    public static CalcInterpreterThread getCalcInterpreterThread() {
        if (m_instance == null) {
            m_instance = new CalcInterpreterThread();
            m_instance.start();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTask(CalcInterpreterTask task) {
        CalcInterpreterThread calcInterpreterThread = this;
        synchronized (calcInterpreterThread) {
            this.m_actions.add(task);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (true) {
                    CalcInterpreterTask task = null;
                    CalcInterpreterThread calcInterpreterThread = this;
                    synchronized (calcInterpreterThread) {
                        while (true) {
                            if (!this.m_actions.isEmpty()) break;
                            this.wait();
                        }
                        task = this.m_actions.poll();
                        this.notifyAll();
                    }
                    PythonInterpreter interpreter = new PythonInterpreter();
                    try {
                        String code = task.getCode();
                        ResultVariable[] parameters = task.getParameters();
                        interpreter.exec("from fr.proline.studio.python.data import Col");
                        interpreter.exec("from fr.proline.studio.python.data import Table");
                        interpreter.exec("from fr.proline.studio.python.math import Stats");
                        interpreter.exec("import math");
                        if (parameters != null) {
                            for (ResultVariable parameter : parameters) {
                                interpreter.set(parameter.getName(), parameter.getValue());
                            }
                        }
                        interpreter.exec(code);
                        ArrayList<ResultVariable> resultVariableArray = new ArrayList<ResultVariable>();
                        PyStringMap locals = (PyStringMap)interpreter.getLocals();
                        PyList keysList = locals.keys();
                        int nbKeys = keysList.size();
                        for (int i = 0; i < nbKeys; ++i) {
                            Col col;
                            String columnName;
                            PyObject key = keysList.__getitem__(i);
                            PyObject value = locals.get(key);
                            if (value instanceof ColDoubleData && ((columnName = (col = (ColDoubleData)value).getColumnName()) == null || columnName.isEmpty())) {
                                col.setColumnName(key.toString());
                            }
                            if (value instanceof ColBooleanData && ((columnName = (col = (ColBooleanData)value).getColumnName()) == null || columnName.isEmpty())) {
                                col.setColumnName(key.toString());
                            }
                            if (!(value instanceof ColDoubleData) && !(value instanceof ColBooleanData) && !(value instanceof PyInteger) && !(value instanceof PyFloat) && !(value instanceof Table) && !(value instanceof PythonImage)) continue;
                            resultVariableArray.add(new ResultVariable(key.toString(), value));
                        }
                        this.runCallback(task, resultVariableArray, null);
                        continue block7;
                    }
                    catch (Throwable e) {
                        int lineError = -1;
                        StackTraceElement[] stackTraceArray = e.getStackTrace();
                        String error = null;
                        for (int i = 0; i < stackTraceArray.length; ++i) {
                            if (error == null) {
                                String lineCode = stackTraceArray[i].toString();
                                if (lineCode == null || lineCode.isEmpty()) continue;
                                error = lineCode;
                                lineError = stackTraceArray[i].getLineNumber();
                                continue;
                            }
                            if (lineError != -1) break;
                            lineError = stackTraceArray[i].getLineNumber();
                        }
                        if (error == null) {
                            error = "Executing Error";
                        }
                        this.runCallback(task, null, new CalcError(e, error, lineError));
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                LoggerFactory.getLogger((String)"ProlineStudio.R").error("Unexpected exception in main loop of CalcInterpreterThread", t);
                m_instance = null;
                return;
            }
        }
    }

    private void runCallback(final CalcInterpreterTask task, final ArrayList<ResultVariable> resultVariableArray, final CalcError error) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                task.getCallback().run(resultVariableArray, error);
            }
        });
    }
}

