/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.model;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterTableModel;

public class QuantiFilterModel
extends FilterTableModel {
    public static final int WHOLE_GROUPS = 0;
    public static final int EVERY_GROUP = 1;
    public static final int AT_LEAST_ONE_GROUP = 2;
    private final int[] m_colsIndex;
    private final int[] m_groupIndex;
    private final int m_option;
    private final int m_threshold;
    private final boolean m_reversed;

    public QuantiFilterModel(GlobalTableModelInterface tableModelSource, int[] colsIndex, int[] groupIndex, int option, int threshold, boolean reversed) {
        super(tableModelSource);
        this.m_colsIndex = colsIndex;
        this.m_groupIndex = groupIndex;
        this.m_option = option;
        this.m_threshold = threshold;
        this.m_reversed = reversed;
    }

    public boolean filter(int row) {
        if (this.m_reversed) {
            return !this.filterImpl(row);
        }
        return this.filterImpl(row);
    }

    private boolean filterImpl(int row) {
        if (this.m_option == 0) {
            int count = 0;
            for (int i = 0; i < this.m_colsIndex.length; ++i) {
                double quantitation = ((Number)this.getDataValueAt(row, this.m_colsIndex[i])).doubleValue();
                if (!(quantitation > 1.0E-9)) continue;
                ++count;
            }
            return count >= this.m_threshold;
        }
        if (this.m_option == 1) {
            int prevGroup = -1;
            int count = 0;
            for (int i = 0; i < this.m_groupIndex.length; ++i) {
                int groupCur = this.m_groupIndex[i];
                if (prevGroup != -1 && groupCur != prevGroup) {
                    if (count < this.m_threshold) {
                        return false;
                    }
                    count = 0;
                }
                prevGroup = groupCur;
                double quantitation = ((Number)this.getDataValueAt(row, this.m_colsIndex[i])).doubleValue();
                if (!(quantitation > 1.0E-9)) continue;
                ++count;
            }
            return count >= this.m_threshold;
        }
        if (this.m_option == 2) {
            int prevGroup = -1;
            int count = 0;
            for (int i = 0; i < this.m_groupIndex.length; ++i) {
                int groupCur = this.m_groupIndex[i];
                if (prevGroup != -1 && groupCur != prevGroup) {
                    if (count >= this.m_threshold) break;
                    count = 0;
                }
                prevGroup = groupCur;
                double quantitation = ((Number)this.getDataValueAt(row, this.m_colsIndex[i])).doubleValue();
                if (!(quantitation > 1.0E-9)) continue;
                ++count;
            }
            return count >= this.m_threshold;
        }
        return true;
    }
}

