
/* REMOVE DUPLICATED ENTRIES IN peptide_match_object_tree_map */

DELETE FROM peptide_match_object_tree_map 
WHERE  peptide_match_object_tree_map.peptide_match_id IN 
		(SELECT  peptide_match_id as pepMId FROM peptide_match_object_tree_map GROUP BY peptide_match_id, schema_name HAVING count(object_tree_id)  > 1)
AND object_tree_id NOT IN 
	(SELECT max(object_tree_id) as distinct_object_tree_id from peptide_match_object_tree_map WHERE peptide_match_object_tree_map.peptide_match_id IN 
		(SELECT  peptide_match_id as pepMId FROM peptide_match_object_tree_map GROUP BY peptide_match_id, schema_name HAVING count(object_tree_id)  > 1)
	 GROUP BY peptide_match_id, schema_name
	);

/* END OF REMOVE DUPLICATED ENTRIES IN peptide_match_object_tree_map */

/* REMOVE ORPHAN ENTRIES IN object_tree */
DELETE  FROM object_tree WHERE object_tree.id IN ( SELECT object_tree.id from object_tree LEFT OUTER JOIN peptide_match_object_tree_map ON object_tree.id = peptide_match_object_tree_map.object_tree_id 
WHERE object_tree.schema_name = 'peptide_match.spectrum_match' AND peptide_match_object_tree_map.schema_name is null);


/* END OF REMOVE ORPHAN ENTRIES IN object_tree */


/* UPDATE SPECTRUM.IS_SUMMED FIELD */
UPDATE public.spectrum SET is_summed = false;


/* SCRIPT GENERATED BY POWER ARCHITECT AND MODIFIED MANUALLY */

ALTER TABLE public.result_summary_object_tree_map DROP CONSTRAINT result_summary_object_tree_map_pk;

ALTER TABLE public.result_summary_object_tree_map ADD CONSTRAINT result_summary_object_tree_map_pk PRIMARY KEY (result_summary_id,schema_name);

ALTER TABLE public.protein_set_object_tree_map DROP CONSTRAINT protein_set_object_tree_map_pk;

ALTER TABLE public.protein_set_object_tree_map ADD CONSTRAINT protein_set_object_tree_map_pk PRIMARY KEY (protein_set_id,schema_name);

ALTER TABLE public.msi_search_object_tree_map DROP CONSTRAINT msi_search_object_tree_map_pk;

ALTER TABLE public.msi_search_object_tree_map ADD CONSTRAINT msi_search_object_tree_map_pk PRIMARY KEY (msi_search_id,schema_name);

ALTER TABLE public.peptide_match_object_tree_map DROP CONSTRAINT peptide_match_object_tree_map_pk;

ALTER TABLE public.peptide_match_object_tree_map ADD CONSTRAINT peptide_match_object_tree_map_pk PRIMARY KEY (peptide_match_id,schema_name);

ALTER TABLE public.result_set ADD COLUMN merged_rsm_id BIGINT;

ALTER TABLE public.result_set_object_tree_map DROP CONSTRAINT result_set_object_tree_map_pk;

ALTER TABLE public.result_set_object_tree_map ADD CONSTRAINT result_set_object_tree_map_pk PRIMARY KEY (result_set_id,schema_name);

ALTER TABLE public.spectrum ADD COLUMN initial_id INTEGER DEFAULT 0 NOT NULL;

ALTER TABLE ONLY public.spectrum ALTER COLUMN is_summed TYPE BOOLEAN, ALTER COLUMN is_summed SET DEFAULT false, ALTER COLUMN is_summed SET NOT NULL;

ALTER TABLE ONLY public.peptide_set ALTER COLUMN peptide_match_count TYPE INTEGER, ALTER COLUMN peptide_match_count SET NOT NULL;

ALTER TABLE ONLY public.peptide_set ALTER COLUMN peptide_count TYPE INTEGER, ALTER COLUMN peptide_count SET NOT NULL;

CREATE INDEX peptide_instance_peptide_idx
 ON peptide_instance
 ( peptide_id );

/* END OF SCRIPT GENERATED BY POWER ARCHITECT AND MODIFIED MANUALLY */


/* ADDITIONAL SQL QUERIES FIXING THE CREATION OF INDICES NOT PERFORMED IN PREVIOUS MIGRATIONS */

CREATE UNIQUE INDEX scoring_idx
 ON scoring
 ( search_engine, name );

CREATE UNIQUE INDEX peaklist_software_idx
 ON peaklist_software
 ( name, version );

CREATE UNIQUE INDEX instrument_config_name_idx
 ON instrument_config
 ( name );

CREATE UNIQUE INDEX seq_database_fasta_file_path_idx
 ON seq_database
 ( fasta_file_path );

CREATE UNIQUE INDEX enzyme_name_idx
 ON enzyme
 ( name );

/* END OF ADDITIONAL SQL QUERIES FIXING THE CREATION OF INDICES NOT PERFORMED IN PREVIOUS MIGRATIONS */


/* ADDITIONAL SQL QUERIES FIXING THE NAME OF FOREIGN KEYS NOT CORRECTLY RENAMED IN PREVIOUS MIGRATIONS */

ALTER TABLE public.master_quant_peptide_ion DROP CONSTRAINT peptide_instance_peptide_ion_fk;
ALTER TABLE public.master_quant_peptide_ion ADD CONSTRAINT peptide_instance_master_quant_peptide_ion_fk
FOREIGN KEY (peptide_instance_id)
REFERENCES public.peptide_instance (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.master_quant_peptide_ion DROP CONSTRAINT peptide_ion_peptide_ion_fk;
ALTER TABLE public.master_quant_peptide_ion ADD CONSTRAINT master_quant_peptide_ion_unmodified_peptide_ion_fk
FOREIGN KEY (unmodified_peptide_ion_id)
REFERENCES public.master_quant_peptide_ion (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.master_quant_peptide_ion DROP CONSTRAINT peptide_match_peptide_ion_fk;
ALTER TABLE public.master_quant_peptide_ion ADD CONSTRAINT peptide_match_master_quant_peptide_ion_fk
FOREIGN KEY (best_peptide_match_id)
REFERENCES public.peptide_match (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.master_quant_peptide_ion DROP CONSTRAINT peptide_quanti_peptide_ion_fk;
ALTER TABLE public.master_quant_peptide_ion ADD CONSTRAINT peptide_master_quant_peptide_ion_fk
FOREIGN KEY (peptide_id)
REFERENCES public.peptide (id)
ON DELETE RESTRICT
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.master_quant_peptide_ion DROP CONSTRAINT result_summary_peptide_ion_fk;
ALTER TABLE public.master_quant_peptide_ion ADD CONSTRAINT result_summary_master_quant_peptide_ion_fk
FOREIGN KEY (result_summary_id)
REFERENCES public.result_summary (id)
ON DELETE CASCADE
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.master_quant_component DROP CONSTRAINT result_summary_quanti_component_fk;
ALTER TABLE public.master_quant_component ADD CONSTRAINT result_summary_master_quant_component_fk
FOREIGN KEY (result_summary_id)
REFERENCES public.result_summary (id)
ON DELETE CASCADE
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.msi_search_object_tree_map DROP CONSTRAINT msi_search_msi_search_properties_fk;
ALTER TABLE public.msi_search_object_tree_map ADD CONSTRAINT msi_search_msi_search_object_tree_map_fk
FOREIGN KEY (msi_search_id)
REFERENCES public.msi_search (id)
ON DELETE CASCADE
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.msi_search_object_tree_map DROP CONSTRAINT property_msi_search_properties_fk;
ALTER TABLE public.msi_search_object_tree_map ADD CONSTRAINT object_tree_msi_search_object_tree_map_fk
FOREIGN KEY (object_tree_id)
REFERENCES public.object_tree (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.object_tree DROP CONSTRAINT property_definition_property_fk;
ALTER TABLE public.object_tree ADD CONSTRAINT object_tree_schema_object_tree_map_fk
FOREIGN KEY (schema_name)
REFERENCES public.object_tree_schema (name)
ON DELETE RESTRICT
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.result_set_object_tree_map DROP CONSTRAINT property_result_set_properties_fk;
ALTER TABLE public.result_set_object_tree_map ADD CONSTRAINT object_tree_result_set_object_tree_map_fk
FOREIGN KEY (object_tree_id)
REFERENCES public.object_tree (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.result_summary_object_tree_map DROP CONSTRAINT property_result_summary_property_fk;
ALTER TABLE public.result_summary_object_tree_map ADD CONSTRAINT object_tree_result_summary_object_tree_map_fk
FOREIGN KEY (object_tree_id)
REFERENCES public.object_tree (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;

/* END OF ADDITIONAL SQL QUERIES FIXING THE NAME OF FOREIGN KEYS NOT CORRECTLY RENAMED IN PREVIOUS MIGRATIONS */